/*
 * Decompiled with CFR 0.152.
 */
package com.soartech.soarls.analysis;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.soartech.soarls.Documents;
import com.soartech.soarls.EntryPoints;
import com.soartech.soarls.SoarFile;
import com.soartech.soarls.analysis.FileAnalysis;
import com.soartech.soarls.analysis.ProcedureCall;
import com.soartech.soarls.analysis.ProcedureDefinition;
import com.soartech.soarls.analysis.Production;
import com.soartech.soarls.analysis.ProjectAnalysis;
import com.soartech.soarls.analysis.VariableDefinition;
import com.soartech.soarls.analysis.VariableRetrieval;
import com.soartech.soarls.tcl.TclAstNode;
import com.soartech.soarls.tcl.TclParser;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.exceptions.SoarInterpreterException;
import org.jsoar.kernel.exceptions.SoftTclInterpreterException;
import org.jsoar.kernel.exceptions.TclInterpreterException;
import org.jsoar.util.SourceLocation;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tcl.lang.Interp;
import tcl.lang.TclException;

public class Analysis {
    private static final Logger LOG = LoggerFactory.getLogger(Analysis.class);
    private static String MISSING_FILE = "File not found";
    private static String DUPLICATE_PRODUCTION_REGEX = "Ignoring .+ because it is a duplicate of .+";
    private static Pattern NO_RHS_FUNCTION_PATTERN = Pattern.compile("No RHS function named '(.+)'");
    public static final String[] NOTHING_COMMANDS = new String[]{"echo", "learn", "waitsnc", "watch", "multi-attributes", "multi-attribute", "o-support-mode", "output-strings-destination", "help", "init-soar", "quit", "run", "stop-soar", "default-wme-depth", "gds-print", "internal-symbols", "matches", "memories", "preferences", "print", "production-find", "chunk-name", "firing-counts", "fc", "pwatch", "explain-backtraces", "indifferent-selection", "max-chunks", "max-elaborations", "max-nil-output-cycles", "multi-attributes", "numeric-indifferent-mode", "o-support-mode", "save-backtraces", "soar8", "timers", "dirs", "log", "rete-net", "set-library-location", "add-wme", "remove-wme", "soarnews", "version", "stats", "wm", "smem", "alias", "rl", "epmem", "chunk"};
    private final EntryPoints projectConfig;
    private final Documents documents;
    private Stack<URI> directoryStack = new Stack();
    private final Agent agent = new Agent();
    private final SoarCommand spCommand;
    private ImmutableMap<String, String> currentVariables;
    private final URI entryPointUri;
    private final Map<URI, FileAnalysis> files = new HashMap<URI, FileAnalysis>();
    private final Map<String, ProcedureDefinition> procedureDefinitions = new HashMap<String, ProcedureDefinition>();
    private final Map<ProcedureDefinition, List<ProcedureCall>> procedureCalls = new HashMap<ProcedureDefinition, List<ProcedureCall>>();
    private final Map<String, VariableDefinition> variableDefinitions = new HashMap<String, VariableDefinition>();
    private final Map<VariableDefinition, List<VariableRetrieval>> variableRetrievals = new HashMap<VariableDefinition, List<VariableRetrieval>>();
    private final Interp tclInterp;

    private Analysis(EntryPoints projectConfig, Documents documents, URI entryPointUri) throws SoarException {
        this.projectConfig = projectConfig;
        this.documents = documents;
        this.entryPointUri = entryPointUri;
        try {
            this.tclInterp = (Interp)FieldUtils.readField((Object)this.agent.getInterpreter(), (String)"interp", (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get tcl interp from Soar interpreter", e);
        }
        try {
            this.directoryStack.push(entryPointUri.resolve(""));
        }
        catch (Exception e) {
            LOG.error("failed to initialize directory stack", (Throwable)e);
        }
        for (String command : NOTHING_COMMANDS) {
            this.agent.getInterpreter().eval("proc " + command + " { args } {}");
        }
        this.agent.getInterpreter().eval("rename proc proc_internal");
        this.spCommand = this.agent.getInterpreter().getCommand("sp", null);
        this.currentVariables = this.getCurrentVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectAnalysis analyse(EntryPoints projectConfig, Documents documents, URI entryPointUri) {
        Analysis analysis = null;
        try {
            analysis = new Analysis(projectConfig, documents, entryPointUri);
            SoarFile file = documents.get(entryPointUri);
            analysis.analyseFile(file);
            LOG.info("Completed analysis {}", (Object)analysis);
            ProjectAnalysis projectAnalysis = analysis.toProjectAnalysis();
            return projectAnalysis;
        }
        catch (Exception e) {
            LOG.error("running analysis", (Throwable)e);
            ProjectAnalysis projectAnalysis = null;
            return projectAnalysis;
        }
        finally {
            analysis.agent.dispose();
        }
    }

    private ProjectAnalysis toProjectAnalysis() {
        return new ProjectAnalysis(this.entryPointUri, this.files, this.procedureDefinitions, this.procedureCalls, this.variableDefinitions, this.variableRetrievals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseFile(SoarFile file) throws SoarException {
        HashMap<TclAstNode, ProcedureCall> procedureCalls = new HashMap<TclAstNode, ProcedureCall>();
        HashMap<TclAstNode, VariableRetrieval> variableRetrievals = new HashMap<TclAstNode, VariableRetrieval>();
        ArrayList<ProcedureDefinition> procedureDefinitions = new ArrayList<ProcedureDefinition>();
        ArrayList<URI> filesSourced = new ArrayList<URI>();
        HashMap<TclAstNode, List<Production>> productions = new HashMap<TclAstNode, List<Production>>();
        ArrayList<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();
        class Context {
            TclAstNode currentNode = null;
            TclAstNode mostRecentComment = null;

            Context() {
            }
        }
        Context ctx = new Context();
        HashMap<String, SoarCommand> originalCommands = new HashMap<String, SoarCommand>();
        for (String string : Arrays.asList("source", "sp", "proc", "pushd", "popd", "pwd")) {
            try {
                originalCommands.put(string, this.agent.getInterpreter().getCommand(string, null));
            }
            catch (SoarException soarException) {}
        }
        try {
            this.addCommand("source", (context, args) -> {
                try {
                    URI uri = this.directoryStack.peek().resolve(args[1]);
                    URI newDirectory = uri.resolve("");
                    this.directoryStack.push(newDirectory);
                    filesSourced.add(uri);
                    SoarFile sourcedFile = this.documents.get(uri);
                    LOG.info("Retrieved file for {} :: {}", (Object)uri, (Object)sourcedFile);
                    if (sourcedFile == null) {
                        throw new SoarException(MISSING_FILE);
                    }
                    this.analyseFile(sourcedFile);
                }
                catch (Exception e) {
                    LOG.error("exception while tracing source", (Throwable)e);
                    throw e;
                }
                finally {
                    this.directoryStack.pop();
                }
                return "";
            });
            this.addCommand("pushd", (context, args) -> {
                URI newDirectory = this.directoryStack.peek().resolve(args[1].replaceAll("([^/])$", "$1/"));
                this.directoryStack.push(newDirectory);
                return "";
            });
            this.addCommand("popd", (context, args) -> {
                this.directoryStack.pop();
                return "";
            });
            this.addCommand("pwd", (context, args) -> {
                String result;
                URI uri = this.directoryStack.peek();
                if (uri.getScheme().equals("file")) {
                    result = Paths.get(uri).toAbsolutePath().toString();
                } else {
                    try {
                        result = uri.toURL().toExternalForm();
                    }
                    catch (MalformedURLException e) {
                        result = uri.toString();
                    }
                }
                return result.replace('\\', '/');
            });
            this.addCommand("sp", (context, args) -> {
                Location location = this.location(file.uri, file.rangeForNode(ctx.currentNode));
                Production production = new Production(args[1], location);
                productions.computeIfAbsent(ctx.currentNode, key -> new ArrayList()).add(production);
                LOG.trace("Added production {} to {}", (Object)production.name, (Object)file.uri);
                return this.spCommand.execute(context, args);
            });
            this.addCommand("proc", (context, args) -> {
                String name = args[1];
                Location location = this.location(file.uri, file.rangeForNode(ctx.currentNode));
                char[] argsBuffer = args[2].replaceAll("\n", " ").toCharArray();
                TclParser parser = new TclParser();
                parser.setInput(argsBuffer, 0, argsBuffer.length);
                TclAstNode procArgs = parser.parse();
                Function<TclAstNode, ProcedureDefinition.Argument> makeArgument = node -> {
                    List<TclAstNode> children = node.getChildren();
                    boolean hasDefault = children.size() == 2;
                    String argName = hasDefault ? children.get(0).getInternalText(argsBuffer) : node.getInternalText(argsBuffer);
                    String defaultValue = hasDefault ? children.get(1).getInternalText(argsBuffer) : null;
                    return new ProcedureDefinition.Argument(argName, defaultValue);
                };
                List arguments = Optional.ofNullable(procArgs.getChild(2)).map(cmd -> cmd.getChildren().stream().map(makeArgument).collect(Collectors.toList())).orElseGet(ArrayList::new);
                TclAstNode commentAstNode = null;
                String commentText = null;
                if (ctx.mostRecentComment != null) {
                    commentAstNode = ctx.mostRecentComment;
                    commentText = ctx.mostRecentComment.getInternalText(file.contents.toCharArray());
                }
                ProcedureDefinition proc = new ProcedureDefinition(name, location, arguments, ctx.currentNode, commentAstNode, commentText);
                procedureDefinitions.add(proc);
                this.procedureDefinitions.put(proc.name, proc);
                this.procedureCalls.put(proc, new ArrayList());
                args[0] = "proc_internal";
                return this.agent.getInterpreter().eval("{" + Joiner.on((String)"} {").join((Object[])args) + "}");
            });
            file.traverseAst(node -> {
                String nodeText = file.getNodeInternalText((TclAstNode)node);
                if (ctx.currentNode != null) {
                    ctx.mostRecentComment = ctx.currentNode.getType() == 1 ? ctx.currentNode : null;
                }
                ctx.currentNode = node;
                if (node.getType() == 2) {
                    Diagnostic diagnostic;
                    try {
                        this.agent.getInterpreter().eval(nodeText);
                    }
                    catch (SoarInterpreterException ex) {
                        LOG.error("interpreter exception {}", (Throwable)ex);
                        SourceLocation location = ex.getSourceLocation();
                        Position start = file.position(location.getOffset() - 1);
                        Position end = file.position(location.getOffset() + location.getLength());
                        Iterator diagnostic2 = new Diagnostic(new Range(start, end), "Failed to source production in this file: " + (Object)((Object)ex), DiagnosticSeverity.Error, "SoarInterpreterException");
                        diagnosticList.add((Diagnostic)diagnostic2);
                    }
                    catch (TclInterpreterException ex) {
                        diagnostic = new Diagnostic(file.rangeForNode(ctx.currentNode), ex.getMessage(), DiagnosticSeverity.Error, "TclInterpreterException");
                        diagnosticList.add(diagnostic);
                    }
                    catch (SoarException ex) {
                        LOG.error("Error while evaluating Soar command: {}", (Object)nodeText, (Object)ex);
                        diagnostic = new Diagnostic(new Range(new Position(0, 0), new Position(0, 8)), "PLACEHOLDER: Failed to source production in this file: " + (Object)((Object)ex), DiagnosticSeverity.Error, "SoarException");
                        diagnosticList.add(diagnostic);
                    }
                }
                switch (node.getType()) {
                    case 2: {
                        VariableDefinition var;
                        String commentText;
                        TclAstNode commentAstNode;
                        String value;
                        Location location;
                        String name;
                        ImmutableMap<String, String> newVariables = this.getCurrentVariables();
                        MapDifference difference = Maps.difference(this.currentVariables, newVariables);
                        Map onRight = difference.entriesOnlyOnRight();
                        Map differing = difference.entriesDiffering();
                        for (Map.Entry entry : onRight.entrySet()) {
                            name = (String)entry.getKey();
                            location = this.location(file.uri, file.rangeForNode(ctx.currentNode));
                            value = (String)entry.getValue();
                            commentAstNode = null;
                            commentText = null;
                            if (ctx.mostRecentComment != null) {
                                commentAstNode = ctx.mostRecentComment;
                                commentText = ctx.mostRecentComment.getInternalText(file.contents.toCharArray());
                            }
                            var = new VariableDefinition(name, location, ctx.currentNode, value, commentAstNode, commentText);
                            this.variableDefinitions.put(var.name, var);
                        }
                        for (Map.Entry entry : differing.entrySet()) {
                            name = (String)entry.getKey();
                            location = this.location(file.uri, file.rangeForNode(ctx.currentNode));
                            value = (String)((MapDifference.ValueDifference)entry.getValue()).rightValue();
                            commentAstNode = null;
                            commentText = null;
                            if (ctx.mostRecentComment != null) {
                                commentAstNode = ctx.mostRecentComment;
                                commentText = ctx.mostRecentComment.getInternalText(file.contents.toCharArray());
                            }
                            var = new VariableDefinition(name, location, ctx.currentNode, value, commentAstNode, commentText);
                            this.variableDefinitions.put(var.name, var);
                        }
                        this.currentVariables = newVariables;
                        for (SoftTclInterpreterException softTclInterpreterException : this.agent.getInterpreter().getExceptionsManager().getExceptions()) {
                            Range range = file.rangeForNode(ctx.currentNode);
                            String message = softTclInterpreterException.getMessage().trim();
                            DiagnosticSeverity severity = DiagnosticSeverity.Error;
                            LOG.info("Diagnostic message: {}", (Object)message);
                            Matcher rhsMatcher = NO_RHS_FUNCTION_PATTERN.matcher(message);
                            if (rhsMatcher.matches()) {
                                severity = DiagnosticSeverity.Warning;
                                String rhsFunction = rhsMatcher.group(1);
                                boolean whitelisted = this.projectConfig.rhsFunctions.contains(rhsFunction);
                                if (whitelisted) continue;
                            }
                            if (message.matches(DUPLICATE_PRODUCTION_REGEX)) {
                                severity = DiagnosticSeverity.Warning;
                            }
                            diagnosticList.add(new Diagnostic(range, message, severity, "SoftTclInterpreterException"));
                        }
                        this.agent.getInterpreter().getExceptionsManager().clearExceptions();
                    }
                    case 6: {
                        TclAstNode firstChild = node.getChild(3);
                        if (firstChild == null) break;
                        String name = file.getNodeInternalText(firstChild);
                        Location location = this.location(file.uri, file.rangeForNode((TclAstNode)node));
                        ProcedureCall procedureCall = new ProcedureCall(location, (TclAstNode)node, this.procedureDefinitions.get(name));
                        procedureCalls.put((TclAstNode)node, procedureCall);
                        procedureCall.definition.ifPresent(def -> this.procedureCalls.get(def).add(procedureCall));
                        break;
                    }
                    case 7: {
                        TclAstNode nameNode = node.getChild(8);
                        if (nameNode == null) break;
                        String name = file.getNodeInternalText(nameNode);
                        Location location = this.location(file.uri, file.rangeForNode((TclAstNode)node));
                        VariableDefinition definition = this.variableDefinitions.get(name);
                        VariableRetrieval retrieval = new VariableRetrieval(location, (TclAstNode)node, definition);
                        variableRetrievals.put((TclAstNode)node, retrieval);
                        retrieval.definition.ifPresent(def -> this.variableRetrievals.computeIfAbsent((VariableDefinition)def, key -> new ArrayList()).add(retrieval));
                    }
                }
            });
            FileAnalysis analysis = new FileAnalysis(file, procedureCalls, variableRetrievals, procedureDefinitions, filesSourced, productions, diagnosticList);
            this.files.put(file.uri, analysis);
        }
        catch (Throwable throwable) {
            for (Map.Entry cmd : originalCommands.entrySet()) {
                this.agent.getInterpreter().addCommand((String)cmd.getKey(), (SoarCommand)cmd.getValue());
            }
            throw throwable;
        }
        for (Map.Entry entry : originalCommands.entrySet()) {
            this.agent.getInterpreter().addCommand((String)entry.getKey(), (SoarCommand)entry.getValue());
        }
    }

    private String printAst(SoarFile file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream(baos, true);){
            file.ast.printTree(ps, file.contents.toCharArray(), 4);
        }
        String data = new String(baos.toByteArray());
        return data;
    }

    private void addCommand(String commandName, final SoarCommandExecute implementation) {
        this.agent.getInterpreter().addCommand(commandName, new SoarCommand(){

            public String execute(SoarCommandContext context, String[] args) throws SoarException {
                LOG.trace("Executing {}", (Object)Arrays.toString(args));
                return implementation.execute(context, args);
            }

            public Object getCommand() {
                return this;
            }
        });
    }

    String evalCommand(String command) {
        try {
            return this.agent.getInterpreter().eval(command);
        }
        catch (SoarException e) {
            LOG.trace("Evaluating command: {}", (Object)command, (Object)e);
            return "";
        }
    }

    ImmutableMap<String, String> getCurrentVariables() {
        String[] variableNames = this.evalCommand("info globals").split("\\s+");
        return (ImmutableMap)Arrays.stream(variableNames).collect(ImmutableMap.toImmutableMap(var -> var, var -> {
            String result;
            try {
                result = this.tclInterp.getVar(var, 1).toString();
            }
            catch (TclException e) {
                result = "";
            }
            return result;
        }));
    }

    Location location(URI uri, Range range) {
        return new Location(uri.toString(), range);
    }

    static interface SoarCommandExecute {
        public String execute(SoarCommandContext var1, String[] var2) throws SoarException;
    }
}

