/*
 * Decompiled with CFR 0.152.
 */
package com.soartech.soarls.analysis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.soartech.soarls.SoarFile;
import com.soartech.soarls.analysis.ProcedureCall;
import com.soartech.soarls.analysis.ProcedureDefinition;
import com.soartech.soarls.analysis.Production;
import com.soartech.soarls.analysis.VariableRetrieval;
import com.soartech.soarls.tcl.TclAstNode;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;

public class FileAnalysis {
    public final URI uri;
    public final SoarFile file;
    public final ImmutableMap<TclAstNode, ProcedureCall> procedureCalls;
    public final ImmutableMap<TclAstNode, VariableRetrieval> variableRetrievals;
    public final ImmutableList<ProcedureDefinition> procedureDefinitions;
    public final ImmutableList<URI> filesSourced;
    public final ImmutableMap<TclAstNode, ImmutableList<Production>> productions;
    public final ImmutableList<Diagnostic> diagnostics;

    public Optional<ProcedureCall> procedureCall(TclAstNode node) {
        while (node != null) {
            ProcedureCall call = (ProcedureCall)this.procedureCalls.get((Object)node);
            if (call != null) {
                return Optional.of(call);
            }
            node = node.getParent();
        }
        return Optional.empty();
    }

    public Optional<VariableRetrieval> variableRetrieval(TclAstNode node) {
        if (node.getType() == 8) {
            node = node.getParent();
        }
        return Optional.ofNullable(this.variableRetrievals.get((Object)node));
    }

    public FileAnalysis(SoarFile file, Map<TclAstNode, ProcedureCall> procedureCalls, Map<TclAstNode, VariableRetrieval> variableRetrievals, List<ProcedureDefinition> procedureDefinitions, List<URI> filesSourced, Map<TclAstNode, List<Production>> productions, List<Diagnostic> diagnostics) {
        this.uri = file.uri;
        this.file = file;
        this.procedureCalls = ImmutableMap.copyOf(procedureCalls);
        this.variableRetrievals = ImmutableMap.copyOf(variableRetrievals);
        this.procedureDefinitions = ImmutableList.copyOf(procedureDefinitions);
        this.filesSourced = ImmutableList.copyOf(filesSourced);
        this.productions = (ImmutableMap)productions.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (TclAstNode)e.getKey(), e -> ImmutableList.copyOf((Collection)((Collection)e.getValue()))));
        this.diagnostics = ImmutableList.copyOf(diagnostics);
    }
}

