/*
 * Decompiled with CFR 0.152.
 */
package com.soartech.soarls.tcl;

import com.soartech.soarls.tcl.TclAstNode;
import com.soartech.soarls.tcl.TclParserError;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class TclParser {
    private static final char EOF = '\u0000';
    private List<TclParserError> errors = new ArrayList<TclParserError>();
    private char[] input;
    private int start;
    private int end;
    private int cursor = 0;
    private int retryPosition = -1;

    public void setInput(char[] input, int offset, int length) {
        this.input = input;
        this.start = offset;
        this.end = this.start + length;
    }

    public void setInput(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            this.setInput(reader);
        }
    }

    public void setInput(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[4096];
        int r = reader.read(buffer);
        while (r >= 0) {
            builder.append(buffer, 0, r);
            r = reader.read(buffer);
        }
        char[] chars = builder.toString().toCharArray();
        this.setInput(chars, 0, chars.length);
    }

    public char[] getInput() {
        return this.input;
    }

    public TclAstNode parse() {
        this.errors.clear();
        TclAstNode root = new TclAstNode(0, 0);
        this.consumeWhitespace();
        while (!this.isEof()) {
            if (this.lookAhead(0) == '#') {
                TclAstNode comment = this.consumeComment();
                if (comment != null) {
                    root.addChild(comment);
                }
            } else {
                TclAstNode command = this.consumeCommand();
                if (command != null) {
                    root.addChild(command);
                    if (command.getError() != null && this.retryPosition != -1) {
                        this.cursor = this.retryPosition;
                        this.retryPosition = -1;
                    }
                }
            }
            this.consumeWhitespace();
        }
        root.setEnd(this.getOffset());
        return root;
    }

    public List<TclParserError> getErrors() {
        return this.errors;
    }

    private TclAstNode consumeCommand() {
        this.retryPosition = -1;
        TclAstNode commandNode = new TclAstNode(2, this.getOffset());
        List<TclAstNode> kids = commandNode.getChildren();
        while (!this.consumeTerminator() && commandNode.getError() == null) {
            TclAstNode node = this.consumeWord('\u0000');
            if (node.getError() != null) {
                commandNode.setError(node.getError());
                commandNode.setEnd(node.getStart() + node.getLength());
            }
            commandNode.addChild(node);
        }
        if (commandNode.getError() == null) {
            if (!kids.isEmpty()) {
                TclAstNode lastChild = kids.get(kids.size() - 1);
                commandNode.setEnd(lastChild.getStart() + lastChild.getLength());
            } else {
                commandNode.setEnd(this.getOffset());
            }
        }
        return commandNode.getChildren().isEmpty() ? null : commandNode;
    }

    private boolean consumeTerminator() {
        char c = this.lookAhead(0);
        while (c != '\u0000') {
            if (c == ';') {
                this.consume();
                return true;
            }
            if (c == '\r' || c == '\n') {
                if (this.lookAhead(-1) == '\\') {
                    this.consumeWhitespace();
                    return false;
                }
                if (c == '\r' && this.lookAhead(1) == '\n') {
                    this.consume();
                    this.consume();
                    return true;
                }
                this.consume();
                return true;
            }
            if (c != '\\' && !Character.isWhitespace(c)) {
                return false;
            }
            this.consume();
            c = this.lookAhead(0);
        }
        return true;
    }

    private TclAstNode consumeWord(char terminator) {
        char c = this.lookAhead(0);
        if (c == '\"') {
            return this.consumeQuotedWord();
        }
        if (c == '{') {
            return this.consumeBracedWord();
        }
        if (c == '[') {
            return this.consumeCommandWord();
        }
        return this.consumeNormalWord(terminator);
    }

    private TclAstNode consumeNormalWord(char terminator) {
        TclAstNode node = new TclAstNode(3, this.getOffset());
        char c = this.lookAhead(0);
        while (c != '\u0000') {
            if (Character.isWhitespace(c) || c == terminator) {
                node.setEnd(this.getOffset());
                return node;
            }
            if (c == ';') {
                node.setEnd(this.getOffset());
                this.consume();
                return node;
            }
            if (c == '\\') {
                this.consumeEscapedCharacter();
            } else if (c == '[') {
                node.addChild(this.consumeCommandWord());
            } else if (c == '$') {
                node.addChild(this.consumeVariable());
            } else {
                this.consume();
            }
            c = this.lookAhead(0);
        }
        node.setEnd(this.getOffset());
        return node;
    }

    private TclAstNode consumeQuotedWord() {
        assert (this.lookAhead(0) == '\"');
        TclAstNode node = new TclAstNode(4, this.getOffset());
        this.consume();
        char c = this.lookAhead(0);
        while (c != '\u0000') {
            if (c == '\"') {
                this.consume();
                node.setEnd(this.getOffset());
                return node;
            }
            if (c == '\\') {
                this.consumeEscapedCharacter();
            } else if (c == '[') {
                node.addChild(this.consumeCommandWord());
            } else if (c == '$') {
                node.addChild(this.consumeVariable());
            } else if (Character.isWhitespace(c)) {
                this.consume();
            } else {
                node.addChild(this.consumeNormalWord('\"'));
            }
            c = this.lookAhead(0);
        }
        node.setEnd(this.getOffset());
        if (c == '\u0000') {
            TclParserError error = new TclParserError(node.getStart(), this.getEndOfError() - node.getStart(), "Missing closing quote");
            this.errors.add(error);
            node.setError(error);
        }
        return node;
    }

    private TclAstNode consumeBracedWord() {
        assert (this.lookAhead(0) == '{');
        TclAstNode node = new TclAstNode(5, this.getOffset());
        this.consume();
        char c = this.lookAhead(0);
        while (c != '\u0000') {
            TclAstNode child;
            if (c == '}') {
                this.consume();
                node.setEnd(this.getOffset());
                return node;
            }
            if (c == '\\') {
                this.consumeEscapedCharacter();
            } else if (c == '{') {
                child = this.consumeBracedWord();
                node.addChild(child);
                if (child.getError() != null) {
                    node.setError(child.getError());
                    node.setEnd(this.getEndOfError());
                    return node;
                }
            } else if (Character.isWhitespace(c)) {
                this.consume();
            } else {
                child = new TclAstNode(3, this.getOffset());
                while (c != '\u0000' && c != '}' && !Character.isWhitespace(c)) {
                    if (c == '\\') {
                        this.consumeEscapedCharacter();
                    } else if (c == '{') {
                        this.consumeBracedWord();
                    } else {
                        this.consume();
                    }
                    c = this.lookAhead(0);
                }
                child.setEnd(this.getOffset());
                node.addChild(child);
            }
            c = this.lookAhead(0);
        }
        node.setEnd(this.getOffset());
        if (c == '\u0000') {
            TclParserError error = new TclParserError(node.getStart(), this.getEndOfError() - node.getStart(), "Missing closing brace");
            this.errors.add(error);
            node.setError(error);
        }
        return node;
    }

    private TclAstNode consumeCommandWord() {
        assert (this.lookAhead(0) == '[');
        TclAstNode node = new TclAstNode(6, this.getOffset());
        this.consume();
        char c = this.lookAhead(0);
        while (c != '\u0000') {
            TclAstNode child = null;
            if (c == ']') {
                this.consume();
                node.setEnd(this.getOffset());
                return node;
            }
            if (c == '\\') {
                this.consumeEscapedCharacter();
            } else if (c == '[') {
                child = this.consumeCommandWord();
                node.addChild(child);
            } else if (c == '{') {
                child = this.consumeBracedWord();
                node.addChild(child);
            } else if (c == '$') {
                child = this.consumeVariable();
                node.addChild(child);
            } else if (Character.isWhitespace(c)) {
                this.consume();
            } else {
                child = this.consumeWord(']');
                node.addChild(child);
            }
            if (child != null && child.getError() != null) {
                node.setError(child.getError());
                node.setEnd(this.getEndOfError());
                return node;
            }
            c = this.lookAhead(0);
        }
        node.setEnd(this.getOffset());
        if (c == '\u0000') {
            TclParserError error = new TclParserError(node.getStart(), this.getEndOfError() - node.getStart(), "Missing closing bracket");
            node.setError(error);
            this.errors.add(error);
        }
        return node;
    }

    private void consumeEscapedCharacter() {
        assert ('\\' == this.lookAhead(0));
        this.consume();
        char c = this.lookAhead(0);
        if (c == '\n') {
            this.consumeWhitespace();
        } else {
            this.consume();
        }
    }

    private TclAstNode consumeVariable() {
        assert (this.lookAhead(0) == '$');
        TclAstNode node = new TclAstNode(7, this.getOffset());
        this.consume();
        char c = this.lookAhead(0);
        if (c == '{') {
            TclAstNode nameNode = new TclAstNode(8, this.getOffset() + 1);
            this.consumeBracedWord();
            nameNode.setEnd(this.getOffset() - 1);
            node.addChild(nameNode);
            node.setEnd(this.getOffset());
            return node;
        }
        TclAstNode nameNode = new TclAstNode(8, this.getOffset());
        while (Character.isLetterOrDigit(c) || c == '_') {
            this.consume();
            c = this.lookAhead(0);
        }
        nameNode.setEnd(this.getOffset());
        node.addChild(nameNode);
        node.setEnd(this.getOffset());
        return node;
    }

    private TclAstNode consumeComment() {
        if (this.isEof() || '#' != this.lookAhead(0)) {
            return null;
        }
        TclAstNode node = new TclAstNode(1, this.getOffset());
        this.consumeLine();
        while (!this.isEof() && '#' == this.lookAhead(0)) {
            this.consumeLine();
        }
        node.setEnd(this.getOffset());
        return node;
    }

    private boolean isEof() {
        return this.cursor == this.end;
    }

    private int getOffset() {
        return this.start + this.cursor;
    }

    private void consume() {
        if (this.cursor < this.end) {
            ++this.cursor;
            this.updateRetryPosition();
        }
    }

    private int getEndOfError() {
        return this.retryPosition != -1 ? this.retryPosition : this.getOffset();
    }

    private void updateRetryPosition() {
        char fwd2 = this.lookAhead(2);
        char fwd1 = this.lookAhead(1);
        char current = this.lookAhead(0);
        char back1 = this.lookAhead(-1);
        char back2 = this.lookAhead(-2);
        char back3 = this.lookAhead(-3);
        if (this.retryPosition != -1) {
            return;
        }
        if (Character.isLetter(current) || fwd1 == '#' && fwd2 == '#') {
            if (back1 == '\n' && back2 == '\r' && back3 != '\\') {
                this.retryPosition = this.cursor;
            } else if ((back1 == '\n' || back1 == '\r') && back2 != '\\') {
                this.retryPosition = this.cursor;
            }
        }
    }

    private void consumeWhitespace() {
        while (!this.isEof()) {
            if (Character.isWhitespace(this.lookAhead(0))) {
                this.consume();
                continue;
            }
            if (this.lookAhead(0) != '\\' || !Character.isWhitespace(this.lookAhead(1))) break;
            this.consume();
            this.consume();
        }
    }

    private void consumeLine() {
        char c = this.lookAhead(0);
        while (!this.isEof()) {
            if ((c == '\n' || c == '\r') && this.lookAhead(-1) != '\\') {
                this.consume();
                break;
            }
            this.consume();
            c = this.lookAhead(0);
        }
        if (c == '\r' && this.lookAhead(0) == '\n') {
            this.consume();
        }
    }

    private char lookAhead(int amount) {
        int newCursor = this.cursor + amount;
        if (newCursor < 0 || newCursor >= this.end) {
            return '\u0000';
        }
        return this.input[newCursor];
    }

    public static void main(String[] args) throws IOException {
        String input = "set x 99\nsp {test\nset p hello\n";
        TclParser parser = new TclParser();
        parser.setInput(input.toCharArray(), 0, input.length());
        TclAstNode root = parser.parse();
        for (TclParserError e : parser.getErrors()) {
            System.err.println(e);
        }
        root.printTree(System.err, parser.getInput(), 0);
    }
}

