/*
 * Decompiled with CFR 0.152.
 */
package com.soartech.soarls.util;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Debouncer {
    private Duration delay;
    private final ScheduledExecutorService workerThread = Executors.newScheduledThreadPool(1);
    private Future<?> pendingTask = null;

    public Debouncer(Duration delay) {
        this.delay = delay;
    }

    public void submit(Runnable task) {
        if (this.pendingTask != null) {
            this.pendingTask.cancel(false);
        }
        this.pendingTask = this.workerThread.schedule(task, this.delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void setDelay(Duration delay) {
        this.delay = delay;
    }
}

