/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jsoar.kernel.AgentRunController;
import org.jsoar.kernel.Consistency;
import org.jsoar.kernel.DebuggerProvider;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.DecisionCycle;
import org.jsoar.kernel.DecisionManipulation;
import org.jsoar.kernel.DefaultDebuggerProvider;
import org.jsoar.kernel.DefaultProductionManager;
import org.jsoar.kernel.Goal;
import org.jsoar.kernel.LogManager;
import org.jsoar.kernel.MatchSet;
import org.jsoar.kernel.Phase;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.ProductionManager;
import org.jsoar.kernel.RunType;
import org.jsoar.kernel.SavedFiringType;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.epmem.DefaultEpisodicMemory;
import org.jsoar.kernel.events.AfterInitSoarEvent;
import org.jsoar.kernel.events.BeforeInitSoarEvent;
import org.jsoar.kernel.exploration.Exploration;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.InputOutputImpl;
import org.jsoar.kernel.learning.Chunker;
import org.jsoar.kernel.learning.Explain;
import org.jsoar.kernel.learning.rl.ReinforcementLearning;
import org.jsoar.kernel.lhs.MultiAttributes;
import org.jsoar.kernel.memory.ContextVariableInfo;
import org.jsoar.kernel.memory.OSupport;
import org.jsoar.kernel.memory.RecognitionMemory;
import org.jsoar.kernel.memory.TemporaryMemory;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WorkingMemory;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rete.SoarReteListener;
import org.jsoar.kernel.rhs.functions.RhsFunctionManager;
import org.jsoar.kernel.rhs.functions.StandardFunctions;
import org.jsoar.kernel.smem.DefaultSemanticMemory;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.tracing.PrintEventWriter;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.tracing.TraceFormatRestriction;
import org.jsoar.kernel.tracing.TraceFormats;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivation;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivationParams;
import org.jsoar.util.Arguments;
import org.jsoar.util.NullWriter;
import org.jsoar.util.adaptables.AbstractAdaptable;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.commands.DefaultInterpreter;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.commands.SoarCommandInterpreterFactory;
import org.jsoar.util.events.SoarEventManager;
import org.jsoar.util.properties.PropertyManager;
import org.jsoar.util.timing.DefaultExecutionTimer;
import org.jsoar.util.timing.ExecutionTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agent
extends AbstractAdaptable
implements AgentRunController {
    private static final Logger logger = LoggerFactory.getLogger(Agent.class);
    private static final AtomicInteger nextName = new AtomicInteger(0);
    private DebuggerProvider debuggerProvider = new DefaultDebuggerProvider();
    private Printer printer = new Printer(new NullWriter());
    private final Random random = new Random();
    private SoarCommandInterpreter interp;
    private final PropertyManager properties = new PropertyManager();
    private final Trace trace = new Trace(this.printer);
    private final TraceFormats traceFormats = new TraceFormats(this);
    private final SymbolFactoryImpl syms = new SymbolFactoryImpl();
    private final PredefinedSymbols predefinedSyms = new PredefinedSymbols(this.syms);
    private final MultiAttributes multiAttrs = new MultiAttributes();
    private final WorkingMemory workingMemory = new WorkingMemory();
    private final TemporaryMemory tempMemory = new TemporaryMemory();
    private final OSupport osupport = new OSupport(this.predefinedSyms, this.printer);
    private final RecognitionMemory recMemory = new RecognitionMemory(this);
    private final Exploration exploration = new Exploration(this);
    private final Decider decider = new Decider(this);
    private final Consistency consistency = new Consistency(this);
    private final Chunker chunker = new Chunker(this);
    private final Explain explain = new Explain(this);
    private final ReinforcementLearning rl = new ReinforcementLearning(this);
    private final DefaultWorkingMemoryActivation wma = new DefaultWorkingMemoryActivation(this);
    private final DefaultSemanticMemory smem = new DefaultSemanticMemory(this);
    private final DefaultEpisodicMemory epmem = new DefaultEpisodicMemory(this);
    private final Rete rete = new Rete(this.trace, this.syms, this.epmem, this.smem, this.rl.getParams());
    private final SoarReteListener soarReteListener = new SoarReteListener(this, this.rete);
    private final DecisionManipulation decisionManip = new DecisionManipulation(this.decider, this.random);
    private final InputOutputImpl io = new InputOutputImpl(this);
    private final RhsFunctionManager rhsFunctions = new RhsFunctionManager(this.recMemory.getRhsFunctionContext());
    private final DecisionCycle decisionCycle = new DecisionCycle(this);
    private final SoarEventManager eventManager = new SoarEventManager();
    private final DefaultProductionManager productions = new DefaultProductionManager(this);
    private final LogManager logManager = new LogManager(this);
    private final ExecutionTimer totalCpuTimer = DefaultExecutionTimer.newInstance().setName("Total CPU time");
    private final ExecutionTimer totalKernelTimer = DefaultExecutionTimer.newInstance().setName("Total kernel time");
    private boolean initialized = false;
    private final List<Object> adaptables = Arrays.asList(this.printer, this.trace, this.decisionManip, this.exploration, this.io, this.traceFormats, this.properties, this.chunker, this.explain, this.decisionCycle, this.rete, this.predefinedSyms, this.predefinedSyms.getSyms(), this.decider, this.printer, this.rhsFunctions, this.workingMemory, this.tempMemory, this.recMemory, this.osupport, this.soarReteListener, this.consistency, this.debuggerProvider, this.decider, this.rl, this.smem, this.wma, this.epmem);

    public Agent() {
        this(null, true);
    }

    public Agent(boolean initializeAgent) {
        this(null, initializeAgent);
    }

    public Agent(String name) {
        this(name, true);
    }

    public Agent(String name, boolean initializeAgent) {
        this.setName(name != null ? name : "JSoar Agent " + nextName.incrementAndGet());
        this.printer.addPersistentWriter(new PrintEventWriter(this.getEvents()));
        this.decider.initialize();
        this.decisionCycle.initialize();
        this.rl.initialize();
        this.recMemory.initialize();
        this.chunker.initialize();
        this.consistency.initialize();
        this.traceFormats.initalize();
        this.productions.initialize();
        this.workingMemory.initialize(this);
        this.io.initialize();
        this.soarReteListener.initialize();
        this.exploration.initialize();
        this.smem.initialize();
        this.epmem.initialize();
        this.wma.initialize();
        new StandardFunctions(this);
        this.installDefaultTraceFormats();
        if (initializeAgent) {
            this.initialize();
        }
    }

    public void dispose() {
        this.setInterpreter(null);
        if (this.smem != null) {
            try {
                this.smem.smem_close();
            }
            catch (SoarException e) {
                logger.error("While closing smem database: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.epmem != null) {
            try {
                this.epmem.epmem_close();
            }
            catch (SoarException e) {
                logger.error("While closing epmem database: " + e.getMessage(), (Throwable)e);
            }
        }
        logger.info("Agent '" + this + "' disposed.");
    }

    public String getName() {
        return this.getProperties().get(SoarProperties.NAME);
    }

    public void setName(String name) {
        this.getProperties().set(SoarProperties.NAME, name);
    }

    public DebuggerProvider getDebuggerProvider() {
        return this.debuggerProvider;
    }

    public void setDebuggerProvider(DebuggerProvider debuggerProvider) {
        Arguments.checkNotNull(debuggerProvider, "debuggerProvider");
        this.debuggerProvider = debuggerProvider;
    }

    public void openDebugger() throws SoarException {
        this.getDebuggerProvider().openDebugger(this);
    }

    public void openDebuggerAndWait() throws SoarException, InterruptedException {
        this.getDebuggerProvider().openDebuggerAndWait(this);
    }

    public void initialize() {
        if (!this.initialized) {
            this.init_agent_memory();
            this.initialized = true;
        } else {
            this.reinitialize_soar();
            this.init_agent_memory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoarCommandInterpreter getInterpreter() {
        Agent agent = this;
        synchronized (agent) {
            if (this.interp == null) {
                this.interp = this.createInterpreter(System.getProperty("jsoar.agent.interpreter", "default"));
                logger.info("Current command interpreter is '" + this.interp.getName() + "' : '" + this.interp.getClass() + "'");
                String DEFAULT_ALIASES = "/org/jsoar/kernel/commands/aliases";
                try {
                    this.interp.source(Agent.class.getResource("/org/jsoar/kernel/commands/aliases"));
                }
                catch (SoarException e) {
                    logger.error("Failed to load default aliases from '/org/jsoar/kernel/commands/aliases': " + e.getMessage(), (Throwable)e);
                }
            }
            return this.interp;
        }
    }

    private SoarCommandInterpreter createInterpreter(String name) {
        ServiceLoader<SoarCommandInterpreterFactory> loader = ServiceLoader.load(SoarCommandInterpreterFactory.class);
        for (SoarCommandInterpreterFactory factory : loader) {
            if (name != null && !name.equals(factory.getName())) continue;
            return factory.create(this);
        }
        logger.warn("Could not find interpreter named '" + name + "'. Using default.");
        return new DefaultInterpreter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterpreter(SoarCommandInterpreter interp) {
        Agent agent = this;
        synchronized (agent) {
            if (this.interp != null) {
                this.interp.dispose();
            }
            this.interp = interp;
            logger.info("Current command interpreter is '" + (interp != null ? interp.getClass() : "none") + "'");
        }
    }

    public PropertyManager getProperties() {
        return this.properties;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public RhsFunctionManager getRhsFunctions() {
        return this.rhsFunctions;
    }

    public MultiAttributes getMultiAttributes() {
        return this.multiAttrs;
    }

    public SoarEventManager getEvents() {
        return this.eventManager;
    }

    @Deprecated
    public SoarEventManager getEventManager() {
        return this.getEvents();
    }

    public ProductionManager getProductions() {
        return this.productions;
    }

    public InputOutput getInputOutput() {
        return this.io;
    }

    public SymbolFactory getSymbols() {
        return this.syms;
    }

    public ContextVariableInfo getContextVariableInfo(String variable) {
        return ContextVariableInfo.get(this.predefinedSyms, this.decider.top_goal, this.decider.bottom_goal, variable);
    }

    public Symbol readIdentifierOrContextVariable(String t) {
        ContextVariableInfo info = ContextVariableInfo.get(this.predefinedSyms, this.decider.top_goal, this.decider.bottom_goal, t);
        if (info.getValue() != null) {
            return info.getValue();
        }
        if (t.charAt(0) == '@') {
            t = t.substring(1);
        }
        if (t.length() < 2 || !Character.isLetter(t.charAt(0))) {
            return null;
        }
        char letter = Character.toUpperCase(t.charAt(0));
        long number = 1L;
        try {
            number = Long.parseLong(t.substring(1));
        }
        catch (NumberFormatException e) {
            return null;
        }
        return this.syms.findIdentifier(letter, number);
    }

    public List<Goal> getGoalStack() {
        return this.decider.getGoalStack();
    }

    public void printStackTrace(boolean states, boolean operators) {
        if (!states && !operators) {
            operators = true;
            states = true;
        }
        int maxStates = 500;
        int stateCount = 0;
        Writer writer = this.printer.getWriter();
        IdentifierImpl g = this.decider.top_goal;
        while (g != null) {
            if (++stateCount <= 500) {
                try {
                    if (states) {
                        this.traceFormats.print_stack_trace(writer, g, g, TraceFormatRestriction.FOR_STATES_TF, false);
                        writer.append('\n');
                    }
                    if (operators && g.goalInfo.operator_slot.getWmes() != null) {
                        this.traceFormats.print_stack_trace(writer, g.goalInfo.operator_slot.getWmes().value, g, TraceFormatRestriction.FOR_OPERATORS_TF, false);
                        writer.append('\n');
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            g = g.goalInfo.lower_goal;
        }
        if (stateCount > 500) {
            this.printer.print("...Stack goes on for another %d states\n", stateCount - 500);
        }
        this.printer.flush();
    }

    public Random getRandom() {
        return this.random;
    }

    public ExecutionTimer getTotalCpuTimer() {
        return this.totalCpuTimer;
    }

    public ExecutionTimer getTotalKernelTimer() {
        return this.totalKernelTimer;
    }

    public List<ExecutionTimer> getAllTimers() {
        return Arrays.asList(this.totalCpuTimer, this.totalKernelTimer);
    }

    @Override
    public Phase getStopPhase() {
        return this.getProperties().get(SoarProperties.STOP_PHASE);
    }

    @Override
    public void setStopPhase(Phase phase) {
        this.getProperties().set(SoarProperties.STOP_PHASE, phase);
    }

    @Override
    public void runFor(long n, RunType runType) {
        this.ensureInitialized();
        if (runType == RunType.DECISIONS && this.decisionCycle.current_phase.get() != this.getStopPhase() && n > 0L) {
            --n;
        }
        this.decisionCycle.runFor(n, runType);
        this.getTrace().flush();
    }

    public void runForever() {
        this.ensureInitialized();
        this.decisionCycle.runForever();
        this.getTrace().flush();
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Agent has not been initialized.");
        }
    }

    public void stop() {
        this.decisionCycle.stop();
    }

    public String getReasonForStop() {
        return this.decisionCycle.getReasonForStop();
    }

    public Phase getCurrentPhase() {
        return (Phase)((Object)this.decisionCycle.current_phase.get());
    }

    public Set<Wme> getAllWmesInRete() {
        return new LinkedHashSet<Wme>(this.rete.getAllWmes());
    }

    public boolean isWmeInRete(Wme wme) {
        return this.rete.containsWme(wme);
    }

    public int getNumWmesInRete() {
        return this.rete.getAllWmes().size();
    }

    public void printMatchSet(Printer printer, Trace.WmeTraceType wtt, EnumSet<Trace.MatchSetTraceType> mst) {
        this.soarReteListener.print_match_set(printer, wtt, mst);
    }

    public MatchSet getMatchSet() {
        return this.soarReteListener.getMatchSet();
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    private void init_agent_memory() {
        if (this.decider.top_goal != null) {
            throw new IllegalStateException("There should be no top goal when init_agent_memory is called!");
        }
        this.decider.create_top_goal();
        if (this.trace.isEnabled() && this.trace.isEnabled(Trace.Category.CONTEXT_DECISIONS)) {
            Writer writer = this.trace.getPrinter().getWriter();
            try {
                writer.write("\n");
                this.traceFormats.print_lowest_slot_in_context_stack(writer, this.decider.bottom_goal);
            }
            catch (IOException e) {
                logger.error("IOException while printing initial stack trace. Ignoring.", (Throwable)e);
            }
        }
        this.decisionCycle.current_phase.set(Phase.INPUT);
        this.decisionCycle.d_cycle_count.increment();
        this.wma.d_cycle_count_increment();
        this.io.init_agent_memory();
        this.io.do_input_cycle();
        this.io.do_output_cycle();
        for (ExecutionTimer timer : this.getAllTimers()) {
            timer.reset();
        }
        this.wma.resetTimers();
    }

    private void installDefaultTraceFormats() {
        this.traceFormats.add_trace_format(false, TraceFormatRestriction.FOR_ANYTHING_TF, null, "%id %ifdef[(%v[name])]");
        this.traceFormats.add_trace_format(false, TraceFormatRestriction.FOR_STATES_TF, null, "%id %ifdef[(%v[attribute] %v[impasse])]");
        this.traceFormats.add_trace_format(false, TraceFormatRestriction.FOR_OPERATORS_TF, this.syms.createString("evaluate-object"), "%id (evaluate-object %o[object])");
        this.traceFormats.add_trace_format(true, TraceFormatRestriction.FOR_STATES_TF, null, "%right[6,%dc]: %rsd[   ]==>S: %cs");
        this.traceFormats.add_trace_format(true, TraceFormatRestriction.FOR_OPERATORS_TF, null, "%right[6,%dc]: %rsd[   ]   O: %co");
    }

    private void reinitialize_soar() {
        this.getEvents().fireEvent(new BeforeInitSoarEvent(this));
        boolean traceState = this.trace.isEnabled();
        this.trace.setEnabled(false);
        try {
            this.epmem.epmem_close();
        }
        catch (SoarException e2) {
            throw new RuntimeException("EpMem failed to close.", e2);
        }
        try {
            this.smem.smem_close();
        }
        catch (SoarException e1) {
            throw new RuntimeException("SMem failed to close.", e1);
        }
        boolean wma_was_enabled = this.wma.wma_enabled();
        this.wma.getParams().activation.set(DefaultWorkingMemoryActivationParams.ActivationChoices.off);
        this.decider.clear_goal_stack();
        this.io.do_input_cycle();
        this.io.do_output_cycle();
        if (wma_was_enabled) {
            this.wma.getParams().activation.set(DefaultWorkingMemoryActivationParams.ActivationChoices.on);
        }
        this.wma.getStats().reset();
        this.decider.active_level = 0;
        this.recMemory.FIRING_TYPE = SavedFiringType.IE_PRODS;
        this.recMemory.do_preference_phase(this.decider.top_goal);
        this.explain.reset_explain();
        this.syms.reset();
        try {
            this.smem.smem_reset_id_counters();
        }
        catch (SoarException e) {
            logger.error("While trying to reset SMEM id counters: " + e.getMessage(), (Throwable)e);
            this.printer.error("While trying to reset SMEM id counters: " + e.getMessage());
        }
        this.workingMemory.reset();
        this.decisionCycle.reset();
        this.recMemory.reset();
        this.chunker.reset();
        this.wma.reset();
        this.reset_statistics();
        this.trace.setEnabled(traceState);
        this.getEvents().fireEvent(new AfterInitSoarEvent(this));
    }

    private void reset_statistics() {
        this.chunker.chunks_this_d_cycle = 0;
        this.productions.resetStatistics();
        for (ExecutionTimer timer : this.getAllTimers()) {
            timer.reset();
        }
    }

    @Override
    public Object getAdapter(Class<?> klass) {
        Object o = Adaptables.findAdapter(this.adaptables, klass);
        if (o != null) {
            return o;
        }
        return super.getAdapter(klass);
    }

    public String toString() {
        return this.getName();
    }

    private static Agent agent() throws Exception {
        Agent a = new Agent();
        a.getPrinter().pushWriter(new OutputStreamWriter(System.out));
        a.initialize();
        a.getInterpreter().source(new File("../performance/count-test-single.soar"));
        System.out.println("\nLoaded " + a.getProductions().getProductionCount() + " rules");
        a.getPrinter().flush();
        a.runFor(20000L, RunType.DECISIONS);
        return a;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        for (int i = 0; i < 1; ++i) {
            System.out.print("\n#" + (i + 1));
            agents.add(Agent.agent());
        }
        while (true) {
            Thread.sleep(1000L);
        }
    }
}

