/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.DecisionCycle;
import org.jsoar.kernel.DecisionManipulation;
import org.jsoar.kernel.Goal;
import org.jsoar.kernel.GoalDependencySetImpl;
import org.jsoar.kernel.ImpasseType;
import org.jsoar.kernel.Phase;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.SoarConstants;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.epmem.EpisodicMemory;
import org.jsoar.kernel.events.GdsGoalRemovedEvent;
import org.jsoar.kernel.exploration.Exploration;
import org.jsoar.kernel.io.InputOutputImpl;
import org.jsoar.kernel.learning.Chunker;
import org.jsoar.kernel.learning.rl.ReinforcementLearning;
import org.jsoar.kernel.learning.rl.ReinforcementLearningInfo;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.memory.RecognitionMemory;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.TemporaryMemory;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.memory.WorkingMemory;
import org.jsoar.kernel.modules.SoarModule;
import org.jsoar.kernel.rete.MatchSetChange;
import org.jsoar.kernel.rete.SoarReteListener;
import org.jsoar.kernel.smem.SemanticMemory;
import org.jsoar.kernel.symbols.GoalIdentifierInfo;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.wma.WorkingMemoryActivation;
import org.jsoar.util.Arguments;
import org.jsoar.util.ByRef;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.markers.DefaultMarker;
import org.jsoar.util.markers.Marker;
import org.jsoar.util.properties.BooleanPropertyProvider;

public class Decider {
    private static final int LOWEST_POSSIBLE_GOAL_LEVEL = Integer.MAX_VALUE;
    private static final boolean DEBUG_GDS = Boolean.valueOf(System.getProperty("jsoar.gds.debug", "false"));
    private static final boolean DEBUG_GDS_HIGH = false;
    private static final boolean DEBUG_LINKS = false;
    private final Agent context;
    private PredefinedSymbols predefinedSyms;
    private DecisionManipulation decisionManip;
    private Exploration exploration;
    private Chunker chunker;
    private InputOutputImpl io;
    private DecisionCycle decisionCycle;
    private WorkingMemory workingMemory;
    private TemporaryMemory tempMemory;
    private RecognitionMemory recMemory;
    private SoarReteListener soarReteListener;
    private ReinforcementLearning rl;
    private SemanticMemory smem;
    private EpisodicMemory epmem;
    private WorkingMemoryActivation wma;
    private int MAX_GOAL_DEPTH = 100;
    private final ListHead<Slot> context_slots_with_changed_acceptable_preferences = ListHead.newInstance();
    private final List<IdentifierImpl> promoted_ids = new ArrayList<IdentifierImpl>();
    private LinkUpdateType link_update_mode = LinkUpdateType.UPDATE_LINKS_NORMALLY;
    private final ListHead<IdentifierImpl> ids_with_unknown_level = ListHead.newInstance();
    private final ListHead<IdentifierImpl> disconnected_ids = ListHead.newInstance();
    private Marker mark_tc_number;
    private int level_at_which_marking_started;
    private int highest_level_anything_could_fall_from;
    private int lowest_level_anything_could_fall_to;
    private Marker walk_tc_number;
    private int walk_level;
    public IdentifierImpl top_goal;
    public IdentifierImpl bottom_goal;
    public IdentifierImpl top_state;
    public IdentifierImpl active_goal;
    IdentifierImpl previous_active_goal;
    public int active_level;
    int previous_active_level;
    public int highest_active_level;
    public IdentifierImpl highest_active_goal;
    public int change_level;
    public int next_change_level;
    private BooleanPropertyProvider waitsnc = new BooleanPropertyProvider(SoarProperties.WAITSNC);
    private ParentInstantiation parent_list_head;

    public Decider(Agent context) {
        Arguments.checkNotNull(context, "context");
        this.context = context;
    }

    public void initialize() {
        this.context.getProperties().setProvider(SoarProperties.WAITSNC, this.waitsnc);
        this.predefinedSyms = Adaptables.adapt(this.context, PredefinedSymbols.class);
        this.exploration = Adaptables.adapt(this.context, Exploration.class);
        this.decisionManip = Adaptables.adapt(this.context, DecisionManipulation.class);
        this.io = Adaptables.adapt(this.context, InputOutputImpl.class);
        this.decisionCycle = Adaptables.adapt(this.context, DecisionCycle.class);
        this.workingMemory = Adaptables.adapt(this.context, WorkingMemory.class);
        this.tempMemory = Adaptables.adapt(this.context, TemporaryMemory.class);
        this.recMemory = Adaptables.adapt(this.context, RecognitionMemory.class);
        this.soarReteListener = Adaptables.adapt(this.context, SoarReteListener.class);
        this.chunker = Adaptables.adapt(this.context, Chunker.class);
        this.rl = Adaptables.adapt(this.context, ReinforcementLearning.class);
        this.smem = Adaptables.require(this.getClass(), this.context, SemanticMemory.class);
        this.epmem = Adaptables.require(this.getClass(), this.context, EpisodicMemory.class);
        this.wma = Adaptables.require(this.getClass(), this.context, WorkingMemoryActivation.class);
    }

    public List<Goal> getGoalStack() {
        ArrayList<Goal> result = new ArrayList<Goal>();
        IdentifierImpl g = this.top_goal;
        while (g != null) {
            Goal goal = Adaptables.adapt(g, Goal.class);
            assert (goal != null);
            result.add(goal);
            g = g.goalInfo.lower_goal;
        }
        return result;
    }

    public IdentifierImpl find_goal_at_goal_stack_level(int level) {
        IdentifierImpl g = this.top_goal;
        while (g != null) {
            if (g.level == level) {
                return g;
            }
            g = g.goalInfo.lower_goal;
        }
        return null;
    }

    public void mark_context_slot_as_acceptable_preference_changed(Slot s) {
        ListItem<Slot> dc;
        if (s.acceptable_preference_changed != null) {
            return;
        }
        s.acceptable_preference_changed = dc = new ListItem<Slot>(s);
        dc.insertAtHead(this.context_slots_with_changed_acceptable_preferences);
    }

    private void do_acceptable_preference_wme_changes_for_slot(Slot s) {
        WmeImpl wme;
        WmeImpl w = s.getAcceptablePreferenceWmes();
        while (w != null) {
            w.value.decider_flag = DeciderFlag.NOTHING;
            w = w.next;
        }
        Preference p = s.getPreferencesByType(PreferenceType.REQUIRE);
        while (p != null) {
            p.value.decider_flag = DeciderFlag.CANDIDATE;
            p = p.next;
        }
        p = s.getPreferencesByType(PreferenceType.ACCEPTABLE);
        while (p != null) {
            p.value.decider_flag = DeciderFlag.CANDIDATE;
            p = p.next;
        }
        w = s.getAcceptablePreferenceWmes();
        while (w != null) {
            WmeImpl next_w = w.next;
            if (w.value.decider_flag == DeciderFlag.CANDIDATE) {
                w.value.decider_flag = DeciderFlag.ALREADY_EXISTING_WME;
                w.value.decider_wme = w;
                w.preference = null;
            } else {
                s.removeAcceptablePreferenceWme(w);
                this.remove_operator_if_necessary(s, w);
                this.workingMemory.remove_wme_from_wm(w);
            }
            w = next_w;
        }
        Preference p2 = s.getPreferencesByType(PreferenceType.REQUIRE);
        while (p2 != null) {
            if (p2.value.decider_flag == DeciderFlag.ALREADY_EXISTING_WME) {
                wme = p2.value.decider_wme;
                if (wme.preference == null) {
                    wme.preference = p2;
                }
            } else {
                wme = this.workingMemory.make_wme(p2.id, p2.attr, p2.value, true);
                s.addAcceptablePreferenceWme(wme);
                wme.preference = p2;
                this.workingMemory.add_wme_to_wm(wme);
                p2.value.decider_flag = DeciderFlag.ALREADY_EXISTING_WME;
                p2.value.decider_wme = wme;
            }
            p2 = p2.next;
        }
        p2 = s.getPreferencesByType(PreferenceType.ACCEPTABLE);
        while (p2 != null) {
            if (p2.value.decider_flag == DeciderFlag.ALREADY_EXISTING_WME) {
                wme = p2.value.decider_wme;
                if (wme.preference == null) {
                    wme.preference = p2;
                }
            } else {
                wme = this.workingMemory.make_wme(p2.id, p2.attr, p2.value, true);
                s.addAcceptablePreferenceWme(wme);
                wme.preference = p2;
                this.workingMemory.add_wme_to_wm(wme);
                p2.value.decider_flag = DeciderFlag.ALREADY_EXISTING_WME;
                p2.value.decider_wme = wme;
            }
            p2 = p2.next;
        }
    }

    private void remove_operator_if_necessary(Slot s, WmeImpl w) {
        if (s.getWmes() != null && s.getWmes().value == w.value) {
            this.context.getTrace().print(Trace.Category.OPERAND2_REMOVALS, "\n        REMOVING: Operator from context slot (proposal no longer matches): %s", w);
            this.remove_wmes_for_context_slot(s);
            if (s.id.goalInfo.lower_goal != null) {
                this.context.getTrace().print(EnumSet.of(Trace.Category.VERBOSE, Trace.Category.WM_CHANGES), "Removing state %s because of an operator removal.\n", s.id.goalInfo.lower_goal);
                this.remove_existing_context_and_descendents(s.id.goalInfo.lower_goal);
            }
        }
    }

    private void do_buffered_acceptable_preference_wme_changes() {
        while (!this.context_slots_with_changed_acceptable_preferences.isEmpty()) {
            Slot s = this.context_slots_with_changed_acceptable_preferences.pop();
            this.do_acceptable_preference_wme_changes_for_slot(s);
            s.acceptable_preference_changed = null;
        }
    }

    public void post_link_addition(IdentifierImpl from, IdentifierImpl to) {
        if (to.isGoal() && from != null) {
            return;
        }
        ++to.link_count;
        if (from == null) {
            return;
        }
        if (from.promotion_level == to.promotion_level) {
            return;
        }
        if (from.promotion_level > to.promotion_level) {
            to.could_be_a_link_from_below = true;
            return;
        }
        to.promotion_level = from.promotion_level;
        this.promoted_ids.add(to);
    }

    private void promote_if_needed(SymbolImpl sym, int new_level) {
        IdentifierImpl id = sym.asIdentifier();
        if (id != null) {
            this.promote_id_and_tc(id, new_level);
        }
    }

    private void promote_id_and_tc(IdentifierImpl id, int new_level) {
        if (id.level <= new_level) {
            return;
        }
        if (id.promotion_level < new_level) {
            return;
        }
        id.level = new_level;
        id.promotion_level = new_level;
        id.could_be_a_link_from_below = true;
        if (id.isGoal()) {
            throw new IllegalStateException("Internal error: tried to promote a goal or impasse id");
        }
        WmeImpl w = id.getInputWmes();
        while (w != null) {
            this.promote_if_needed(w.value, new_level);
            w = w.next;
        }
        Slot s = id.slots;
        while (s != null) {
            Preference pref = s.getAllPreferences();
            while (pref != null) {
                this.promote_if_needed(pref.value, new_level);
                if (pref.type.isBinary()) {
                    this.promote_if_needed(pref.referent, new_level);
                }
                pref = pref.nextOfSlot;
            }
            WmeImpl w2 = s.getWmes();
            while (w2 != null) {
                this.promote_if_needed(w2.value, new_level);
                w2 = w2.next;
            }
            s = s.next;
        }
    }

    private void do_promotion() {
        while (!this.promoted_ids.isEmpty()) {
            IdentifierImpl to = this.promoted_ids.remove(this.promoted_ids.size() - 1);
            this.promote_id_and_tc(to, to.promotion_level);
        }
    }

    public void post_link_removal(IdentifierImpl from, IdentifierImpl to) {
        if (to.isGoal() && from != null) {
            return;
        }
        --to.link_count;
        if (this.link_update_mode == LinkUpdateType.JUST_UPDATE_COUNT) {
            return;
        }
        if (this.link_update_mode == LinkUpdateType.UPDATE_DISCONNECTED_IDS_LIST && to.link_count == 0) {
            if (to.unknown_level != null) {
                ListItem<IdentifierImpl> dc = to.unknown_level;
                dc.remove(this.ids_with_unknown_level);
                dc.insertAtHead(this.disconnected_ids);
            } else {
                to.unknown_level = new ListItem<IdentifierImpl>(to);
                to.unknown_level.insertAtHead(this.disconnected_ids);
            }
            return;
        }
        if (from != null && from.level != to.level) {
            return;
        }
        if (to.unknown_level == null) {
            to.unknown_level = new ListItem<IdentifierImpl>(to);
            to.unknown_level.insertAtHead(this.ids_with_unknown_level);
        }
    }

    private void garbage_collect_id(IdentifierImpl id) {
        id.unknown_level = null;
        this.workingMemory.remove_wme_list_from_wm(id.getInputWmes(), true);
        id.removeAllInputWmes();
        Slot s = id.slots;
        while (s != null) {
            this.workingMemory.remove_wme_list_from_wm(s.getWmes(), false);
            s.removeAllWmes();
            Preference pref = s.getAllPreferences();
            while (pref != null) {
                Preference next_pref = pref.nextOfSlot;
                this.recMemory.remove_preference_from_tm(pref);
                pref = next_pref;
            }
            this.tempMemory.mark_slot_for_possible_removal(s);
            s = s.next;
        }
    }

    private boolean mark_level_unknown_needed(SymbolImpl sym) {
        return sym.asIdentifier() != null;
    }

    private void mark_id_and_tc_as_unknown_level(IdentifierImpl root) {
        ArrayDeque<IdentifierImpl> ids_to_walk = new ArrayDeque<IdentifierImpl>();
        ids_to_walk.push(root);
        while (!ids_to_walk.isEmpty()) {
            IdentifierImpl id = (IdentifierImpl)ids_to_walk.pop();
            if (id.tc_number == this.mark_tc_number || id.level < this.level_at_which_marking_started) continue;
            id.tc_number = this.mark_tc_number;
            if (id.level < this.highest_level_anything_could_fall_from) {
                this.highest_level_anything_could_fall_from = id.level;
            }
            if (id.level > this.lowest_level_anything_could_fall_to) {
                this.lowest_level_anything_could_fall_to = id.level;
            }
            if (id.could_be_a_link_from_below) {
                this.lowest_level_anything_could_fall_to = Integer.MAX_VALUE;
            }
            if (id.unknown_level == null) {
                id.unknown_level = new ListItem<IdentifierImpl>(id);
                id.unknown_level.insertAtHead(this.ids_with_unknown_level);
            }
            WmeImpl w = id.getInputWmes();
            while (w != null) {
                if (this.mark_level_unknown_needed(w.value)) {
                    ids_to_walk.push(w.value.asIdentifier());
                }
                w = w.next;
            }
            Slot s = id.slots;
            while (s != null) {
                Preference pref = s.getAllPreferences();
                while (pref != null) {
                    if (this.mark_level_unknown_needed(pref.value)) {
                        ids_to_walk.push(pref.value.asIdentifier());
                    }
                    if (pref.type.isBinary() && this.mark_level_unknown_needed(pref.referent)) {
                        ids_to_walk.push(pref.referent.asIdentifier());
                    }
                    pref = pref.nextOfSlot;
                }
                if (s.impasse_id != null && this.mark_level_unknown_needed(s.impasse_id)) {
                    ids_to_walk.push(s.impasse_id.asIdentifier());
                }
                WmeImpl w2 = s.getWmes();
                while (w2 != null) {
                    if (this.mark_level_unknown_needed(w2.value)) {
                        ids_to_walk.push(w2.value.asIdentifier());
                    }
                    w2 = w2.next;
                }
                s = s.next;
            }
        }
    }

    private boolean level_update_needed(SymbolImpl sym) {
        IdentifierImpl id = sym.asIdentifier();
        return id != null && id.tc_number != this.walk_tc_number;
    }

    private void walk_and_update_levels(IdentifierImpl root) {
        ArrayDeque<IdentifierImpl> ids_to_walk = new ArrayDeque<IdentifierImpl>();
        ids_to_walk.push(root);
        while (!ids_to_walk.isEmpty()) {
            IdentifierImpl id = (IdentifierImpl)ids_to_walk.pop();
            id.tc_number = this.walk_tc_number;
            if (id.unknown_level == null && id.level < this.walk_level) continue;
            if (id.unknown_level != null) {
                id.unknown_level.remove(this.ids_with_unknown_level);
                id.unknown_level = null;
                id.level = this.walk_level;
                id.promotion_level = this.walk_level;
            }
            WmeImpl w = id.getInputWmes();
            while (w != null) {
                if (this.level_update_needed(w.value)) {
                    ids_to_walk.push(w.value.asIdentifier());
                }
                w = w.next;
            }
            Slot s = id.slots;
            while (s != null) {
                Preference pref = s.getAllPreferences();
                while (pref != null) {
                    if (this.level_update_needed(pref.value)) {
                        ids_to_walk.push(pref.value.asIdentifier());
                    }
                    if (pref.type.isBinary() && this.level_update_needed(pref.referent)) {
                        ids_to_walk.push(pref.referent.asIdentifier());
                    }
                    pref = pref.nextOfSlot;
                }
                if (s.impasse_id != null && this.level_update_needed(s.impasse_id)) {
                    ids_to_walk.push(s.impasse_id.asIdentifier());
                }
                WmeImpl w2 = s.getWmes();
                while (w2 != null) {
                    if (this.level_update_needed(w2.value)) {
                        ids_to_walk.push(w2.value.asIdentifier());
                    }
                    w2 = w2.next;
                }
                s = s.next;
            }
        }
    }

    private void do_demotion() {
        IdentifierImpl id;
        ListItem<IdentifierImpl> dc = this.ids_with_unknown_level.first;
        while (dc != null) {
            ListItem next_dc = dc.next;
            id = (IdentifierImpl)dc.item;
            if (id.link_count == 0) {
                dc.remove(this.ids_with_unknown_level);
                dc.insertAtHead(this.disconnected_ids);
            }
            dc = next_dc;
        }
        this.link_update_mode = LinkUpdateType.UPDATE_DISCONNECTED_IDS_LIST;
        while (!this.disconnected_ids.isEmpty()) {
            id = this.disconnected_ids.pop();
            this.garbage_collect_id(id);
        }
        this.link_update_mode = LinkUpdateType.UPDATE_LINKS_NORMALLY;
        if (this.ids_with_unknown_level.isEmpty()) {
            return;
        }
        this.highest_level_anything_could_fall_from = Integer.MAX_VALUE;
        this.lowest_level_anything_could_fall_to = -1;
        this.mark_tc_number = DefaultMarker.create();
        dc = this.ids_with_unknown_level.first;
        while (dc != null) {
            id = (IdentifierImpl)dc.item;
            this.level_at_which_marking_started = id.level;
            this.mark_id_and_tc_as_unknown_level(id);
            dc = dc.next;
        }
        IdentifierImpl g = this.top_goal;
        while (g != null && g.level <= this.lowest_level_anything_could_fall_to) {
            if (g.level >= this.highest_level_anything_could_fall_from) {
                this.walk_level = g.level;
                this.walk_tc_number = DefaultMarker.create();
                this.walk_and_update_levels(g);
            }
            g = g.goalInfo.lower_goal;
        }
        this.link_update_mode = LinkUpdateType.JUST_UPDATE_COUNT;
        while (!this.ids_with_unknown_level.isEmpty()) {
            IdentifierImpl id2 = this.ids_with_unknown_level.pop();
            this.garbage_collect_id(id2);
        }
        this.link_update_mode = LinkUpdateType.UPDATE_LINKS_NORMALLY;
    }

    private void do_buffered_link_changes() {
        if (this.promoted_ids.isEmpty() && this.ids_with_unknown_level.isEmpty() && this.disconnected_ids.isEmpty()) {
            return;
        }
        this.do_promotion();
        this.do_demotion();
    }

    void rl_update_for_one_candidate(Slot s, boolean consistency, Preference candidates) {
        if (!consistency && this.rl.rl_enabled()) {
            this.rl.rl_tabulate_reward_values();
            this.exploration.exploration_compute_value_of_candidate(candidates, s, 0.0);
            this.rl.rl_perform_update(candidates.numeric_value, candidates.rl_contribution, s.id);
        }
    }

    public ImpasseType run_preference_semantics(Slot s, ByRef<Preference> result_candidates) {
        return this.run_preference_semantics(s, result_candidates, false, false);
    }

    public ImpasseType run_preference_semantics(Slot s, ByRef<Preference> result_candidates, boolean consistency) {
        return this.run_preference_semantics(s, result_candidates, consistency, false);
    }

    public ImpasseType run_preference_semantics(Slot s, ByRef<Preference> result_candidates, boolean consistency, boolean predict) {
        Preference p;
        Preference p2;
        Preference cand;
        Preference candidates;
        Preference p3;
        boolean do_CDPS;
        boolean bl = do_CDPS = s.isa_context_slot && !consistency && s.id.level > 1 && this.chunker.chunkThroughEvaluationRules;
        if (do_CDPS && s.hasContextDependentPreferenceSet()) {
            s.clear_CDPS(this.context);
        }
        if (s.getAllPreferences() == null) {
            if (!s.isa_context_slot) {
                this.tempMemory.mark_slot_for_possible_removal(s);
            }
            result_candidates.value = null;
            return ImpasseType.NONE;
        }
        if (!s.isa_context_slot && !consistency && this.decisionManip.select_get_operator() != null) {
            Preference force_result = this.decisionManip.select_force(s.getPreferencesByType(PreferenceType.ACCEPTABLE), !predict);
            if (force_result != null) {
                force_result.next_candidate = null;
                result_candidates.value = force_result;
                if (!predict && this.rl.rl_enabled()) {
                    this.rl.rl_tabulate_reward_values();
                    this.exploration.exploration_compute_value_of_candidate(force_result, s, 0.0);
                    this.rl.rl_perform_update(force_result.numeric_value, force_result.rl_contribution, s.id);
                }
                return ImpasseType.NONE;
            }
            this.context.getPrinter().warn("WARNING: Invalid forced selection operator id");
        }
        Trace trace = this.context.getTrace();
        Printer printer = trace.getPrinter();
        boolean traceBacktracing = trace.isEnabled(Trace.Category.BACKTRACING);
        if (traceBacktracing && s.isa_context_slot) {
            printer.print("\n-------------------------------\nRUNNING PREFERENCE SEMANTICS...\n-------------------------------\n");
            printer.print("All Preferences for slot:");
            for (PreferenceType type : PreferenceType.values()) {
                Preference pref = s.getPreferencesByType(type);
                if (pref == null) continue;
                printer.print("\n %ss:\n", type.getDisplayName());
                Preference p4 = pref;
                while (p4 != null) {
                    printer.print(" ");
                    printer.print(p4.toString());
                    p4 = p4.next;
                }
            }
            printer.print("-------------------------------\n");
        }
        if (s.getPreferencesByType(PreferenceType.REQUIRE) != null) {
            p3 = s.getPreferencesByType(PreferenceType.REQUIRE);
            while (p3 != null) {
                p3.value.decider_flag = DeciderFlag.NOTHING;
                p3 = p3.next;
            }
            candidates = null;
            Preference p5 = s.getPreferencesByType(PreferenceType.REQUIRE);
            while (p5 != null) {
                if (p5.value.decider_flag == DeciderFlag.NOTHING) {
                    p5.next_candidate = candidates;
                    candidates = p5;
                    p5.value.decider_flag = DeciderFlag.CANDIDATE;
                }
                p5 = p5.next;
            }
            result_candidates.value = candidates;
            if (candidates.next_candidate != null) {
                return ImpasseType.CONSTRAINT_FAILURE;
            }
            SymbolImpl value = candidates.value;
            Preference p6 = s.getPreferencesByType(PreferenceType.PROHIBIT);
            while (p6 != null) {
                if (p6.value == value) {
                    return ImpasseType.CONSTRAINT_FAILURE;
                }
                p6 = p6.next;
            }
            this.rl_update_for_one_candidate(s, consistency, candidates);
            if (traceBacktracing) {
                printer.print("--> Adding preference to CDPS: ");
                printer.print(candidates.toString());
            }
            return ImpasseType.NONE;
        }
        p3 = s.getPreferencesByType(PreferenceType.ACCEPTABLE);
        while (p3 != null) {
            p3.value.decider_flag = DeciderFlag.CANDIDATE;
            p3 = p3.next;
        }
        p3 = s.getPreferencesByType(PreferenceType.PROHIBIT);
        while (p3 != null) {
            p3.value.decider_flag = DeciderFlag.NOTHING;
            p3 = p3.next;
        }
        p3 = s.getPreferencesByType(PreferenceType.REJECT);
        while (p3 != null) {
            p3.value.decider_flag = DeciderFlag.NOTHING;
            p3 = p3.next;
        }
        candidates = null;
        Preference p7 = s.getPreferencesByType(PreferenceType.ACCEPTABLE);
        while (p7 != null) {
            if (p7.value.decider_flag == DeciderFlag.CANDIDATE) {
                p7.next_candidate = candidates;
                candidates = p7;
                p7.value.decider_flag = DeciderFlag.NOTHING;
            }
            p7 = p7.next;
        }
        if (!s.isa_context_slot) {
            result_candidates.value = candidates;
            return ImpasseType.NONE;
        }
        if (do_CDPS && (s.getPreferencesByType(PreferenceType.PROHIBIT) != null || s.getPreferencesByType(PreferenceType.REJECT) != null)) {
            p7 = s.getPreferencesByType(PreferenceType.PROHIBIT);
            while (p7 != null) {
                s.add_to_CDPS(this.context, p7);
                p7 = p7.next;
            }
            p7 = s.getPreferencesByType(PreferenceType.REJECT);
            while (p7 != null) {
                s.add_to_CDPS(this.context, p7);
                p7 = p7.next;
            }
        }
        if (candidates == null || candidates.next_candidate == null) {
            result_candidates.value = candidates;
            if (candidates != null) {
                this.rl_update_for_one_candidate(s, consistency, candidates);
            } else if (do_CDPS && s.hasContextDependentPreferenceSet()) {
                s.clear_CDPS(this.context);
            }
            return ImpasseType.NONE;
        }
        if (s.getPreferencesByType(PreferenceType.BETTER) != null || s.getPreferencesByType(PreferenceType.WORSE) != null) {
            SymbolImpl k;
            p7 = s.getPreferencesByType(PreferenceType.BETTER);
            while (p7 != null) {
                p7.value.decider_flag = DeciderFlag.NOTHING;
                p7.referent.decider_flag = DeciderFlag.NOTHING;
                p7 = p7.next;
            }
            p7 = s.getPreferencesByType(PreferenceType.WORSE);
            while (p7 != null) {
                p7.value.decider_flag = DeciderFlag.NOTHING;
                p7.referent.decider_flag = DeciderFlag.NOTHING;
                p7 = p7.next;
            }
            cand = candidates;
            while (cand != null) {
                cand.value.decider_flag = DeciderFlag.CANDIDATE;
                cand = cand.next_candidate;
            }
            p7 = s.getPreferencesByType(PreferenceType.BETTER);
            while (p7 != null) {
                SymbolImpl j = p7.value;
                k = p7.referent;
                if (j != k && j.decider_flag.isSomething() && k.decider_flag.isSomething() && (j.decider_flag == DeciderFlag.CANDIDATE || k.decider_flag == DeciderFlag.CANDIDATE)) {
                    k.decider_flag = DeciderFlag.CONFLICTED;
                }
                p7 = p7.next;
            }
            p7 = s.getPreferencesByType(PreferenceType.WORSE);
            while (p7 != null) {
                SymbolImpl j = p7.value;
                k = p7.referent;
                if (j != k && j.decider_flag.isSomething() && k.decider_flag.isSomething() && (j.decider_flag == DeciderFlag.CANDIDATE || k.decider_flag == DeciderFlag.CANDIDATE)) {
                    j.decider_flag = DeciderFlag.CONFLICTED;
                }
                p7 = p7.next;
            }
            cand = null;
            cand = candidates;
            while (cand != null && cand.value.decider_flag != DeciderFlag.CANDIDATE) {
                cand = cand.next_candidate;
            }
            Preference prev_cand = null;
            if (cand == null) {
                prev_cand = null;
                cand = candidates;
                while (cand != null) {
                    if (cand.value.decider_flag != DeciderFlag.CONFLICTED) {
                        if (prev_cand != null) {
                            prev_cand.next_candidate = cand.next_candidate;
                        } else {
                            candidates = cand.next_candidate;
                        }
                    } else {
                        prev_cand = cand;
                    }
                    cand = cand.next_candidate;
                }
                result_candidates.value = candidates;
                if (do_CDPS && s.hasContextDependentPreferenceSet()) {
                    s.clear_CDPS(this.context);
                }
                return ImpasseType.CONFLICT;
            }
            prev_cand = null;
            cand = candidates;
            while (cand != null) {
                if (cand.value.decider_flag == DeciderFlag.CONFLICTED) {
                    if (prev_cand != null) {
                        prev_cand.next_candidate = cand.next_candidate;
                    } else {
                        candidates = cand.next_candidate;
                    }
                } else {
                    if (do_CDPS) {
                        p2 = s.getPreferencesByType(PreferenceType.BETTER);
                        while (p2 != null) {
                            if (p2.value == cand.value) {
                                s.add_to_CDPS(this.context, p2);
                            }
                            p2 = p2.next;
                        }
                        p2 = s.getPreferencesByType(PreferenceType.WORSE);
                        while (p2 != null) {
                            if (p2.referent == cand.value) {
                                s.add_to_CDPS(this.context, p2);
                            }
                            p2 = p2.next;
                        }
                    }
                    prev_cand = cand;
                }
                cand = cand.next_candidate;
            }
        }
        if (candidates == null || candidates.next_candidate == null) {
            result_candidates.value = candidates;
            if (candidates != null) {
                this.rl_update_for_one_candidate(s, consistency, candidates);
            } else if (do_CDPS && s.hasContextDependentPreferenceSet()) {
                s.clear_CDPS(this.context);
            }
            return ImpasseType.NONE;
        }
        if (s.getPreferencesByType(PreferenceType.BEST) != null) {
            cand = candidates;
            while (cand != null) {
                cand.value.decider_flag = DeciderFlag.NOTHING;
                cand = cand.next_candidate;
            }
            p2 = s.getPreferencesByType(PreferenceType.BEST);
            while (p2 != null) {
                p2.value.decider_flag = DeciderFlag.BEST;
                p2 = p2.next;
            }
            Preference prev_cand = null;
            cand = candidates;
            while (cand != null) {
                if (cand.value.decider_flag == DeciderFlag.BEST) {
                    if (do_CDPS) {
                        p2 = s.getPreferencesByType(PreferenceType.BEST);
                        while (p2 != null) {
                            if (p2.value == cand.value) {
                                s.add_to_CDPS(this.context, p2);
                            }
                            p2 = p2.next;
                        }
                    }
                    if (prev_cand != null) {
                        prev_cand.next_candidate = cand;
                    } else {
                        candidates = cand;
                    }
                    prev_cand = cand;
                }
                cand = cand.next_candidate;
            }
            if (prev_cand != null) {
                prev_cand.next_candidate = null;
            }
        }
        if (candidates == null || candidates.next_candidate == null) {
            result_candidates.value = candidates;
            if (candidates != null) {
                this.rl_update_for_one_candidate(s, consistency, candidates);
            } else if (do_CDPS && s.hasContextDependentPreferenceSet()) {
                s.clear_CDPS(this.context);
            }
            return ImpasseType.NONE;
        }
        if (s.getPreferencesByType(PreferenceType.WORST) != null) {
            cand = candidates;
            while (cand != null) {
                cand.value.decider_flag = DeciderFlag.NOTHING;
                cand = cand.next_candidate;
            }
            p2 = s.getPreferencesByType(PreferenceType.WORST);
            while (p2 != null) {
                p2.value.decider_flag = DeciderFlag.WORST;
                p2 = p2.next;
            }
            boolean some_not_worst = false;
            if (do_CDPS) {
                cand = candidates;
                while (cand != null) {
                    if (cand.value.decider_flag != DeciderFlag.WORST) {
                        some_not_worst = true;
                    }
                    cand = cand.next_candidate;
                }
            }
            Preference prev_cand = null;
            cand = candidates;
            while (cand != null) {
                if (cand.value.decider_flag != DeciderFlag.WORST) {
                    if (prev_cand != null) {
                        prev_cand.next_candidate = cand;
                    } else {
                        candidates = cand;
                    }
                    prev_cand = cand;
                } else if (do_CDPS && some_not_worst) {
                    p = s.getPreferencesByType(PreferenceType.WORST);
                    while (p != null) {
                        if (p.value == cand.value) {
                            s.add_to_CDPS(this.context, p);
                        }
                        p = p.next;
                    }
                }
                cand = cand.next_candidate;
            }
            if (prev_cand != null) {
                prev_cand.next_candidate = null;
            }
        }
        if (candidates == null || candidates.next_candidate == null) {
            result_candidates.value = candidates;
            if (candidates != null) {
                this.rl_update_for_one_candidate(s, consistency, candidates);
            } else if (do_CDPS && s.hasContextDependentPreferenceSet()) {
                s.clear_CDPS(this.context);
            }
            return ImpasseType.NONE;
        }
        cand = candidates;
        while (cand != null) {
            cand.value.decider_flag = DeciderFlag.NOTHING;
            cand = cand.next_candidate;
        }
        p7 = s.getPreferencesByType(PreferenceType.UNARY_INDIFFERENT);
        while (p7 != null) {
            p7.value.decider_flag = DeciderFlag.UNARY_INDIFFERENT;
            p7 = p7.next;
        }
        p7 = s.getPreferencesByType(PreferenceType.NUMERIC_INDIFFERENT);
        while (p7 != null) {
            p7.value.decider_flag = DeciderFlag.UNARY_INDIFFERENT_CONSTANT;
            p7 = p7.next;
        }
        boolean not_all_indifferent = false;
        boolean some_numeric = false;
        Preference cand2 = candidates;
        while (cand2 != null) {
            if (cand2.value.decider_flag != DeciderFlag.UNARY_INDIFFERENT) {
                if (cand2.value.decider_flag == DeciderFlag.UNARY_INDIFFERENT_CONSTANT) {
                    some_numeric = true;
                } else {
                    p = candidates;
                    while (p != null) {
                        if (p != cand2) {
                            boolean match_found = false;
                            Preference p22 = s.getPreferencesByType(PreferenceType.BINARY_INDIFFERENT);
                            while (p22 != null) {
                                if (p22.value == cand2.value && p22.referent == p.value || p22.value == p.value && p22.referent == cand2.value) {
                                    match_found = true;
                                    break;
                                }
                                p22 = p22.next;
                            }
                            if (!match_found) {
                                not_all_indifferent = true;
                                break;
                            }
                        }
                        p = p.next_candidate;
                    }
                    if (not_all_indifferent) break;
                }
            }
            cand2 = cand2.next_candidate;
        }
        if (!not_all_indifferent) {
            if (!consistency) {
                result_candidates.value = this.exploration.exploration_choose_according_to_policy(s, candidates);
                ((Preference)result_candidates.value).next_candidate = null;
                if (do_CDPS) {
                    Preference p8;
                    if (some_numeric) {
                        p8 = s.getPreferencesByType(PreferenceType.NUMERIC_INDIFFERENT);
                        while (p8 != null) {
                            if (p8.value == ((Preference)result_candidates.value).value) {
                                s.add_to_CDPS(this.context, p8, false);
                            }
                            p8 = p8.next;
                        }
                        p8 = s.getPreferencesByType(PreferenceType.BINARY_INDIFFERENT);
                        while (p8 != null) {
                            if (!(p8.value != ((Preference)result_candidates.value).value && p8.referent != ((Preference)result_candidates.value).value || p8.referent.decider_flag == DeciderFlag.UNARY_INDIFFERENT_CONSTANT && p8.value.decider_flag == DeciderFlag.UNARY_INDIFFERENT_CONSTANT)) {
                                s.add_to_CDPS(this.context, p8);
                            }
                            p8 = p8.next;
                        }
                    } else {
                        p8 = s.getPreferencesByType(PreferenceType.UNARY_INDIFFERENT);
                        while (p8 != null) {
                            if (p8.value == ((Preference)result_candidates.value).value) {
                                s.add_to_CDPS(this.context, p8);
                            }
                            p8 = p8.next;
                        }
                        p8 = s.getPreferencesByType(PreferenceType.BINARY_INDIFFERENT);
                        while (p8 != null) {
                            if (p8.value == ((Preference)result_candidates.value).value || p8.referent == ((Preference)result_candidates.value).value) {
                                s.add_to_CDPS(this.context, p8);
                            }
                            p8 = p8.next;
                        }
                    }
                }
            } else {
                result_candidates.value = candidates;
            }
            return ImpasseType.NONE;
        }
        result_candidates.value = candidates;
        if (do_CDPS && s.hasContextDependentPreferenceSet()) {
            s.clear_CDPS(this.context);
        }
        return ImpasseType.TIE;
    }

    private void add_impasse_wme(IdentifierImpl id, SymbolImpl attr, SymbolImpl value, Preference p) {
        WmeImpl w = this.workingMemory.make_wme(id, attr, value, false);
        id.goalInfo.addImpasseWme(w);
        w.preference = p;
        this.workingMemory.add_wme_to_wm(w);
    }

    private IdentifierImpl create_new_impasse(SymbolImpl object, SymbolImpl attr, ImpasseType impasse_type, int level) {
        PredefinedSymbols predefined = this.predefinedSyms;
        IdentifierImpl id = predefined.getSyms().make_new_identifier('S', level);
        this.post_link_addition(null, id);
        id.goalInfo = new GoalIdentifierInfo(id);
        this.add_impasse_wme(id, predefined.type_symbol, predefined.state_symbol, null);
        this.add_impasse_wme(id, predefined.superstate_symbol, object, null);
        if (attr != null) {
            this.add_impasse_wme(id, predefined.attribute_symbol, attr, null);
        }
        switch (impasse_type) {
            case NONE: {
                break;
            }
            case CONSTRAINT_FAILURE: {
                this.add_impasse_wme(id, predefined.impasse_symbol, predefined.constraint_failure_symbol, null);
                this.add_impasse_wme(id, predefined.choices_symbol, predefined.none_symbol, null);
                break;
            }
            case CONFLICT: {
                this.add_impasse_wme(id, predefined.impasse_symbol, predefined.conflict_symbol, null);
                this.add_impasse_wme(id, predefined.choices_symbol, predefined.multiple_symbol, null);
                break;
            }
            case TIE: {
                this.add_impasse_wme(id, predefined.impasse_symbol, predefined.tie_symbol, null);
                this.add_impasse_wme(id, predefined.choices_symbol, predefined.multiple_symbol, null);
                break;
            }
            case NO_CHANGE: {
                this.add_impasse_wme(id, predefined.impasse_symbol, predefined.no_change_symbol, null);
                this.add_impasse_wme(id, predefined.choices_symbol, predefined.none_symbol, null);
                break;
            }
        }
        id.goalInfo.allow_bottom_up_chunks = true;
        id.goalInfo.operator_slot = Slot.make_slot(id, this.predefinedSyms.operator_symbol, this.predefinedSyms.operator_symbol);
        id.goalInfo.reward_header = predefined.getSyms().make_new_identifier('R', level);
        SoarModule.add_module_wme(this.workingMemory, id, predefined.rl_sym_reward_link, id.goalInfo.reward_header);
        this.epmem.initializeNewContext(this.workingMemory, id);
        this.smem.initializeNewContext(this.workingMemory, id);
        return id;
    }

    private Preference make_fake_preference_for_goal_item(IdentifierImpl goal, Preference cand) {
        Slot s = cand.slot;
        WmeImpl ap_wme = s.getAcceptablePreferenceWmes();
        while (ap_wme != null && ap_wme.value != cand.value) {
            ap_wme = ap_wme.next;
        }
        if (ap_wme == null) {
            throw new IllegalStateException("Internal error: couldn't find acceptable pref wme");
        }
        Preference pref = new Preference(PreferenceType.ACCEPTABLE, goal, this.predefinedSyms.item_symbol, cand.value, null);
        goal.goalInfo.addGoalPreference(pref);
        pref.on_goal_list = true;
        pref.preference_add_ref();
        Instantiation inst = new Instantiation(null, null, null);
        pref.setInstantiation(inst);
        inst.match_goal = goal;
        inst.match_goal_level = goal.level;
        inst.reliable = true;
        inst.backtrace_number = 0;
        inst.in_ms = false;
        PositiveCondition cond = new PositiveCondition();
        cond.id_test = SymbolImpl.makeEqualityTest(ap_wme.id);
        cond.attr_test = SymbolImpl.makeEqualityTest(ap_wme.attr);
        cond.value_test = SymbolImpl.makeEqualityTest(ap_wme.value);
        cond.test_for_acceptable_preference = true;
        cond.bt().wme_ = ap_wme;
        cond.bt().level = ap_wme.id.level;
        inst.top_of_instantiated_conditions = cond;
        inst.bottom_of_instantiated_conditions = cond;
        inst.nots = null;
        if (SoarConstants.DO_TOP_LEVEL_REF_CTS || inst.match_goal_level > 1) {
            // empty if block
        }
        return pref;
    }

    private void remove_fake_preference_for_goal_item(Preference pref) {
        pref.preference_remove_ref(this.recMemory);
    }

    private void update_impasse_items(IdentifierImpl id, Preference items) {
        int item_count = Preference.countCandidates(items);
        WmeImpl w = id.goalInfo.getImpasseWmes();
        while (w != null) {
            if (w.attr == this.predefinedSyms.item_symbol) {
                w.value.decider_flag = DeciderFlag.NOTHING;
            }
            w = w.next;
        }
        Preference cand = items;
        while (cand != null) {
            cand.value.decider_flag = DeciderFlag.CANDIDATE;
            cand = cand.next_candidate;
        }
        w = id.goalInfo.getImpasseWmes();
        while (w != null) {
            WmeImpl next_w = w.next;
            if (w.attr == this.predefinedSyms.item_symbol) {
                if (w.value.decider_flag == DeciderFlag.CANDIDATE) {
                    w.value.decider_flag = DeciderFlag.ALREADY_EXISTING_WME;
                    w.value.decider_wme = w;
                } else {
                    id.goalInfo.removeImpasseWme(w);
                    this.remove_fake_preference_for_goal_item(w.preference);
                    this.workingMemory.remove_wme_from_wm(w);
                }
            } else if (w.attr == this.predefinedSyms.item_count_symbol) {
                id.goalInfo.removeImpasseWme(w);
                this.workingMemory.remove_wme_from_wm(w);
            }
            w = next_w;
        }
        Preference cand2 = items;
        while (cand2 != null) {
            Preference bt_pref = id.isGoal() ? this.make_fake_preference_for_goal_item(id, cand2) : cand2;
            if (cand2.value.decider_flag == DeciderFlag.ALREADY_EXISTING_WME) {
                if (id.isGoal()) {
                    this.remove_fake_preference_for_goal_item(cand2.value.decider_wme.preference);
                }
                cand2.value.decider_wme.preference = bt_pref;
            } else {
                this.add_impasse_wme(id, this.predefinedSyms.item_symbol, cand2.value, bt_pref);
            }
            cand2 = cand2.next_candidate;
        }
        if (item_count > 0) {
            this.add_impasse_wme(id, this.predefinedSyms.item_count_symbol, this.predefinedSyms.getSyms().createInteger(item_count), null);
        }
    }

    private void decide_non_context_slot(Slot s) {
        ByRef<Object> candidates = ByRef.create(null);
        ImpasseType impasse_type = this.run_preference_semantics(s, candidates);
        if (impasse_type == ImpasseType.NONE) {
            WmeImpl w = s.getWmes();
            while (w != null) {
                w.value.decider_flag = DeciderFlag.NOTHING;
                w = w.next;
            }
            Preference cand = (Preference)candidates.value;
            while (cand != null) {
                cand.value.decider_flag = DeciderFlag.CANDIDATE;
                cand = cand.next_candidate;
            }
            WmeImpl it = s.getWmes();
            while (it != null) {
                WmeImpl w2 = it;
                it = w2.next;
                if (w2.value.decider_flag == DeciderFlag.CANDIDATE) {
                    w2.value.decider_flag = DeciderFlag.ALREADY_EXISTING_WME;
                    w2.value.decider_wme = w2;
                    continue;
                }
                s.removeWme(w2);
                if (w2.gds != null && w2.gds.getGoal() != null) {
                    this.gds_invalid_so_remove_goal(w2, "While deciding non-context slot");
                }
                this.workingMemory.remove_wme_from_wm(w2);
            }
            Preference cand2 = (Preference)candidates.value;
            while (cand2 != null) {
                if (cand2.value.decider_flag == DeciderFlag.ALREADY_EXISTING_WME) {
                    cand2.value.decider_wme.preference = cand2;
                } else {
                    Long numRefs;
                    WmeImpl w3 = this.workingMemory.make_wme(cand2.id, cand2.attr, cand2.value, false);
                    s.addWme(w3);
                    w3.preference = cand2;
                    if (s.wma_val_references != null && this.wma.wma_enabled() && (numRefs = s.wma_val_references.get(w3.getValue())) != null) {
                        this.wma.wma_activate_wme(w3, numRefs, null, true);
                        s.wma_val_references.remove(w3.getValue());
                        if (s.wma_val_references.isEmpty()) {
                            s.wma_val_references = null;
                        }
                    }
                    this.parent_list_head = null;
                    if (w3.preference.o_supported && w3.preference.inst.match_goal_level != 1) {
                        if (w3.preference.inst.match_goal.goalInfo.gds == null) {
                            if (w3.preference.inst.match_goal_level == w3.preference.id.level) {
                                this.create_gds_for_goal(w3.preference.inst.match_goal);
                            } else if (!this.decisionCycle.isHalted()) {
                                throw new IllegalStateException("Wanted to create a GDS for a WME level different from the instantiation level.....Big problems....exiting....");
                            }
                        }
                        if (!this.decisionCycle.isHalted()) {
                            Preference pref = w3.preference;
                            while (pref != null) {
                                if (!pref.inst.GDS_evaluated_already && pref.inst.match_goal_level <= pref.id.level) {
                                    this.uniquely_add_to_head_of_dll(pref.inst);
                                    pref.inst.GDS_evaluated_already = true;
                                }
                                pref = pref.next;
                            }
                            this.elaborate_gds();
                            this.free_parent_list();
                        }
                    }
                    this.workingMemory.add_wme_to_wm(w3);
                }
                cand2 = cand2.next_candidate;
            }
            return;
        }
        if (s.getWmes() != null) {
            this.workingMemory.remove_wme_list_from_wm(s.getWmes(), false);
            s.removeAllWmes();
        }
        this.update_impasse_items(s.impasse_id, (Preference)candidates.value);
    }

    private void decide_non_context_slots() {
        ListHead<Slot> changed_slots = this.tempMemory.changed_slots;
        while (!changed_slots.isEmpty()) {
            Slot s = changed_slots.pop();
            this.decide_non_context_slot(s);
            s.changed = null;
        }
    }

    private boolean context_slot_is_decidable(Slot s) {
        if (s.getWmes() == null) {
            return s.changed != null;
        }
        return false;
    }

    void remove_wmes_for_context_slot(Slot s) {
        if (s.getWmes() == null) {
            return;
        }
        WmeImpl w = s.getWmes();
        assert (w.next == null);
        w.preference.preference_remove_ref(this.recMemory);
        this.workingMemory.remove_wme_from_wm(w);
        s.removeAllWmes();
    }

    void remove_existing_context_and_descendents(IdentifierImpl goal) {
        Preference p;
        if (goal.goalInfo.lower_goal != null) {
            this.remove_existing_context_and_descendents(goal.goalInfo.lower_goal);
        }
        if (goal != this.top_goal && this.rl.rl_enabled()) {
            this.rl.rl_tabulate_reward_value_for_goal(goal);
            this.rl.rl_perform_update(0.0, true, goal, false);
        }
        if (goal == this.top_goal) {
            this.top_goal = null;
            this.bottom_goal = null;
        } else {
            this.bottom_goal = goal.goalInfo.higher_goal;
            this.bottom_goal.goalInfo.lower_goal = null;
        }
        if (SoarConstants.DO_TOP_LEVEL_REF_CTS) {
            while (goal.goalInfo.preferences_from_goal != null) {
                p = goal.goalInfo.popGoalPreference();
                p.on_goal_list = false;
                if (p.remove_preference_from_clones(this.recMemory) || !p.isInTempMemory()) continue;
                this.recMemory.remove_preference_from_tm(p);
            }
        } else if (goal.goalInfo.preferences_from_goal != null) {
            p = goal.goalInfo.preferences_from_goal;
            while (p.all_of_goal_next != null) {
                p = p.all_of_goal_next;
            }
            while (p != null) {
                Preference p_next = p.all_of_goal_prev;
                goal.goalInfo.removeGoalPreference(p);
                p.on_goal_list = false;
                if (!p.remove_preference_from_clones(this.recMemory) && p.isInTempMemory()) {
                    this.recMemory.remove_preference_from_tm(p);
                }
                p = p_next;
            }
        }
        this.remove_wmes_for_context_slot(goal.goalInfo.operator_slot);
        this.update_impasse_items(goal, null);
        this.epmem.epmem_reset(goal);
        this.smem.smem_reset(goal);
        this.workingMemory.remove_wme_list_from_wm(goal.goalInfo.getImpasseWmes(), false);
        goal.goalInfo.removeAllImpasseWmes();
        if (goal.goalInfo.gds != null) {
            goal.goalInfo.gds.clearGoal();
        }
        if (!goal.goalInfo.ms_retractions.isEmpty()) {
            MatchSetChange head;
            MatchSetChange tail = head = goal.goalInfo.ms_retractions.getFirstItem();
            while (tail.in_level.next != null) {
                tail.goal = null;
                tail = tail.in_level.getNextItem();
            }
            tail.goal = null;
            ListHead<MatchSetChange> nil_goal_retractions = this.soarReteListener.nil_goal_retractions;
            if (!nil_goal_retractions.isEmpty()) {
                nil_goal_retractions.first.previous = tail.in_level;
                tail.in_level.next = nil_goal_retractions.first;
                nil_goal_retractions.first = head.in_level;
            } else {
                nil_goal_retractions.first = head.in_level;
            }
        }
        goal.goalInfo.rl_info = null;
        this.chunker.removeGoalFromChunkyProblemSpaces(goal);
        this.chunker.removeGoalFromChunkFreeProblemSpaces(goal);
        this.post_link_removal(null, goal);
    }

    private void create_new_context_rl(IdentifierImpl id) {
        id.goalInfo.rl_info = new ReinforcementLearningInfo();
    }

    private void create_new_context(SymbolImpl attr_of_impasse, ImpasseType impasse_type) {
        IdentifierImpl id;
        if (this.bottom_goal != null) {
            id = this.create_new_impasse(this.bottom_goal, attr_of_impasse, impasse_type, this.bottom_goal.level + 1);
            id.goalInfo.higher_goal = this.bottom_goal;
            this.bottom_goal.goalInfo.lower_goal = id;
            this.bottom_goal = id;
            this.add_impasse_wme(id, this.predefinedSyms.quiescence_symbol, this.predefinedSyms.t_symbol, null);
            if (ImpasseType.NO_CHANGE == impasse_type && this.MAX_GOAL_DEPTH < this.bottom_goal.level) {
                this.context.getPrinter().warn("\nGoal stack depth exceeded %d on a no-change impasse.\nSoar appears to be in an infinite loop.  \nContinuing to subgoal may cause Soar to \nexceed the program stack of your system.\n", this.MAX_GOAL_DEPTH);
                this.decisionCycle.halt("Max Goal Depth (" + this.MAX_GOAL_DEPTH + ") exceeded");
            }
        } else {
            this.top_goal = id = this.create_new_impasse(this.predefinedSyms.nil_symbol, null, ImpasseType.NONE, 1);
            this.bottom_goal = id;
            this.top_state = this.top_goal;
        }
        this.create_new_context_rl(id);
    }

    public ImpasseType type_of_existing_impasse(IdentifierImpl goal) {
        if (goal.goalInfo.lower_goal == null) {
            return ImpasseType.NONE;
        }
        WmeImpl w = goal.goalInfo.lower_goal.goalInfo.getImpasseWmes();
        while (w != null) {
            if (w.attr == this.predefinedSyms.impasse_symbol) {
                if (w.value == this.predefinedSyms.no_change_symbol) {
                    return ImpasseType.NO_CHANGE;
                }
                if (w.value == this.predefinedSyms.tie_symbol) {
                    return ImpasseType.TIE;
                }
                if (w.value == this.predefinedSyms.constraint_failure_symbol) {
                    return ImpasseType.CONSTRAINT_FAILURE;
                }
                if (w.value == this.predefinedSyms.conflict_symbol) {
                    return ImpasseType.CONFLICT;
                }
                if (w.value == this.predefinedSyms.none_symbol) {
                    return ImpasseType.NONE;
                }
                throw new IllegalStateException("Internal error: bad type of existing impasse.");
            }
            w = w.next;
        }
        throw new IllegalStateException("Internal error: couldn't find type of existing impasse.");
    }

    public SymbolImpl attribute_of_existing_impasse(IdentifierImpl goal) {
        if (goal.goalInfo.lower_goal == null) {
            return null;
        }
        WmeImpl w = goal.goalInfo.lower_goal.goalInfo.getImpasseWmes();
        while (w != null) {
            if (w.attr == this.predefinedSyms.attribute_symbol) {
                return w.value;
            }
            w = w.next;
        }
        throw new IllegalStateException("Internal error: couldn't find attribute of existing impasse.");
    }

    private boolean decide_context_slot(IdentifierImpl goal, Slot s, boolean predict) {
        ImpasseType impasse_type;
        ByRef<Object> candidates = ByRef.create(null);
        if (!this.context_slot_is_decidable(s)) {
            impasse_type = ImpasseType.NO_CHANGE;
            candidates.value = null;
            if (predict) {
                this.decisionManip.predict_set("none");
                return true;
            }
        } else {
            impasse_type = this.run_preference_semantics(s, candidates);
            if (predict) {
                switch (impasse_type) {
                    case CONSTRAINT_FAILURE: {
                        this.decisionManip.predict_set("constraint");
                        break;
                    }
                    case CONFLICT: {
                        this.decisionManip.predict_set("conflict");
                        break;
                    }
                    case TIE: {
                        this.decisionManip.predict_set("tie");
                        break;
                    }
                    case NO_CHANGE: {
                        this.decisionManip.predict_set("none");
                        break;
                    }
                    default: {
                        if (candidates.value == null || ((Preference)candidates.value).value.asIdentifier() == null) {
                            this.decisionManip.predict_set("none");
                            break;
                        }
                        IdentifierImpl tempId = ((Preference)candidates.value).value.asIdentifier();
                        String temp = String.format("%s", tempId);
                        this.decisionManip.predict_set(temp);
                    }
                }
                return true;
            }
            this.remove_wmes_for_context_slot(s);
            if (impasse_type == ImpasseType.NONE) {
                if (candidates.value == null) {
                    impasse_type = ImpasseType.NO_CHANGE;
                } else if (((Preference)candidates.value).next_candidate != null) {
                    throw new IllegalStateException("Internal error: more than one winner for context slot");
                }
            }
        }
        s.changed = null;
        SymbolImpl attribute_of_impasse = impasse_type == ImpasseType.NO_CHANGE ? (s.getWmes() != null ? s.attr : this.predefinedSyms.state_symbol) : s.attr;
        if (attribute_of_impasse == this.predefinedSyms.state_symbol) {
            this.remove_wmes_for_context_slot(goal.goalInfo.operator_slot);
        }
        if (impasse_type == ImpasseType.NONE) {
            Preference temp = (Preference)candidates.value;
            while (temp != null) {
                temp.preference_add_ref();
                temp = temp.next_candidate;
            }
            if (goal.goalInfo.lower_goal != null) {
                this.context.getTrace().print(EnumSet.of(Trace.Category.VERBOSE, Trace.Category.WM_CHANGES), "Removing state %s because of a decision.\n", goal.goalInfo.lower_goal);
                this.remove_existing_context_and_descendents(goal.goalInfo.lower_goal);
            }
            WmeImpl w = this.workingMemory.make_wme(s.id, s.attr, ((Preference)candidates.value).value, false);
            s.addWme(w);
            w.preference = (Preference)candidates.value;
            w.preference.preference_add_ref();
            this.workingMemory.add_wme_to_wm(w);
            Preference temp2 = (Preference)candidates.value;
            while (temp2 != null) {
                temp2.preference_remove_ref(this.recMemory);
                temp2 = temp2.next_candidate;
            }
            if (this.rl.rl_enabled()) {
                this.rl.rl_store_data(goal, (Preference)candidates.value);
            }
            return true;
        }
        if (impasse_type == this.type_of_existing_impasse(goal) && attribute_of_impasse == this.attribute_of_existing_impasse(goal)) {
            this.update_impasse_items(goal.goalInfo.lower_goal, (Preference)candidates.value);
            return false;
        }
        Preference temp = (Preference)candidates.value;
        while (temp != null) {
            temp.preference_add_ref();
            temp = temp.next_candidate;
        }
        if (goal.goalInfo.lower_goal != null) {
            this.context.getTrace().print(EnumSet.of(Trace.Category.VERBOSE, Trace.Category.WM_CHANGES), "Removing state %s because it's the wrong type of impasse.\n", goal.goalInfo.lower_goal);
            this.remove_existing_context_and_descendents(goal.goalInfo.lower_goal);
        }
        if (!this.waitsnc.value.get() || impasse_type != ImpasseType.NO_CHANGE || attribute_of_impasse != this.predefinedSyms.state_symbol) {
            this.create_new_context(attribute_of_impasse, impasse_type);
            this.update_impasse_items(goal.goalInfo.lower_goal, (Preference)candidates.value);
        }
        temp = (Preference)candidates.value;
        while (temp != null) {
            temp.preference_remove_ref(this.recMemory);
            temp = temp.next_candidate;
        }
        return true;
    }

    private void decide_context_slots(boolean predict) {
        IdentifierImpl goal = this.tempMemory.highest_goal_whose_context_changed != null ? this.tempMemory.highest_goal_whose_context_changed : this.bottom_goal;
        Slot s = goal.goalInfo.operator_slot;
        while (true) {
            if (!this.context_slot_is_decidable(s)) {
                if (s != goal.goalInfo.operator_slot && s.getWmes() != null) continue;
                if (goal.goalInfo.lower_goal != null) {
                    goal = goal.goalInfo.lower_goal;
                    s = goal.goalInfo.operator_slot;
                    continue;
                }
            }
            if (this.decide_context_slot(goal, s, predict)) break;
        }
        if (!predict) {
            this.tempMemory.highest_goal_whose_context_changed = null;
        }
    }

    public void do_buffered_wm_and_ownership_changes() {
        this.do_buffered_acceptable_preference_wme_changes();
        this.do_buffered_link_changes();
        this.workingMemory.do_buffered_wm_changes(this.io);
        this.tempMemory.remove_garbage_slots(this.context);
    }

    public void do_working_memory_phase() {
        Trace trace = this.context.getTrace();
        if (trace.isEnabled() && trace.isEnabled(Trace.Category.PHASES) && this.decisionCycle.current_phase.get() == Phase.APPLY) {
            switch (this.recMemory.FIRING_TYPE) {
                case PE_PRODS: {
                    this.context.getPrinter().startNewLine().print("--- Change Working Memory (PE) ---\n");
                    break;
                }
                case IE_PRODS: {
                    this.context.getPrinter().startNewLine().print("--- Change Working Memory (IE) ---\n");
                    break;
                }
            }
        }
        this.decide_non_context_slots();
        this.do_buffered_wm_and_ownership_changes();
    }

    public void do_decision_phase(boolean predict) {
        this.decisionManip.predict_srand_restore_snapshot(!predict);
        this.decide_context_slots(predict);
        if (!predict) {
            this.do_buffered_wm_and_ownership_changes();
            this.decide_non_context_slots();
            this.do_buffered_wm_and_ownership_changes();
            this.exploration.exploration_update_parameters();
        }
    }

    public void create_top_goal() {
        this.create_new_context(null, ImpasseType.NONE);
        this.tempMemory.highest_goal_whose_context_changed = null;
        this.do_buffered_wm_and_ownership_changes();
    }

    public void clear_goal_stack() {
        if (this.top_goal == null) {
            return;
        }
        this.remove_existing_context_and_descendents(this.top_goal);
        this.tempMemory.highest_goal_whose_context_changed = null;
        this.do_buffered_wm_and_ownership_changes();
        this.top_state = null;
        this.active_goal = null;
    }

    private void uniquely_add_to_head_of_dll(Instantiation inst) {
        ParentInstantiation curr_pi = this.parent_list_head;
        while (curr_pi != null) {
            if (curr_pi.inst == inst) {
                if (DEBUG_GDS) {
                    this.context.getPrinter().print("UNIQUE DLL: %s (%d) is already in parent list\n", curr_pi.inst.prod.getName(), System.identityHashCode(curr_pi.inst));
                }
                return;
            }
            if (DEBUG_GDS) {
                this.context.getPrinter().print("UNIQUE DLL: %s (%d)\n", curr_pi.inst.prod.getName(), System.identityHashCode(curr_pi.inst));
            }
            curr_pi = curr_pi.next;
        }
        ParentInstantiation new_pi = new ParentInstantiation();
        new_pi.next = null;
        new_pi.prev = null;
        new_pi.inst = inst;
        new_pi.next = this.parent_list_head;
        if (this.parent_list_head != null) {
            this.parent_list_head.prev = new_pi;
        }
        this.parent_list_head = new_pi;
        if (DEBUG_GDS) {
            this.context.getPrinter().print("UNIQUE DLL: added: %s %d\n", inst.prod.getName(), System.identityHashCode(inst));
        }
    }

    private void add_wme_to_gds(GoalDependencySetImpl gds, WmeImpl wme_to_add) {
        gds.addWme(wme_to_add);
        if (this.context.getTrace().isEnabled(EnumSet.of(Trace.Category.GDS, Trace.Category.WM_CHANGES, Trace.Category.VERBOSE))) {
            this.context.getTrace().startNewLine().print("Adding to GDS for %s: %s", wme_to_add.gds.getGoal(), wme_to_add);
        }
    }

    private void elaborate_gds() {
        ParentInstantiation temp_pi = null;
        ParentInstantiation curr_pi = this.parent_list_head;
        while (curr_pi != null) {
            Instantiation inst = curr_pi.inst;
            if (DEBUG_GDS) {
                this.context.getTrace().print("\n      EXPLORING INSTANTIATION: %s\n", inst);
            }
            Condition cond = inst.top_of_instantiated_conditions;
            while (cond != null) {
                block51: {
                    Slot s;
                    Preference pref_for_this_wme;
                    WmeImpl wme_matching_this_cond;
                    block54: {
                        block53: {
                            block52: {
                                PositiveCondition pc = cond.asPositiveCondition();
                                if (pc == null) break block51;
                                wme_matching_this_cond = pc.bt().wme_;
                                int wme_goal_level = pc.bt().level;
                                pref_for_this_wme = wme_matching_this_cond.preference;
                                if (DEBUG_GDS) {
                                    this.context.getPrinter().print("\n wme_matching_this_cond at goal_level = %d : %s", wme_goal_level, wme_matching_this_cond);
                                    if (pref_for_this_wme != null) {
                                        this.context.getPrinter().print("       pref_for_this_wme                        : %s", pref_for_this_wme);
                                    }
                                }
                                if (pref_for_this_wme != null && wme_goal_level >= inst.match_goal_level) break block52;
                                if (DEBUG_GDS) {
                                    if (pref_for_this_wme == null) {
                                        this.context.getPrinter().print(" this wme has no preferences (it's an arch-created wme)\n");
                                    } else if (wme_goal_level < inst.match_goal_level) {
                                        this.context.getPrinter().print(" this wme is in the supergoal\n");
                                    }
                                    this.context.getPrinter().print("inst->match_goal [%s]\n", inst.match_goal);
                                }
                                if (wme_matching_this_cond.gds != null) {
                                    if (wme_matching_this_cond.gds.getGoal() == null) {
                                        wme_matching_this_cond.gds.removeWme(wme_matching_this_cond);
                                        this.add_wme_to_gds(inst.match_goal.goalInfo.gds, wme_matching_this_cond);
                                        if (DEBUG_GDS) {
                                            this.context.getPrinter().print("\n       .....GDS' goal is NIL so switching from old to new GDS list....\n");
                                        }
                                    } else if (wme_matching_this_cond.gds.getGoal().level > inst.match_goal_level) {
                                        wme_matching_this_cond.gds.removeWme(wme_matching_this_cond);
                                        this.add_wme_to_gds(inst.match_goal.goalInfo.gds, wme_matching_this_cond);
                                        if (DEBUG_GDS) {
                                            this.context.getPrinter().print("\n       ....switching from old to new GDS list....\n");
                                        }
                                        wme_matching_this_cond.gds = inst.match_goal.goalInfo.gds;
                                    }
                                } else {
                                    this.add_wme_to_gds(inst.match_goal.goalInfo.gds, wme_matching_this_cond);
                                    if (DEBUG_GDS) {
                                        this.context.getPrinter().print("\n       ......WME did not have defined GDS.  Now adding to goal [%s].\n", wme_matching_this_cond.gds.getGoal());
                                    }
                                }
                                if (DEBUG_GDS) {
                                    this.context.getPrinter().print("            Added WME to GDS for goal = %d [%s]\n", wme_matching_this_cond.gds.getGoal().level, wme_matching_this_cond.gds.getGoal());
                                }
                                break block51;
                            }
                            if (!pref_for_this_wme.o_supported) break block53;
                            if (DEBUG_GDS) {
                                this.context.getPrinter().print("         this wme is local and o-supported\n");
                            }
                            break block51;
                        }
                        if (inst.match_goal_level != 1) break block54;
                        if (!DEBUG_GDS) break block51;
                        this.context.getPrinter().print("         don't back up through top state\n");
                        if (inst.prod == null || inst.prod.getName() == null) break block51;
                        this.context.getPrinter().print("         don't back up through top state for instantiation %s\n", inst.prod.getName());
                        break block51;
                    }
                    if (DEBUG_GDS) {
                        this.context.getPrinter().print("         this wme is local and i-supported\n");
                    }
                    if ((s = Slot.find_slot(pref_for_this_wme.id, pref_for_this_wme.attr)) == null) {
                        if (DEBUG_GDS) {
                            this.context.getPrinter().print("here's the wme with no slot:\t %s", pref_for_this_wme.inst.top_of_instantiated_conditions.asPositiveCondition().bt().wme_);
                        }
                        WmeImpl fake_inst_wme_cond = pref_for_this_wme.inst.top_of_instantiated_conditions.asPositiveCondition().bt().wme_;
                        if (fake_inst_wme_cond.gds != null) {
                            if (fake_inst_wme_cond.gds.getGoal() == null) {
                                fake_inst_wme_cond.gds.removeWme(fake_inst_wme_cond);
                                this.add_wme_to_gds(inst.match_goal.goalInfo.gds, fake_inst_wme_cond);
                                if (DEBUG_GDS) {
                                    this.context.getPrinter().print("\n       .....GDS' goal is NIL so switching from old to new GDS list....\n");
                                }
                            } else if (fake_inst_wme_cond.gds.getGoal().level > inst.match_goal_level) {
                                fake_inst_wme_cond.gds.removeWme(fake_inst_wme_cond);
                                this.add_wme_to_gds(inst.match_goal.goalInfo.gds, fake_inst_wme_cond);
                                if (DEBUG_GDS) {
                                    this.context.getPrinter().print("\n       .....switching from old to new GDS list....\n");
                                }
                                fake_inst_wme_cond.gds = inst.match_goal.goalInfo.gds;
                            }
                        } else {
                            this.add_wme_to_gds(inst.match_goal.goalInfo.gds, fake_inst_wme_cond);
                            if (DEBUG_GDS) {
                                this.context.getPrinter().print("\n       ......WME did not have defined GDS.  Now adding to goal [%s].\n", fake_inst_wme_cond.gds.getGoal());
                            }
                        }
                        if (DEBUG_GDS) {
                            this.context.getPrinter().print("            Added WME to GDS for goal = %d [%s]\n", fake_inst_wme_cond.gds.getGoal().level, fake_inst_wme_cond.gds.getGoal());
                        }
                    } else {
                        Preference pref = s.getPreferencesByType(PreferenceType.ACCEPTABLE);
                        while (pref != null) {
                            if (DEBUG_GDS) {
                                this.context.getPrinter().print("           looking at pref for the wme: %s", pref);
                            }
                            if (pref.value == wme_matching_this_cond.value) {
                                if (!pref.inst.GDS_evaluated_already) {
                                    if (DEBUG_GDS) {
                                        this.context.getPrinter().print("\n           adding inst that produced the pref to GDS: %s\n", pref.inst.prod.getName());
                                    }
                                    if (pref.inst.match_goal_level <= inst.match_goal_level) {
                                        this.uniquely_add_to_head_of_dll(pref.inst);
                                        pref.inst.GDS_evaluated_already = true;
                                    } else if (DEBUG_GDS) {
                                        this.context.getPrinter().print("\n           ignoring inst %s because it is at a lower level than the GDS\n", pref.inst.prod.getName());
                                        pref.inst.GDS_evaluated_already = true;
                                    }
                                } else if (DEBUG_GDS) {
                                    this.context.getPrinter().print("           the inst producing this pref was already explored; skipping it\n");
                                }
                            } else if (DEBUG_GDS) {
                                this.context.getPrinter().print("        this inst is for a pref with a differnt value than the condition WME; skippint it\n");
                            }
                            pref = pref.next;
                        }
                    }
                }
                cond = cond.next;
            }
            if (DEBUG_GDS) {
                this.context.getPrinter().print("\n      removing instantiation: %s\n", curr_pi.inst.prod.getName());
            }
            if (curr_pi.next != null) {
                curr_pi.next.prev = curr_pi.prev;
            }
            if (curr_pi.prev != null) {
                curr_pi.prev.next = curr_pi.next;
            }
            if (this.parent_list_head == curr_pi) {
                this.parent_list_head = curr_pi.next;
            }
            curr_pi = temp_pi = curr_pi.next;
        }
        if (this.parent_list_head != null) {
            if (DEBUG_GDS) {
                this.context.getPrinter().print("\n    RECURSING using these parents:\n");
                curr_pi = this.parent_list_head;
                while (curr_pi != null) {
                    this.context.getPrinter().print("      %s\n", curr_pi.inst.prod.getName());
                    curr_pi = curr_pi.next;
                }
            }
            this.elaborate_gds();
            this.free_parent_list();
        }
    }

    public void gds_invalid_so_remove_goal(WmeImpl w, String traceContext) {
        this.context.getTrace().print(EnumSet.of(Trace.Category.GDS, Trace.Category.VERBOSE), "%n%sRemoving state %s because element in GDS changed. WME: %s", traceContext != null ? traceContext + ": " : "", w.gds.getGoal(), w);
        if (this.tempMemory.highest_goal_whose_context_changed != null) {
            if (this.tempMemory.highest_goal_whose_context_changed.level >= w.gds.getGoal().level) {
                this.tempMemory.highest_goal_whose_context_changed = w.gds.getGoal().goalInfo.higher_goal;
            }
        } else {
            this.tempMemory.highest_goal_whose_context_changed = w.gds.getGoal().goalInfo.higher_goal;
            Slot s = this.tempMemory.highest_goal_whose_context_changed.slots;
            while (s != null) {
                if (s.isa_context_slot && s.changed == null) {
                    s.changed = s;
                }
                s = s.next;
            }
        }
        Goal goal = Adaptables.adapt(w.gds.getGoal(), Goal.class);
        this.remove_existing_context_and_descendents(w.gds.getGoal());
        this.context.getEvents().fireEvent(new GdsGoalRemovedEvent(this.context, goal, w));
    }

    private void free_parent_list() {
        this.parent_list_head = null;
    }

    private void create_gds_for_goal(IdentifierImpl goal) {
        goal.goalInfo.gds = new GoalDependencySetImpl(goal);
        if (DEBUG_GDS) {
            this.context.getPrinter().print("\nCreated GDS for goal [%s].\n", goal);
        }
    }

    private static class ParentInstantiation {
        ParentInstantiation next;
        ParentInstantiation prev;
        Instantiation inst;

        private ParentInstantiation() {
        }

        public String toString() {
            return this.inst != null ? this.inst.toString() : "null";
        }
    }

    public static enum LinkUpdateType {
        UPDATE_LINKS_NORMALLY,
        UPDATE_DISCONNECTED_IDS_LIST,
        JUST_UPDATE_COUNT;

    }

    public static enum DeciderFlag {
        NOTHING,
        CANDIDATE,
        CONFLICTED,
        FORMER_CANDIDATE,
        BEST,
        WORST,
        UNARY_INDIFFERENT,
        ALREADY_EXISTING_WME,
        UNARY_INDIFFERENT_CONSTANT;


        public boolean isSomething() {
            return this != NOTHING;
        }
    }
}

