/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Consistency;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.Phase;
import org.jsoar.kernel.RunType;
import org.jsoar.kernel.SavedFiringType;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.epmem.EpisodicMemory;
import org.jsoar.kernel.events.AbstractPhaseEvent;
import org.jsoar.kernel.events.AfterDecisionCycleEvent;
import org.jsoar.kernel.events.AfterElaborationEvent;
import org.jsoar.kernel.events.AfterHaltEvent;
import org.jsoar.kernel.events.BeforeDecisionCycleEvent;
import org.jsoar.kernel.events.BeforeElaborationEvent;
import org.jsoar.kernel.events.PhaseEvents;
import org.jsoar.kernel.events.RunLoopEvent;
import org.jsoar.kernel.io.InputOutputImpl;
import org.jsoar.kernel.learning.Chunker;
import org.jsoar.kernel.learning.rl.ReinforcementLearning;
import org.jsoar.kernel.memory.RecognitionMemory;
import org.jsoar.kernel.memory.WorkingMemory;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.StandaloneRhsFunctionHandler;
import org.jsoar.kernel.smem.SemanticMemory;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.tracing.TraceFormats;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivation;
import org.jsoar.kernel.wma.wma_go_action;
import org.jsoar.util.Arguments;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.properties.EnumPropertyProvider;
import org.jsoar.util.properties.IntegerPropertyProvider;
import org.jsoar.util.properties.LongPropertyProvider;
import org.jsoar.util.properties.PropertyManager;
import org.jsoar.util.timing.ExecutionTimers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionCycle {
    private static final Logger logger = LoggerFactory.getLogger(DecisionCycle.class);
    private final Agent context;
    private Decider decider;
    private InputOutputImpl io;
    private TraceFormats traceFormats;
    private Chunker chunker;
    private WorkingMemory workingMemory;
    private RecognitionMemory recMemory;
    private Consistency consistency;
    private ReinforcementLearning rl;
    private SemanticMemory smem;
    private EpisodicMemory epmem;
    private DefaultWorkingMemoryActivation wma;
    private boolean system_halted = false;
    private boolean stop_soar = false;
    private String reason_for_stopping = null;
    public final EnumPropertyProvider<Phase> current_phase = new EnumPropertyProvider<Phase>(SoarProperties.CURRENT_PHASE);
    private GoType go_type = GoType.GO_DECISION;
    private EnumPropertyProvider<Phase> stopPhase = new EnumPropertyProvider<Phase>(SoarProperties.STOP_PHASE);
    int e_cycles_this_d_cycle;
    private int run_phase_count;
    private int run_elaboration_count;
    private int pe_cycles_this_d_cycle;
    private int run_last_output_count;
    private int run_generated_output_count;
    public LongPropertyProvider d_cycle_count = new LongPropertyProvider(SoarProperties.D_CYCLE_COUNT);
    private LongPropertyProvider decision_phases_count = new LongPropertyProvider(SoarProperties.DECISION_PHASES_COUNT);
    private LongPropertyProvider e_cycle_count = new LongPropertyProvider(SoarProperties.E_CYCLE_COUNT);
    private LongPropertyProvider pe_cycle_count = new LongPropertyProvider(SoarProperties.PE_CYCLE_COUNT);
    public LongPropertyProvider inner_e_cycle_count = new LongPropertyProvider(SoarProperties.INNER_E_CYCLE_COUNT);
    private IntegerPropertyProvider maxElaborations = new IntegerPropertyProvider(SoarProperties.MAX_ELABORATIONS){

        @Override
        public Integer set(Integer value) {
            Arguments.check(value > 0, "max elaborations must be greater than zero");
            return super.set(value);
        }
    };
    private boolean hitMaxElaborations = false;
    private int maxNilOutputCycles = 15;
    private final RhsFunctionHandler haltHandler = new StandaloneRhsFunctionHandler("halt"){

        @Override
        public SymbolImpl execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
            DecisionCycle.this.system_halted = true;
            return null;
        }
    };
    private final AfterHaltEvent afterHaltEvent;
    private final BeforeElaborationEvent beforeElaborationEvent;
    private final AfterElaborationEvent afterElaborationEvent;
    private final BeforeDecisionCycleEvent beforeDecisionCycleEvent;
    private final RunLoopEvent pollEvent;
    private final Map<Phase, AbstractPhaseEvent> beforePhaseEvents;
    private final Map<Phase, AbstractPhaseEvent> afterPhaseEvents;

    public DecisionCycle(Agent context) {
        this.context = context;
        this.afterHaltEvent = new AfterHaltEvent(context);
        this.beforeElaborationEvent = new BeforeElaborationEvent(context);
        this.afterElaborationEvent = new AfterElaborationEvent(context);
        this.beforeDecisionCycleEvent = new BeforeDecisionCycleEvent(context, Phase.INPUT);
        this.pollEvent = new RunLoopEvent(context);
        this.beforePhaseEvents = PhaseEvents.createBeforeEvents(context);
        this.afterPhaseEvents = PhaseEvents.createAfterEvents(context);
    }

    public void initialize() {
        PropertyManager properties = this.context.getProperties();
        properties.setProvider(SoarProperties.D_CYCLE_COUNT, this.d_cycle_count);
        properties.setProvider(SoarProperties.E_CYCLE_COUNT, this.e_cycle_count);
        properties.setProvider(SoarProperties.DECISION_PHASES_COUNT, this.decision_phases_count);
        properties.setProvider(SoarProperties.PE_CYCLE_COUNT, this.pe_cycle_count);
        properties.setProvider(SoarProperties.INNER_E_CYCLE_COUNT, this.inner_e_cycle_count);
        properties.setProvider(SoarProperties.MAX_ELABORATIONS, this.maxElaborations);
        properties.setProvider(SoarProperties.CURRENT_PHASE, this.current_phase);
        properties.setProvider(SoarProperties.STOP_PHASE, this.stopPhase);
        this.io = Adaptables.adapt(this.context, InputOutputImpl.class);
        this.decider = Adaptables.adapt(this.context, Decider.class);
        this.traceFormats = Adaptables.adapt(this.context, TraceFormats.class);
        this.chunker = Adaptables.adapt(this.context, Chunker.class);
        this.workingMemory = Adaptables.adapt(this.context, WorkingMemory.class);
        this.recMemory = Adaptables.adapt(this.context, RecognitionMemory.class);
        this.consistency = Adaptables.adapt(this.context, Consistency.class);
        this.rl = Adaptables.adapt(this.context, ReinforcementLearning.class);
        this.smem = Adaptables.adapt(this.context, SemanticMemory.class);
        this.epmem = Adaptables.adapt(this.context, EpisodicMemory.class);
        this.wma = Adaptables.adapt(this.context, DefaultWorkingMemoryActivation.class);
        this.context.getRhsFunctions().registerHandler(this.haltHandler);
    }

    public void reset() {
        this.system_halted = false;
        this.stop_soar = false;
        this.reason_for_stopping = null;
        this.go_type = GoType.GO_DECISION;
        this.current_phase.set(Phase.INPUT);
        this.resetStatistics();
    }

    private void resetStatistics() {
        this.d_cycle_count.reset();
        this.decision_phases_count.reset();
        this.e_cycle_count.reset();
        this.e_cycles_this_d_cycle = 0;
        this.pe_cycle_count.reset();
        this.pe_cycles_this_d_cycle = 0;
        this.run_phase_count = 0;
        this.run_elaboration_count = 0;
        this.run_last_output_count = 0;
        this.run_generated_output_count = 0;
        this.inner_e_cycle_count.reset();
    }

    public int getMaxElaborations() {
        return this.maxElaborations.value.get();
    }

    public boolean isHitMaxElaborations() {
        return this.hitMaxElaborations;
    }

    private void setHitMaxElaborations(boolean hitMaxElaborations) {
        this.hitMaxElaborations = hitMaxElaborations;
    }

    private void do_one_top_level_phase() {
        assert (!this.system_halted);
        assert (!this.stop_soar);
        ExecutionTimers.pause(this.context.getTotalKernelTimer());
        this.context.getEvents().fireEvent(this.pollEvent);
        ExecutionTimers.start(this.context.getTotalKernelTimer());
        try {
            this.smem.smem_attach();
        }
        catch (SoarException e) {
            logger.error("While initializing smem: " + e.getMessage(), (Throwable)e);
            this.context.getPrinter().error("While initializing smem: " + e.getMessage());
        }
        switch ((Phase)((Object)this.current_phase.get())) {
            case INPUT: {
                this.doInputPhase();
                break;
            }
            case PROPOSE: {
                this.doProposePhase();
                break;
            }
            case APPLY: {
                this.doApplyPhase();
                break;
            }
            case OUTPUT: {
                this.doOutputPhase();
                break;
            }
            case DECISION: {
                this.doDecisionPhase();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid phase enumeration value " + this.current_phase);
            }
        }
        this.workingMemory.updateStats(this.context.getNumWmesInRete());
        this.checkForSystemHalt();
        if (this.stop_soar && this.reason_for_stopping != null && this.reason_for_stopping.length() > 0) {
            this.context.getPrinter().print("\n%s", this.reason_for_stopping);
        }
    }

    private void beforePhase(Phase phase) {
        this.context.getEvents().fireEvent((SoarEvent)this.beforePhaseEvents.get((Object)phase));
    }

    private void afterPhase(Phase phase) {
        ++this.run_phase_count;
        this.context.getEvents().fireEvent((SoarEvent)this.afterPhaseEvents.get((Object)phase));
    }

    private void beforeElaboration() {
        this.context.getEvents().fireEvent(this.beforeElaborationEvent);
    }

    private void afterElaboration() {
        this.context.getEvents().fireEvent(this.afterElaborationEvent);
    }

    private void pauseTopLevelTimers() {
        ExecutionTimers.pause(this.context.getTotalKernelTimer());
        ExecutionTimers.pause(this.context.getTotalCpuTimer());
    }

    private void startTopLevelTimers() {
        ExecutionTimers.start(this.context.getTotalCpuTimer());
        ExecutionTimers.start(this.context.getTotalKernelTimer());
    }

    private void doDecisionPhase() {
        assert (this.current_phase.get() == Phase.DECISION);
        Trace trace = this.context.getTrace();
        Phase.DECISION.trace(trace, true);
        this.decision_phases_count.increment();
        this.beforePhase(Phase.DECISION);
        this.decider.do_decision_phase(false);
        ++this.run_elaboration_count;
        this.afterPhase(Phase.DECISION);
        if (trace.isEnabled() && trace.isEnabled(Trace.Category.CONTEXT_DECISIONS)) {
            Writer writer = trace.getPrinter().getWriter();
            try {
                writer.append("\n");
                this.traceFormats.print_lowest_slot_in_context_stack(writer, this.decider.bottom_goal);
                writer.flush();
            }
            catch (IOException e) {
                logger.warn("While printing current context: " + e);
            }
        }
        this.e_cycles_this_d_cycle = 0;
        this.pe_cycles_this_d_cycle = 0;
        if (this.epmem.epmem_enabled() && this.epmem.encodeInSelectionPhase()) {
            this.epmem.epmem_go();
        }
        Phase.DECISION.trace(trace, false);
        this.recMemory.FIRING_TYPE = SavedFiringType.PE_PRODS;
        this.current_phase.set(Phase.APPLY);
    }

    private void doOutputPhase() {
        assert (this.current_phase.get() == Phase.OUTPUT);
        Trace trace = this.context.getTrace();
        Phase.OUTPUT.trace(trace, true);
        this.beforePhase(Phase.OUTPUT);
        this.io.do_output_cycle();
        if (this.smem.smem_enabled()) {
            this.smem.smem_go(false);
        }
        assert (this.wma.get_d_cycle_count() == this.d_cycle_count.get().longValue());
        if (this.wma.wma_enabled()) {
            this.wma.wma_go(wma_go_action.wma_histories);
        }
        if (this.epmem.epmem_enabled() && this.epmem.encodeInOutputPhase()) {
            this.wma.d_cycle_count_increment();
            this.epmem.epmem_go();
            this.wma.d_cycle_count_decrement();
        }
        if (this.wma.wma_enabled()) {
            this.wma.wma_go(wma_go_action.wma_histories);
            this.wma.wma_go(wma_go_action.wma_forgetting);
        }
        assert (this.wma.get_d_cycle_count() == this.d_cycle_count.get().longValue());
        if (this.io.isOutputLinkChanged() || ++this.run_last_output_count >= this.maxNilOutputCycles) {
            this.run_last_output_count = 0;
            ++this.run_generated_output_count;
        }
        ++this.run_elaboration_count;
        this.afterPhase(Phase.OUTPUT);
        this.context.getEvents().fireEvent(new AfterDecisionCycleEvent(this.context, Phase.OUTPUT));
        Phase.OUTPUT.trace(trace, false);
        this.current_phase.set(Phase.INPUT);
        this.d_cycle_count.increment();
        this.wma.d_cycle_count_increment();
    }

    boolean checkForMaxElaborations(Phase nextPhase) {
        if (this.e_cycles_this_d_cycle >= this.maxElaborations.value.get()) {
            this.setHitMaxElaborations(true);
            this.context.getPrinter().warn("\nWarning: reached max-elaborations(%d); proceeding to %s phases.", new Object[]{this.maxElaborations.value.get(), nextPhase});
            this.current_phase.set(nextPhase);
            return true;
        }
        return false;
    }

    private void doApplyPhase() {
        assert (this.current_phase.get() == Phase.APPLY);
        Trace trace = this.context.getTrace();
        if (this.e_cycles_this_d_cycle < 1) {
            Phase.APPLY.trace(trace, true);
            this.beforePhase(Phase.APPLY);
            this.beforeElaboration();
            this.consistency.initialize_consistency_calculations_for_new_decision();
            this.recMemory.FIRING_TYPE = SavedFiringType.PE_PRODS;
            this.consistency.determine_highest_active_production_level_in_stack_apply();
            if (this.current_phase.get() == Phase.OUTPUT) {
                ++this.run_elaboration_count;
                this.afterElaboration();
            }
        }
        while (this.current_phase.get() != Phase.OUTPUT) {
            if (this.e_cycles_this_d_cycle != 0) {
                this.beforeElaboration();
            }
            this.recMemory.do_preference_phase(this.decider.top_goal);
            this.decider.do_working_memory_phase();
            if (this.smem.smem_enabled()) {
                this.smem.smem_go(true);
            }
            this.e_cycle_count.increment();
            ++this.e_cycles_this_d_cycle;
            ++this.run_elaboration_count;
            if (this.recMemory.FIRING_TYPE == SavedFiringType.PE_PRODS) {
                this.pe_cycle_count.increment();
                ++this.pe_cycles_this_d_cycle;
            }
            this.consistency.determine_highest_active_production_level_in_stack_apply();
            this.afterElaboration();
            if (this.go_type != GoType.GO_ELABORATION) continue;
        }
        if (this.current_phase.get() == Phase.OUTPUT) {
            this.current_phase.set(Phase.APPLY);
            Phase.APPLY.trace(trace, false);
            this.afterPhase(Phase.APPLY);
            this.current_phase.set(Phase.OUTPUT);
        }
    }

    private void doProposePhase() {
        assert (this.current_phase.get() == Phase.PROPOSE);
        Trace trace = this.context.getTrace();
        if (this.e_cycles_this_d_cycle < 1) {
            Phase.PROPOSE.trace(trace, true);
            this.beforePhase(Phase.PROPOSE);
            this.beforeElaboration();
            this.consistency.initialize_consistency_calculations_for_new_decision();
            this.recMemory.FIRING_TYPE = SavedFiringType.IE_PRODS;
            this.consistency.determine_highest_active_production_level_in_stack_propose();
            if (this.current_phase.get() == Phase.DECISION) {
                ++this.run_elaboration_count;
                this.afterElaboration();
            }
        }
        while (this.current_phase.get() != Phase.DECISION) {
            if (this.e_cycles_this_d_cycle != 0) {
                this.beforeElaboration();
            }
            this.recMemory.do_preference_phase(this.decider.top_goal);
            this.decider.do_working_memory_phase();
            if (this.smem.smem_enabled()) {
                this.smem.smem_go(true);
            }
            this.e_cycle_count.increment();
            ++this.e_cycles_this_d_cycle;
            ++this.run_elaboration_count;
            this.consistency.determine_highest_active_production_level_in_stack_propose();
            this.afterElaboration();
            if (this.go_type != GoType.GO_ELABORATION) continue;
        }
        if (this.current_phase.get() == Phase.DECISION) {
            this.current_phase.set(Phase.PROPOSE);
            Phase.PROPOSE.trace(trace, false);
            this.afterPhase(Phase.PROPOSE);
            this.current_phase.set(Phase.DECISION);
        }
    }

    private void doInputPhase() {
        assert (this.current_phase.get() == Phase.INPUT);
        Trace trace = this.context.getTrace();
        Phase.INPUT.trace(trace, true);
        this.chunker.chunks_this_d_cycle = 0;
        this.e_cycles_this_d_cycle = 0;
        if (this.e_cycles_this_d_cycle == 0) {
            this.context.getEvents().fireEvent(this.beforeDecisionCycleEvent);
        }
        this.beforePhase(Phase.INPUT);
        this.io.do_input_cycle();
        ++this.run_elaboration_count;
        this.afterPhase(Phase.INPUT);
        Phase.INPUT.trace(trace, false);
        this.current_phase.set(Phase.PROPOSE);
    }

    private boolean checkForSystemHaltedAtStartOfTopLevel() {
        Printer printer = this.context.getPrinter();
        if (this.system_halted) {
            printer.print("\nSystem halted.  Use (init-soar) before running Soar again.");
            printer.flush();
            this.stop_soar = true;
            this.reason_for_stopping = "System halted.";
            return true;
        }
        return false;
    }

    private void checkForSystemHalt() {
        if (this.system_halted) {
            this.stop_soar = true;
            this.reason_for_stopping = "System halted.";
            this.context.getEvents().fireEvent(this.afterHaltEvent);
            if (this.rl.rl_enabled()) {
                IdentifierImpl g = this.decider.bottom_goal;
                while (g != null) {
                    this.rl.rl_tabulate_reward_value_for_goal(g);
                    this.rl.rl_perform_update(0.0, true, g);
                    g = g.goalInfo.higher_goal;
                }
            }
        }
    }

    private void run_for_n_phases(long n) {
        Arguments.check(n >= 0L, "n must be non-negative");
        this.startTopLevelTimers();
        this.stop_soar = false;
        this.reason_for_stopping = null;
        this.setHitMaxElaborations(false);
        while (!this.stop_soar && n != 0L) {
            this.do_one_top_level_phase();
            --n;
        }
        this.pauseTopLevelTimers();
    }

    private void run_for_n_elaboration_cycles(long n) {
        Arguments.check(n >= 0L, "n must be non-negative");
        this.startTopLevelTimers();
        this.stop_soar = false;
        this.reason_for_stopping = null;
        long d_cycles_at_start = this.d_cycle_count.value.get();
        int elapsed_cycles = 0;
        GoType save_go_type = GoType.GO_PHASE;
        elapsed_cycles = -1;
        save_go_type = this.go_type;
        this.go_type = GoType.GO_ELABORATION;
        if (d_cycles_at_start == 0L) {
            ++d_cycles_at_start;
        }
        while (!this.stop_soar && n != (long)(++elapsed_cycles)) {
            this.do_one_top_level_phase();
        }
        this.go_type = save_go_type;
        this.pauseTopLevelTimers();
    }

    private void run_for_n_modifications_of_output(long n) {
        Arguments.check(n >= 0L, "n must be non-negative");
        this.startTopLevelTimers();
        this.stop_soar = false;
        this.reason_for_stopping = null;
        int count = 0;
        while (!this.stop_soar && n != 0L) {
            boolean was_output_phase = this.current_phase.get() == Phase.OUTPUT;
            this.do_one_top_level_phase();
            if (was_output_phase) {
                if (this.io.isOutputLinkChanged()) {
                    --n;
                } else {
                    ++count;
                }
            }
            if (count < this.maxNilOutputCycles) continue;
            break;
        }
        this.pauseTopLevelTimers();
    }

    private void run_for_n_decision_cycles(long n) {
        Arguments.check(n >= 0L, "n must be non-negative");
        Phase stopPhase = (Phase)((Object)this.stopPhase.get());
        this.startTopLevelTimers();
        this.stop_soar = false;
        this.reason_for_stopping = null;
        long d_cycles_at_start = this.d_cycle_count.value.get();
        if (d_cycles_at_start == 0L) {
            ++d_cycles_at_start;
        }
        while (!this.stop_soar && n != this.d_cycle_count.value.get() - d_cycles_at_start) {
            this.do_one_top_level_phase();
        }
        while (!this.stop_soar && this.current_phase.get() != stopPhase) {
            this.do_one_top_level_phase();
        }
        this.pauseTopLevelTimers();
    }

    public void runFor(long n, RunType runType) {
        if (this.checkForSystemHaltedAtStartOfTopLevel()) {
            return;
        }
        switch (runType) {
            case ELABORATIONS: {
                this.run_for_n_elaboration_cycles(n);
                break;
            }
            case DECISIONS: {
                this.run_for_n_decision_cycles(n);
                break;
            }
            case PHASES: {
                this.run_for_n_phases(n);
                break;
            }
            case MODIFICATIONS_OF_OUTPUT: {
                for (long i = 0L; i < n; ++i) {
                    this.run_for_n_modifications_of_output(1L);
                }
                break;
            }
            case FOREVER: {
                this.runForever();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown run type: " + (Object)((Object)runType));
            }
        }
    }

    public void runForever() {
        if (this.checkForSystemHaltedAtStartOfTopLevel()) {
            return;
        }
        this.startTopLevelTimers();
        this.stop_soar = false;
        this.reason_for_stopping = null;
        while (!this.stop_soar) {
            this.do_one_top_level_phase();
        }
        this.pauseTopLevelTimers();
    }

    public boolean isStopped() {
        return this.stop_soar;
    }

    public String getReasonForStop() {
        return this.reason_for_stopping;
    }

    public void stop() {
        if (!this.stop_soar) {
            this.stop_soar = true;
            this.reason_for_stopping = "Stopped by user.";
        }
    }

    public void interrupt(String production) {
        this.stop_soar = true;
        this.reason_for_stopping = "*** Interrupt from production " + production + " ***";
    }

    public boolean isHalted() {
        return this.system_halted;
    }

    public void halt(String string) {
        this.stop_soar = true;
        this.system_halted = true;
        this.reason_for_stopping = string;
    }

    private static enum GoType {
        GO_PHASE,
        GO_ELABORATION,
        GO_DECISION;

    }
}

