/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import java.util.Random;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.symbols.IdentifierImpl;

public class DecisionManipulation {
    private final Decider decider;
    private final Random random;
    private boolean select_enabled = false;
    private String select_operator = "";
    private long predict_seed;
    private String prediction;

    public DecisionManipulation(Decider decider, Random random) {
        this.decider = decider;
        this.random = random;
        this.select_init();
        this.predict_init();
    }

    private void select_init() {
        this.select_enabled = false;
        this.select_operator = "";
    }

    public void select_next_operator(String operator_id) {
        this.select_init();
        this.select_enabled = true;
        this.select_operator = operator_id;
    }

    public String select_get_operator() {
        if (!this.select_enabled) {
            return null;
        }
        return this.select_operator;
    }

    Preference select_force(Preference candidates, boolean reinit) {
        Preference return_val = null;
        Preference cand = candidates;
        if (this.select_enabled) {
            while (cand != null && return_val == null) {
                String temp;
                IdentifierImpl valueAsId = cand.value.asIdentifier();
                if (valueAsId != null && this.select_operator.equals(temp = String.format("%s", valueAsId))) {
                    return_val = cand;
                }
                cand = cand.next;
            }
            if (reinit) {
                this.select_init();
            }
        }
        return return_val;
    }

    void predict_init() {
        this.predict_seed = 0L;
        this.prediction = "";
    }

    void predict_srand_store_snapshot() {
        int storage_val = 0;
        while (storage_val == 0) {
            storage_val = this.random.nextInt();
        }
        this.predict_seed = storage_val;
    }

    void predict_srand_restore_snapshot(boolean clear_snapshot) {
        if (this.predict_seed != 0L) {
            this.random.setSeed(this.predict_seed);
        }
        if (clear_snapshot) {
            this.predict_init();
        }
    }

    void predict_set(String prediction) {
        this.prediction = prediction;
    }

    public String predict_get() {
        this.predict_srand_store_snapshot();
        this.decider.do_decision_phase(true);
        return this.prediction;
    }
}

