/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jsoar.kernel.GoalDependencySet;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.util.Arguments;

public class GoalDependencySetImpl
implements GoalDependencySet {
    private IdentifierImpl goal;
    private WmeImpl wmes;

    public GoalDependencySetImpl(IdentifierImpl goal) {
        Arguments.checkNotNull(goal, "goal");
        this.goal = goal;
    }

    @Override
    public IdentifierImpl getGoal() {
        return this.goal;
    }

    public void clearGoal() {
        if (this.goal == null) {
            throw new IllegalStateException("GDS goal has already been cleared");
        }
        this.goal = null;
    }

    @Override
    public Iterator<Wme> getWmes() {
        return new WmeIterator(this.wmes);
    }

    @Override
    public boolean isEmpty() {
        return this.wmes == null;
    }

    public void addWme(WmeImpl w) {
        w.gds = this;
        w.gds_next = this.wmes;
        w.gds_prev = null;
        if (this.wmes != null) {
            this.wmes.gds_prev = w;
        }
        this.wmes = w;
    }

    public void removeWme(WmeImpl w) {
        if (w.gds != this) {
            throw new IllegalArgumentException(String.format("%s is not a member of GDS %s", w, this.goal));
        }
        if (w.gds_next != null) {
            w.gds_next.gds_prev = w.gds_prev;
        }
        if (w.gds_prev != null) {
            w.gds_prev.gds_next = w.gds_next;
        } else {
            this.wmes = w.gds_next;
        }
        w.gds_next = null;
        w.gds_prev = null;
        if (this.wmes == null) {
            w.gds = null;
        }
    }

    private static class WmeIterator
    implements Iterator<Wme> {
        private WmeImpl current;

        public WmeIterator(WmeImpl current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Wme next() {
            if (this.current == null) {
                throw new NoSuchElementException("At end of GDS WME list");
            }
            WmeImpl value = this.current;
            this.current = this.current.gds_next;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove WMEs from GDS with iterator");
        }
    }
}

