/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSoarVersion {
    private static final Logger logger = LoggerFactory.getLogger(JSoarVersion.class);
    private static final String PREFIX = "jsoar-core.buildinfo";
    private static JSoarVersion instance = new JSoarVersion();
    private Properties properties = new Properties();

    public static JSoarVersion getInstance() {
        return instance;
    }

    private JSoarVersion() {
        InputStream input = JSoarVersion.class.getResourceAsStream("/jsoar-core.buildinfo.properties");
        if (input != null) {
            try {
                this.properties.load(input);
            }
            catch (IOException e) {
                logger.error("Failed to load buildinfo properties: " + e.getMessage());
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getVersion() {
        return this.properties.getProperty("jsoar-core.buildinfo.version", "0.0.0").toString();
    }

    public String getBuildDate() {
        return this.properties.getProperty("jsoar-core.buildinfo.date", "Unknown");
    }

    public String getBuiltBy() {
        return this.properties.getProperty("jsoar-core.buildinfo.builtBy", "Unknown");
    }

    public String toString() {
        return this.getVersion();
    }
}

