/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import com.google.common.base.Joiner;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jsoar.kernel.Agent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogManager {
    private final Agent agent;
    private EchoMode echoMode = EchoMode.on;
    private boolean active = true;
    private boolean strict = false;
    private boolean abbreviate = true;
    private SourceLocationMethod sourceLocationMethod = SourceLocationMethod.disk;
    private LogLevel currentLogLevel = LogLevel.info;
    private final Map<String, Logger> loggers = new HashMap<String, Logger>();
    private final Set<String> disabledLoggers = new HashSet<String>();
    private static final SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public LogManager(Agent agent) {
        this.agent = agent;
        this.init();
    }

    public void init() {
        this.loggers.clear();
        this.disabledLoggers.clear();
        this.loggers.put("default", LoggerFactory.getLogger((String)"default"));
    }

    public Logger getLogger(String loggerName) throws LoggerException {
        Logger logger = this.loggers.get(loggerName);
        if (logger == null) {
            if (this.strict) {
                throw new LoggerException("Logger [" + loggerName + "] does not exist (strict mode enabled).");
            }
            logger = LoggerFactory.getLogger((String)loggerName);
            this.loggers.put(loggerName, logger);
        }
        return logger;
    }

    public Set<String> getLoggerNames() {
        return new HashSet<String>(this.loggers.keySet());
    }

    public int getLoggerCount() {
        return this.loggers.size();
    }

    public Logger addLogger(String loggerName) throws LoggerException {
        Logger logger = this.loggers.get(loggerName);
        if (logger != null) {
            if (this.strict) {
                throw new LoggerException("Logger [" + loggerName + "] already exists (strict mode enabled).");
            }
        } else {
            logger = LoggerFactory.getLogger((String)loggerName);
            this.loggers.put(loggerName, logger);
        }
        return logger;
    }

    public boolean hasLogger(String loggerName) {
        return this.loggers.containsKey(loggerName);
    }

    public String getLoggerStatus() {
        String result = "      Log Settings     \n";
        result = result + "=======================\n";
        result = result + "logging:           " + (this.isActive() ? "on" : "off") + "\n";
        result = result + "strict:            " + (this.isStrict() ? "on" : "off") + "\n";
        result = result + "echo mode:         " + this.getEchoMode().toString().toLowerCase() + "\n";
        result = result + "log level:         " + this.getLogLevel().toString().toLowerCase() + "\n";
        result = result + "source location:   " + this.getSourceLocationMethod().toString().toLowerCase() + "\n";
        result = result + "abbreviate:        " + (this.getAbbreviate() ? "yes" : "no") + "\n";
        result = result + "number of loggers: " + this.loggers.size() + "\n";
        result = result + "------- Loggers -------\n";
        ArrayList<String> loggerList = new ArrayList<String>(this.getLoggerNames());
        Collections.sort(loggerList);
        for (String loggerName : loggerList) {
            result = result + (this.disabledLoggers.contains(loggerName) ? "*" : " ") + " " + loggerName + "\n";
        }
        return result;
    }

    public void log(String loggerName, LogLevel logLevel, List<String> args, boolean collapse) throws LoggerException {
        if (!this.isActive()) {
            return;
        }
        Logger logger = this.getLogger(loggerName);
        String result = this.formatArguments(args, collapse);
        if (logLevel == LogLevel.debug) {
            logger.debug(result);
        } else if (logLevel == LogLevel.info) {
            logger.info(result);
        } else if (logLevel == LogLevel.warn) {
            logger.warn(result);
        } else if (logLevel == LogLevel.trace) {
            logger.trace(result);
        } else {
            logger.error(result);
        }
        if (this.echoMode != EchoMode.off && this.currentLogLevel.wouldAcceptLogLevel(logLevel) && !this.disabledLoggers.contains(loggerName)) {
            this.agent.getPrinter().startNewLine();
            if (this.echoMode == EchoMode.simple) {
                this.agent.getPrinter().print(result);
            } else {
                this.agent.getPrinter().print("[" + logLevel.toString() + " " + LogManager.getTimestamp() + "] " + loggerName + ": " + result);
            }
            this.agent.getPrinter().flush();
        }
    }

    private String formatArguments(List<String> args, boolean collapse) {
        int numFields;
        String formatString;
        if (args.size() > 1 && (formatString = args.get(0)).contains("{}") && (numFields = (formatString.length() - formatString.replace("{}", "").length()) / 2) == args.size() - 1) {
            return String.format(formatString.replace("{}", "%s"), args.subList(1, args.size()).toArray(new Object[args.size() - 1]));
        }
        return Joiner.on((String)(collapse ? "" : " ")).join(args);
    }

    public static String getTimestamp() {
        return timestampFormatter.format(new Date(System.currentTimeMillis()));
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public EchoMode getEchoMode() {
        return this.echoMode;
    }

    public void setEchoMode(EchoMode echoMode) {
        this.echoMode = echoMode;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.currentLogLevel = logLevel;
    }

    public LogLevel getLogLevel() {
        return this.currentLogLevel;
    }

    public void setSourceLocationMethod(SourceLocationMethod sourceLocationMethod) {
        this.sourceLocationMethod = sourceLocationMethod;
    }

    public SourceLocationMethod getSourceLocationMethod() {
        return this.sourceLocationMethod;
    }

    public void enableLogger(String name) throws LoggerException {
        this.getLogger(name);
        if (this.isStrict() && !this.disabledLoggers.contains(name)) {
            throw new LoggerException("Logger is not currently disabled (strict mode enabled).");
        }
        this.disabledLoggers.remove(name);
    }

    public void disableLogger(String name) throws LoggerException {
        this.getLogger(name);
        if (this.isStrict() && this.disabledLoggers.contains(name)) {
            throw new LoggerException("Logger is already disabled (strict mode enabled).");
        }
        this.disabledLoggers.add(name);
    }

    public void setAbbreviate(boolean abbreviate) {
        this.abbreviate = abbreviate;
    }

    public boolean getAbbreviate() {
        return this.abbreviate;
    }

    public static enum EchoMode {
        off("OFF"),
        simple("SIMPLE"),
        on("ON");

        private static Map<String, EchoMode> echoModeStrings;
        private String stringValue;

        private EchoMode(String stringValue) {
            this.stringValue = stringValue;
        }

        public static EchoMode fromString(String echoMode) {
            EchoMode val = echoModeStrings.get(echoMode.toUpperCase());
            if (val == null) {
                throw new IllegalArgumentException();
            }
            return val;
        }

        public String toString() {
            return this.stringValue;
        }

        static {
            echoModeStrings = new HashMap<String, EchoMode>();
            echoModeStrings.put("OFF", off);
            echoModeStrings.put("SIMPLE", simple);
            echoModeStrings.put("ON", on);
        }
    }

    public static enum LogLevel {
        trace("TRACE", 1),
        debug("DEBUG", 2),
        info("INFO", 3),
        warn("WARN", 4),
        error("ERROR", 5);

        private static Map<String, LogLevel> logLevelStrings;
        private String stringValue;
        private int numericValue;

        private LogLevel(String stringValue, int numericValue) {
            this.stringValue = stringValue;
            this.numericValue = numericValue;
        }

        public static LogLevel fromString(String logLevel) {
            LogLevel val = logLevelStrings.get(logLevel.toUpperCase());
            if (val == null) {
                throw new IllegalArgumentException();
            }
            return val;
        }

        public String toString() {
            return this.stringValue;
        }

        public boolean wouldAcceptLogLevel(LogLevel logLevel) {
            return logLevel.numericValue >= this.numericValue;
        }

        static {
            logLevelStrings = new HashMap<String, LogLevel>();
            logLevelStrings.put("INFO", info);
            logLevelStrings.put("DEBUG", debug);
            logLevelStrings.put("WARN", warn);
            logLevelStrings.put("TRACE", trace);
            logLevelStrings.put("ERROR", error);
        }
    }

    public static enum SourceLocationMethod {
        none("NONE"),
        disk("DISK"),
        stack("STACK");

        private static Map<String, SourceLocationMethod> sourceLocationMethodStrings;
        private String stringValue;

        private SourceLocationMethod(String stringValue) {
            this.stringValue = stringValue;
        }

        public static SourceLocationMethod fromString(String sourceLocationMethod) {
            SourceLocationMethod val = sourceLocationMethodStrings.get(sourceLocationMethod.toUpperCase());
            if (val == null) {
                throw new IllegalArgumentException();
            }
            return val;
        }

        public String toString() {
            return this.stringValue;
        }

        static {
            sourceLocationMethodStrings = new HashMap<String, SourceLocationMethod>();
            sourceLocationMethodStrings.put("NONE", none);
            sourceLocationMethodStrings.put("DISK", disk);
            sourceLocationMethodStrings.put("STACK", stack);
        }
    }

    public class LoggerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LoggerException(String message) {
            super(message);
        }
    }
}

