/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.RunType;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.util.NullWriter;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.commands.SoarCommands;

public class PerformanceTimer {
    private static List<Double> cpuTimes = new ArrayList<Double>();
    private static List<Double> kernelTimes = new ArrayList<Double>();
    private static List<Integer> decisionCycles = new ArrayList<Integer>();
    private static List<Long> totalMemory = new ArrayList<Long>();

    public static void main(String[] args) throws Exception {
        int i;
        int numRuns = 10;
        for (i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("--raw".equals(arg)) {
                System.out.println("TotalCPU, TotalKernel");
                continue;
            }
            if ("--decisions".equals(arg)) {
                System.out.println("Decisions!");
                continue;
            }
            if (!"--runs".equals(arg)) continue;
            boolean badArg = false;
            if (++i < args.length) {
                numRuns = Integer.parseInt(args[i]);
            } else {
                badArg = true;
            }
            if (numRuns <= 0) {
                badArg = true;
            }
            if (!badArg) continue;
            System.out.println("Positive integer argument required for --runs option");
        }
        System.out.println("Doing " + numRuns + " runs");
        for (i = 0; i < numRuns; ++i) {
            PerformanceTimer.doRun(args);
        }
        System.out.println("\n-----------------------------------------");
        Collections.sort(cpuTimes);
        Collections.sort(kernelTimes);
        Collections.sort(decisionCycles);
        Collections.sort(totalMemory);
        System.out.printf("   CPU: min %f, med %f, max %f\n", cpuTimes.get(0), cpuTimes.get(cpuTimes.size() / 2), cpuTimes.get(cpuTimes.size() - 1));
        System.out.printf("Kernel: min %f, med %f, max %f\n", kernelTimes.get(0), kernelTimes.get(kernelTimes.size() / 2), kernelTimes.get(kernelTimes.size() - 1));
        System.out.printf("DecCyc: min %8d, med %8d, max %8d\n", decisionCycles.get(0), decisionCycles.get(decisionCycles.size() / 2), decisionCycles.get(decisionCycles.size() - 1));
        System.out.printf("TotMem: min %8d, med %8d, max %8d\n", totalMemory.get(0), totalMemory.get(totalMemory.size() / 2), totalMemory.get(totalMemory.size() - 1));
    }

    private static void doRun(String[] args) throws SoarException {
        Agent agent = new Agent();
        agent.getTrace().setEnabled(false);
        agent.getPrinter().pushWriter(new NullWriter());
        SoarCommandInterpreter ifc = agent.getInterpreter();
        boolean raw = false;
        boolean runs = false;
        long decisions = -1L;
        for (String arg : args) {
            if (decisions == 0L) {
                decisions = Integer.valueOf(arg).intValue();
                if (decisions != 0L) continue;
                decisions = -1L;
                continue;
            }
            if (runs) {
                runs = false;
                continue;
            }
            if ("--raw".equals(arg)) {
                raw = true;
                continue;
            }
            if ("--decisions".equals(arg)) {
                decisions = 0L;
                continue;
            }
            if ("--runs".equals(arg)) {
                runs = true;
                continue;
            }
            SoarCommands.source(ifc, arg);
        }
        if (decisions > 0L) {
            agent.runFor(decisions, RunType.DECISIONS);
        } else {
            agent.runForever();
        }
        agent.getPrinter().popWriter();
        double cpuTime = agent.getTotalCpuTimer().getTotalSeconds();
        double kernelTime = agent.getTotalKernelTimer().getTotalSeconds();
        int dc = agent.getProperties().get(SoarProperties.D_CYCLE_COUNT).intValue();
        long mem = Runtime.getRuntime().totalMemory();
        cpuTimes.add(cpuTime);
        kernelTimes.add(kernelTime);
        decisionCycles.add(dc);
        totalMemory.add(mem);
        if (!raw) {
            ifc.eval("stats");
        } else {
            agent.getPrinter().print("%f, %f, %d, %d\n", cpuTime, kernelTime, dc, mem);
        }
        agent.dispose();
    }
}

