/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import org.jsoar.kernel.events.AbstractPhaseEvent;
import org.jsoar.kernel.events.PhaseEvents;
import org.jsoar.kernel.tracing.Trace;

public enum Phase {
    INPUT("input", PhaseEvents.BeforeInput.class, PhaseEvents.AfterInput.class),
    PROPOSE("propose", PhaseEvents.BeforePropose.class, PhaseEvents.AfterPropose.class),
    DECISION("decision", PhaseEvents.BeforeDecision.class, PhaseEvents.AfterDecision.class),
    APPLY("apply", PhaseEvents.BeforeApply.class, PhaseEvents.AfterApply.class),
    OUTPUT("output", PhaseEvents.BeforeOutput.class, PhaseEvents.AfterOutput.class);

    private final String traceName;
    private final String traceEndName;
    private final Class<? extends AbstractPhaseEvent> beforeEventType;
    private final Class<? extends AbstractPhaseEvent> afterEventType;

    private Phase(String traceName, Class<? extends AbstractPhaseEvent> beforeEventType, Class<? extends AbstractPhaseEvent> afterEventType) {
        this.traceName = traceName;
        this.traceEndName = "END " + traceName;
        this.beforeEventType = beforeEventType;
        this.afterEventType = afterEventType;
    }

    private String getTraceName(boolean startOfPhase) {
        return startOfPhase ? this.traceName : this.traceEndName;
    }

    public void trace(Trace trace, boolean startOfPhase) {
        if (startOfPhase && trace.isEnabled(Trace.Category.PHASES)) {
            trace.startNewLine().print("--- " + this.getTraceName(startOfPhase) + " phase ---");
        }
    }

    public Class<? extends AbstractPhaseEvent> getBeforeEvent() {
        return this.beforeEventType;
    }

    public Class<? extends AbstractPhaseEvent> getAfterEvent() {
        return this.afterEventType;
    }
}

