/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.learning.rl.RLRuleInfo;
import org.jsoar.kernel.learning.rl.RLTemplateInfo;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.ConditionReorderer;
import org.jsoar.kernel.lhs.Conditions;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.rete.ConditionsAndNots;
import org.jsoar.kernel.rete.PartialMatches;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rete.ReteNode;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.rhs.ActionReorderer;
import org.jsoar.kernel.rhs.ActionSupport;
import org.jsoar.kernel.rhs.ReordererException;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.kernel.symbols.VariableGenerator;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.util.Arguments;
import org.jsoar.util.ByRef;
import org.jsoar.util.DefaultSourceLocation;
import org.jsoar.util.SourceLocation;
import org.jsoar.util.StringTools;
import org.jsoar.util.markers.DefaultMarker;

public class Production {
    private static final List<Variable> EMPTY_RHS_UNBOUND_VARS_LIST = Collections.emptyList();
    private final ProductionType type;
    private final SourceLocation location;
    private final String name;
    private String documentation;
    private final Support declared_support;
    private final boolean interrupt;
    private Condition condition_list;
    private Condition bottomOfConditionList;
    private Action action_list;
    private final AtomicBoolean breakpointEnabled = new AtomicBoolean();
    private final AtomicLong firingCount = new AtomicLong(0L);
    private final AtomicBoolean traceFirings = new AtomicBoolean();
    private Rete rete;
    private ReteNode p_node;
    public Instantiation instantiations;
    private List<Variable> rhs_unbound_variables = null;
    private boolean reordered = false;
    public RLRuleInfo rlRuleInfo = null;
    public final RLTemplateInfo rlTemplateInfo;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Production(ProductionType type, SourceLocation location, String name, String doc, Condition lhs_top_in, Condition lhs_bottom_in, Action rhs_top_in, Support support, boolean interrupt) {
        Arguments.checkNotNull((Object)type, "type");
        Arguments.checkNotNull(location, "location");
        Arguments.checkNotNull(name, "name");
        this.type = type;
        this.location = location;
        this.name = name;
        this.documentation = doc;
        this.condition_list = lhs_top_in;
        this.bottomOfConditionList = lhs_bottom_in;
        this.action_list = rhs_top_in;
        this.declared_support = support;
        this.interrupt = interrupt;
        this.rlTemplateInfo = type == ProductionType.TEMPLATE ? new RLTemplateInfo() : null;
    }

    public ProductionType getType() {
        return this.type;
    }

    public SourceLocation getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation != null ? this.documentation : "";
    }

    public void setDocumentation(String newDoc) {
        this.documentation = newDoc;
    }

    public Support getDeclaredSupport() {
        return this.declared_support;
    }

    public Condition getFirstCondition() {
        return this.condition_list;
    }

    public Action getFirstAction() {
        return this.action_list;
    }

    public long getFiringCount() {
        return this.firingCount.get();
    }

    public void resetFiringCount() {
        this.firingCount.set(0L);
    }

    public long incrementFiringCount() {
        return this.firingCount.incrementAndGet();
    }

    public boolean isBreakpointEnabled() {
        return this.interrupt || this.breakpointEnabled.get();
    }

    public void setBreakpointEnabled(boolean v) {
        this.breakpointEnabled.set(v);
    }

    public boolean isTraceFirings() {
        return this.traceFirings.get();
    }

    public void setTraceFirings(boolean value) {
        this.traceFirings.set(value);
    }

    public void printPartialMatches(Printer printer, Trace.WmeTraceType wtt) {
        this.printPartialMatches(printer, wtt, false);
    }

    public void printPartialMatches(Printer printer, Trace.WmeTraceType wtt, boolean showNodeIds) {
        if (this.rete == null) {
            return;
        }
        this.rete.print_partial_match_information(printer, this.p_node, wtt, showNodeIds);
    }

    public PartialMatches getPartialMatches() {
        if (this.rete == null) {
            return new PartialMatches(new ArrayList<PartialMatches.Entry>());
        }
        return this.rete.getPartialMatches(this.p_node);
    }

    public int getReteTokenCount() {
        return this.rete != null ? this.rete.count_rete_tokens_for_production(this.p_node) : 0;
    }

    public void reorder(VariableGenerator varGen, ConditionReorderer cr, ActionReorderer ar, boolean reorder_nccs) throws ReordererException {
        if (this.reordered) {
            throw new IllegalStateException("Production '" + this.name + "' already reordered");
        }
        if (this.type != ProductionType.JUSTIFICATION) {
            ByRef<Condition> lhs_top = ByRef.create(this.condition_list);
            ByRef<Condition> lhs_bottom = ByRef.create(this.bottomOfConditionList);
            ByRef<Action> rhs_top = ByRef.create(this.action_list);
            varGen.reset((Condition)lhs_top.value, (Action)rhs_top.value);
            DefaultMarker tc = DefaultMarker.create();
            Condition.addBoundVariables((Condition)lhs_top.value, tc, null);
            ar.reorder_action_list(rhs_top, tc);
            cr.reorder_lhs(lhs_top, lhs_bottom, reorder_nccs);
            Action a = (Action)rhs_top.value;
            while (a != null) {
                a.support = ActionSupport.UNKNOWN_SUPPORT;
                a = a.next;
            }
            this.condition_list = (Condition)lhs_top.value;
            this.bottomOfConditionList = (Condition)lhs_bottom.value;
            this.action_list = (Action)rhs_top.value;
        } else {
            Action a = this.action_list;
            while (a != null) {
                a.support = ActionSupport.UNKNOWN_SUPPORT;
                a = a.next;
            }
        }
        this.reordered = true;
    }

    public List<Variable> getRhsUnboundVariables() {
        return this.rhs_unbound_variables != null ? this.rhs_unbound_variables : EMPTY_RHS_UNBOUND_VARS_LIST;
    }

    public void clearRhsUnboundVariables() {
        this.rhs_unbound_variables = null;
    }

    public void setRhsUnboundVariables(List<Variable> unboundVars) {
        this.rhs_unbound_variables = unboundVars;
    }

    public void setReteNode(Rete rete, ReteNode p_node) {
        if (!(this.rete == null && this.p_node == null || rete == null && p_node == null)) {
            throw new IllegalStateException("Production " + this + " is already in rete");
        }
        this.rete = rete;
        this.p_node = p_node;
    }

    public ReteNode getReteNode() {
        return this.p_node;
    }

    public String toString() {
        return this.name.toString() + " (" + (Object)((Object)this.type) + ") " + this.firingCount;
    }

    public void print(Printer printer, boolean internal) {
        if (this.rete == null || this.p_node == null) {
            printer.print("%s has been excised", this.name);
            return;
        }
        printer.print("sp {%s\n", this.name);
        if (this.documentation != null && this.documentation.length() > 0) {
            printer.print("    %s\n", StringTools.string_to_escaped_string(this.documentation, '\"'));
        }
        switch (this.type) {
            case DEFAULT: {
                printer.print("    :default\n");
                break;
            }
            case USER: {
                break;
            }
            case CHUNK: {
                printer.print("    :chunk\n");
                break;
            }
            case JUSTIFICATION: {
                printer.print("    :justification ;# not reloadable\n");
                break;
            }
            case TEMPLATE: {
                printer.print("    :template\n");
            }
        }
        switch (this.declared_support) {
            case DECLARED_O_SUPPORT: {
                printer.print("    :o-support\n");
                break;
            }
            case DECLARED_I_SUPPORT: {
                printer.print("    :i-support\n");
                break;
            }
        }
        if (this.interrupt) {
            printer.print("    :interrupt\n");
        }
        ConditionsAndNots cns = this.rete.p_node_to_conditions_and_nots(this.p_node, null, null, true);
        printer.print("   ");
        Conditions.print_condition_list(printer, cns.top, 3, internal);
        printer.print("\n    -->\n  ");
        printer.print("  ");
        Action.print_action_list(printer, cns.actions, 4, internal);
        printer.print("\n}\n").flush();
    }

    public static class Builder {
        private ProductionType type;
        private SourceLocation location = DefaultSourceLocation.UNKNOWN;
        private String name;
        private String documentation = "";
        private Condition topCondition;
        private Condition bottomCondition;
        private Action actions;
        private Support support = Support.UNDECLARED;
        private boolean interrupt = false;

        public Builder type(ProductionType type) {
            this.type = type;
            return this;
        }

        public Builder location(SourceLocation v) {
            this.location = v;
            return this;
        }

        public Builder name(String v) {
            this.name = v;
            return this;
        }

        public Builder documentation(String v) {
            this.documentation = v;
            return this;
        }

        public Builder conditions(Condition top, Condition bottom) {
            this.topCondition = top;
            this.bottomCondition = bottom;
            return this;
        }

        public Builder actions(Action v) {
            this.actions = v;
            return this;
        }

        public Builder support(Support v) {
            this.support = v;
            return this;
        }

        public Builder interrupt(boolean v) {
            this.interrupt = v;
            return this;
        }

        public Production build() {
            return new Production(this.type, this.location, this.name, this.documentation, this.topCondition, this.bottomCondition, this.actions, this.support, this.interrupt);
        }
    }

    public static enum Support {
        UNDECLARED,
        DECLARED_O_SUPPORT,
        DECLARED_I_SUPPORT;

    }
}

