/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class ChunkCommand
implements SoarCommand {
    private Agent agent;

    public ChunkCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Chunk(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Chunk(this.agent);
    }

    @CommandLine.Command(name="chunk", description={"Prints or adjusts Soar's ability to learn new rules"}, subcommands={CommandLine.HelpCommand.class})
    public static class Chunk
    implements Runnable {
        private Agent agent;
        @CommandLine.Option(names={"on", "-e", "--on", "--enable"}, description={"Enables chunking"})
        boolean enable = false;
        @CommandLine.Option(names={"off", "-d", "--off", "--disable"}, description={"Disables chunking"})
        boolean disable = false;

        public Chunk(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            if (!this.enable && !this.disable) {
                this.agent.getPrinter().startNewLine().print("The current chunk setting is: " + (this.agent.getProperties().get(SoarProperties.LEARNING_ON) != false ? "enabled" : "disabled"));
            } else if (this.enable) {
                this.agent.getProperties().set(SoarProperties.LEARNING_ON, true);
            } else {
                this.agent.getProperties().set(SoarProperties.LEARNING_ON, false);
            }
        }
    }
}

