/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.DecisionManipulation;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.exploration.Exploration;
import org.jsoar.util.PrintHelper;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class DecideCommand
implements SoarCommand {
    private static final int DISPLAY_COLUMNS = 55;
    private final Agent agent;

    public DecideCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Decide(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Decide(this.agent);
    }

    private static String currentNumericIndifferentMode(Exploration exploration) {
        return PrintHelper.generateItem("Numeric indifference mode:", exploration.exploration_get_numeric_indifferent_mode().getModeName(), 55);
    }

    private static String currentPolicy(Exploration exploration) {
        return PrintHelper.generateItem("Exploration Policy:", exploration.exploration_get_policy().getPolicyName(), 55);
    }

    private static String currentParameterValue(Exploration exploration, String name) {
        return PrintHelper.generateItem(name.substring(0, 1).toUpperCase() + name.substring(1) + ":", exploration.exploration_get_parameter_value(name), 55);
    }

    private static String currentParameterReductionPolicy(Exploration exploration, String name) {
        return PrintHelper.generateItem(name.substring(0, 1).toUpperCase() + name.substring(1) + " Reduction Policy:", exploration.exploration_get_reduction_policy(name).getPolicyName(), 55);
    }

    private static String currentParameterReductionRate(Exploration exploration, String name, String policy) {
        return PrintHelper.generateItem(name.substring(0, 1).toUpperCase() + name.substring(1) + " " + policy.substring(0, 1).toUpperCase() + policy.substring(1) + " Reduction Rate:", exploration.exploration_get_reduction_rate(name, policy), 55);
    }

    private static String currentAutoReduceSetting(Exploration exploration) {
        return PrintHelper.generateItem("Automatic Policy Parameter Reduction:", exploration.exploration_get_auto_update() ? "on" : "off", 55);
    }

    @CommandLine.Command(name="srand", description={"Alias to set-random-seed"}, subcommands={CommandLine.HelpCommand.class})
    public static class SRand
    implements Runnable {
        @CommandLine.ParentCommand
        Decide parent;
        @CommandLine.Parameters(index="0", arity="0..1", description={"The seed for the random number generator"})
        private Long seed = null;

        @Override
        public void run() {
            if (this.seed == null) {
                this.seed = System.nanoTime();
            }
            this.parent.agent.getRandom().setSeed(this.seed);
            this.parent.agent.getPrinter().startNewLine().print("Random number generator seed set to " + this.seed);
        }
    }

    @CommandLine.Command(name="set-random-seed", description={"Seeds the random number generator with the passed seed"}, subcommands={CommandLine.HelpCommand.class})
    public static class SetRandomSeed
    implements Runnable {
        @CommandLine.ParentCommand
        Decide parent;
        @CommandLine.Parameters(index="0", arity="0..1", description={"The seed for the random number generator"})
        private Long seed = null;

        @Override
        public void run() {
            if (this.seed == null) {
                this.seed = System.nanoTime();
            }
            this.parent.agent.getRandom().setSeed(this.seed);
            this.parent.agent.getPrinter().startNewLine().print("Random number generator seed set to " + this.seed);
        }
    }

    @CommandLine.Command(name="select", description={"Forces the selection of an operator whose ID is supplied as an argument during the next decision phase"}, subcommands={CommandLine.HelpCommand.class})
    public static class Select
    implements Runnable {
        @CommandLine.ParentCommand
        Decide parent;
        @CommandLine.Parameters(index="0", arity="0..1", description={"The operator's identifier"})
        private String operatorID = null;

        @Override
        public void run() {
            if (this.operatorID == null) {
                String my_selection = this.parent.decisionManipulation.select_get_operator();
                if (my_selection == null) {
                    this.parent.agent.getPrinter().startNewLine().print("No operator selected.");
                } else {
                    this.parent.agent.getPrinter().startNewLine().print(my_selection);
                }
            } else {
                this.parent.decisionManipulation.select_next_operator(this.operatorID);
                this.parent.agent.getPrinter().startNewLine().print("Operator " + this.operatorID + " will be selected.");
            }
        }
    }

    @CommandLine.Command(name="predict", description={"Based upon current operator proposals, determines which operator will be chosen during the next decision phase"}, subcommands={CommandLine.HelpCommand.class})
    public static class Predict
    implements Runnable {
        @CommandLine.ParentCommand
        Decide parent;

        @Override
        public void run() {
            this.parent.agent.getPrinter().startNewLine().print(this.parent.decisionManipulation.predict_get());
        }
    }

    @CommandLine.Command(name="numeric-indifferent-mode", description={"Sets how multiple numeric indifferent preference values given to an operator are combined into a single value for use in random selection"}, subcommands={CommandLine.HelpCommand.class})
    public static class NumericIndifferentMode
    implements Runnable {
        @CommandLine.ParentCommand
        Decide parent;
        @CommandLine.Option(names={"-a", "--avg"}, description={"Combines multiple preference values via an average"})
        boolean average = false;
        @CommandLine.Option(names={"-s", "--sum"}, description={"Combines multiple preference values via a sum"})
        boolean sum = false;

        @Override
        public void run() {
            if (this.average) {
                if (this.parent.exploration.exploration_set_numeric_indifferent_mode("avg")) {
                    this.parent.agent.getPrinter().startNewLine().print("Set decide numeric-indifferent-mode to avg");
                } else {
                    this.parent.agent.getPrinter().startNewLine().print("Failed to set numeric-indifferent-mode to avg");
                }
            } else if (this.sum) {
                if (this.parent.exploration.exploration_set_numeric_indifferent_mode("sum")) {
                    this.parent.agent.getPrinter().startNewLine().print("Set decide numeric-indifferent-mode to sum");
                } else {
                    this.parent.agent.getPrinter().startNewLine().print("Failed to set numeric-indifferent-mode to sum");
                }
            } else {
                this.parent.agent.getPrinter().startNewLine().print(DecideCommand.currentNumericIndifferentMode(this.parent.exploration));
            }
        }
    }

    @CommandLine.Command(name="indifferent-selection", description={"Allows the user to set options relating to selection between operator proposals that are mutually indifferent in preference memory"}, subcommands={CommandLine.HelpCommand.class})
    public static class IndifferentSelection
    implements Runnable {
        @CommandLine.ParentCommand
        Decide parent;
        @CommandLine.Option(names={"-b", "--boltzmann"}, description={"Sets the exploration policy to 'boltzmann'"})
        boolean boltzmannPolicy = false;
        @CommandLine.Option(names={"-E", "--epsilon-greedy"}, description={"Sets the exploration policy to 'epsilon-greedy'"})
        boolean epsilonGreedyPolicy = false;
        @CommandLine.Option(names={"-f", "--first"}, description={"Sets the exploration policy to 'first'"})
        boolean firstPolicy = false;
        @CommandLine.Option(names={"-l", "--last"}, description={"Sets the exploration policy to 'last'"})
        boolean lastPolicy = false;
        @CommandLine.Option(names={"-s", "--softmax"}, description={"Sets the exploration policy to 'softmax'"})
        boolean softmaxPolicy = false;
        @CommandLine.Option(names={"-e", "--epsilon"}, description={"Prints or updates the epsilon value"})
        boolean epsilon = false;
        @CommandLine.Option(names={"-t", "--temperature"}, description={"Prints or updates temperature value"})
        boolean temperature = false;
        @CommandLine.Option(names={"-p", "--reduction-policy"}, description={"Prints or updates the reduction policy for the given parameter"})
        String reductionPolicyParam = null;
        @CommandLine.Option(names={"-r", "--reduction-rate"}, description={"Prints or updates the reduction rate for the given parameter"})
        String reductionRateParam = null;
        @CommandLine.Option(names={"-a", "--auto-reduce"}, description={"Prints or toggles automatic policy parameter reduction"})
        boolean autoReduce = false;
        @CommandLine.Option(names={"-S", "--stats"}, description={"Prints summary of decision settings"})
        boolean printStats = false;
        @CommandLine.Parameters(index="0", arity="0..1", description={"New epsilon/temperature value; or exploration parameter reduction policy: 'linear' or 'exponential'; or toggles auto-reduce: 'on' or 'off'"})
        private String param = null;
        @CommandLine.Parameters(index="1", arity="0..1", description={"New exploration parameter reduction rate"})
        private Double reductionRate = null;

        @Override
        public void run() {
            block52: {
                if ((this.boltzmannPolicy ? 1 : 0) + (this.epsilonGreedyPolicy ? 1 : 0) + (this.firstPolicy ? 1 : 0) + (this.lastPolicy ? 1 : 0) + (this.softmaxPolicy ? 1 : 0) + (this.epsilon ? 1 : 0) + (this.temperature ? 1 : 0) + (this.reductionPolicyParam != null ? 1 : 0) + (this.reductionRateParam != null ? 1 : 0) + (this.autoReduce ? 1 : 0) + (this.printStats ? 1 : 0) >= 2) {
                    this.parent.agent.getPrinter().startNewLine().print("indifferent-selection takes only one option at a time.");
                    return;
                }
                if (this.boltzmannPolicy || this.epsilonGreedyPolicy || this.firstPolicy || this.lastPolicy || this.softmaxPolicy) {
                    String policyName = "boltzmann";
                    if (this.epsilonGreedyPolicy) {
                        policyName = "epsilon-greedy";
                    } else if (this.firstPolicy) {
                        policyName = "first";
                    } else if (this.lastPolicy) {
                        policyName = "last";
                    } else if (this.softmaxPolicy) {
                        policyName = "softmax";
                    }
                    if (this.parent.exploration.exploration_set_policy(policyName)) {
                        this.parent.agent.getPrinter().startNewLine().print("Set decide indifferent-selection policy to " + policyName);
                    } else {
                        this.parent.agent.getPrinter().startNewLine().print("Failed to set decide indifferent-selection policy to " + policyName);
                    }
                } else if (this.epsilon || this.temperature) {
                    String parameterName = "epsilon";
                    if (this.temperature) {
                        parameterName = "temperature";
                    }
                    if (this.param == null) {
                        this.parent.agent.getPrinter().startNewLine().print(DecideCommand.currentParameterValue(this.parent.exploration, parameterName));
                    } else {
                        Double newValue = null;
                        try {
                            newValue = Double.parseDouble(this.param);
                            if (this.parent.exploration.exploration_valid_parameter_value(parameterName, (double)newValue)) {
                                if (this.parent.exploration.exploration_set_parameter_value(parameterName, (double)newValue)) {
                                    this.parent.agent.getPrinter().startNewLine().print("Set decide " + parameterName + " parameter value to " + newValue);
                                } else {
                                    this.parent.agent.getPrinter().startNewLine().print("Unknown error trying to set decide " + parameterName + " parameter value");
                                }
                                break block52;
                            }
                            this.parent.agent.getPrinter().startNewLine().print("Illegal value for decide " + parameterName + " parameter value");
                        }
                        catch (NumberFormatException e) {
                            this.parent.agent.getPrinter().startNewLine().print(String.format("%s is not a valid double: %s", this.param, e.getMessage()));
                        }
                    }
                } else if (this.reductionPolicyParam != null) {
                    if (this.parent.exploration.exploration_valid_parameter(this.reductionPolicyParam)) {
                        if (this.param == null) {
                            this.parent.agent.getPrinter().startNewLine().print(DecideCommand.currentParameterReductionPolicy(this.parent.exploration, this.reductionPolicyParam));
                        } else if (this.parent.exploration.exploration_set_reduction_policy(this.reductionPolicyParam, this.param)) {
                            this.parent.agent.getPrinter().startNewLine().print("Set " + this.reductionPolicyParam + " reduction policy to " + this.param);
                        } else {
                            this.parent.agent.getPrinter().startNewLine().print("Illegal value for " + this.reductionPolicyParam + " reduction policy: " + this.param);
                        }
                    } else {
                        this.parent.agent.getPrinter().startNewLine().print("Unknown parameter name: " + this.reductionPolicyParam);
                    }
                } else if (this.reductionRateParam != null) {
                    if (this.parent.exploration.exploration_valid_parameter(this.reductionRateParam)) {
                        if (this.param == null) {
                            this.parent.agent.getPrinter().startNewLine().print("Error: exploration parameter reduction policy must be specified");
                        } else if (this.parent.exploration.exploration_valid_reduction_policy(this.reductionRateParam, this.param)) {
                            if (this.reductionRate == null) {
                                this.parent.agent.getPrinter().startNewLine().print(DecideCommand.currentParameterReductionRate(this.parent.exploration, this.reductionRateParam, this.param));
                            } else if (this.parent.exploration.exploration_set_reduction_rate(this.reductionRateParam, this.param, this.reductionRate)) {
                                this.parent.agent.getPrinter().startNewLine().print("Set " + this.reductionRateParam + " " + this.param + " reduction rate to " + this.reductionRate);
                            } else {
                                this.parent.agent.getPrinter().startNewLine().print("Illegal value for " + this.reductionRateParam + " " + this.param + " reduction rate: " + this.reductionRate);
                            }
                        } else {
                            this.parent.agent.getPrinter().startNewLine().print("Unknown reduction policy name: " + this.param);
                        }
                    } else {
                        this.parent.agent.getPrinter().startNewLine().print("Unknown parameter name: " + this.reductionRateParam);
                    }
                } else if (this.autoReduce) {
                    if (this.param == null) {
                        this.parent.agent.getPrinter().startNewLine().print(DecideCommand.currentAutoReduceSetting(this.parent.exploration));
                    } else if (this.param.equals("on")) {
                        this.parent.exploration.exploration_set_auto_update(true);
                        this.parent.agent.getPrinter().startNewLine().print("Enabled decide indifferent-selection auto-update");
                    } else if (this.param.equals("off")) {
                        this.parent.exploration.exploration_set_auto_update(false);
                        this.parent.agent.getPrinter().startNewLine().print("Disabled decide indifferent-selection auto-update");
                    } else {
                        this.parent.agent.getPrinter().startNewLine().print("Illegal argument to decide indifferent-selection --auto-reduce: " + this.param);
                    }
                } else if (this.printStats) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.printf(DecideCommand.currentPolicy(this.parent.exploration), new Object[0]);
                    pw.printf(DecideCommand.currentAutoReduceSetting(this.parent.exploration), new Object[0]);
                    pw.printf(DecideCommand.currentParameterValue(this.parent.exploration, "epsilon"), new Object[0]);
                    pw.printf(DecideCommand.currentParameterReductionPolicy(this.parent.exploration, "epsilon"), new Object[0]);
                    pw.printf(DecideCommand.currentParameterReductionRate(this.parent.exploration, "epsilon", "exponential"), new Object[0]);
                    pw.printf(DecideCommand.currentParameterReductionRate(this.parent.exploration, "epsilon", "linear"), new Object[0]);
                    pw.printf(DecideCommand.currentParameterValue(this.parent.exploration, "temperature"), new Object[0]);
                    pw.printf(DecideCommand.currentParameterReductionPolicy(this.parent.exploration, "temperature"), new Object[0]);
                    pw.printf(DecideCommand.currentParameterReductionRate(this.parent.exploration, "temperature", "exponential"), new Object[0]);
                    pw.printf(DecideCommand.currentParameterReductionRate(this.parent.exploration, "temperature", "linear"), new Object[0]);
                    pw.flush();
                    this.parent.agent.getPrinter().startNewLine().print(sw.toString());
                } else {
                    this.parent.agent.getPrinter().startNewLine().print(DecideCommand.currentPolicy(this.parent.exploration));
                }
            }
        }
    }

    @CommandLine.Command(name="decide", description={"Commands and settings related to the selection of operators during the Soar decision process"}, subcommands={CommandLine.HelpCommand.class, IndifferentSelection.class, NumericIndifferentMode.class, Predict.class, Select.class, SetRandomSeed.class, SRand.class})
    public static class Decide
    implements Runnable {
        private Agent agent;
        private Exploration exploration;
        private DecisionManipulation decisionManipulation;

        public Decide(Agent agent) {
            this.agent = agent;
            this.exploration = Adaptables.adapt(agent, Exploration.class);
            this.decisionManipulation = Adaptables.adapt(agent, DecisionManipulation.class);
        }

        @Override
        public void run() {
            this.printCurrentDecideSettings();
        }

        private void printCurrentDecideSettings() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.printf(PrintHelper.generateHeader("Decide Summary", 55), new Object[0]);
            pw.printf(DecideCommand.currentNumericIndifferentMode(this.exploration), new Object[0]);
            pw.printf(PrintHelper.generateSection("Discount", 55), new Object[0]);
            pw.printf(DecideCommand.currentPolicy(this.exploration), new Object[0]);
            pw.printf(DecideCommand.currentAutoReduceSetting(this.exploration), new Object[0]);
            pw.printf(DecideCommand.currentParameterValue(this.exploration, "epsilon"), new Object[0]);
            pw.printf(DecideCommand.currentParameterReductionPolicy(this.exploration, "epsilon"), new Object[0]);
            pw.printf(DecideCommand.currentParameterReductionRate(this.exploration, "epsilon", "exponential"), new Object[0]);
            pw.printf(DecideCommand.currentParameterReductionRate(this.exploration, "epsilon", "linear"), new Object[0]);
            pw.printf(DecideCommand.currentParameterValue(this.exploration, "temperature"), new Object[0]);
            pw.printf(DecideCommand.currentParameterReductionPolicy(this.exploration, "temperature"), new Object[0]);
            pw.printf(DecideCommand.currentParameterReductionRate(this.exploration, "temperature", "exponential"), new Object[0]);
            pw.printf(DecideCommand.currentParameterReductionRate(this.exploration, "temperature", "linear"), new Object[0]);
            pw.printf(PrintHelper.generateSection("Discount", 55), new Object[0]);
            pw.flush();
            this.agent.getPrinter().startNewLine().print(sw.toString());
        }
    }
}

