/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.util.FileTools;
import org.jsoar.util.SourceLocation;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class EditProductionCommand
implements SoarCommand {
    private final Agent agent;

    public EditProductionCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new EditProduction(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new EditProduction(this.agent);
    }

    @CommandLine.Command(name="edit-production", description={"Opens the given production in a text editor"}, subcommands={CommandLine.HelpCommand.class})
    public static class EditProduction
    implements Runnable {
        private Agent agent;
        @CommandLine.Parameters(index="0", description={"The production to edit"})
        private String prodName = null;

        public EditProduction(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            if (this.prodName == null) {
                this.agent.getPrinter().startNewLine().print("Expected single production name argument");
                return;
            }
            Production p = this.agent.getProductions().getProduction(this.prodName);
            if (p == null) {
                this.agent.getPrinter().startNewLine().print("No production named '" + this.prodName + "'");
                return;
            }
            SourceLocation location = p.getLocation();
            String file = location.getFile();
            if (file == null || file.length() == 0) {
                this.agent.getPrinter().startNewLine().print("Don't know source location of production '" + this.prodName + "'");
                return;
            }
            if (FileTools.asUrl(file) != null) {
                this.agent.getPrinter().startNewLine().print("Don't know how to edit productions loaded from URLs: " + file);
                return;
            }
            try {
                Desktop.getDesktop().edit(new File(file));
            }
            catch (IOException e) {
                this.agent.getPrinter().startNewLine().print("Failed to edit '" + file + "': " + e);
            }
        }
    }
}

