/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Goal;
import org.jsoar.kernel.LogManager;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.util.DefaultSourceLocation;
import org.jsoar.util.SourceLocation;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.commands.SoarCommandInterpreter;
import picocli.CommandLine;

public class LogCommand
implements SoarCommand {
    private final Agent agent;
    private SoarCommandInterpreter interpreter;

    public LogCommand(Agent agent, SoarCommandInterpreter interpreter) {
        this.agent = agent;
        this.interpreter = interpreter;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Log(this.agent, this.interpreter, context), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Log(this.agent, this.interpreter, null);
    }

    @CommandLine.Command(name="log", description={"Adjusts logging settings"}, subcommands={CommandLine.HelpCommand.class})
    public static class Log
    implements Runnable {
        private final Agent agent;
        private final LogManager logManager;
        private final SoarCommandInterpreter interpreter;
        private final SoarCommandContext context;
        private static String sourceLocationSeparator = ".";
        @CommandLine.Spec
        private CommandLine.Model.CommandSpec spec;
        @CommandLine.Option(names={"-a", "--add"}, description={"Adds a logger with the given name"})
        String logToAdd = null;
        @CommandLine.Option(names={"on", "-e", "--on", "--enable", "--yes"}, description={"Enables logging"})
        boolean enable = false;
        @CommandLine.Option(names={"off", "-d", "--off", "--disable", "--no"}, description={"Disables logging"})
        boolean disable = false;
        @CommandLine.Option(names={"-s", "--strict"}, description={"Enables or disables logging strictness"})
        String strict = null;
        @CommandLine.Option(names={"-E", "--echo"}, description={"Sets logger echo mode to on, simple, or off"})
        String echo = null;
        @CommandLine.Option(names={"-i", "--init"}, description={"Re-initializes log manager"})
        boolean init = false;
        @CommandLine.Option(names={"-c", "--collapse"}, description={"Specifies collapsed logging"})
        boolean collapse = false;
        @CommandLine.Option(names={"-l", "--level"}, description={"Sets the logging level to trace, debug, info, warn, or error"})
        String level = null;
        @CommandLine.Option(names={"-S", "--source"}, description={"Sets the logging source to disk, stack, or none"})
        String source = null;
        @CommandLine.Option(names={"-A", "--abbreviate"}, description={"Enables or disables logging abbreviation"})
        String abbreviate = null;
        @CommandLine.Parameters(description={"The logger to enable/disable or send a message to, the log level, and/or the message to log"})
        String[] params = null;

        public Log(Agent agent, SoarCommandInterpreter interpreter, SoarCommandContext context) {
            this.agent = agent;
            this.logManager = agent.getLogManager();
            this.interpreter = interpreter;
            this.context = context;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            List<String> parameters;
            String loggerName;
            LogManager.LogLevel logLevel;
            if (this.logToAdd != null) {
                try {
                    this.logManager.addLogger(this.logToAdd);
                }
                catch (LogManager.LoggerException e) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), e.getMessage(), (Throwable)e);
                }
                this.agent.getPrinter().startNewLine().print("Added logger: " + this.logToAdd);
                return;
            }
            if (this.enable) {
                if (this.params == null) {
                    if (this.logManager.isActive()) {
                        this.agent.getPrinter().startNewLine().print("Logging already enabled.");
                        return;
                    } else {
                        this.logManager.setActive(true);
                        this.agent.getPrinter().startNewLine().print("Logging enabled.");
                    }
                    return;
                }
                try {
                    this.logManager.enableLogger(this.params[0]);
                }
                catch (LogManager.LoggerException e) {
                    this.agent.getPrinter().startNewLine().print(e.getMessage());
                    return;
                }
                this.agent.getPrinter().startNewLine().print("Logger [" + this.params[0] + "] enabled.");
                return;
            }
            if (this.disable) {
                if (this.params == null) {
                    if (!this.logManager.isActive()) {
                        this.agent.getPrinter().startNewLine().print("Logging already disabled.");
                        return;
                    } else {
                        this.logManager.setActive(false);
                        this.agent.getPrinter().startNewLine().print("Logging disabled.");
                    }
                    return;
                }
                try {
                    this.logManager.disableLogger(this.params[0]);
                }
                catch (LogManager.LoggerException e) {
                    this.agent.getPrinter().startNewLine().print(e.getMessage());
                    return;
                }
                this.agent.getPrinter().startNewLine().print("Logger [" + this.params[0] + "] disabled.");
                return;
            }
            if (this.init) {
                this.logManager.init();
                this.agent.getPrinter().startNewLine().print("Log manager re-initialized.");
                return;
            }
            if (this.strict != null) {
                if (this.strict.toLowerCase().equalsIgnoreCase("yes") || this.strict.toLowerCase().equalsIgnoreCase("enable") || this.strict.toLowerCase().equalsIgnoreCase("on")) {
                    if (this.logManager.isStrict()) {
                        this.agent.getPrinter().startNewLine().print("Logger already in strict mode.");
                        return;
                    } else {
                        this.logManager.setStrict(true);
                        this.agent.getPrinter().startNewLine().print("Logger set to strict mode.");
                    }
                    return;
                } else {
                    if (!this.strict.toLowerCase().equalsIgnoreCase("no") && !this.strict.toLowerCase().equalsIgnoreCase("disable") && !this.strict.toLowerCase().equalsIgnoreCase("off")) throw new CommandLine.ParameterException(this.spec.commandLine(), "Expected one argument: on | off");
                    if (!this.logManager.isStrict()) {
                        this.agent.getPrinter().startNewLine().print("Logger already in non-strict mode.");
                        return;
                    } else {
                        this.logManager.setStrict(false);
                        this.agent.getPrinter().startNewLine().print("Logger set to non-strict mode.");
                    }
                }
                return;
            }
            if (this.abbreviate != null) {
                if (this.abbreviate.toLowerCase().equalsIgnoreCase("yes") || this.abbreviate.toLowerCase().equalsIgnoreCase("enable") || this.abbreviate.toLowerCase().equalsIgnoreCase("on")) {
                    this.logManager.setAbbreviate(true);
                    this.agent.getPrinter().startNewLine().print("Logger using abbreviated paths.");
                    return;
                } else {
                    if (!this.abbreviate.toLowerCase().equalsIgnoreCase("no") && !this.abbreviate.toLowerCase().equalsIgnoreCase("disable") && !this.abbreviate.toLowerCase().equalsIgnoreCase("off")) throw new CommandLine.ParameterException(this.spec.commandLine(), "Expected one argument: on | off");
                    this.logManager.setAbbreviate(false);
                    this.agent.getPrinter().startNewLine().print("Logger using full paths.");
                }
                return;
            }
            if (this.echo != null) {
                LogManager.EchoMode echoMode;
                try {
                    echoMode = LogManager.EchoMode.fromString(this.echo);
                }
                catch (IllegalArgumentException e) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "Expected one argument: on | simple | off", (Throwable)e);
                }
                this.logManager.setEchoMode(echoMode);
                this.agent.getPrinter().startNewLine().print("Logger echo mode set to: " + echoMode.toString());
                return;
            }
            if (this.source != null) {
                LogManager.SourceLocationMethod sourceLocationMethod = null;
                try {
                    sourceLocationMethod = LogManager.SourceLocationMethod.fromString(this.source);
                }
                catch (IllegalArgumentException e) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "Expected one argument: disk | stack | none", (Throwable)e);
                }
                this.logManager.setSourceLocationMethod(sourceLocationMethod);
                this.agent.getPrinter().startNewLine().print("Logger source location method set to: " + sourceLocationMethod.toString());
                return;
            }
            if (this.level != null) {
                LogManager.LogLevel logLevel2;
                try {
                    logLevel2 = LogManager.LogLevel.fromString(this.level);
                }
                catch (IllegalArgumentException e) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "Expected one argument: trace | debug | info | warn | error", (Throwable)e);
                }
                this.logManager.setLogLevel(logLevel2);
                this.agent.getPrinter().startNewLine().print("Logger level set to: " + logLevel2.toString());
                return;
            }
            if (this.params == null) {
                this.agent.getPrinter().startNewLine().print(this.logManager.getLoggerStatus());
                return;
            }
            if (this.params.length == 1) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Unknown command: " + this.params[0]);
            }
            try {
                logLevel = LogManager.LogLevel.fromString(this.params[0]);
                loggerName = this.getSourceLocation(this.context, this.logManager.getAbbreviate(), this.logManager.getSourceLocationMethod());
                if (loggerName != null && !this.logManager.hasLogger(loggerName)) {
                    try {
                        this.logManager.addLogger(loggerName);
                    }
                    catch (LogManager.LoggerException e) {
                        throw new CommandLine.ParameterException(this.spec.commandLine(), e.getMessage(), (Throwable)e);
                    }
                }
                if (loggerName == null) {
                    loggerName = "default";
                }
                parameters = Arrays.asList(Arrays.copyOfRange(this.params, 1, this.params.length));
            }
            catch (IllegalArgumentException e) {
                loggerName = this.params[0];
                try {
                    logLevel = LogManager.LogLevel.fromString(this.params[1]);
                }
                catch (IllegalArgumentException ee) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "Unknown log-level value: " + this.params[1], (Throwable)ee);
                }
                parameters = Arrays.asList(Arrays.copyOfRange(this.params, 2, this.params.length));
            }
            try {
                this.logManager.log(loggerName, logLevel, parameters, this.collapse);
                return;
            }
            catch (LogManager.LoggerException e) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), e.getMessage(), (Throwable)e);
            }
        }

        public String getSourceLocation(SoarCommandContext context, boolean abbreviate, LogManager.SourceLocationMethod sourceLocationMethod) {
            if (sourceLocationMethod.equals((Object)LogManager.SourceLocationMethod.stack)) {
                return this.getGoalStackLocation(abbreviate);
            }
            if (sourceLocationMethod.equals((Object)LogManager.SourceLocationMethod.disk)) {
                return this.getSourceFileLocation(context, abbreviate);
            }
            return null;
        }

        public String getGoalStackLocation(boolean abbreviate) {
            StringBuffer location = new StringBuffer();
            Iterator<Goal> it = this.agent.getGoalStack().iterator();
            if (it.hasNext()) {
                String thisGoal = Log.getOperatorNameFromGoal(it.next());
                if (!abbreviate || !it.hasNext()) {
                    location.append(thisGoal);
                } else {
                    location.append(thisGoal.charAt(0));
                }
                while (it.hasNext()) {
                    location.append(sourceLocationSeparator);
                    thisGoal = Log.getOperatorNameFromGoal(it.next());
                    if (!abbreviate || !it.hasNext()) {
                        location.append(thisGoal);
                        continue;
                    }
                    location.append(thisGoal.charAt(0));
                }
            }
            return location.toString();
        }

        public String getSourceFileLocation(SoarCommandContext context, boolean abbreviate) {
            String fileName;
            SourceLocation sourceLocation = context.getSourceLocation();
            if (sourceLocation != DefaultSourceLocation.UNKNOWN && (fileName = sourceLocation.getFile()) != null && !fileName.isEmpty()) {
                return Log.collapseFileName(fileName, this.interpreter.getWorkingDirectory(), abbreviate);
            }
            return null;
        }

        private static String getOperatorNameFromGoal(Goal g) {
            Symbol opName = g.getOperatorName();
            return opName == null ? "?" : opName.toString();
        }

        public static List<String> uberSplit(String file) throws IOException {
            ArrayList<String> result = new ArrayList<String>();
            File f = new File(file).getCanonicalFile();
            result.add(f.getName());
            for (f = f.getParentFile(); f != null; f = f.getParentFile()) {
                String n = f.getName();
                if (n.isEmpty()) continue;
                result.add(f.getName());
            }
            Collections.reverse(result);
            return result;
        }

        public static String collapseFileName(String file, String cwd, boolean abbreviate) {
            int marker;
            String[] fileParts;
            String[] cwdParts;
            try {
                cwdParts = Log.uberSplit(cwd).toArray(new String[0]);
                fileParts = Log.uberSplit(file).toArray(new String[0]);
            }
            catch (IOException e) {
                return null;
            }
            int minLength = Math.min(cwdParts.length, fileParts.length);
            for (marker = 0; marker < minLength && cwdParts[marker].equals(fileParts[marker]); ++marker) {
            }
            String result = "";
            int diff = cwdParts.length - marker;
            if (diff > 0) {
                result = result + "^" + diff + sourceLocationSeparator;
            }
            for (int i = marker; i < fileParts.length - 1; ++i) {
                result = abbreviate ? result + fileParts[i].charAt(0) : result + fileParts[i];
                result = result + sourceLocationSeparator;
            }
            result = result + fileParts[fileParts.length - 1];
            return result;
        }
    }
}

