/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.SourceCommand;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class PopdCommand
implements SoarCommand {
    private final SourceCommand sourceCommand;
    private Agent agent;

    public PopdCommand(SourceCommand sourceCommand, Agent agent) {
        this.sourceCommand = sourceCommand;
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Popd(this.sourceCommand, this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Popd(this.sourceCommand, this.agent);
    }

    @CommandLine.Command(name="popd", description={"Pops the top working directory off the stack and sets the current working directory to it"}, subcommands={CommandLine.HelpCommand.class})
    public static class Popd
    implements Runnable {
        private final SourceCommand sourceCommand;
        private Agent agent;

        public Popd(SourceCommand sourceCommand, Agent agent) {
            this.sourceCommand = sourceCommand;
            this.agent = agent;
        }

        @Override
        public void run() {
            try {
                this.sourceCommand.popd();
            }
            catch (SoarException e) {
                this.agent.getPrinter().print(e.getMessage());
            }
        }
    }
}

