/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.ProductionFinder;
import org.jsoar.kernel.ProductionManager;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.learning.rl.ReinforcementLearning;
import org.jsoar.kernel.parser.ParserException;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.util.StringTools;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class ProductionCommand
implements SoarCommand {
    private Agent agent;

    public ProductionCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        String result = Utils.parseAndRun(new ProductionC(this.agent), args);
        return result;
    }

    @Override
    public Object getCommand() {
        return new ProductionC(this.agent);
    }

    @CommandLine.Command(name="watch", description={"Alters the set of watched productions"}, subcommands={CommandLine.HelpCommand.class})
    public static class Watch
    implements Runnable {
        @CommandLine.ParentCommand
        ProductionC parent;
        @CommandLine.Option(names={"on", "-e", "--on", "--enable"}, description={"Enables watching of given productions"})
        List<String> productionsToEnable = null;
        @CommandLine.Option(names={"off", "-d", "--off", "--disable"}, description={"Disables watching of given productions"})
        List<String> productionsToDisable = null;

        @Override
        public void run() {
            Production p;
            if (this.productionsToEnable == null && this.productionsToDisable == null) {
                List<String> tracedRuleNames = this.collectAndSortTracedRuleNames();
                if (tracedRuleNames.size() == 0) {
                    this.parent.agent.getPrinter().startNewLine().print("No watched productions found.");
                } else {
                    this.parent.agent.getPrinter().print(Joiner.on((char)'\n').join(this.collectAndSortTracedRuleNames()));
                }
            }
            if (this.productionsToEnable != null) {
                for (String name : this.productionsToEnable) {
                    p = this.parent.agent.getProductions().getProduction(name);
                    if (p != null) {
                        p.setTraceFirings(true);
                        continue;
                    }
                    this.parent.agent.getPrinter().startNewLine().print("No production named '" + name + "'");
                }
            }
            if (this.productionsToDisable != null) {
                for (String name : this.productionsToDisable) {
                    p = this.parent.agent.getProductions().getProduction(name);
                    if (p != null) {
                        p.setTraceFirings(false);
                        continue;
                    }
                    this.parent.agent.getPrinter().startNewLine().print("No production named '" + name + "'");
                }
            }
        }

        private List<String> collectAndSortTracedRuleNames() {
            ArrayList<String> result = new ArrayList<String>();
            for (Production p : this.parent.agent.getProductions().getProductions(null)) {
                if (!p.isTraceFirings()) continue;
                result.add(p.getName());
            }
            Collections.sort(result);
            return result;
        }
    }

    @CommandLine.Command(name="optimize-attribute", description={"Declare a symbol to be multi-attributed so the rule can be matched more efficiently"}, subcommands={CommandLine.HelpCommand.class})
    public static class OptimizeAttribute
    implements Runnable {
        @CommandLine.ParentCommand
        ProductionC parent;
        @CommandLine.Parameters(index="0", description={"Any Soar attribute"})
        private String attribute = null;
        @CommandLine.Parameters(index="1", description={"Estimate of degree of simultaneous values for attribute"})
        private Integer degree = null;

        @Override
        public void run() {
            StringSymbol attr = this.parent.agent.getSymbols().createString(this.attribute);
            int cost = this.degree;
            this.parent.agent.getMultiAttributes().setCost(attr, cost);
        }
    }

    @CommandLine.Command(name="memory-usage", description={"Print memory usage for partial matches"}, subcommands={CommandLine.HelpCommand.class})
    public static class MemoryUsage
    implements Runnable {
        @CommandLine.ParentCommand
        ProductionC parent;
        @CommandLine.Option(names={"-c", "--chunks"}, description={"Print memory usage of chunks"})
        boolean filterByChunks = false;
        @CommandLine.Option(names={"-d", "--default"}, description={"Print memory usage of default productions"})
        boolean filterByDefault = false;
        @CommandLine.Option(names={"-j", "--justifications"}, description={"Print memory usage of justifications"})
        boolean filterByJustify = false;
        @CommandLine.Option(names={"-T", "--templates"}, description={"Print how many times Soar-RL templates fired"})
        boolean filterByTemplates = false;
        @CommandLine.Option(names={"-u", "--user"}, description={"Print memory usage of user-defined productions"})
        boolean filterByUser = false;
        @CommandLine.Parameters(index="0", arity="0..1", description={"If an integer, list the top n productions according to memory usage. If not an integer, print memory usage for a specific production."})
        private String param = null;

        @Override
        public void run() {
            Integer topN = null;
            String prodName = null;
            Production single = null;
            int count = Integer.MAX_VALUE;
            EnumSet<ProductionType> types = EnumSet.noneOf(ProductionType.class);
            if (this.param != null) {
                try {
                    topN = Integer.valueOf(this.param);
                }
                catch (NumberFormatException e) {
                    prodName = this.param;
                }
            }
            if (topN != null) {
                count = topN;
                if (count < 1) {
                    this.parent.agent.getPrinter().startNewLine().print("Count argument must be greater than 0, got " + count);
                    return;
                }
            } else if (prodName != null) {
                single = this.parent.agent.getProductions().getProduction(prodName);
                if (single == null) {
                    this.parent.agent.getPrinter().startNewLine().print("No production named '" + prodName + "'");
                    return;
                }
            } else if (this.filterByDefault) {
                types.add(ProductionType.DEFAULT);
            } else if (this.filterByChunks) {
                types.add(ProductionType.CHUNK);
            } else if (this.filterByUser) {
                types.add(ProductionType.USER);
            } else if (this.filterByJustify) {
                types.add(ProductionType.JUSTIFICATION);
            } else if (this.filterByTemplates) {
                types.add(ProductionType.TEMPLATE);
            }
            if (single != null) {
                this.printResults(Arrays.asList(single), 1);
            } else {
                if (types.isEmpty()) {
                    types.addAll(EnumSet.allOf(ProductionType.class));
                }
                this.printTopProductions(types, count);
            }
        }

        private void printResults(List<Production> productions, int n) {
            Printer printer = this.parent.agent.getPrinter();
            for (int i = 0; i < n && i < productions.size(); ++i) {
                Production p = productions.get(i);
                printer.startNewLine().print("%5d:  %s", p.getReteTokenCount(), p.getName());
            }
        }

        private void printTopProductions(EnumSet<ProductionType> types, int n) {
            ArrayList<Production> prods = new ArrayList<Production>();
            for (ProductionType type : types) {
                prods.addAll(this.parent.agent.getProductions().getProductions(type));
            }
            Collections.sort(prods, new Comparator<Production>(){

                @Override
                public int compare(Production o1, Production o2) {
                    return o2.getReteTokenCount() - o1.getReteTokenCount();
                }
            });
            this.printResults(prods, n);
        }
    }

    @CommandLine.Command(name="matches", description={"Print the list of productions that will retract or fire in the next propose or apply phase"}, subcommands={CommandLine.HelpCommand.class})
    public static class Matches
    implements Runnable {
        @CommandLine.ParentCommand
        ProductionC parent;
        @CommandLine.Option(names={"-c", "--counts"}, description={"Same as default implementation"})
        boolean includeCounts = false;
        @CommandLine.Option(names={"-n", "--names"}, description={"Same as default implementation"})
        boolean includeNames = false;
        @CommandLine.Option(names={"-t", "--timetags"}, description={"Also print the timetags of the wmes at the first failing condition"})
        boolean includeTimetags = false;
        @CommandLine.Option(names={"-w", "--wmes"}, description={"Also print the full wmes, not just the timetags, at the first failing condition"})
        boolean includeWmes = false;
        @CommandLine.Option(names={"-a", "--assertions"}, description={"List only productions about to fire"})
        boolean onlyAssertions = false;
        @CommandLine.Option(names={"-r", "--retractions"}, description={"List only productions about to retract"})
        boolean onlyRetractions = false;
        @CommandLine.Option(names={"-i", "--internal"}, description={"Also print some internal information when a production name is provided"})
        boolean includeInternalInfo = false;
        @CommandLine.Parameters(index="0", arity="0..1", description={"Print partial match information for the named production"})
        private String prodName = null;

        @Override
        public void run() {
            Trace.WmeTraceType wmeTraceType = Trace.WmeTraceType.NONE;
            EnumSet<Trace.MatchSetTraceType> mstt = EnumSet.allOf(Trace.MatchSetTraceType.class);
            if (this.includeWmes) {
                wmeTraceType = Trace.WmeTraceType.FULL;
            } else if (this.includeTimetags) {
                wmeTraceType = Trace.WmeTraceType.TIMETAG;
            }
            if (this.onlyAssertions) {
                mstt.clear();
                mstt.add(Trace.MatchSetTraceType.MS_ASSERT);
            } else if (this.onlyRetractions) {
                mstt.clear();
                mstt.add(Trace.MatchSetTraceType.MS_RETRACT);
            }
            if (this.prodName != null) {
                Production p = this.parent.agent.getProductions().getProduction(this.prodName);
                if (p == null) {
                    this.parent.agent.getPrinter().startNewLine().print("No production '" + this.prodName + "'");
                } else if (p.getReteNode() == null) {
                    this.parent.agent.getPrinter().startNewLine().print("Production '" + this.prodName + "' is not in rete");
                } else {
                    p.printPartialMatches(this.parent.agent.getPrinter(), wmeTraceType, this.includeInternalInfo);
                }
            } else {
                this.parent.agent.printMatchSet(this.parent.agent.getPrinter(), wmeTraceType, mstt);
                this.parent.agent.getPrinter().flush();
            }
        }
    }

    @CommandLine.Command(name="firing-counts", description={"Print the number of times productions have fired"}, subcommands={CommandLine.HelpCommand.class})
    public static class FiringCounts
    implements Runnable {
        @CommandLine.ParentCommand
        ProductionC parent;
        @CommandLine.Option(names={"-a", "--all"}, description={"Print how many times all productions fired"})
        boolean countAll = false;
        @CommandLine.Option(names={"-c", "--chunks"}, description={"Print how many times chunks (learned rules) fired"})
        boolean countChunks = false;
        @CommandLine.Option(names={"-d", "--default"}, description={"Print how many times default productions fired"})
        boolean countDefault = false;
        @CommandLine.Option(names={"-f", "--fired"}, description={"Prints only rules that have fired"})
        boolean countFired = false;
        @CommandLine.Option(names={"-r", "--rl"}, description={"Print how many times Soar-RL rules fired"})
        boolean countRL = false;
        @CommandLine.Option(names={"-T", "--templates"}, description={"Print how many times Soar-RL templates fired"})
        boolean countTemplates = false;
        @CommandLine.Option(names={"-u", "--user"}, description={"Print how many times user productions fired"})
        boolean countUser = false;
        @CommandLine.Parameters(index="0", arity="0..1", description={"If an integer, list the top n productions; if n is 0, only the productions which haven't fired are listed. If not an integer, print how many times a specific production has fired."})
        private String param = null;

        @Override
        public void run() {
            Integer topN = null;
            String prodName = null;
            if (this.param != null) {
                try {
                    topN = Integer.valueOf(this.param);
                }
                catch (NumberFormatException e) {
                    prodName = this.param;
                }
            }
            if (topN != null) {
                if (topN == 0) {
                    ArrayList<Production> productionsNotFired = new ArrayList<Production>();
                    for (Production p : this.parent.agent.getProductions().getProductions(null)) {
                        if (p.getFiringCount() != 0L) continue;
                        productionsNotFired.add(p);
                    }
                    this.printResults(productionsNotFired, Integer.MAX_VALUE);
                } else {
                    this.printTopProductions(topN);
                }
            } else if (prodName != null) {
                this.printSingleProduction(prodName);
            } else {
                if (this.countChunks || this.countDefault || this.countFired || this.countRL || this.countTemplates || this.countUser) {
                    this.parent.agent.getPrinter().startNewLine().print("Option(s) not implemented yet. Displaying all firing counts:");
                }
                this.printTopProductions(Integer.MAX_VALUE);
            }
        }

        private void printResults(List<Production> productions, int n) {
            Printer printer = this.parent.agent.getPrinter();
            for (int i = 0; i < n && i < productions.size(); ++i) {
                Production p = productions.get(i);
                printer.startNewLine().print("%5d:  %s", p.getFiringCount(), p.getName());
            }
        }

        private void printSingleProduction(String name) {
            Production p = this.parent.agent.getProductions().getProduction(name);
            if (p == null) {
                this.parent.agent.getPrinter().startNewLine().print("No production named '" + name + "'");
            } else {
                this.printResults(Arrays.asList(p), 1);
            }
        }

        private void printTopProductions(int n) {
            List<Production> prods = this.parent.agent.getProductions().getProductions(null);
            Collections.sort(prods, new Comparator<Production>(){

                @Override
                public int compare(Production o1, Production o2) {
                    long d = o2.getFiringCount() - o1.getFiringCount();
                    if (d < 0L) {
                        return -1;
                    }
                    if (d > 0L) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.printResults(prods, n);
        }
    }

    @CommandLine.Command(name="find", description={"Find productions by condition or action patterns"}, subcommands={CommandLine.HelpCommand.class})
    public static class Find
    implements Runnable {
        @CommandLine.ParentCommand
        ProductionC parent;
        @CommandLine.Option(names={"-l", "--lhs"}, description={"Match pattern only against the conditions of productions (default)"})
        boolean matchLHS = false;
        @CommandLine.Option(names={"-r", "--rhs"}, description={"Match pattern against the actions of productions"})
        boolean matchRHS = false;
        @CommandLine.Option(names={"-c", "--chunks"}, description={"Look only for chunks that match the pattern"})
        boolean matchChunks = false;
        @CommandLine.Option(names={"-n", "--nochunks"}, description={"Disregard chunks when looking for the pattern"})
        boolean matchNoChunks = false;
        @CommandLine.Option(names={"-s", "--show-bindings"}, description={"Show the bindings associated with a wildcard pattern"})
        boolean showBindings = false;
        @CommandLine.Parameters(arity="1", description={"Any pattern that can appear in productions"})
        String[] arrPattern = null;

        @Override
        public void run() {
            ProductionFinder finder = new ProductionFinder(this.parent.agent);
            finder.options().clear();
            if (this.matchRHS) {
                finder.options().add(ProductionFinder.Options.RHS);
            } else {
                finder.options().add(ProductionFinder.Options.LHS);
            }
            if (this.showBindings) {
                this.parent.agent.getPrinter().startNewLine().print("Option not yet supported");
                return;
            }
            String pattern = StringTools.join(Arrays.asList(this.arrPattern), " ");
            Collection<Production> productions = this.collectProductions(this.matchChunks, this.matchNoChunks);
            try {
                List<Production> result = finder.find(pattern, productions);
                this.printResults(pattern, result);
            }
            catch (ParserException e) {
                this.parent.agent.getPrinter().startNewLine().print(e.getMessage());
            }
        }

        private void printResults(String pattern, List<Production> result) {
            Printer printer = this.parent.agent.getPrinter();
            printer.startNewLine();
            if (result.isEmpty()) {
                printer.print("No productions match '%s'\n", pattern);
            } else {
                for (Production p : result) {
                    printer.print("%s\n", p.getName());
                }
            }
        }

        private Collection<Production> collectProductions(final boolean chunks, final boolean nochunks) {
            Predicate<Production> filter = new Predicate<Production>(){

                public boolean apply(Production p) {
                    ProductionType type = p.getType();
                    return type == ProductionType.CHUNK && chunks || type != ProductionType.CHUNK && nochunks || !chunks && !nochunks;
                }
            };
            Collection productions = Collections2.filter(this.parent.agent.getProductions().getProductions(null), (Predicate)filter);
            return productions;
        }
    }

    @CommandLine.Command(name="excise", description={"Excises specified productions"}, subcommands={CommandLine.HelpCommand.class})
    public static class Excise
    implements Runnable {
        @CommandLine.ParentCommand
        ProductionC parent;
        @CommandLine.Option(names={"-a", "--all"}, description={"Remove all productions from memory and perform an init-soar command"})
        boolean exciseAll = false;
        @CommandLine.Option(names={"-c", "--chunks"}, description={"Remove all chunks (learned productions) from memory"})
        boolean exciseChunks = false;
        @CommandLine.Option(names={"-d", "--default"}, description={"Remove all default productions from memory"})
        boolean exciseDefault = false;
        @CommandLine.Option(names={"-n", "--never-fired"}, description={"Excise rules that have a firing count of 0"})
        boolean exciseNeverFired = false;
        @CommandLine.Option(names={"-r", "--rl"}, description={"Excise Soar-RL rules"})
        boolean exciseRL = false;
        @CommandLine.Option(names={"-t", "--task"}, description={"Remove chunks, justifications, and user productions from memory"})
        boolean exciseTasks = false;
        @CommandLine.Option(names={"-T", "--templates"}, description={"Excise Soar-RL templates"})
        boolean exciseTemplates = false;
        @CommandLine.Option(names={"-u", "--user"}, description={"Remove all user productions (but not chunks or default rules) from memory"})
        boolean exciseUser = false;
        @CommandLine.Parameters(index="0", arity="0..1", description={"Remove the specific production with this name"})
        private String prodName = null;

        @Override
        public void run() {
            ProductionManager pm = this.parent.agent.getProductions();
            if (this.prodName != null) {
                Production p = pm.getProduction(this.prodName);
                if (p == null) {
                    this.parent.agent.getPrinter().startNewLine().print("No production named '" + this.prodName + "'");
                } else {
                    pm.exciseProduction(p, false);
                    this.parent.agent.getPrinter().startNewLine().print("1 production excised");
                }
            } else {
                LinkedHashSet<Production> toExcise = new LinkedHashSet<Production>();
                boolean doInit = false;
                if (this.exciseAll) {
                    toExcise.addAll(pm.getProductions(null));
                    doInit = true;
                }
                if (this.exciseChunks) {
                    toExcise.addAll(pm.getProductions(ProductionType.CHUNK));
                }
                if (this.exciseDefault) {
                    toExcise.addAll(pm.getProductions(ProductionType.DEFAULT));
                }
                if (this.exciseNeverFired) {
                    for (Production production : pm.getProductions(null)) {
                        if (production.getFiringCount() != 0L) continue;
                        toExcise.add(production);
                    }
                }
                if (this.exciseRL) {
                    LinkedHashSet<Production> maybeExcise = new LinkedHashSet<Production>();
                    maybeExcise.addAll(pm.getProductions(ProductionType.DEFAULT));
                    maybeExcise.addAll(pm.getProductions(ProductionType.USER));
                    maybeExcise.addAll(pm.getProductions(ProductionType.CHUNK));
                    for (Production p : toExcise) {
                        if (p.rlRuleInfo == null) continue;
                        toExcise.add(p);
                    }
                }
                if (this.exciseTasks) {
                    toExcise.addAll(pm.getProductions(ProductionType.CHUNK));
                    toExcise.addAll(pm.getProductions(ProductionType.JUSTIFICATION));
                    toExcise.addAll(pm.getProductions(ProductionType.USER));
                }
                if (this.exciseTemplates) {
                    toExcise.addAll(pm.getProductions(ProductionType.TEMPLATE));
                }
                if (this.exciseUser) {
                    toExcise.addAll(pm.getProductions(ProductionType.USER));
                }
                for (Production production : toExcise) {
                    pm.exciseProduction(production, false);
                }
                if (this.exciseRL) {
                    Adaptables.adapt(this.parent.agent, ReinforcementLearning.class).rl_initialize_template_tracking();
                }
                if (doInit) {
                    this.parent.agent.initialize();
                }
                this.parent.agent.getPrinter().startNewLine().print(String.format("\n%d production%s excised.", toExcise.size(), toExcise.size() == 1 ? "" : "s"));
            }
        }
    }

    @CommandLine.Command(name="break", description={"Stops the Soar decision cycle when the given rule fires"}, subcommands={CommandLine.HelpCommand.class})
    public static class Break
    implements Runnable {
        @CommandLine.ParentCommand
        ProductionC parent;
        @CommandLine.Option(names={"-c", "--clear"}, description={"Clear :interrupt flag from a production"})
        String prodToClear = null;
        @CommandLine.Option(names={"-p", "--print"}, description={"Print which production rules have had their :interrupt flags set"})
        boolean printBreaks = false;
        @CommandLine.Option(names={"-s", "--set"}, description={"Set interrupt flag on a production rule"})
        String prodToBreak = null;
        @CommandLine.Parameters(index="0", arity="0..1", description={"Production rule on which to set :interrupt flag"})
        private String prodName = null;

        @Override
        public void run() {
            String name = null;
            boolean flag = false;
            if (this.prodToClear != null) {
                name = this.prodToClear;
            } else if (this.prodToBreak != null) {
                name = this.prodToBreak;
                flag = true;
            } else if (this.prodName != null) {
                name = this.prodName;
                flag = true;
            }
            if (name != null) {
                Production p = this.parent.agent.getProductions().getProduction(name);
                if (p != null) {
                    p.setBreakpointEnabled(flag);
                } else {
                    this.parent.agent.getPrinter().startNewLine().print("No production named '" + name + "'");
                }
            } else {
                this.parent.agent.getPrinter().print(Joiner.on((char)'\n').join(this.collectAndSortRuleNames()));
            }
        }

        private List<String> collectAndSortRuleNames() {
            ProductionManager pm = this.parent.agent.getProductions();
            ArrayList<String> result = new ArrayList<String>();
            for (Production p : pm.getProductions(null)) {
                if (!p.isBreakpointEnabled()) continue;
                result.add(p.getName());
            }
            Collections.sort(result);
            return result;
        }
    }

    @CommandLine.Command(name="production", description={"Commands related to altering and printing production info"}, subcommands={CommandLine.HelpCommand.class, Break.class, Excise.class, Find.class, FiringCounts.class, Matches.class, MemoryUsage.class, OptimizeAttribute.class, Watch.class})
    public static class ProductionC
    implements Runnable {
        private Agent agent;

        public ProductionC(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            this.agent.getPrinter().startNewLine().print("=======================================================\n-                     Productions                     -\n=======================================================\n");
        }
    }
}

