/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyManager;
import picocli.CommandLine;

public class PropertiesCommand
implements SoarCommand {
    private final Agent agent;

    public PropertiesCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Properties(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Properties(this.agent);
    }

    @CommandLine.Command(name="properties", description={"Displays the agent's current properties"}, subcommands={CommandLine.HelpCommand.class})
    public static class Properties
    implements Runnable {
        private Agent agent;

        public Properties(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            Printer p = this.agent.getPrinter();
            p.startNewLine();
            PropertyManager properties = this.agent.getProperties();
            List<PropertyKey<?>> keys = properties.getKeys();
            Collections.sort(keys, new Comparator<PropertyKey<?>>(){

                @Override
                public int compare(PropertyKey<?> a, PropertyKey<?> b) {
                    return a.getName().compareTo(b.getName());
                }
            });
            for (PropertyKey<?> key : keys) {
                p.print("%30s = %s%s\n", key.getName(), properties.get(key), key.isReadonly() ? " [RO]" : "");
            }
        }
    }
}

