/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.io.quick.DefaultQMemory;
import org.jsoar.kernel.io.quick.QMemory;
import org.jsoar.kernel.io.quick.SoarQMemoryAdapter;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class QMemoryCommand
implements SoarCommand {
    private final Agent agent;
    private final SoarQMemoryAdapter adapter;

    public QMemoryCommand(Agent agent) {
        this.agent = agent;
        this.adapter = SoarQMemoryAdapter.attach(agent, DefaultQMemory.create());
    }

    @Override
    public Object getCommand() {
        return new QMemoryC(this.agent, this.adapter);
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new QMemoryC(this.agent, this.adapter), args);
        return "";
    }

    @CommandLine.Command(name="qmemory", description={"Stores and retrieves items from qmemory"}, subcommands={CommandLine.HelpCommand.class})
    public static class QMemoryC
    implements Runnable {
        private Agent agent;
        private final SoarQMemoryAdapter adapter;
        @CommandLine.Option(names={"-g", "--get"}, description={"Item to retreive from qmemory"})
        String getPath = null;
        @CommandLine.Option(names={"-s", "--set"}, description={"Item to set in qmemory"})
        String setPath = null;
        @CommandLine.Parameters(arity="0..1", description={"New value of item"})
        String value = null;
        @CommandLine.Option(names={"-r", "--remove"}, description={"Item to remove from qmemory"})
        String removePath = null;
        @CommandLine.Option(names={"-c", "--clear"}, description={"Clears everything from qmemory"})
        boolean clear = false;

        public QMemoryC(Agent agent, SoarQMemoryAdapter adapter) {
            this.agent = agent;
            this.adapter = adapter;
        }

        @Override
        public void run() {
            if (this.getPath != null) {
                String returnVal = this.adapter.getSource().getString(this.fixPath(this.getPath));
                this.agent.getPrinter().startNewLine().print(returnVal);
            } else if (this.setPath != null) {
                if (this.value != null) {
                    block17: {
                        QMemory qmemory = this.adapter.getSource();
                        String path = this.fixPath(this.setPath);
                        try {
                            qmemory.setInteger(path, Integer.parseInt(this.value));
                        }
                        catch (NumberFormatException e) {
                            try {
                                qmemory.setDouble(path, Double.parseDouble(this.value));
                            }
                            catch (NumberFormatException e1) {
                                if (this.value.length() >= 2 && this.value.charAt(0) == '|' && this.value.charAt(this.value.length() - 1) == '|') {
                                    qmemory.setString(path, this.value.substring(1, this.value.length() - 1));
                                    break block17;
                                }
                                qmemory.setString(path, this.value);
                            }
                        }
                    }
                    this.agent.getPrinter().startNewLine().print(this.value);
                } else {
                    this.agent.getPrinter().startNewLine().print("Error: new value not provided");
                }
            } else if (this.removePath != null) {
                this.adapter.getSource().remove(this.fixPath(this.removePath));
            } else if (this.clear) {
                this.adapter.setSource(DefaultQMemory.create());
            } else if (this.value != null) {
                String returnVal = this.adapter.getSource().getString(this.fixPath(this.value));
                this.agent.getPrinter().startNewLine().print(returnVal);
            } else {
                this.agent.getPrinter().startNewLine().print("Error: expected one of --get, --set, --remove, or --clear");
            }
        }

        private String fixPath(String path) {
            return path.replace('(', '[').replace(')', ']');
        }
    }
}

