/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.AgentRunController;
import org.jsoar.kernel.RunType;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class RunCommand
implements SoarCommand {
    private final AgentRunController controller;

    public RunCommand(AgentRunController controller) {
        this.controller = controller;
    }

    @Override
    public Object getCommand() {
        return new Run(this.controller);
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        String result = Utils.parseAndRun(new Run(this.controller), args);
        return result;
    }

    @CommandLine.Command(name="run", description={"Begin Soar's execution cycle"}, subcommands={CommandLine.HelpCommand.class})
    public static class Run
    implements Runnable {
        private final AgentRunController controller;
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;
        @CommandLine.Option(names={"-d", "--decision"}, description={"Run Soar for <count> decision cycles"})
        boolean runDecision = false;
        @CommandLine.Option(names={"-e", "--elaboration"}, description={"Run Soar for <count> elaboration cycles"})
        boolean runElaboration = false;
        @CommandLine.Option(names={"-p", "--phase"}, description={"Run Soar for <count> phases"})
        boolean runPhase = false;
        @CommandLine.Option(names={"-f", "--forever"}, description={"Run forever"})
        boolean runForever = false;
        @CommandLine.Option(names={"-o", "--output"}, description={"Run Soar until the <count>th time output is generated by the agent"})
        boolean runOutput = false;
        @CommandLine.Parameters(arity="0..1", description={"A single integer which specifies the number of cycles to run Soar"})
        Integer count = null;

        public Run(AgentRunController controller) {
            this.controller = controller;
        }

        @Override
        public void run() {
            this.validateArgs();
            RunType type = null;
            type = this.runDecision ? RunType.DECISIONS : (this.runElaboration ? RunType.ELABORATIONS : (this.runPhase ? RunType.PHASES : (this.runForever ? RunType.FOREVER : (this.runOutput ? RunType.MODIFICATIONS_OF_OUTPUT : RunType.FOREVER))));
            if (this.count == null) {
                this.count = 1;
            }
            this.controller.runFor(this.count.intValue(), type);
        }

        void validateArgs() {
            if ((this.runDecision || this.runElaboration || this.runPhase || this.runForever || this.runOutput) && !(this.runDecision ^ this.runElaboration ^ this.runPhase ^ this.runForever ^ this.runOutput)) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Multiple run types specified");
            }
            if (this.count != null && this.count <= 0) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Expected count larger than 0 for run command, got " + this.count);
            }
        }
    }
}

