/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class SaveBacktracesCommand
implements SoarCommand {
    private final Agent agent;

    public SaveBacktracesCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new SaveBacktraces(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new SaveBacktraces(this.agent);
    }

    @CommandLine.Command(name="save-backtraces", description={"Toggles or prints backtrace saving"}, subcommands={CommandLine.HelpCommand.class})
    public static class SaveBacktraces
    implements Runnable {
        private Agent agent;
        @CommandLine.Option(names={"on", "-e", "--on", "--enable"}, description={"Enables backtrace saving"})
        boolean enable = false;
        @CommandLine.Option(names={"off", "-d", "--off", "--disable"}, description={"Disables backtrace saving"})
        boolean disable = false;

        public SaveBacktraces(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            if (!this.enable && !this.disable) {
                this.agent.getPrinter().startNewLine().print("The current save-backtraces setting is: " + (this.agent.getProperties().get(SoarProperties.EXPLAIN) != false ? "enabled" : "disabled"));
            } else if (this.enable) {
                this.agent.getProperties().set(SoarProperties.EXPLAIN, true);
            } else {
                this.agent.getProperties().set(SoarProperties.EXPLAIN, false);
            }
        }
    }
}

