/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.lang.reflect.InvocationTargetException;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.parser.Parser;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import picocli.CommandLine;

public class SetParserCommand
implements SoarCommand {
    private final Agent agent;

    public SetParserCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new SetParser(this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new SetParser(this.agent);
    }

    @CommandLine.Command(name="set-parser", description={"Sets the current parser"}, subcommands={CommandLine.HelpCommand.class})
    public static class SetParser
    implements Runnable {
        private Agent agent;
        @CommandLine.Parameters(description={"The new parser"})
        String parser = null;

        public SetParser(Agent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            if (this.parser == null) {
                this.agent.getPrinter().startNewLine().print("No parser provided");
                return;
            }
            try {
                Class<?> klass = Class.forName(this.parser);
                Parser parser = (Parser)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.agent.getProductions().setParser(parser);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.agent.getPrinter().startNewLine().print(e.getClass() + " error: " + e.getMessage());
            }
        }
    }
}

