/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Stack;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.SourceCommandAdapter;
import org.jsoar.kernel.events.ProductionAddedEvent;
import org.jsoar.kernel.events.ProductionExcisedEvent;
import org.jsoar.util.FileTools;
import org.jsoar.util.StringTools;
import org.jsoar.util.UrlTools;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;
import org.jsoar.util.events.SoarEventManager;

public class SourceCommand
implements SoarCommand {
    private final SourceCommandAdapter interp;
    private DirStackEntry workingDirectory = new DirStackEntry(new File(System.getProperty("user.dir")));
    private Stack<DirStackEntry> directoryStack = new Stack();
    private Stack<String> fileStack = new Stack();
    private List<String> sourcedFiles = new ArrayList<String>();
    TopLevelState topLevelState;
    final SoarEventManager events;
    final SoarEventListener eventListener = new SoarEventListener(){

        @Override
        public void onEvent(SoarEvent event) {
            if (event instanceof ProductionAddedEvent) {
                SourceCommand.this.topLevelState.productionAdded(((ProductionAddedEvent)event).getProduction());
            } else if (event instanceof ProductionExcisedEvent) {
                SourceCommand.this.topLevelState.productionExcised(((ProductionExcisedEvent)event).getProduction());
            }
        }
    };
    String[] lastTopLevelCommand = null;

    public SourceCommand(SourceCommandAdapter interp, SoarEventManager events) {
        this.interp = interp;
        this.events = events;
        this.fileStack.push("");
    }

    @Override
    public Object getCommand() {
        return null;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory.url != null ? this.workingDirectory.url.toExternalForm() : this.workingDirectory.file.getAbsolutePath();
    }

    DirStackEntry getWorkingDirectoryRaw() {
        return this.workingDirectory;
    }

    public String getCurrentFile() {
        return this.fileStack.peek();
    }

    public List<String> getSourcedFiles() {
        return this.sourcedFiles;
    }

    public void pushd(String dirString) throws SoarException {
        File newDir = new File(dirString);
        URL url = FileTools.asUrl(dirString);
        if (url != null || UrlTools.isClassPath(dirString)) {
            if (UrlTools.isClassPath(dirString)) {
                try {
                    url = UrlTools.lookupClassPathURL(dirString);
                }
                catch (IOException e) {
                    throw new SoarException(e);
                }
            }
            this.directoryStack.push(this.workingDirectory);
            this.workingDirectory = new DirStackEntry(url);
        } else if (this.workingDirectory.url != null && !newDir.isAbsolute()) {
            this.directoryStack.push(this.workingDirectory);
            this.workingDirectory = new DirStackEntry(this.joinUrl(this.workingDirectory.url, dirString));
        } else {
            if (!newDir.isAbsolute()) {
                assert (this.workingDirectory.url == null);
                newDir = new File(this.workingDirectory.file, dirString);
            }
            if (!newDir.exists()) {
                throw new SoarException("Directory '" + newDir + "' does not exist");
            }
            if (!newDir.isDirectory()) {
                throw new SoarException("'" + newDir + "' is not a directory");
            }
            this.directoryStack.push(this.workingDirectory);
            this.workingDirectory = new DirStackEntry(newDir);
        }
    }

    public void popd() throws SoarException {
        if (this.directoryStack.isEmpty()) {
            throw new SoarException("Directory stack is empty");
        }
        this.workingDirectory = this.directoryStack.pop();
    }

    public void source(String fileString) throws SoarException {
        URL url = FileTools.asUrl(fileString);
        File file = new File(fileString);
        if (url != null) {
            this.pushd(this.getParentUrl(url).toExternalForm());
            this.evalUrlAndPop(url);
        } else if (UrlTools.isClassPath(fileString)) {
            try {
                url = UrlTools.lookupClassPathURL(fileString);
            }
            catch (IOException e) {
                throw new SoarException(e);
            }
            this.pushd(this.getParentUrl(url).toExternalForm());
            this.evalUrlAndPop(url);
        } else if (file.isAbsolute()) {
            this.pushd(file.getParent());
            this.evalFileAndPop(file);
        } else if (this.workingDirectory.url != null) {
            URL childUrl = this.joinUrl(this.workingDirectory.url, fileString);
            this.pushd(this.getParentUrl(childUrl).toExternalForm());
            this.evalUrlAndPop(childUrl);
        } else {
            file = new File(this.workingDirectory.file, file.getPath());
            this.pushd(file.getParent());
            this.evalFileAndPop(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(SoarCommandContext commandContext, String[] args) throws SoarException {
        boolean reload;
        if (args.length < 2) {
            throw new SoarException("Expected fileName argument");
        }
        boolean topLevel = this.topLevelState == null;
        boolean bl = reload = "-r".equals(args[1]) || "--reload".equals(args[1]);
        if (topLevel && reload && this.lastTopLevelCommand != null) {
            return "Reloaded: " + StringTools.join(Arrays.asList(this.lastTopLevelCommand), " ") + "\n" + this.execute(commandContext, this.lastTopLevelCommand);
        }
        if (!topLevel && reload) {
            throw new SoarException(args[1] + " option only valid at top level");
        }
        if (this.lastTopLevelCommand == null && reload) {
            throw new SoarException("No previous file to reload");
        }
        ArrayList<String> files = new ArrayList<String>();
        EnumSet<Options> opts = EnumSet.noneOf(Options.class);
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-d") || arg.equals("--disable")) {
                opts.add(Options.DISABLE);
                continue;
            }
            if (arg.equals("-a") || arg.equals("--all")) {
                opts.add(Options.ALL);
                continue;
            }
            if (arg.equals("-v") || arg.endsWith("--verbose")) {
                opts.add(Options.VERBOSE);
                continue;
            }
            if (arg.startsWith("-")) {
                throw new SoarException("Unknown option '" + arg + "'");
            }
            files.add(arg);
        }
        if (topLevel) {
            this.topLevelState = new TopLevelState();
            this.events.addListener(ProductionAddedEvent.class, this.eventListener);
            this.events.addListener(ProductionExcisedEvent.class, this.eventListener);
        }
        try {
            for (String file : files) {
                this.source(file);
            }
            if (topLevel) {
                this.lastTopLevelCommand = Arrays.copyOf(args, args.length);
            }
            String string = this.generateResult(topLevel, opts);
            return string;
        }
        finally {
            if (topLevel) {
                this.topLevelState = null;
                this.events.removeListener(null, this.eventListener);
            }
        }
    }

    private String generateResult(boolean topLevel, EnumSet<Options> opts) {
        StringBuilder result = new StringBuilder();
        if (topLevel) {
            if (opts.contains((Object)Options.ALL)) {
                for (FileInfo file : this.topLevelState.files) {
                    result.append(String.format("%s: %d productions sourced.\n", file.name, file.productionsAdded.size()));
                    if (!opts.contains((Object)Options.VERBOSE) || file.productionsExcised.isEmpty()) continue;
                    result.append("Excised productions:\n");
                    for (String p : file.productionsExcised) {
                        result.append("        " + p + "\n");
                    }
                }
            }
            if (!opts.contains((Object)Options.DISABLE)) {
                result.append(String.format("Total: %d productions sourced. %d productions excised.\n", this.topLevelState.totalProductionsAdded, this.topLevelState.totalProductionsExcised));
            }
            if (opts.contains((Object)Options.VERBOSE) && !opts.contains((Object)Options.ALL) && this.topLevelState.totalProductionsExcised != 0) {
                result.append("Excised productions:\n");
                for (FileInfo file : this.topLevelState.files) {
                    for (String p : file.productionsExcised) {
                        result.append("        " + p + "\n");
                    }
                }
            }
            result.append("Source finished.");
        }
        return result.toString();
    }

    private URL getParentUrl(URL url) throws SoarException {
        String s = url.toExternalForm();
        int i = s.lastIndexOf(47);
        if (i == -1) {
            throw new SoarException("Cannot determine parent of URL: " + url);
        }
        URL parent = FileTools.asUrl(s.substring(0, i));
        if (parent != null) {
            return parent;
        }
        return FileTools.asUrl(s.substring(0, i) + "/");
    }

    URL joinUrl(URL parent, String child) {
        String s = parent.toExternalForm();
        return FileTools.asUrl(s.endsWith("/") ? s + child : s + "/" + child);
    }

    private void evalFileAndPop(File file) throws SoarException {
        try {
            this.sourcedFiles.add(file.getAbsolutePath().replace(File.separator, "/"));
            this.fileStack.push(file.getAbsolutePath());
            if (this.topLevelState != null) {
                this.topLevelState.files.add(new FileInfo(file.getName()));
            }
            this.interp.eval(file);
        }
        finally {
            this.fileStack.pop();
            this.popd();
        }
    }

    private void evalUrlAndPop(URL urlIn) throws SoarException {
        URL url = this.normalizeUrl(urlIn);
        try {
            this.fileStack.push(url.toExternalForm());
            if (this.topLevelState != null) {
                this.topLevelState.files.add(new FileInfo(url.toExternalForm()));
            }
            this.interp.eval(url);
        }
        finally {
            this.fileStack.pop();
            this.popd();
        }
    }

    private URL normalizeUrl(URL url) throws SoarException {
        try {
            return url.toURI().normalize().toURL();
        }
        catch (MalformedURLException e) {
            throw new SoarException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new SoarException(e.getMessage(), e);
        }
    }

    static class TopLevelState {
        final List<FileInfo> files = new ArrayList<FileInfo>();
        int totalProductionsAdded = 0;
        int totalProductionsExcised = 0;

        TopLevelState() {
        }

        void productionAdded(Production p) {
            this.current().productionsAdded.add(p.getName());
            ++this.totalProductionsAdded;
        }

        void productionExcised(Production p) {
            this.current().productionsExcised.add(p.getName());
            ++this.totalProductionsExcised;
        }

        private FileInfo current() {
            return this.files.get(this.files.size() - 1);
        }
    }

    static class FileInfo {
        final String name;
        final List<String> productionsAdded = new ArrayList<String>();
        final List<String> productionsExcised = new ArrayList<String>();

        public FileInfo(String name) {
            this.name = name;
        }
    }

    static class DirStackEntry {
        File file;
        URL url;

        public DirStackEntry(File file) {
            this.file = file;
        }

        public DirStackEntry(URL url) {
            this.url = url;
        }
    }

    private static enum Options {
        ALL,
        DISABLE,
        VERBOSE;

    }
}

