/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.commands;

import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.parser.ParserException;
import org.jsoar.kernel.rhs.ReordererException;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.commands.SoarTclExceptionsManager;
import picocli.CommandLine;

public class SpCommand
implements SoarCommand {
    private Agent agent;

    public SpCommand(Agent agent) {
        this.agent = agent;
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new Sp(this.agent, context), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new Sp(this.agent, null);
    }

    @CommandLine.Command(name="sp", description={"Define a Soar production"}, subcommands={CommandLine.HelpCommand.class})
    public static class Sp
    implements Runnable {
        private Agent agent;
        private SoarCommandContext context;
        @CommandLine.Parameters(description={"A Soar production"})
        String production = null;

        public Sp(Agent agent, SoarCommandContext context) {
            this.agent = agent;
            this.context = context;
        }

        @Override
        public void run() {
            if (this.production == null) {
                this.agent.getPrinter().startNewLine().print("Use this command to define a Soar production");
            } else {
                try {
                    this.agent.getProductions().loadProduction(this.production, this.context.getSourceLocation());
                    this.agent.getPrinter().print("*");
                    SoarTclExceptionsManager exceptionsManager = this.agent.getInterpreter().getExceptionsManager();
                    this.agent.getPrinter().getWarningsAndClear().forEach(warning -> exceptionsManager.addException((String)warning, this.context, this.production));
                }
                catch (ParserException | ReordererException e) {
                    this.agent.getPrinter().startNewLine().print(this.context.getSourceLocation() + ":" + e.getMessage());
                    this.agent.getInterpreter().getExceptionsManager().addException(e, this.context, this.production);
                }
            }
        }
    }
}

