/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.epmem;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.epmem.DefaultEpisodicMemoryParams;
import org.jsoar.kernel.epmem.DefaultEpisodicMemoryStats;
import org.jsoar.kernel.epmem.EpisodicMemory;
import org.jsoar.kernel.epmem.EpisodicMemoryDatabase;
import org.jsoar.kernel.epmem.EpisodicMemoryIdReservation;
import org.jsoar.kernel.epmem.EpisodicMemoryStateInfo;
import org.jsoar.kernel.epmem.EpisodicMemoryStatistics;
import org.jsoar.kernel.epmem.EpisodicMemorySymbols;
import org.jsoar.kernel.learning.Chunker;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.RecognitionMemory;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.memory.WmeType;
import org.jsoar.kernel.memory.WorkingMemory;
import org.jsoar.kernel.modules.SoarModule;
import org.jsoar.kernel.parser.original.Lexeme;
import org.jsoar.kernel.parser.original.LexemeType;
import org.jsoar.kernel.parser.original.Lexer;
import org.jsoar.kernel.smem.DefaultSemanticMemory;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.IntegerSymbolImpl;
import org.jsoar.kernel.symbols.JavaSymbol;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Symbols;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.wma.WorkingMemoryActivation;
import org.jsoar.util.ByRef;
import org.jsoar.util.JdbcTools;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.db.SoarPreparedStatement;
import org.jsoar.util.markers.DefaultMarker;
import org.jsoar.util.markers.Marker;
import org.jsoar.util.properties.PropertyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEpisodicMemory
implements EpisodicMemory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEpisodicMemory.class);
    public static final long EPMEM_MEMID_NONE = 0L;
    public static final long EPMEM_NODEID_BAD = -1L;
    public static final long EPMEM_HASH_ACCEPTABLE = 1L;
    public static final int EPMEM_NODE_POS = 0;
    public static final int EPMEM_NODE_NEG = 1;
    public static final int EPMEM_RANGE_START = 0;
    public static final int EPMEM_RANGE_END = 1;
    public static final int EPMEM_RANGE_EP = 0;
    public static final long EPMEM_RANGE_NOW = 1L;
    public static final long EPMEM_RANGE_POINT = 2L;
    private static final long EPMEM_RIT_ROOT = 0L;
    private static final double EPMEM_LN_2 = 0.693147180559945;
    private Adaptable context;
    private Agent agent;
    private DefaultSemanticMemory smem;
    private Chunker chunker;
    private DefaultEpisodicMemoryParams params;
    DefaultEpisodicMemoryStats stats;
    private Decider decider;
    SymbolFactoryImpl symbols;
    EpisodicMemoryDatabase db;
    private RecognitionMemory recognitionMemory;
    private long epmem_validation = 0L;
    private SortedMap<Long, Boolean> epmem_node_removals;
    private List<Long> epmem_node_mins;
    private List<Boolean> epmem_node_maxes;
    private SortedMap<Long, Boolean> epmem_edge_removals;
    private List<Long> epmem_edge_mins;
    private List<Boolean> epmem_edge_maxes;
    private Map<Long, Map<Long, LinkedList<EpisodicMemoryIdReservation.EpisodicMemoryIdPair>>> epmem_id_repository;
    private Map<Long, LinkedList<EpisodicMemoryIdReservation.EpisodicMemoryIdPair>> epmem_id_replacement;
    private Map<Long, Set<WmeImpl>> epmem_id_ref_counts;
    private Deque<SymbolImpl> epmem_id_removes;
    private final Set<IdentifierImpl> epmem_wme_adds = new LinkedHashSet<IdentifierImpl>();
    private final Set<SymbolImpl> epmem_promotions = new LinkedHashSet<SymbolImpl>();
    private static final Long EPMEM_NODEID_ROOT = 0L;
    private static final int EPMEM_RIT_STATE_NODE = 0;
    private static final int EPMEM_RIT_STATE_EDGE = 1;
    private static final int EPMEM_RIT_OFFSET_INIT = -1;
    private final epmem_rit_state[] epmem_rit_state_graph = new epmem_rit_state[]{new epmem_rit_state(), new epmem_rit_state()};
    private Trace trace;
    private Random random;
    EpisodicMemorySymbols predefinedSyms;
    private final Map<IdentifierImpl, EpisodicMemoryStateInfo> stateInfos = new LinkedHashMap<IdentifierImpl, EpisodicMemoryStateInfo>();
    private final SoarModule soarModule = new SoarModule();
    private WorkingMemoryActivation wma;

    public DefaultEpisodicMemory(Adaptable context) {
        this(context, null);
    }

    public DefaultEpisodicMemory(Adaptable context, EpisodicMemoryDatabase db) {
        this.context = context;
        this.db = db;
    }

    public EpisodicMemoryStatistics getStats() {
        return this.stats;
    }

    public void initialize() {
        this.agent = Adaptables.adapt(this.context, Agent.class);
        this.symbols = Adaptables.require(DefaultEpisodicMemory.class, this.context, SymbolFactoryImpl.class);
        this.smem = Adaptables.require(DefaultEpisodicMemory.class, this.context, DefaultSemanticMemory.class);
        this.recognitionMemory = Adaptables.require(DefaultEpisodicMemory.class, this.context, RecognitionMemory.class);
        this.chunker = Adaptables.require(DefaultEpisodicMemory.class, this.context, Chunker.class);
        this.decider = Adaptables.require(DefaultEpisodicMemory.class, this.context, Decider.class);
        this.wma = Adaptables.require(DefaultEpisodicMemory.class, this.context, WorkingMemoryActivation.class);
        this.random = this.agent.getRandom();
        this.trace = this.agent.getTrace();
        PropertyManager properties = Adaptables.require(DefaultEpisodicMemory.class, this.context, PropertyManager.class);
        this.params = new DefaultEpisodicMemoryParams(properties, this.symbols);
        this.stats = new DefaultEpisodicMemoryStats(properties);
        this.predefinedSyms = new EpisodicMemorySymbols(this.symbols);
        this.epmem_node_removals = Maps.newTreeMap();
        this.epmem_node_mins = Lists.newArrayList();
        this.epmem_node_maxes = Lists.newArrayList();
        this.epmem_edge_removals = Maps.newTreeMap();
        this.epmem_edge_mins = Lists.newArrayList();
        this.epmem_edge_maxes = Lists.newArrayList();
        this.epmem_id_repository = Maps.newLinkedHashMap();
        this.epmem_id_replacement = Maps.newLinkedHashMap();
        this.epmem_id_ref_counts = Maps.newLinkedHashMap();
        this.epmem_id_removes = Lists.newLinkedList();
        this.epmem_rit_state_graph[0].offset.var_key = epmem_variable_key.var_rit_offset_1;
        this.epmem_rit_state_graph[0].leftroot.var_key = epmem_variable_key.var_rit_leftroot_1;
        this.epmem_rit_state_graph[0].rightroot.var_key = epmem_variable_key.var_rit_rightroot_1;
        this.epmem_rit_state_graph[0].minstep.var_key = epmem_variable_key.var_rit_minstep_1;
        this.epmem_rit_state_graph[1].offset.var_key = epmem_variable_key.var_rit_offset_2;
        this.epmem_rit_state_graph[1].leftroot.var_key = epmem_variable_key.var_rit_leftroot_2;
        this.epmem_rit_state_graph[1].rightroot.var_key = epmem_variable_key.var_rit_rightroot_2;
        this.epmem_rit_state_graph[1].minstep.var_key = epmem_variable_key.var_rit_minstep_2;
        this.soarModule.initialize(this.context);
    }

    EpisodicMemoryDatabase getDatabase() {
        return this.db;
    }

    DefaultEpisodicMemoryParams getParams() {
        return this.params;
    }

    void epmem_init_db() throws SoarException {
        this.epmem_init_db(false);
    }

    private void epmem_init_db_catch() {
        try {
            this.epmem_init_db();
        }
        catch (SoarException e) {
            logger.error("While initializing epmem: " + e.getMessage(), (Throwable)e);
            this.agent.getPrinter().error("While initializing epmem: " + e.getMessage());
        }
    }

    void epmem_init_db(boolean readonly) throws SoarException {
        if (this.db == null) {
            try {
                this.epmem_init_db_ex(readonly);
            }
            catch (SQLException e) {
                throw new SoarException("While attaching epmem: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new SoarException("While attaching epmem: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDatabasePerformanceOptions() throws SQLException, SoarException, IOException {
        if (this.params.driver.get().equals("org.sqlite.JDBC")) {
            long cacheSize = this.params.cache_size.get();
            try (Statement s = this.db.getConnection().createStatement();){
                s.execute("PRAGMA cache_size = " + cacheSize);
            }
        }
        if (this.params.optimization.get() == DefaultEpisodicMemoryParams.Optimization.performance) {
            String perfResource = this.params.driver.get() + ".performance.sql";
            InputStream perfStream = this.getClass().getResourceAsStream(perfResource);
            String fullPath = "/" + this.getClass().getCanonicalName().replace('.', '/') + "/" + perfResource;
            if (perfStream != null) {
                logger.info("Applying performance settings from '" + fullPath + "'.");
                try {
                    JdbcTools.executeSql(this.db.getConnection(), perfStream, null);
                }
                finally {
                    perfStream.close();
                }
            } else {
                logger.warn("Could not find performance resource at '" + fullPath + "'. No performance settings applied.");
            }
        }
        if (this.params.driver.get().equals("org.sqlite.JDBC")) {
            DefaultEpisodicMemoryParams.PageChoices pageSize = (DefaultEpisodicMemoryParams.PageChoices)((Object)this.params.page_size.get());
            long pageSizeLong = 0L;
            switch (pageSize) {
                case page_16k: {
                    pageSizeLong = 16384L;
                    break;
                }
                case page_1k: {
                    pageSizeLong = 1024L;
                    break;
                }
                case page_2k: {
                    pageSizeLong = 2048L;
                    break;
                }
                case page_32k: {
                    pageSizeLong = 32768L;
                    break;
                }
                case page_4k: {
                    pageSizeLong = 4096L;
                    break;
                }
                case page_64k: {
                    pageSizeLong = 65536L;
                    break;
                }
                case page_8k: {
                    pageSizeLong = 8192L;
                    break;
                }
            }
            try (Statement s = this.db.getConnection().createStatement();){
                s.execute("PRAGMA page_size = " + pageSizeLong);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMinMax(long time_max, PreparedStatement minmax_select, List<Boolean> minmax_max, List<Long> minmax_min) throws SQLException {
        try (ResultSet rs = minmax_select.executeQuery();){
            while (rs.next()) {
                if (this.db.column_type(rs.getMetaData().getColumnType(1)) == EpisodicMemoryDatabase.value_type.null_t) continue;
                int num_ids = rs.getInt(1);
                for (int i = 0; i < num_ids; ++i) {
                    minmax_max.add(Boolean.TRUE);
                    minmax_min.add(time_max);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void epmem_init_db_ex(boolean readonly) throws SQLException, IOException, SoarException {
        if (this.db != null) {
            return;
        }
        String jdbcUrl = URLDecoder.decode(this.params.protocol.get() + ":" + this.params.path.get(), "UTF-8");
        Connection connection = JdbcTools.connect(this.params.driver.get(), jdbcUrl);
        DatabaseMetaData meta = connection.getMetaData();
        logger.info("Opened database '" + jdbcUrl + "' with " + meta.getDriverName() + ":" + meta.getDriverVersion());
        this.db = new EpisodicMemoryDatabase(this.params.driver.get(), connection);
        this.applyDatabasePerformanceOptions();
        ++this.epmem_validation;
        this.db.structure();
        this.db.prepare();
        if (!":memory:".equals(this.params.path.get())) {
            try (ResultSet result = this.db.get_schema_version.executeQuery();){
                if (result.next()) {
                    String schemaVersion = result.getString(1);
                    if (!"2.0".equals(schemaVersion)) {
                        logger.error("Incorrect database version, switching to memory.  Found version: " + schemaVersion);
                        this.params.path.set(":memory:");
                        connection.close();
                        this.db = null;
                        this.epmem_init_db_ex(readonly);
                    }
                } else if (this.params.append_database.get() == DefaultEpisodicMemoryParams.AppendDatabaseChoices.on) {
                    logger.info("The selected database contained no data to append on.  New tables created.");
                }
            }
        }
        this.db.set_schema_version.setString(1, "2.0");
        this.db.set_schema_version.execute();
        if (this.params.append_database.get() == DefaultEpisodicMemoryParams.AppendDatabaseChoices.off) {
            this.db.dropEpmemTables();
            this.db.structure();
            this.db.prepare();
        }
        this.epmem_node_mins.clear();
        this.epmem_node_maxes.clear();
        this.epmem_node_removals.clear();
        this.epmem_edge_mins.clear();
        this.epmem_edge_maxes.clear();
        this.epmem_edge_removals.clear();
        this.epmem_id_repository.put(EPMEM_NODEID_ROOT, new LinkedHashMap());
        LinkedHashSet wms_temp = Sets.newLinkedHashSet();
        wms_temp.add(null);
        this.epmem_id_ref_counts.put(EPMEM_NODEID_ROOT, wms_temp);
        this.stats.time.set(1L);
        this.stats.next_id.set(1L);
        ByRef<Long> stored_id = ByRef.create(0L);
        if (this.epmem_get_variable(epmem_variable_key.var_next_id, stored_id)) {
            this.stats.next_id.set((Long)stored_id.value);
        } else {
            this.epmem_set_variable(epmem_variable_key.var_next_id, this.stats.next_id.get());
        }
        for (int i = 0; i <= 1; ++i) {
            this.epmem_rit_state_graph[i].offset.stat = -1L;
            this.epmem_rit_state_graph[i].leftroot.stat = 0L;
            this.epmem_rit_state_graph[i].rightroot.stat = 1L;
            this.epmem_rit_state_graph[i].minstep.stat = Long.MAX_VALUE;
        }
        this.epmem_rit_state_graph[0].add_query = this.db.add_epmem_wmes_constant_range;
        this.epmem_rit_state_graph[1].add_query = this.db.add_epmem_wmes_identifier_range;
        ByRef<Long> var_val = ByRef.create(0L);
        for (int i = 0; i <= 1; ++i) {
            if (this.epmem_get_variable(this.epmem_rit_state_graph[i].offset.var_key, var_val)) {
                this.epmem_rit_state_graph[i].offset.stat = (Long)var_val.value;
            } else {
                this.epmem_set_variable(this.epmem_rit_state_graph[i].offset.var_key, this.epmem_rit_state_graph[i].offset.stat);
            }
            if (this.epmem_get_variable(this.epmem_rit_state_graph[i].leftroot.var_key, var_val)) {
                this.epmem_rit_state_graph[i].leftroot.stat = (Long)var_val.value;
            } else {
                this.epmem_set_variable(this.epmem_rit_state_graph[i].leftroot.var_key, this.epmem_rit_state_graph[i].leftroot.stat);
            }
            if (this.epmem_get_variable(this.epmem_rit_state_graph[i].rightroot.var_key, var_val)) {
                this.epmem_rit_state_graph[i].rightroot.stat = (Long)var_val.value;
            } else {
                this.epmem_set_variable(this.epmem_rit_state_graph[i].rightroot.var_key, this.epmem_rit_state_graph[i].rightroot.stat);
            }
            if (this.epmem_get_variable(this.epmem_rit_state_graph[i].minstep.var_key, var_val)) {
                this.epmem_rit_state_graph[i].minstep.stat = (Long)var_val.value;
                continue;
            }
            this.epmem_set_variable(this.epmem_rit_state_graph[i].minstep.var_key, this.epmem_rit_state_graph[i].minstep.stat);
        }
        PreparedStatement temp_q = this.db.get_max_time;
        try (ResultSet rs = temp_q.executeQuery();){
            if (rs.next()) {
                this.stats.time.set(rs.getLong(1) + 1L);
            }
        }
        long time_max = this.stats.time.get();
        if (!readonly) {
            long time_last = time_max - 1L;
            PreparedStatement[] now_select = new PreparedStatement[]{this.db.now_select_node, this.db.now_select_edge};
            PreparedStatement[] now_add = new PreparedStatement[]{this.db.add_epmem_wmes_constant_point, this.db.add_epmem_wmes_identifier_point};
            PreparedStatement[] now_delete = new PreparedStatement[]{this.db.now_delete_node, this.db.now_delete_edge};
            for (int i = 0; i <= 1; ++i) {
                PreparedStatement temp_q2 = now_add[i];
                temp_q2.setLong(2, time_last);
                PreparedStatement temp_q22 = now_select[i];
                try (ResultSet rs = temp_q22.executeQuery();){
                    while (rs.next()) {
                        long range_start = rs.getLong(2);
                        if (range_start == time_last) {
                            temp_q2.setLong(1, rs.getLong(1));
                            temp_q2.executeUpdate();
                            continue;
                        }
                        this.epmem_rit_insert_interval(range_start, time_last, rs.getLong(1), this.epmem_rit_state_graph[i]);
                    }
                }
                now_delete[i].execute();
            }
        }
        this.initMinMax(time_max, this.db.minmax_select_node, this.epmem_node_maxes, this.epmem_node_mins);
        this.initMinMax(time_max, this.db.minmax_select_edge, this.epmem_edge_maxes, this.epmem_edge_mins);
        PreparedStatement temp_q3 = this.db.edge_unique_select;
        try (ResultSet rs = temp_q3.executeQuery();){
            while (rs.next()) {
                LinkedList ip;
                long parent_n_id = rs.getLong(1);
                long attributes_s_id = rs.getLong(2);
                long child_n_id = rs.getLong(3);
                long wi_id = rs.getLong(4);
                Map<Object, Object> hp = this.epmem_id_repository.get(parent_n_id);
                if (hp == null) {
                    hp = Maps.newLinkedHashMap();
                    this.epmem_id_repository.put(parent_n_id, hp);
                }
                if ((ip = (LinkedList)hp.get(attributes_s_id)) == null) {
                    ip = Lists.newLinkedList();
                    hp.put(attributes_s_id, ip);
                }
                ip.addFirst(new EpisodicMemoryIdReservation.EpisodicMemoryIdPair(child_n_id, wi_id));
                hp = this.epmem_id_repository.get(child_n_id);
                if (hp != null) continue;
                hp = Maps.newLinkedHashMap();
                this.epmem_id_repository.put(child_n_id, hp);
            }
        }
        this.epmem_wme_adds.add(this.decider.top_state);
        this.decider.top_goal.epmem_id = EPMEM_NODEID_ROOT;
        this.decider.top_goal.epmem_valid = this.epmem_validation;
        ResultSet r = this.db.database_version.executeQuery();
        r.next();
        try {
            this.stats.db_version.set(r.getString(1));
        }
        finally {
            r.close();
        }
        if (this.params.lazy_commit.get() == DefaultEpisodicMemoryParams.LazyCommitChoices.on) {
            this.db.begin.executeUpdate();
        }
    }

    private void epmem_rit_insert_interval(long lower, long upper, long id, epmem_rit_state rit_state) throws SQLException {
        long offset = rit_state.offset.stat;
        if (offset == -1L) {
            offset = lower;
            this.epmem_set_variable(rit_state.offset.var_key, offset);
            rit_state.offset.stat = offset;
        }
        long left_root = rit_state.leftroot.stat;
        long right_root = rit_state.rightroot.stat;
        long min_step = rit_state.minstep.stat;
        long l = lower - offset;
        long u = upper - offset;
        if (u < 0L && l <= 2L * left_root) {
            left_root = (long)Math.pow(-2.0, Math.floor(Math.log(-l) / 0.693147180559945));
            this.epmem_set_variable(rit_state.leftroot.var_key, left_root);
            rit_state.leftroot.stat = left_root;
        }
        if (l > 0L && u >= 2L * right_root) {
            right_root = (long)Math.pow(2.0, Math.floor(Math.log(u) / 0.693147180559945));
            this.epmem_set_variable(rit_state.rightroot.var_key, right_root);
            rit_state.rightroot.stat = right_root;
        }
        EpmemRitForkNodeResult forkNodeResult = this.epmem_rit_fork_node(l, u, rit_state);
        long step = forkNodeResult.step;
        long node = forkNodeResult.node;
        if (node != 0L && step < min_step) {
            min_step = step;
            this.epmem_set_variable(rit_state.minstep.var_key, min_step);
            rit_state.minstep.stat = min_step;
        }
        rit_state.add_query.setLong(1, node);
        rit_state.add_query.setLong(2, lower);
        rit_state.add_query.setLong(3, upper);
        rit_state.add_query.setLong(4, id);
        rit_state.add_query.executeUpdate();
    }

    private final EpmemRitForkNodeResult epmem_rit_fork_node(long lower, long upper, epmem_rit_state rit_state) {
        long step;
        long node = 0L;
        if (upper < 0L) {
            node = rit_state.leftroot.stat;
        } else if (lower > 0L) {
            node = rit_state.rightroot.stat;
        }
        for (step = (node >= 0L ? node : -1L * node) / 2L; step >= 1L; step /= 2L) {
            if (upper < node) {
                node -= step;
                continue;
            }
            if (node >= lower) break;
            node += step;
        }
        return new EpmemRitForkNodeResult(node, step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean epmem_get_variable(epmem_variable_key variable_id, ByRef<Long> variable_value) throws SQLException {
        PreparedStatement var_get = this.db.var_get;
        var_get.setInt(1, variable_id.ordinal());
        try (ResultSet rs = var_get.executeQuery();){
            if (rs.next()) {
                variable_value.value = rs.getLong(1);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    void epmem_set_variable(epmem_variable_key variable_id, long variable_value) throws SQLException {
        PreparedStatement var_set = this.db.var_set;
        var_set.setInt(1, variable_id.ordinal());
        var_set.setLong(2, variable_value);
        var_set.execute();
    }

    @Override
    public void epmem_close() throws SoarException {
        if (this.db != null) {
            try {
                if (this.params.lazy_commit.get() == DefaultEpisodicMemoryParams.LazyCommitChoices.on) {
                    this.db.commit.execute();
                }
                this.db.getConnection().close();
                this.db = null;
                logger.info("EpMem| Closing database " + this.params.path.get() + ".");
            }
            catch (SQLException e) {
                throw new SoarException("While closing epmem: " + e.getMessage(), e);
            }
        }
        this.epmem_wme_adds.clear();
    }

    @Override
    public void initializeNewContext(WorkingMemory wm, IdentifierImpl id) {
        this.stateInfos.put(id, new EpisodicMemoryStateInfo(this, wm, id));
    }

    @Override
    public void epmem_reset(IdentifierImpl state) {
        if (state == null) {
            state = this.decider.top_goal;
        }
        while (state != null) {
            EpisodicMemoryStateInfo data = this.stateInfos.remove(state);
            data.last_ol_time = 0L;
            data.last_cmd_time = 0L;
            data.last_cmd_count = 0L;
            data.last_memory = 0L;
            data.epmem_wmes.clear();
            state = state.goalInfo.lower_goal;
        }
    }

    @Override
    public void epmem_go() {
        this.epmem_go(true);
    }

    @Override
    public void epmem_go(boolean allow_store) {
        boolean new_memory = false;
        if (allow_store) {
            new_memory = this.epmem_consider_new_episode();
        }
        try {
            this.epmem_respond_to_cmd(new_memory);
        }
        catch (SQLException e) {
            logger.error("While responding to epmem command: " + e.getMessage(), (Throwable)e);
            this.agent.getPrinter().error("While responding to epmem command: " + e.getMessage());
        }
        catch (SoarException e) {
            logger.error("While responding to epmem command: " + e.getMessage(), (Throwable)e);
            this.agent.getPrinter().error("While responding to epmem command: " + e.getMessage());
        }
    }

    private boolean epmem_consider_new_episode() {
        boolean new_memory;
        block10: {
            block9: {
                new_memory = false;
                if (this.params.force.get() != DefaultEpisodicMemoryParams.Force.off) break block9;
                switch ((DefaultEpisodicMemoryParams.Trigger)((Object)this.params.trigger.get())) {
                    case output: {
                        EpisodicMemoryStateInfo stateInfo = this.stateInfos.get(this.decider.top_goal);
                        for (Wme wme : this.agent.getInputOutput().getPendingCommands()) {
                            if ((long)wme.getTimetag() <= stateInfo.last_ol_time) continue;
                            new_memory = true;
                            stateInfo.last_ol_time = wme.getTimetag();
                        }
                        break block10;
                    }
                    case dc: {
                        new_memory = true;
                        break;
                    }
                    case none: {
                        new_memory = false;
                    }
                }
                break block10;
            }
            new_memory = this.params.force.get() == DefaultEpisodicMemoryParams.Force.remember;
            this.params.force.set(DefaultEpisodicMemoryParams.Force.off);
        }
        if (new_memory) {
            try {
                this.epmem_new_episode();
            }
            catch (SQLException e) {
                logger.error("While recording new epmem episode: " + e.getMessage(), (Throwable)e);
                this.agent.getPrinter().error("While recording new epmem episode: " + e.getMessage());
            }
        }
        return new_memory;
    }

    private Set<WmeImpl> epmem_find_inclusion_wmes(IdentifierImpl id) {
        HashSet<WmeImpl> result = new HashSet<WmeImpl>();
        DefaultMarker tc = DefaultMarker.create();
        this.epmem_expand_inclusions(id, tc, result);
        return result;
    }

    private boolean epmem_expand_inclusions(SymbolImpl sym, Marker tc, Set<WmeImpl> wmesToKeep) {
        boolean keptSomething = false;
        IdentifierImpl id = sym.asIdentifier();
        if (id != null && id.epmem_id != -1L) {
            List<WmeImpl> wmes = this.epmem_get_augs_of_id(id, tc);
            for (WmeImpl wme : wmes) {
                if (this.params.exclusions.contains(wme.attr)) continue;
                if (this.params.inclusions.contains(wme.attr)) {
                    wmesToKeep.add(wme);
                    this.mark_all_includable(wme.value, tc, wmesToKeep);
                    keptSomething = true;
                    continue;
                }
                if (!this.epmem_expand_inclusions(wme.value, tc, wmesToKeep)) continue;
                wmesToKeep.add(wme);
                keptSomething = true;
            }
        }
        return keptSomething;
    }

    private void mark_all_includable(SymbolImpl sym, Marker tc, Set<WmeImpl> wmesToKeep) {
        IdentifierImpl id = sym.asIdentifier();
        if (id != null && id.epmem_id != -1L) {
            List<WmeImpl> wmes = this.epmem_get_augs_of_id(id, tc);
            for (WmeImpl wme : wmes) {
                if (this.params.exclusions.contains(wme.attr)) continue;
                wmesToKeep.add(wme);
                this.mark_all_includable(wme.value, tc, wmesToKeep);
            }
        }
    }

    private void epmem_new_episode() throws SQLException {
        this.epmem_init_db_catch();
        if (this.db == null) {
            return;
        }
        long time_counter = this.stats.getTime();
        this.trace.startNewLine().print(Trace.Category.EPMEM, "EpMem| NEW EPISODE: " + time_counter + "\n");
        LinkedList<Long> epmem_node = new LinkedList<Long>();
        LinkedList<Long> epmem_edge = new LinkedList<Long>();
        DefaultMarker tc = DefaultMarker.create();
        List<WmeImpl> wmes = null;
        LinkedList<SymbolImpl> parent_syms = new LinkedList<SymbolImpl>();
        SymbolImpl parent_sym = null;
        LinkedList<Long> parent_ids = new LinkedList<Long>();
        LinkedHashMap<WmeImpl, EpisodicMemoryIdReservation> id_reservations = new LinkedHashMap<WmeImpl, EpisodicMemoryIdReservation>();
        LinkedHashSet<SymbolImpl> new_identifiers = new LinkedHashSet<SymbolImpl>();
        Set<WmeImpl> inclusion_wmes = null;
        for (IdentifierImpl id_p : this.epmem_wme_adds) {
            if (!this.params.inclusions.isEmpty()) {
                inclusion_wmes = this.epmem_find_inclusion_wmes(id_p);
            }
            if (id_p.epmem_id == -1L) continue;
            parent_syms.add(id_p);
            parent_ids.add(id_p.epmem_id);
            while (!parent_syms.isEmpty()) {
                parent_sym = (SymbolImpl)parent_syms.poll();
                long parent_id = (Long)parent_ids.poll();
                wmes = this.epmem_get_augs_of_id(parent_sym, tc);
                if (!this.params.inclusions.isEmpty()) {
                    ListIterator<WmeImpl> it = wmes.listIterator();
                    while (it.hasNext()) {
                        if (inclusion_wmes.contains(it.next())) continue;
                        it.remove();
                    }
                }
                if (!wmes.isEmpty()) {
                    this._epmem_store_level(parent_syms, parent_ids, tc, wmes, parent_id, time_counter, id_reservations, new_identifiers, epmem_node, epmem_edge);
                }
                wmes = null;
            }
        }
        while (!epmem_node.isEmpty()) {
            long temp_node = (Long)epmem_node.element();
            this.db.add_epmem_wmes_constant_now.setLong(1, temp_node);
            this.db.add_epmem_wmes_constant_now.setLong(2, time_counter);
            this.db.add_epmem_wmes_constant_now.executeUpdate();
            this.epmem_node_mins.set((int)temp_node - 1, time_counter);
            epmem_node.poll();
        }
        while (!epmem_edge.isEmpty()) {
            long temp_node = (Long)epmem_edge.element();
            this.db.add_epmem_wmes_identifier_now.setLong(1, temp_node);
            this.db.add_epmem_wmes_identifier_now.setLong(2, time_counter);
            this.db.add_epmem_wmes_identifier_now.executeUpdate();
            this.epmem_edge_mins.set((int)temp_node - 1, time_counter);
            this.db.update_epmem_wmes_identifier_last_episode_id.setLong(1, Long.MAX_VALUE);
            this.db.update_epmem_wmes_identifier_last_episode_id.setLong(2, temp_node);
            this.db.update_epmem_wmes_identifier_last_episode_id.executeUpdate();
            epmem_edge.poll();
        }
        for (Map.Entry<Long, Boolean> r : this.epmem_node_removals.entrySet()) {
            if (!r.getValue().booleanValue()) continue;
            this.db.delete_epmem_wmes_constant_now.setLong(1, r.getKey());
            this.db.delete_epmem_wmes_constant_now.executeUpdate();
            long range_start = this.epmem_node_mins.get((int)(r.getKey() - 1L));
            long range_end = time_counter - 1L;
            if (range_start == range_end) {
                this.db.add_epmem_wmes_constant_point.setLong(1, r.getKey());
                this.db.add_epmem_wmes_constant_point.setLong(2, range_start);
                this.db.add_epmem_wmes_constant_point.executeUpdate();
            } else {
                this.epmem_rit_insert_interval(range_start, range_end, r.getKey(), this.epmem_rit_state_graph[0]);
            }
            this.epmem_node_maxes.set((int)(r.getKey() - 1L), true);
        }
        this.epmem_node_removals.clear();
        for (Map.Entry<Long, Boolean> r : this.epmem_edge_removals.entrySet()) {
            if (!r.getValue().booleanValue()) continue;
            this.db.delete_epmem_wmes_identifier_now.setLong(1, r.getKey());
            this.db.delete_epmem_wmes_identifier_now.executeUpdate();
            long range_start = this.epmem_edge_mins.get((int)(r.getKey() - 1L));
            long range_end = time_counter - 1L;
            this.db.update_epmem_wmes_identifier_last_episode_id.setLong(1, range_end);
            this.db.update_epmem_wmes_identifier_last_episode_id.setLong(2, r.getKey());
            this.db.update_epmem_wmes_identifier_last_episode_id.executeUpdate();
            if (range_start == range_end) {
                this.db.add_epmem_wmes_identifier_point.setLong(1, r.getKey());
                this.db.add_epmem_wmes_identifier_point.setLong(2, range_start);
                this.db.add_epmem_wmes_identifier_point.executeUpdate();
            } else {
                this.epmem_rit_insert_interval(range_start, range_end, r.getKey(), this.epmem_rit_state_graph[1]);
            }
            this.epmem_edge_maxes.set((int)(r.getKey() - 1L), true);
        }
        this.epmem_edge_removals.clear();
        for (SymbolImpl p_it : this.epmem_promotions) {
            IdentifierImpl identifier = p_it.asIdentifier();
            if (identifier.smem_time_id != time_counter || identifier.id_smem_valid != this.epmem_validation) continue;
            this._epmem_promote_id(identifier, time_counter);
        }
        this.epmem_promotions.clear();
        this.db.add_time.setLong(1, time_counter);
        this.db.add_time.executeUpdate();
        this.stats.setTime(time_counter + 1L);
        IdentifierImpl state = this.decider.bottom_goal;
        IntegerSymbolImpl my_time_sym = this.symbols.createInteger(time_counter + 1L);
        while (state != null) {
            EpisodicMemoryStateInfo stateInfo = this.stateInfos.get(((SymbolImpl)state).asIdentifier());
            if (stateInfo.epmem_time_wme != null) {
                this.soarModule.remove_module_wme(stateInfo.epmem_time_wme);
            }
            stateInfo.epmem_time_wme = this.soarModule.add_module_wme(stateInfo.epmem_header, this.predefinedSyms.epmem_sym_present_id, my_time_sym);
            state = ((SymbolImpl)state).asIdentifier().goalInfo.higher_goal;
        }
        this.epmem_wme_adds.clear();
    }

    private List<WmeImpl> epmem_get_augs_of_id(SymbolImpl sym, Marker tc) {
        LinkedList return_val = Lists.newLinkedList();
        IdentifierImpl id = sym.asIdentifier();
        if (id != null && id.tc_number != tc) {
            WmeImpl w;
            id.tc_number = tc;
            WmeImpl wmeImpl = w = id.goalInfo != null ? id.goalInfo.getImpasseWmes() : null;
            while (w != null) {
                return_val.add(w);
                w = w.next;
            }
            WmeImpl wi = id.getInputWmes();
            while (wi != null) {
                return_val.add(wi);
                wi = wi.next;
            }
            Slot s = id.slots;
            while (s != null) {
                WmeImpl w2 = s.getWmes();
                while (w2 != null) {
                    return_val.add(w2);
                    w2 = w2.next;
                }
                w2 = s.getAcceptablePreferenceWmes();
                while (w2 != null) {
                    return_val.add(w2);
                    w2 = w2.next;
                }
                s = s.next;
            }
        }
        return return_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void _epmem_store_level(Queue<SymbolImpl> parent_syms, Queue<Long> parent_ids, Marker tc, List<WmeImpl> w_p, long parent_id, long time_counter, Map<WmeImpl, EpisodicMemoryIdReservation> id_reservations, Set<SymbolImpl> new_identifiers, Queue<Long> epmem_node, Queue<Long> epmem_edge) throws SQLException {
        value_known_apriori = false;
        my_id_repo = null;
        my_id_repo2 = null;
        if (DefaultEpisodicMemory.logger.isDebugEnabled()) {
            DefaultEpisodicMemory.logger.debug("==================================================\nDEBUG _epmem_store_level called for parent_id " + parent_id + "\n==================================================\n");
        }
        for (WmeImpl wme : w_p) {
            if (DefaultEpisodicMemory.logger.isDebugEnabled()) {
                DefaultEpisodicMemory.logger.debug("--------------------------------------------\nProcessing WME: " + Long.toString(parent_id) + " ^" + wme.getAttribute() + " " + wme.getValue() + "\n");
            }
            if (wme.epmem_id != -1L && wme.epmem_valid == this.epmem_validation || wme.value.asIdentifier() == null || wme.value.asIdentifier().epmem_id == -1L || wme.value.asIdentifier().epmem_valid != this.epmem_validation || wme.value.asIdentifier().smem_lti != 0L) continue;
            if (this.params.exclusions.contains(wme.attr)) {
                DefaultEpisodicMemory.logger.debug("   WME excluded.  Skipping.\n");
                continue;
            }
            new_id_reservation = wme.acceptable != false ? new EpisodicMemoryIdReservation(-1L, 1L) : new EpisodicMemoryIdReservation(-1L, this.epmem_temporal_hash(wme.attr));
            my_id_repo = this.epmem_id_repository.get(parent_id).get(new_id_reservation.my_hash);
            if (my_id_repo != null) {
                it = my_id_repo.iterator();
                while (it.hasNext()) {
                    pool_p = (EpisodicMemoryIdReservation.EpisodicMemoryIdPair)it.next();
                    if (pool_p.first != wme.value.asIdentifier().epmem_id) continue;
                    new_id_reservation.my_id = pool_p.second;
                    it.remove();
                    break;
                }
            } else {
                my_id_repo = Lists.newLinkedList();
                this.epmem_id_repository.get(parent_id).put(new_id_reservation.my_hash, my_id_repo);
            }
            new_id_reservation.my_pool = my_id_repo;
            id_reservations.put(wme, new_id_reservation);
            new_id_reservation = null;
        }
        for (WmeImpl wme : w_p) {
            if (DefaultEpisodicMemory.logger.isDebugEnabled()) {
                DefaultEpisodicMemory.logger.debug("--------------------------------------------\nProcessing WME: " + parent_id + " ^" + wme.getAttribute() + " " + wme.getValue() + "\n");
            }
            if (wme.epmem_id != -1L && wme.epmem_valid == this.epmem_validation) {
                if (!DefaultEpisodicMemory.logger.isDebugEnabled()) continue;
                DefaultEpisodicMemory.logger.debug("   WME already in system with id " + wme.epmem_id + ".\n");
                continue;
            }
            if (this.params.exclusions.contains(wme.attr)) {
                DefaultEpisodicMemory.logger.debug("   WME excluded.  Skipping.\n");
                continue;
            }
            wmeValueId = wme.value.asIdentifier();
            if (wmeValueId != null) {
                DefaultEpisodicMemory.logger.debug("   WME value is IDENTIFER.\n");
                wme.epmem_valid = this.epmem_validation;
                wme.epmem_id = -1L;
                my_hash = 0L;
                my_id_repo = null;
                v0 = value_known_apriori = wmeValueId.epmem_id != -1L && wmeValueId.epmem_valid == this.epmem_validation;
                if (wmeValueId.smem_lti != 0L) {
                    if (!value_known_apriori) {
                        DefaultEpisodicMemory.logger.debug("   Value is an LTI  Doing processing we haven't looked at!\n");
                        wmeValueId.epmem_id = -1L;
                        wmeValueId.epmem_valid = this.epmem_validation;
                        ps = this.db.find_lti;
                        ps.setLong(1, wmeValueId.getNameLetter());
                        ps.setLong(2, wmeValueId.getNameNumber());
                        rs = ps.executeQuery();
                        try {
                            if (rs.next()) {
                                wmeValueId.epmem_id = rs.getLong(1);
                            }
                        }
                        finally {
                            rs.close();
                        }
                        if (wmeValueId.epmem_id == -1L) {
                            wmeValueId.epmem_id = this.stats.getNextId();
                            this.stats.setNextId(wmeValueId.epmem_id + 1L);
                            this.epmem_set_variable(epmem_variable_key.var_next_id, wmeValueId.epmem_id + 1L);
                            if (DefaultEpisodicMemory.logger.isDebugEnabled()) {
                                DefaultEpisodicMemory.logger.debug("   Adding new n_id and setting wme id to " + wmeValueId.epmem_id + " for VALUE which is lti " + wmeValueId.getNameLetter() + wmeValueId.getNameNumber() + "\n");
                            }
                            epmem_hashed_id_pool = Maps.newLinkedHashMap();
                            this.epmem_id_repository.put(wmeValueId.epmem_id, epmem_hashed_id_pool);
                            this._epmem_promote_id(wmeValueId, time_counter);
                        }
                    }
                    my_hash = wme.acceptable != false ? 1L : this.epmem_temporal_hash(wme.attr);
                    ps = this.db.find_epmem_wmes_identifier_shared;
                    ps.setLong(1, parent_id);
                    ps.setLong(2, my_hash);
                    ps.setLong(3, wmeValueId.epmem_id);
                    rs = ps.executeQuery();
                    try {
                        if (!rs.next()) ** GOTO lbl153
                        wme.epmem_id = rs.getLong(1);
                    }
                    finally {
                        rs.close();
                    }
                } else if (value_known_apriori) {
                    DefaultEpisodicMemory.logger.debug("   WME is known.  Looking for reservation.\n");
                    r_p = id_reservations.get(wme);
                    if (r_p != null) {
                        DefaultEpisodicMemory.logger.debug("   Found existing reservation.\n");
                        my_hash = r_p.my_hash;
                        my_id_repo2 = r_p.my_pool;
                        if (r_p.my_id != -1L) {
                            wme.epmem_id = r_p.my_id;
                            this.epmem_id_replacement.put(wme.epmem_id, my_id_repo2);
                            DefaultEpisodicMemory.logger.debug("   Assigning id from existing pool: " + wme.epmem_id + "\n");
                        }
                        id_reservations.remove(wme);
                    } else {
                        DefaultEpisodicMemory.logger.debug("   No reservation found.  Looking for shared identifier at same level.\n");
                        my_hash = wme.acceptable != false ? 1L : this.epmem_temporal_hash(wme.attr);
                        my_id_repo = this.epmem_id_repository.get(parent_id).get(my_hash);
                        if (my_id_repo != null) {
                            if (!my_id_repo.isEmpty()) {
                                it = my_id_repo.iterator();
                                while (it.hasNext()) {
                                    pool_p = (EpisodicMemoryIdReservation.EpisodicMemoryIdPair)it.next();
                                    if (pool_p.first != wmeValueId.epmem_id) continue;
                                    wme.epmem_id = pool_p.second;
                                    it.remove();
                                    this.epmem_id_replacement.put(wme.epmem_id, my_id_repo);
                                    if (DefaultEpisodicMemory.logger.isDebugEnabled()) {
                                        DefaultEpisodicMemory.logger.debug("   Assigning id from existing pool: " + wme.epmem_id + "\n");
                                    }
                                    break;
                                }
                            }
                        } else {
                            DefaultEpisodicMemory.logger.debug("   No pool.  Creating a new one.\n");
                            my_id_repo = Lists.newLinkedList();
                            this.epmem_id_repository.get(parent_id).put(my_hash, my_id_repo);
                        }
                        my_id_repo2 = my_id_repo;
                    }
                } else {
                    new_identifiers.add(wme.value);
                    my_hash = wme.acceptable != false ? 1L : this.epmem_temporal_hash(wme.attr);
                    my_id_repo = this.epmem_id_repository.get(parent_id).get(my_hash);
                    if (my_id_repo != null) {
                        if (!my_id_repo.isEmpty()) {
                            it = my_id_repo.iterator();
                            while (it.hasNext()) {
                                pool_p = (EpisodicMemoryIdReservation.EpisodicMemoryIdPair)it.next();
                                if (this.epmem_id_ref_counts.get(pool_p.first) != null && !this.epmem_id_ref_counts.get(pool_p.first).isEmpty()) continue;
                                wme.epmem_id = pool_p.second;
                                wmeValueId.epmem_id = pool_p.first;
                                wmeValueId.epmem_valid = this.epmem_validation;
                                it.remove();
                                this.epmem_id_replacement.put(wme.epmem_id, my_id_repo);
                                break;
                            }
                        }
                    } else {
                        my_id_repo = Lists.newLinkedList();
                        this.epmem_id_repository.get(parent_id).put(my_hash, my_id_repo);
                    }
                    my_id_repo2 = my_id_repo;
                }
lbl153:
                // 5 sources

                if (wme.epmem_id == -1L) {
                    block67: {
                        DefaultEpisodicMemory.logger.debug("   No success, adding wme to database.");
                        if (wmeValueId.epmem_id == -1L || wmeValueId.epmem_valid != this.epmem_validation) {
                            wmeValueId.epmem_id = this.stats.getNextId();
                            wmeValueId.epmem_valid = this.epmem_validation;
                            this.stats.setNextId(wmeValueId.epmem_id + 1L);
                            this.epmem_set_variable(epmem_variable_key.var_next_id, wmeValueId.epmem_id + 1L);
                            if (DefaultEpisodicMemory.logger.isDebugEnabled()) {
                                DefaultEpisodicMemory.logger.debug("   Adding new n_id and setting wme id for VALUE to " + wmeValueId.epmem_id + " \n");
                            }
                            this.db.add_node.setLong(1, wmeValueId.epmem_id);
                            this.db.add_node.execute();
                            epmem_hashed_id_pool = Maps.newLinkedHashMap();
                            this.epmem_id_repository.put(wmeValueId.epmem_id, epmem_hashed_id_pool);
                            epmem_wme_set = Sets.newLinkedHashSet();
                            this.epmem_id_ref_counts.put(wmeValueId.epmem_id, epmem_wme_set);
                        }
                        if (DefaultEpisodicMemory.logger.isDebugEnabled()) {
                            DefaultEpisodicMemory.logger.debug("   Performing database insertion: " + parent_id + " " + my_hash + " " + wmeValueId.epmem_id + "\n");
                            DefaultEpisodicMemory.logger.debug("   Adding wme to epmem_wmes_identifier table.\n");
                        }
                        ps = this.db.add_epmem_wmes_identifier;
                        ps.setLong(1, parent_id);
                        ps.setLong(2, my_hash);
                        ps.setLong(3, wmeValueId.epmem_id);
                        ps.setLong(4, 0x7FFFFFFFFFFFFFFFL);
                        ps.execute();
                        rs = ps.getGeneratedKeys();
                        try {
                            if (rs.next()) {
                                wme.epmem_id = rs.getLong(1);
                                break block67;
                            }
                            throw new SQLException("ps.getGeneratedKeys failed!");
                        }
                        finally {
                            rs.close();
                        }
                    }
                    if (DefaultEpisodicMemory.logger.isDebugEnabled()) {
                        DefaultEpisodicMemory.logger.debug("   Incrementing and setting wme id to " + wme.epmem_id + " \n");
                    }
                    if (wmeValueId.smem_lti == 0L) {
                        this.epmem_id_replacement.put(wme.epmem_id, my_id_repo2);
                    }
                    epmem_edge.add(wme.epmem_id);
                    this.epmem_edge_mins.add(time_counter);
                    this.epmem_edge_maxes.add(false);
                } else {
                    DefaultEpisodicMemory.logger.debug("   No success but already has id, so don't remove.\n");
                    this.epmem_edge_removals.put(wme.epmem_id, false);
                    if (this.epmem_edge_maxes.get((int)(wme.epmem_id - 1L)).booleanValue()) {
                        epmem_edge.add(wme.epmem_id);
                        this.epmem_edge_maxes.set((int)(wme.epmem_id - 1L), false);
                    }
                }
                if (new_identifiers.contains(wme.value)) {
                    if (!this.epmem_id_ref_counts.containsKey(wmeValueId.epmem_id)) {
                        epmem_wme_set = Sets.newLinkedHashSet();
                        this.epmem_id_ref_counts.put(wmeValueId.epmem_id, epmem_wme_set);
                    }
                    this.epmem_id_ref_counts.get(wmeValueId.epmem_id).add(wme);
                }
                if (wmeValueId.tc_number == tc) continue;
                parent_syms.add(wme.value);
                parent_ids.add(wmeValueId.epmem_id);
                continue;
            }
            DefaultEpisodicMemory.logger.debug("   WME value is a CONSTANT.\n");
            if (wme.epmem_id != -1L && wme.epmem_valid == this.epmem_validation) continue;
            DefaultEpisodicMemory.logger.debug("   This is a new wme.\n");
            wme.epmem_id = -1L;
            wme.epmem_valid = this.epmem_validation;
            my_hash = this.epmem_temporal_hash(wme.attr);
            my_hash2 = this.epmem_temporal_hash(wme.value);
            DefaultEpisodicMemory.logger.debug("   Looking for id of a duplicate entry in epmem_wmes_constant.\n");
            ps = this.db.find_epmem_wmes_constant;
            ps.setLong(1, parent_id);
            ps.setLong(2, my_hash);
            ps.setLong(3, my_hash2);
            rs = ps.executeQuery();
            try {
                if (rs.next()) {
                    wme.epmem_id = rs.getLong(1);
                }
            }
            finally {
                rs.close();
            }
            if (wme.epmem_id == -1L) {
                block69: {
                    if (DefaultEpisodicMemory.logger.isDebugEnabled()) {
                        DefaultEpisodicMemory.logger.debug("   No duplicate wme found in epmem_wmes_constant.  Adding wme to table!!!!\n");
                        DefaultEpisodicMemory.logger.debug("   Performing database insertion: " + parent_id + " " + my_hash + " " + my_hash2 + "\n");
                    }
                    ps = this.db.add_epmem_wmes_constant;
                    ps.setLong(1, parent_id);
                    ps.setLong(2, my_hash);
                    ps.setLong(3, my_hash2);
                    ps.execute();
                    rs = ps.getGeneratedKeys();
                    try {
                        if (rs.next()) {
                            wme.epmem_id = rs.getLong(1);
                            break block69;
                        }
                        throw new SQLException("ps.getGeneratedKeys failed!");
                    }
                    finally {
                        rs.close();
                    }
                }
                if (DefaultEpisodicMemory.logger.isDebugEnabled()) {
                    DefaultEpisodicMemory.logger.debug("   Setting wme id from last row to  " + wme.epmem_id + " \n");
                }
                epmem_node.add(wme.epmem_id);
                this.epmem_node_mins.add(time_counter);
                this.epmem_node_maxes.add(false);
                continue;
            }
            if (DefaultEpisodicMemory.logger.isDebugEnabled()) {
                DefaultEpisodicMemory.logger.debug("Node found in database, definitely don't remove.\n");
                DefaultEpisodicMemory.logger.debug("   Setting wme id from existing node to  " + wme.epmem_id + " \n");
            }
            this.epmem_node_removals.put(wme.epmem_id, false);
            if (!this.epmem_node_maxes.get((int)(wme.epmem_id - 1L)).booleanValue()) continue;
            epmem_node.add(wme.epmem_id);
            this.epmem_node_maxes.set((int)(wme.epmem_id - 1L), false);
        }
    }

    public void epmem_schedule_promotion(IdentifierImpl id) {
        if (this.epmem_enabled() && id.epmem_id != -1L && id.epmem_valid == this.epmem_validation) {
            this.epmem_promotions.add(id);
        }
    }

    void _epmem_promote_id(IdentifierImpl id, long t) throws SQLException {
        PreparedStatement ps = this.db.promote_id;
        ps.setLong(1, id.epmem_id);
        ps.setLong(2, id.getNameLetter());
        ps.setLong(3, id.getNameNumber());
        ps.setLong(4, t);
        ps.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long epmem_temporal_hash_add_type(int sym_type) {
        long toReturn = -1L;
        try {
            this.db.hash_add_type.setInt(1, sym_type);
            this.db.hash_add_type.execute();
            ResultSet rs = this.db.hash_add_type.getGeneratedKeys();
            rs.next();
            try {
                toReturn = rs.getLong(1);
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        return toReturn;
    }

    long epmem_temporal_hash_int(long val) {
        return this.epmem_temporal_hash_int(val, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long epmem_temporal_hash_int(long val, boolean add_on_fail) {
        long return_val = 0L;
        try {
            this.db.hash_get_int.setLong(1, val);
            try (ResultSet rs = this.db.hash_get_int.executeQuery();){
                if (rs.next()) {
                    return_val = rs.getLong(1);
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        if (return_val == 0L && add_on_fail) {
            return_val = this.epmem_temporal_hash_add_type(3);
            try {
                this.db.hash_add_int.setLong(1, return_val);
                this.db.hash_add_int.setLong(2, val);
                this.db.hash_add_int.execute();
            }
            catch (SQLException e) {
                logger.error(e.getMessage());
            }
        }
        return return_val;
    }

    long epmem_temporal_hash_float(double val) {
        return this.epmem_temporal_hash_float(val, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long epmem_temporal_hash_float(double val, boolean add_on_fail) {
        long return_val = 0L;
        try {
            this.db.hash_get_float.setDouble(1, val);
            try (ResultSet rs = this.db.hash_get_float.executeQuery();){
                if (rs.next()) {
                    return_val = rs.getLong(1);
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        if (return_val == 0L && add_on_fail) {
            return_val = this.epmem_temporal_hash_add_type(4);
            try {
                this.db.hash_add_float.setLong(1, return_val);
                this.db.hash_add_float.setDouble(2, val);
                this.db.hash_add_float.execute();
            }
            catch (SQLException e) {
                logger.error(e.getMessage());
            }
        }
        return return_val;
    }

    long epmem_temporal_hash_str(String val) {
        return this.epmem_temporal_hash_str(val, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long epmem_temporal_hash_str(String val, boolean add_on_fail) {
        long return_val = 0L;
        try {
            this.db.hash_get_str.setString(1, val);
            try (ResultSet rs = this.db.hash_get_str.executeQuery();){
                if (rs.next()) {
                    return_val = rs.getLong(1);
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        if (return_val == 0L && add_on_fail) {
            return_val = this.epmem_temporal_hash_add_type(2);
            try {
                this.db.hash_add_str.setLong(1, return_val);
                this.db.hash_add_str.setString(2, val);
                this.db.hash_add_str.execute();
            }
            catch (SQLException e) {
                logger.error(e.getMessage());
            }
        }
        return return_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long epmem_reverse_hash_int(long s_id_lookup) {
        long return_val = 0L;
        try {
            this.db.hash_rev_int.setLong(1, s_id_lookup);
            try (ResultSet res = this.db.hash_rev_int.executeQuery();){
                if (!res.next()) {
                    throw new AssertionError((Object)"Database query for unknown value");
                }
                return_val = res.getLong(1);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        return return_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double epmem_reverse_hash_float(long s_id_lookup) {
        double return_val = 0.0;
        try {
            this.db.hash_rev_float.setLong(1, s_id_lookup);
            try (ResultSet res = this.db.hash_rev_float.executeQuery();){
                if (!res.next()) {
                    throw new AssertionError((Object)"Database query for unknown value");
                }
                return_val = res.getDouble(1);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        return return_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String epmem_reverse_hash_str(long s_id_lookup) {
        String return_val = null;
        try {
            this.db.hash_rev_str.setLong(1, s_id_lookup);
            try (ResultSet res = this.db.hash_rev_str.executeQuery();){
                if (!res.next()) {
                    throw new AssertionError((Object)"Database query for unknown value");
                }
                return_val = res.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        return return_val;
    }

    SymbolImpl epmem_reverse_hash(long s_id_lookup) {
        return this.epmem_reverse_hash(s_id_lookup, 255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SymbolImpl epmem_reverse_hash(long s_id_lookup, int sym_type) {
        SymbolImpl return_val = null;
        if (sym_type == 255) {
            try {
                this.db.hash_get_type.setLong(1, s_id_lookup);
                try (ResultSet res = this.db.hash_get_type.executeQuery();){
                    if (!res.next()) {
                        throw new AssertionError((Object)"Database query for unknown value");
                    }
                    sym_type = res.getInt(1);
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage());
            }
        }
        switch (sym_type) {
            case 2: {
                String dest = this.epmem_reverse_hash_str(s_id_lookup);
                return_val = this.symbols.createString(dest);
                break;
            }
            case 3: {
                return_val = this.symbols.createInteger(this.epmem_reverse_hash_int(s_id_lookup));
                break;
            }
            case 4: {
                return_val = this.symbols.createDouble(this.epmem_reverse_hash_float(s_id_lookup));
                break;
            }
            default: {
                return_val = null;
            }
        }
        return return_val;
    }

    String epmem_reverse_hash_print(long s_id_lookup) {
        return this.epmem_reverse_hash_print(s_id_lookup, 255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String epmem_reverse_hash_print(long s_id_lookup, int sym_type) {
        Object return_val = null;
        String dest = null;
        if (sym_type == 255) {
            try {
                this.db.hash_get_type.setLong(1, s_id_lookup);
                try (ResultSet res = this.db.hash_get_type.executeQuery();){
                    if (!res.next()) {
                        throw new AssertionError((Object)"Database query for unknown value");
                    }
                    sym_type = res.getInt(1);
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage());
            }
        }
        switch (sym_type) {
            case 2: {
                dest = this.epmem_reverse_hash_str(s_id_lookup);
                break;
            }
            case 3: {
                dest = Long.toString(this.epmem_reverse_hash_int(s_id_lookup));
                break;
            }
            case 4: {
                dest = Double.toString(this.epmem_reverse_hash_float(s_id_lookup));
                break;
            }
            default: {
                return_val = null;
            }
        }
        return dest;
    }

    long epmem_temporal_hash(SymbolImpl sym) {
        return this.epmem_temporal_hash(sym, true);
    }

    long epmem_temporal_hash(SymbolImpl sym, boolean add_on_fail) {
        long return_val = 0L;
        if (sym.symbol_is_constant()) {
            if (sym.epmem_hash_id != 0L || sym.epmem_valid != this.epmem_validation) {
                sym.epmem_hash_id = 0L;
                sym.epmem_valid = this.epmem_validation;
                if (sym.asString() != null) {
                    return_val = this.epmem_temporal_hash_str(sym.asString().getValue(), add_on_fail);
                } else if (sym.asInteger() != null) {
                    return_val = this.epmem_temporal_hash_int(sym.asInteger().getValue(), add_on_fail);
                } else if (sym.asDouble() != null) {
                    return_val = this.epmem_temporal_hash_float(sym.asDouble().getValue(), add_on_fail);
                }
                sym.epmem_hash_id = return_val;
                sym.epmem_valid = this.epmem_validation;
            }
            return_val = sym.epmem_hash_id;
        }
        return return_val;
    }

    private void epmem_respond_to_cmd(boolean created_new_memory) throws SoarException, SQLException {
        if (this.db == null) {
            this.epmem_init_db();
        }
        IdentifierImpl state = this.decider.bottom_goal;
        LinkedHashSet cue_wmes = Sets.newLinkedHashSet();
        ArrayList meta_wmes = Lists.newArrayList();
        ArrayList retrieval_wmes = Lists.newArrayList();
        ByRef<Long> retrieve = ByRef.create(0L);
        ByRef<Object> next = new ByRef<Object>(null);
        ByRef<Object> previous = new ByRef<Object>(null);
        ByRef<Object> query = new ByRef<Object>(null);
        ByRef<Object> neg_query = new ByRef<Object>(null);
        ByRef<Object> filter = new ByRef<Object>(null);
        LinkedList prohibit = Lists.newLinkedList();
        ByRef<Long> before = ByRef.create(0L);
        ByRef<Long> after = ByRef.create(0L);
        ByRef<Object> store = new ByRef<Object>(null);
        LinkedHashSet currents = Sets.newLinkedHashSet();
        ByRef<Boolean> good_cue = ByRef.create(false);
        ByRef<Integer> path = ByRef.create(0);
        boolean do_wm_phase = false;
        while (state != null) {
            EpisodicMemoryStateInfo epmem_info = this.epmem_info(state);
            boolean new_cue = false;
            long wme_count = 0L;
            List<WmeImpl> cmds = null;
            DefaultMarker tc = DefaultMarker.create();
            LinkedList<IdentifierImpl> syms = new LinkedList<IdentifierImpl>();
            syms.add(epmem_info.epmem_cmd_header);
            while (!syms.isEmpty()) {
                SymbolImpl parent_sym = (SymbolImpl)syms.poll();
                List<WmeImpl> wmes = this.epmem_get_augs_of_id(parent_sym, tc);
                for (WmeImpl wme : wmes) {
                    ++wme_count;
                    if ((long)wme.timetag > epmem_info.last_cmd_time) {
                        new_cue = true;
                        epmem_info.last_cmd_time = wme.timetag;
                    }
                    if (wme.value.asIdentifier() == null) continue;
                    syms.add(wme.value.asIdentifier());
                }
                if (cmds == null) {
                    cmds = wmes;
                    continue;
                }
                wmes = null;
            }
            if (epmem_info.last_cmd_count != wme_count) {
                new_cue = true;
                epmem_info.last_cmd_count = wme_count;
            }
            if (new_cue) {
                this.epmem_clear_result(state);
                do_wm_phase = true;
            }
            if (new_cue && wme_count != 0L) {
                this._epmem_respond_to_cmd_parse(cmds, good_cue, path, retrieve, next, previous, query, neg_query, filter, prohibit, before, after, currents, cue_wmes, store);
                retrieval_wmes.clear();
                meta_wmes.clear();
                if (((Boolean)good_cue.value).booleanValue()) {
                    if ((Integer)path.value == 1) {
                        this.epmem_install_memory(state, (Long)retrieve.value, meta_wmes, retrieval_wmes);
                        this.stats.ncbr.set(this.stats.ncbr.get() + 1L);
                    } else if ((Integer)path.value == 2) {
                        if (next.value != null) {
                            this.epmem_install_memory(state, this.epmem_next_episode(epmem_info.last_memory), meta_wmes, retrieval_wmes);
                            this.stats.nexts.set(this.stats.nexts.get() + 1L);
                        } else {
                            this.epmem_install_memory(state, this.epmem_previous_episode(epmem_info.last_memory), meta_wmes, retrieval_wmes);
                            this.stats.prevs.set(this.stats.prevs.get() + 1L);
                        }
                        if (epmem_info.last_memory == 0L) {
                            this.epmem_buffer_add_wme(meta_wmes, epmem_info.epmem_result_header, this.predefinedSyms.epmem_sym_failure, next.value != null ? (SymbolImpl)next.value : (SymbolImpl)previous.value);
                        } else {
                            this.epmem_buffer_add_wme(meta_wmes, epmem_info.epmem_result_header, this.predefinedSyms.epmem_sym_success, next.value != null ? (SymbolImpl)next.value : (SymbolImpl)previous.value);
                        }
                    } else if ((Integer)path.value == 3) {
                        this.epmem_process_query(state, (SymbolImpl)query.value, (SymbolImpl)neg_query.value, (SymbolImpl)filter.value, prohibit, (Long)before.value, (Long)after.value, currents, cue_wmes, meta_wmes, retrieval_wmes);
                        this.stats.cbr.set(this.stats.cbr.get() + 1L);
                    } else if ((Integer)path.value == 4) {
                        if (!created_new_memory) {
                            this.epmem_new_episode();
                        }
                        this.epmem_buffer_add_wme(meta_wmes, epmem_info.epmem_result_header, this.predefinedSyms.epmem_sym_success, (SymbolImpl)store.value);
                    }
                } else {
                    this.epmem_buffer_add_wme(meta_wmes, epmem_info.epmem_result_header, this.predefinedSyms.epmem_sym_status, this.predefinedSyms.epmem_sym_bad_cmd);
                }
                prohibit.clear();
                if (!retrieval_wmes.isEmpty() || !meta_wmes.isEmpty()) {
                    this.epmem_process_buffered_wmes(state, cue_wmes, meta_wmes, retrieval_wmes);
                    meta_wmes.clear();
                    retrieval_wmes.clear();
                    do_wm_phase = true;
                }
                cue_wmes.clear();
            }
            if (cmds != null) {
                cmds = null;
            }
            state = state.goalInfo.higher_goal;
        }
        if (do_wm_phase) {
            this.decider.do_working_memory_phase();
        }
    }

    private void epmem_process_buffered_wmes(IdentifierImpl state, Set<WmeImpl> cue_wmes, List<WmeImpl.SymbolTriple> meta_wmes, List<WmeImpl.SymbolTriple> retrieval_wmes) {
        this._epmem_process_buffered_wme_list(state, cue_wmes, meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_wmes);
        this._epmem_process_buffered_wme_list(state, cue_wmes, retrieval_wmes, null);
    }

    private void _epmem_process_buffered_wme_list(IdentifierImpl state, Set<WmeImpl> cue_wmes, List<WmeImpl.SymbolTriple> my_list, Deque<Preference> epmem_wmes) {
        if (my_list.isEmpty()) {
            return;
        }
        Instantiation inst = SoarModule.make_fake_instantiation(state, cue_wmes, my_list);
        Preference pref = inst.preferences_generated;
        while (pref != null) {
            this.recognitionMemory.add_preference_to_tm(pref);
            state.goalInfo.addGoalPreference(pref);
            pref.on_goal_list = true;
            if (epmem_wmes != null) {
                epmem_wmes.add(pref);
            }
            pref = pref.inst_next;
        }
        if (epmem_wmes == null) {
            ByRef<Object> my_justification_list = new ByRef<Object>(null);
            this.chunker.chunk_instantiation(inst, false, my_justification_list);
            if (my_justification_list.value != null) {
                Preference just_pref = null;
                Instantiation next_justification = null;
                Instantiation my_justification = (Instantiation)my_justification_list.value;
                while (my_justification != null) {
                    next_justification = my_justification.nextInProdList;
                    if (my_justification.in_ms) {
                        my_justification.prod.instantiations = my_justification.insertAtHeadOfProdList(my_justification.prod.instantiations);
                    }
                    just_pref = my_justification.preferences_generated;
                    while (just_pref != null) {
                        this.recognitionMemory.add_preference_to_tm(just_pref);
                        if (this.wma.wma_enabled()) {
                            this.wma.wma_activate_wmes_in_pref(just_pref);
                        }
                        just_pref = just_pref.inst_next;
                    }
                    my_justification = next_justification;
                }
            }
        }
    }

    private void epmem_process_query(IdentifierImpl state, SymbolImpl query, SymbolImpl neg_query, SymbolImpl filter, List<Long> prohibit, long before, long after, Set<SymbolImpl> currents, Set<WmeImpl> cue_wmes, List<WmeImpl.SymbolTriple> meta_wmes, List<WmeImpl.SymbolTriple> retrieval_wmes) throws SQLException, SoarException {
        this.epmem_process_query(state, query, neg_query, filter, prohibit, before, after, currents, cue_wmes, meta_wmes, retrieval_wmes, 3);
    }

    private void epmem_process_query(IdentifierImpl state, SymbolImpl pos_query, SymbolImpl neg_query, SymbolImpl filter, List<Long> prohibits, long before, long after, Set<SymbolImpl> currents, Set<WmeImpl> cue_wmes, List<WmeImpl.SymbolTriple> meta_wmes, List<WmeImpl.SymbolTriple> retrieval_wmes, int level) throws SQLException, SoarException {
        if (pos_query == null) {
            this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_status, this.predefinedSyms.epmem_sym_bad_cmd);
            return;
        }
        if (before != 0L && after != 0L && before <= after) {
            this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_status, this.predefinedSyms.epmem_sym_bad_cmd);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\n==========================\n");
        }
        this.stats.last_considered.set(0L);
        this.stats.last_graph_matches.set(0L);
        if (!prohibits.isEmpty()) {
            Collections.sort(prohibits);
        }
        boolean do_graph_match = this.params.graph_match.get() == DefaultEpisodicMemoryParams.GraphMatchChoices.on;
        DefaultEpisodicMemoryParams.GmOrderingChoices gm_order = (DefaultEpisodicMemoryParams.GmOrderingChoices)((Object)this.params.gm_ordering.get());
        LinkedHashMap<WmeImpl, EpmemLiteral> literal_cache = new LinkedHashMap<WmeImpl, EpmemLiteral>();
        Map[] pedge_caches = new Map[]{new LinkedHashMap(), new LinkedHashMap()};
        SortedMap[] uedge_caches = new SortedMap[]{new TreeMap(), new TreeMap()};
        LinkedHashSet<EpmemInterval> interval_cleanup = new LinkedHashSet<EpmemInterval>();
        EpmemLiteral root_literal = new EpmemLiteral();
        LinkedHashSet<EpmemLiteral> leaf_literals = new LinkedHashSet<EpmemLiteral>();
        PriorityQueue<EpmemPEdge> pedge_pq = new PriorityQueue<EpmemPEdge>(11, new Comparator<EpmemPEdge>(){

            @Override
            public int compare(EpmemPEdge a, EpmemPEdge b) {
                if (a.time != b.time) {
                    return a.time < b.time ? 1 : -1;
                }
                return a.triple.compareTo(b.triple);
            }
        });
        PriorityQueue<EpmemInterval> interval_pq = new PriorityQueue<EpmemInterval>(11, new Comparator<EpmemInterval>(){

            @Override
            public int compare(EpmemInterval a, EpmemInterval b) {
                if (a.time != b.time) {
                    return a.time < b.time ? 1 : -1;
                }
                if (a.is_end_point == b.is_end_point) {
                    return a.uedge.triple.compareTo(b.uedge.triple);
                }
                return a.is_end_point == 1 ? 1 : -1;
            }
        });
        LinkedHashMap<SymbolImpl, Integer> symbol_num_incoming = new LinkedHashMap<SymbolImpl, Integer>();
        LinkedHashMap<EpmemSymbolNodePair, Integer> symbol_node_count = new LinkedHashMap<EpmemSymbolNodePair, Integer>();
        long best_episode = 0L;
        double best_score = 0.0;
        boolean best_graph_matched = false;
        long best_cardinality = 0L;
        LinkedHashMap<EpmemLiteral, EpmemNodePair> best_bindings = new LinkedHashMap<EpmemLiteral, EpmemNodePair>();
        double current_score = 0.0;
        long current_cardinality = 0L;
        LinkedList<EpmemLiteral> gm_ordering = new LinkedList<EpmemLiteral>();
        if (level > 1) {
            this.stats.qry_pos.set(0L);
            this.stats.qry_neg.set(0L);
            root_literal.id_sym = null;
            root_literal.value_sym = pos_query;
            root_literal.is_neg_q = 0L;
            root_literal.value_is_id = 1L;
            root_literal.is_leaf = false;
            root_literal.is_current = false;
            root_literal.attribute_s_id = -1L;
            root_literal.child_n_id = EPMEM_NODEID_ROOT;
            root_literal.weight = 0.0;
            root_literal.parents = new LinkedHashSet<EpmemLiteral>();
            root_literal.children = new LinkedHashSet<EpmemLiteral>();
            root_literal.matches = new TreeSet<EpmemNodePair>();
            root_literal.values = new LinkedHashMap<Long, Integer>();
            symbol_num_incoming.put(pos_query, 1);
            literal_cache.put(null, root_literal);
            LinkedHashSet<SymbolImpl> visiting = new LinkedHashSet<SymbolImpl>();
            visiting.add(pos_query);
            visiting.add(neg_query);
            for (int query_type = 0; query_type <= 1; ++query_type) {
                SymbolImpl query_root = null;
                switch (query_type) {
                    case 0: {
                        query_root = pos_query;
                        break;
                    }
                    case 1: {
                        query_root = neg_query;
                    }
                }
                if (query_root == null) continue;
                List<WmeImpl> children = this.epmem_get_augs_of_id(query_root, DefaultMarker.create());
                Iterator<WmeImpl> iterator = children.iterator();
                while (iterator.hasNext()) {
                    WmeImpl wme_iter = iterator.next();
                    EpmemLiteral child = this.epmem_build_dnf(wme_iter, literal_cache, leaf_literals, symbol_num_incoming, gm_ordering, currents, query_type, visiting, cue_wmes);
                    if (child == null) continue;
                    child.id_sym = pos_query;
                    child.parents.add(root_literal);
                    root_literal.children.add(child);
                }
            }
            this.stats.qry_lits.set(this.stats.qry_pos.get() + this.stats.qry_neg.get());
            double perfect_score = 0.0;
            int perfect_cardinality = 0;
            for (EpmemLiteral iter : leaf_literals) {
                if (iter.is_neg_q != 0L) continue;
                perfect_score += iter.weight;
                ++perfect_cardinality;
            }
            before = before == 0L ? this.stats.time.get() - 1L : --before;
            long current_episode = before;
            EpmemTriple triple = new EpmemTriple(-1L, -1L, EPMEM_NODEID_ROOT);
            EpmemPEdge root_pedge = new EpmemPEdge();
            root_pedge.triple = triple.copyEpmemTriple();
            root_pedge.value_is_id = 1;
            root_pedge.has_noncurrent = false;
            root_pedge.literals = new ConcurrentSkipListSet<EpmemLiteral>();
            root_pedge.literals.add(root_literal);
            root_pedge.sql = this.db.pool_dummy.getCopy();
            root_pedge.sql.setLong(1, Long.MAX_VALUE);
            root_pedge.sqlResults = root_pedge.sql.executeQuery();
            root_pedge.time = Long.MAX_VALUE;
            pedge_pq.add(root_pedge);
            pedge_caches[1].put(triple, root_pedge);
            EpmemUEdge root_uedge = new EpmemUEdge();
            root_uedge.triple = triple.copyEpmemTriple();
            root_uedge.value_is_id = 1L;
            root_uedge.has_noncurrent = false;
            root_uedge.activation_count = 0L;
            root_uedge.pedges = new LinkedHashSet<EpmemPEdge>();
            root_uedge.intervals = 1L;
            root_uedge.activated = false;
            uedge_caches[1].put(triple, root_uedge);
            EpmemInterval root_interval = new EpmemInterval();
            root_interval.uedge = root_uedge;
            root_interval.is_end_point = 1;
            root_interval.sql = this.db.pool_dummy.getCopy();
            root_interval.sql.setLong(1, before);
            root_interval.sqlResult = root_interval.sql.executeQuery();
            root_interval.time = before;
            interval_pq.add(root_interval);
            interval_cleanup.add(root_interval);
            if (logger.isDebugEnabled()) {
                logger.debug(this.epmem_print_retrieval_state(literal_cache, pedge_caches, uedge_caches));
            }
            block7: while (pedge_pq.size() != 0 && current_episode > after) {
                boolean changed_score = false;
                long next_edge = pedge_pq.peek().time;
                while (pedge_pq.size() != 0 && (pedge_pq.peek().time == next_edge || pedge_pq.peek().time >= current_episode)) {
                    EpmemUEdge uedge;
                    SortedMap uedge_cache;
                    EpmemUEdge uedge_iter;
                    EpmemPEdge pedge = pedge_pq.poll();
                    EpmemTriple triple2 = pedge.triple.copyEpmemTriple();
                    triple2.child_n_id = pedge.sqlResults.getMetaData().getColumnCount() > 1 ? pedge.sqlResults.getLong(2) : 0L;
                    if (logger.isDebugEnabled()) {
                        logger.debug("  EDGE " + triple2.parent_n_id + "-" + triple2.attribute_s_id + "-" + triple2.child_n_id);
                    }
                    if (pedge.value_is_id != 0) {
                        boolean created = false;
                        Iterator<EpmemLiteral> iterator = pedge.literals.iterator();
                        while (iterator.hasNext()) {
                            EpmemLiteral literal_iter;
                            EpmemLiteral literal = literal_iter = iterator.next();
                            for (EpmemLiteral child_iter : literal.children) {
                                created |= this.epmem_register_pedges(triple2.child_n_id, child_iter, pedge_pq, after, pedge_caches, uedge_caches);
                            }
                        }
                    }
                    if ((uedge_iter = (EpmemUEdge)(uedge_cache = uedge_caches[pedge.value_is_id]).get(triple2)) == null) {
                        boolean is_lti;
                        uedge = new EpmemUEdge();
                        uedge.triple = triple2.copyEpmemTriple();
                        uedge.value_is_id = pedge.value_is_id;
                        uedge.has_noncurrent = pedge.has_noncurrent;
                        uedge.activation_count = 0L;
                        uedge.pedges = new LinkedHashSet<EpmemPEdge>();
                        uedge.intervals = 0L;
                        uedge.activated = false;
                        boolean created = false;
                        long edge_id = pedge.sqlResults.getLong(1);
                        long promo_time = 0L;
                        boolean bl = is_lti = pedge.value_is_id != 0 && pedge.triple.child_n_id != -1L && pedge.triple.child_n_id != EPMEM_NODEID_ROOT;
                        if (is_lti) {
                            this.db.find_lti_promotion_time.setLong(1, triple2.child_n_id);
                            ResultSet results = this.db.find_lti_promotion_time.executeQuery();
                            if (results.next()) {
                                promo_time = results.getLong(1);
                            }
                            results.close();
                        }
                        int interval_type = 0;
                        while ((long)interval_type <= 2L) {
                            for (int point_type = 0; point_type <= 1; ++point_type) {
                                SoarPreparedStatement interval_sql = null;
                                interval_sql = is_lti ? this.db.pool_find_lti_queries[point_type][interval_type].getCopy() : this.db.pool_find_interval_queries[pedge.value_is_id][point_type][interval_type].getCopy();
                                int bind_pos = 1;
                                if (point_type == 1 && (long)interval_type == 1L) {
                                    interval_sql.setLong(bind_pos++, current_episode);
                                }
                                interval_sql.setLong(bind_pos++, edge_id);
                                if (is_lti && interval_type == 0) {
                                    interval_sql.setLong(bind_pos++, promo_time);
                                }
                                interval_sql.setLong(bind_pos++, current_episode);
                                ResultSet results = interval_sql.executeQuery();
                                if (results.next()) {
                                    EpmemInterval interval = new EpmemInterval();
                                    interval.is_end_point = point_type;
                                    interval.uedge = uedge;
                                    interval.time = results.getLong(1);
                                    if (is_lti && point_type == 0 && (long)interval_type != 2L && interval.time < promo_time) {
                                        interval.time = promo_time - 1L;
                                    }
                                    interval.sql = interval_sql;
                                    interval.sqlResult = results;
                                    interval_pq.add(interval);
                                    interval_cleanup.add(interval);
                                    ++uedge.intervals;
                                    created = true;
                                    continue;
                                }
                                results.close();
                                interval_sql.close();
                            }
                            ++interval_type;
                        }
                        if (created) {
                            if (is_lti) {
                                EpmemInterval start_interval = new EpmemInterval();
                                start_interval.uedge = uedge;
                                start_interval.is_end_point = 0;
                                start_interval.time = promo_time - 1L;
                                start_interval.sql = null;
                                interval_pq.add(start_interval);
                                interval_cleanup.add(start_interval);
                            }
                            uedge.pedges.add(pedge);
                            uedge_cache.put(triple2.copyEpmemTriple(), uedge);
                        } else {
                            uedge.pedges.clear();
                            uedge.pedges = null;
                        }
                    } else {
                        uedge = uedge_iter;
                        uedge.pedges.add(pedge);
                        if (uedge.activated && uedge.activation_count == 1L) {
                            Iterator<EpmemLiteral> created = pedge.literals.iterator();
                            while (created.hasNext()) {
                                EpmemLiteral lit_iter;
                                EpmemLiteral literal = lit_iter = created.next();
                                ByRef<Double> curScoreRef = new ByRef<Double>(current_score);
                                ByRef<Long> curCardinalityRef = new ByRef<Long>(current_cardinality);
                                changed_score |= this.epmem_satisfy_literal(literal, triple2.parent_n_id, triple2.child_n_id, curScoreRef, curCardinalityRef, symbol_node_count, uedge_caches, symbol_num_incoming);
                                current_score = (Double)curScoreRef.value;
                                current_cardinality = (Long)curCardinalityRef.value;
                            }
                        }
                    }
                    if (pedge.sql == null) continue;
                    if (pedge.sqlResults == null) {
                        ResultSet results;
                        pedge.sqlResults = results = pedge.sql.executeQuery();
                    }
                    if (pedge.sqlResults.next()) {
                        pedge.time = pedge.sqlResults.getMetaData().getColumnCount() > 2 ? pedge.sqlResults.getLong(3) : 0L;
                        pedge_pq.add(pedge);
                        continue;
                    }
                    pedge.sqlResults.close();
                    pedge.sqlResults = null;
                    pedge.sql.close();
                    pedge.sql = null;
                }
                long l = next_edge = pedge_pq.isEmpty() ? after : pedge_pq.peek().time;
                while (interval_pq.size() != 0 && interval_pq.peek().time > next_edge && current_episode > after) {
                    long next_episode;
                    if (logger.isDebugEnabled()) {
                        logger.debug("EPISODE " + current_episode);
                    }
                    while (interval_pq.size() != 0 && interval_pq.peek().time >= current_episode) {
                        EpmemPEdge pedge;
                        EpmemPEdge pedge_iter;
                        Iterator<EpmemPEdge> uedge_iter;
                        EpmemInterval interval = interval_pq.poll();
                        EpmemUEdge uedge = interval.uedge;
                        EpmemTriple triple3 = uedge.triple.copyEpmemTriple();
                        if (logger.isDebugEnabled()) {
                            logger.debug("  INTERVAL (" + (interval.is_end_point != 0 ? "end" : "start") + "): " + triple3.parent_n_id + "-" + triple3.attribute_s_id + "-" + triple3.child_n_id);
                        }
                        if (interval.is_end_point != 0) {
                            uedge.activated = true;
                            ++uedge.activation_count;
                            if (uedge.activation_count == 1L) {
                                uedge_iter = uedge.pedges.iterator();
                                while (uedge_iter.hasNext()) {
                                    pedge = pedge_iter = uedge_iter.next();
                                    Iterator<EpmemLiteral> iterator = pedge.literals.iterator();
                                    while (iterator.hasNext()) {
                                        EpmemLiteral lit_iter;
                                        EpmemLiteral literal = lit_iter = iterator.next();
                                        ByRef<Double> curScoreRef = new ByRef<Double>(current_score);
                                        ByRef<Long> curCardinalityRef = new ByRef<Long>(current_cardinality);
                                        changed_score |= this.epmem_satisfy_literal(literal, triple3.parent_n_id, triple3.child_n_id, curScoreRef, curCardinalityRef, symbol_node_count, uedge_caches, symbol_num_incoming);
                                        current_score = (Double)curScoreRef.value;
                                        current_cardinality = (Long)curCardinalityRef.value;
                                    }
                                }
                            }
                        } else {
                            uedge.activated = false;
                            --uedge.activation_count;
                            uedge_iter = uedge.pedges.iterator();
                            while (uedge_iter.hasNext()) {
                                pedge = pedge_iter = uedge_iter.next();
                                for (EpmemLiteral lit_iter : pedge.literals) {
                                    ByRef<Double> curScore = new ByRef<Double>(current_score);
                                    ByRef<Long> curCardinality = new ByRef<Long>(current_cardinality);
                                    changed_score |= this.epmem_unsatisfy_literal(lit_iter, triple3.parent_n_id, triple3.child_n_id, curScore, curCardinality, symbol_node_count);
                                    current_score = (Double)curScore.value;
                                    current_cardinality = (Long)curCardinality.value;
                                }
                            }
                        }
                        if (interval.sql == null) continue;
                        if (interval.sqlResult == null) {
                            interval.sqlResult = interval.sql.executeQuery();
                        }
                        if (interval.uedge.has_noncurrent && interval.sqlResult.next()) {
                            interval.time = interval.sqlResult.getInt(1);
                            interval_pq.add(interval);
                            continue;
                        }
                        interval.sqlResult.close();
                        interval.sqlResult = null;
                        interval.sql.close();
                        interval.sql = null;
                        --uedge.intervals;
                        if (uedge.intervals == 0L) continue;
                        interval_cleanup.remove(interval);
                    }
                    long next_interval = interval_pq.isEmpty() ? after : interval_pq.peek().time;
                    long l2 = next_episode = next_edge > next_interval ? next_edge : next_interval;
                    while (prohibits.size() != 0 && prohibits.get(prohibits.size() - 1) > current_episode) {
                        prohibits.remove(prohibits.size() - 1);
                    }
                    while (prohibits.size() != 0 && current_episode > next_episode && current_episode == prohibits.get(prohibits.size() - 1)) {
                        --current_episode;
                        prohibits.remove(prohibits.size() - 1);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace(this.epmem_print_retrieval_state(literal_cache, pedge_caches, uedge_caches));
                    }
                    this.stats.considered.set(this.stats.considered.get() + 1L);
                    this.stats.last_considered.set(this.stats.last_considered.get() + 1L);
                    this.trace.startNewLine().print(Trace.Category.EPMEM, "EpMem| Considering episode (time, cardinality, score) (" + current_episode + ", " + current_cardinality + ", " + current_score + ")");
                    if (current_episode > next_episode && changed_score && (best_episode == 0L || current_score > best_score || do_graph_match && current_score == best_score && !best_graph_matched)) {
                        boolean new_king = false;
                        if (best_episode == 0L || current_score > best_score) {
                            best_episode = current_episode;
                            best_score = current_score;
                            best_cardinality = current_cardinality;
                            new_king = true;
                        }
                        if (current_cardinality == (long)perfect_cardinality) {
                            boolean graph_matched = false;
                            if (do_graph_match) {
                                if (gm_order == DefaultEpisodicMemoryParams.GmOrderingChoices.undefined) {
                                    Collections.shuffle(gm_ordering, this.random);
                                } else if (gm_order == DefaultEpisodicMemoryParams.GmOrderingChoices.mcv) {
                                    Collections.sort(gm_ordering, new Comparator<EpmemLiteral>(){

                                        @Override
                                        public int compare(EpmemLiteral a, EpmemLiteral b) {
                                            return a.matches.size() < b.matches.size() ? -1 : 1;
                                        }
                                    });
                                }
                                best_bindings.clear();
                                Map[] bound_nodes = new Map[2];
                                for (int i = 0; i < bound_nodes.length; ++i) {
                                    bound_nodes[i] = new LinkedHashMap();
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.debug("  GRAPH MATCH");
                                    logger.debug(this.epmem_print_retrieval_state(literal_cache, pedge_caches, uedge_caches));
                                }
                                this.stats.graph_matches.set(this.stats.graph_matches.get() + 1L);
                                this.stats.last_graph_matches.set(this.stats.last_graph_matches.get() + 1L);
                                graph_matched = this.epmem_graph_match(gm_ordering, gm_ordering.listIterator(), best_bindings, bound_nodes, 2);
                            }
                            if (!do_graph_match || graph_matched) {
                                best_episode = current_episode;
                                best_graph_matched = true;
                                current_episode = 0L;
                                new_king = true;
                            }
                        }
                        if (new_king) {
                            this.trace.startNewLine().print(Trace.Category.EPMEM, "NEW KING (perfect, graph-match): (" + Boolean.toString(current_cardinality == (long)perfect_cardinality) + ", " + Boolean.toString(best_graph_matched) + ")");
                        }
                    }
                    if (current_episode == 0L) continue block7;
                    current_episode = next_episode;
                }
            }
            if (best_episode == 0L) {
                this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_failure, pos_query);
                if (neg_query != null) {
                    this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_failure, neg_query);
                }
            } else {
                this.stats.qry_ret.set(best_episode);
                this.stats.qry_card.set(best_cardinality);
                LinkedHashMap<Long, IntegerSymbolImpl> node_map_map = new LinkedHashMap<Long, IntegerSymbolImpl>();
                LinkedHashMap<Long, SymbolImpl> node_mem_map = new LinkedHashMap<Long, SymbolImpl>();
                SymbolImpl temp_sym = this.symbols.createInteger(leaf_literals.size());
                this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_cue_size, temp_sym);
                temp_sym = this.symbols.createInteger(best_cardinality);
                this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_match_cardinality, temp_sym);
                temp_sym = this.symbols.createDouble(best_score);
                this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_match_score, temp_sym);
                temp_sym = this.symbols.createDouble(best_score / perfect_score);
                this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_normalized_match_score, temp_sym);
                this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_success, pos_query);
                if (neg_query != null) {
                    this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_success, neg_query);
                }
                if (do_graph_match) {
                    temp_sym = this.symbols.createInteger(best_graph_matched ? 1 : 0);
                    this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_graph_match, temp_sym);
                    if (best_graph_matched) {
                        int levelLocal = this.epmem_info((IdentifierImpl)state).epmem_result_header.level;
                        IdentifierImpl mapping = this.symbols.make_new_identifier('M', level);
                        this.epmem_buffer_add_wme(meta_wmes, this.epmem_info((IdentifierImpl)state).epmem_result_header, this.predefinedSyms.epmem_sym_graph_match_mapping, mapping);
                        for (Map.Entry iter : best_bindings.entrySet()) {
                            if (((EpmemLiteral)iter.getKey()).value_is_id == 0L) continue;
                            temp_sym = this.symbols.make_new_identifier('N', level);
                            this.epmem_buffer_add_wme(meta_wmes, mapping, this.predefinedSyms.epmem_sym_graph_match_mapping_node, temp_sym);
                            this.epmem_buffer_add_wme(meta_wmes, temp_sym, this.predefinedSyms.epmem_sym_graph_match_mapping_cue, ((EpmemLiteral)iter.getKey()).value_sym);
                            node_map_map.put(((EpmemNodePair)iter.getValue()).second, (IntegerSymbolImpl)temp_sym);
                            node_mem_map.put(((EpmemNodePair)iter.getValue()).second, null);
                        }
                    }
                }
                if (level > 2) {
                    this.epmem_install_memory(state, best_episode, meta_wmes, retrieval_wmes, node_mem_map, filter);
                }
                if (best_graph_matched) {
                    for (Map.Entry iter : node_mem_map.entrySet()) {
                        SymbolImpl map_iter = (SymbolImpl)node_map_map.get(iter.getKey());
                        if (map_iter == null || iter.getValue() == null) continue;
                        this.epmem_buffer_add_wme(meta_wmes, map_iter, this.predefinedSyms.epmem_sym_retrieved, (SymbolImpl)iter.getValue());
                    }
                }
            }
        }
        for (EpmemInterval interval : interval_cleanup) {
            if (interval.sqlResult == null) continue;
            interval.sqlResult.close();
            interval.sqlResult = null;
            interval.sql.close();
            interval.sql = null;
        }
        for (int type = 0; type <= 1; ++type) {
            for (EpmemPEdge pedge : pedge_caches[type].values()) {
                if (pedge.sqlResults == null) continue;
                pedge.sqlResults.close();
                pedge.sqlResults = null;
                pedge.sql.close();
                pedge.sql = null;
            }
        }
    }

    private boolean epmem_graph_match(LinkedList<EpmemLiteral> dnf_array, ListIterator<EpmemLiteral> dnf_iter, Map<EpmemLiteral, EpmemNodePair> bindings, Map<Long, SymbolImpl>[] bound_nodes, int depth) {
        if (!dnf_iter.hasNext()) {
            return true;
        }
        EpmemLiteral literal = dnf_iter.next();
        dnf_iter.previous();
        if (bindings.containsKey(literal)) {
            return false;
        }
        ListIterator<EpmemLiteral> next_iter = dnf_array.listIterator(dnf_iter.nextIndex());
        next_iter.next();
        LinkedHashSet<Long> failed_parents = new LinkedHashSet<Long>();
        LinkedHashSet<Long> failed_children = new LinkedHashSet<Long>();
        for (EpmemNodePair match : literal.matches) {
            Object sb;
            long parent_n_id = match.first;
            long child_n_id = match.second;
            if (failed_parents.contains(parent_n_id)) continue;
            if (logger.isTraceEnabled()) {
                StringBuilder sb2 = new StringBuilder();
                for (int i = 0; i < depth; ++i) {
                    sb2.append("\t");
                }
                sb2.append("TRYING ").append(literal).append(" ").append(parent_n_id);
                logger.trace(sb2.toString());
            }
            boolean relations_okay = true;
            for (EpmemLiteral parent : literal.parents) {
                EpmemNodePair bind = bindings.get(parent);
                if (bind == null || bind.second == parent_n_id) continue;
                relations_okay = false;
                break;
            }
            if (!relations_okay) {
                if (logger.isTraceEnabled()) {
                    StringBuilder sb3 = new StringBuilder();
                    for (int i = 0; i < depth; ++i) {
                        sb3.append("\t");
                    }
                    sb3.append("PARENT CONSTRAINT FAIL");
                    logger.trace(sb3.toString());
                }
                failed_parents.add(parent_n_id);
                continue;
            }
            SymbolImpl binder = bound_nodes[(int)literal.value_is_id].get(child_n_id);
            if (binder != null && binder != literal.value_sym) {
                failed_children.add(child_n_id);
                continue;
            }
            if (logger.isTraceEnabled()) {
                sb = new StringBuilder();
                for (int i = 0; i < depth; ++i) {
                    ((StringBuilder)sb).append("\t");
                }
                ((StringBuilder)sb).append("TRYING ").append(literal).append(" ").append(parent_n_id).append(" ").append(child_n_id);
                logger.trace(((StringBuilder)sb).toString());
            }
            if (literal.child_n_id != -1L && literal.child_n_id != child_n_id) {
                relations_okay = false;
            }
            for (EpmemLiteral child : literal.children) {
                EpmemNodePair bind = bindings.get(child);
                if (bind == null || bind.first == child_n_id) continue;
                relations_okay = false;
                break;
            }
            if (!relations_okay) {
                sb = new StringBuilder();
                if (logger.isTraceEnabled()) {
                    for (int i = 0; i < depth; ++i) {
                        ((StringBuilder)sb).append("\t");
                    }
                    ((StringBuilder)sb).append("CHILD CONSTRAINT FAIL");
                    logger.trace(((StringBuilder)sb).toString());
                }
                failed_children.add(child_n_id);
                continue;
            }
            if (logger.isTraceEnabled()) {
                sb = new StringBuilder();
                for (int i = 0; i < depth; ++i) {
                    ((StringBuilder)sb).append("\t");
                }
                ((StringBuilder)sb).append(literal).append(" ").append(parent_n_id).append(" ").append(child_n_id);
            }
            bindings.put(literal, new EpmemNodePair(parent_n_id, child_n_id));
            bound_nodes[(int)literal.value_is_id].put(child_n_id, literal.value_sym);
            boolean list_satisfied = this.epmem_graph_match(dnf_array, next_iter, bindings, bound_nodes, depth + 1);
            if (list_satisfied) {
                return true;
            }
            bindings.remove(literal);
            bound_nodes[(int)literal.value_is_id].remove(child_n_id);
        }
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                sb.append("\t");
            }
            sb.append("EPIC FAIL");
            logger.trace(sb.toString());
        }
        return false;
    }

    private boolean epmem_unsatisfy_literal(EpmemLiteral literal, long parent, long child, ByRef<Double> current_score, ByRef<Long> current_cardinality, Map<EpmemSymbolNodePair, Integer> symbol_node_count) {
        EpmemNodePair enpair;
        boolean removedMatch;
        if (literal.matches.size() == 0) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("      RECURSING ON " + parent + " " + child + " " + literal);
        }
        if (removedMatch = literal.matches.remove(enpair = new EpmemNodePair(parent, child))) {
            int value = literal.values.get(child);
            literal.values.put(child, --value);
            if (value == 0) {
                literal.values.remove(child);
                if (literal.is_leaf) {
                    if (literal.matches.size() == 0) {
                        ByRef<Number> byRef = current_score;
                        byRef.value = (Double)byRef.value - literal.weight;
                        byRef = current_cardinality;
                        byRef.value = (Long)byRef.value - (long)(literal.is_neg_q != 0L ? -1 : 1);
                        if (logger.isDebugEnabled()) {
                            logger.debug("          NEW SCORE: " + current_score + ", " + current_cardinality);
                        }
                        return true;
                    }
                } else {
                    boolean changed_score = false;
                    EpmemSymbolNodePair match = new EpmemSymbolNodePair(literal.value_sym, child);
                    int match_value = symbol_node_count.get(match);
                    if (--match_value == 0) {
                        symbol_node_count.remove(match);
                    } else {
                        symbol_node_count.put(match, match_value);
                    }
                    if (literal.matches.size() == 0) {
                        for (EpmemLiteral child_lit : literal.children) {
                            for (EpmemNodePair node : child_lit.matches) {
                                changed_score |= this.epmem_unsatisfy_literal(child_lit, node.first, node.second, current_score, current_cardinality, symbol_node_count);
                            }
                        }
                    } else {
                        EpmemNodePair node_pair = new EpmemNodePair(child, -1L);
                        for (EpmemLiteral child_lit : literal.children) {
                            EpmemNodePair node = child_lit.matches.ceiling(node_pair);
                            if (node == null || node.first != child) continue;
                            changed_score |= this.epmem_unsatisfy_literal(child_lit, node.first, node.second, current_score, current_cardinality, symbol_node_count);
                        }
                    }
                    return changed_score;
                }
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean epmem_satisfy_literal(EpmemLiteral literal, long parent, long child, ByRef<Double> current_score, ByRef<Long> current_cardinality, Map<EpmemSymbolNodePair, Integer> symbol_node_count, SortedMap<EpmemTriple, EpmemUEdge>[] uedge_caches, Map<SymbolImpl, Integer> symbol_num_incoming) {
        Object match;
        boolean parents_satisfied;
        if (logger.isDebugEnabled()) {
            logger.debug("      RECURSING ON " + parent + " " + child + " " + literal);
        }
        boolean bl = parents_satisfied = literal.id_sym == null;
        if (!parents_satisfied) {
            Integer num_incoming = symbol_num_incoming.get(literal.id_sym);
            match = symbol_node_count.get(new EpmemSymbolNodePair(literal.id_sym, parent));
            if (match == null) return false;
            if (match != num_incoming) return false;
            boolean bl2 = true;
            parents_satisfied = bl2;
        }
        if (!parents_satisfied) return false;
        literal.matches.add(new EpmemNodePair(parent, child));
        Integer value = literal.values.get(child);
        if (value == null) {
            literal.values.put(child, 1);
            if (literal.is_leaf) {
                if (literal.matches.size() != 1) return false;
                match = current_score;
                ((ByRef)match).value = (Double)((ByRef)match).value + literal.weight;
                match = current_cardinality;
                ((ByRef)match).value = (Long)((ByRef)match).value + (long)(literal.is_neg_q != 0L ? -1 : 1);
                if (!logger.isDebugEnabled()) return true;
                logger.debug("          NEW SCORE: " + current_score + ", " + current_cardinality);
                return true;
            }
            boolean changed_score = false;
            EpmemSymbolNodePair matchKey = new EpmemSymbolNodePair(literal.value_sym, child);
            Integer match2 = symbol_node_count.get(matchKey);
            if (match2 == null) {
                symbol_node_count.put(matchKey, 1);
            } else {
                symbol_node_count.put(matchKey, match2 + 1);
            }
            Iterator<EpmemLiteral> iterator = literal.children.iterator();
            block0: while (iterator.hasNext()) {
                EpmemLiteral child_lit = iterator.next();
                SortedMap<EpmemTriple, EpmemUEdge> uedge_cache = uedge_caches[(int)child_lit.value_is_id];
                EpmemTriple child_triple = new EpmemTriple(child, child_lit.attribute_s_id, child_lit.child_n_id);
                EpmemUEdge child_uedge = null;
                if (child_lit.child_n_id == -1L) {
                    SortedMap<EpmemTriple, EpmemUEdge> tailMap = uedge_cache.tailMap(child_triple);
                    Iterator<Map.Entry<EpmemTriple, EpmemUEdge>> iterator2 = tailMap.entrySet().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block0;
                        Map.Entry<EpmemTriple, EpmemUEdge> entry = iterator2.next();
                        child_triple = entry.getKey();
                        child_uedge = entry.getValue();
                        if (child_triple.parent_n_id != child || child_triple.attribute_s_id != child_lit.attribute_s_id) continue block0;
                        if (!child_uedge.activated || literal.is_current && child_uedge.activation_count != 1L) continue;
                        changed_score |= this.epmem_satisfy_literal(child_lit, child_triple.parent_n_id, child_triple.child_n_id, current_score, current_cardinality, symbol_node_count, uedge_caches, symbol_num_incoming);
                    }
                }
                child_uedge = (EpmemUEdge)uedge_cache.get(child_triple);
                if (child_uedge == null || !child_uedge.activated || literal.is_current && child_uedge.activation_count != 1L) continue;
                changed_score |= this.epmem_satisfy_literal(child_lit, child_triple.parent_n_id, child_triple.child_n_id, current_score, current_cardinality, symbol_node_count, uedge_caches, symbol_num_incoming);
            }
            return changed_score;
        }
        literal.values.put(child, value + 1);
        return false;
    }

    private boolean epmem_register_pedges(long parent, EpmemLiteral literal, PriorityQueue<EpmemPEdge> pedge_pq, long after, Map<EpmemTriple, EpmemPEdge>[] pedge_caches, SortedMap<EpmemTriple, EpmemUEdge>[] uedge_caches) throws SQLException {
        Map<EpmemTriple, EpmemPEdge> pedge_cache;
        EpmemPEdge child_pedge;
        EpmemTriple triple = new EpmemTriple(parent, literal.attribute_s_id, literal.child_n_id);
        int is_edge = (int)literal.value_is_id;
        if (logger.isDebugEnabled()) {
            logger.debug("      RECURSING ON " + parent + " " + literal);
        }
        if ((child_pedge = (pedge_cache = pedge_caches[is_edge]).get(triple)) == null) {
            ResultSet results;
            int has_value = literal.child_n_id != -1L ? 1 : 0;
            SoarPreparedStatement pedge_sql = this.db.pool_find_edge_queries[is_edge][has_value].getCopy();
            int bind_pos = 1;
            if (is_edge == 0) {
                pedge_sql.setLong(bind_pos++, Long.MAX_VALUE);
            }
            pedge_sql.setLong(bind_pos++, triple.parent_n_id);
            pedge_sql.setLong(bind_pos++, triple.attribute_s_id);
            if (has_value != 0) {
                pedge_sql.setLong(bind_pos++, triple.child_n_id);
            }
            if (is_edge != 0) {
                pedge_sql.setLong(bind_pos++, after);
            }
            if ((results = pedge_sql.executeQuery()).next()) {
                child_pedge = new EpmemPEdge();
                child_pedge.triple = triple.copyEpmemTriple();
                child_pedge.value_is_id = (int)literal.value_is_id;
                child_pedge.has_noncurrent = !literal.is_current;
                child_pedge.sql = pedge_sql;
                child_pedge.literals = new ConcurrentSkipListSet<EpmemLiteral>();
                child_pedge.literals.add(literal);
                child_pedge.sqlResults = results;
                child_pedge.time = results.getLong(3);
                pedge_pq.add(child_pedge);
                pedge_cache.put(triple.copyEpmemTriple(), child_pedge);
                return true;
            }
            results.close();
            pedge_sql.close();
            return false;
        }
        if (!child_pedge.literals.contains(literal)) {
            child_pedge.literals.add(literal);
            if (!literal.is_current) {
                child_pedge.has_noncurrent = true;
            }
            if (!literal.is_leaf && literal.child_n_id == -1L) {
                boolean created = false;
                SortedMap<EpmemTriple, EpmemUEdge> uedge_cache = uedge_caches[is_edge];
                SortedMap<EpmemTriple, EpmemUEdge> uedge_iter = uedge_cache.tailMap(triple);
                for (Map.Entry entry : uedge_iter.entrySet()) {
                    EpmemTriple child_triple = (EpmemTriple)entry.getKey();
                    if (child_triple.parent_n_id != triple.parent_n_id || child_triple.attribute_s_id != triple.attribute_s_id) break;
                    EpmemUEdge child_uedge = (EpmemUEdge)entry.getValue();
                    if (child_triple.child_n_id == -1L || child_uedge.value_is_id == 0L) continue;
                    for (EpmemLiteral child_iter : literal.children) {
                        created |= this.epmem_register_pedges(child_triple.child_n_id, child_iter, pedge_pq, after, pedge_caches, uedge_caches);
                    }
                }
                return created;
            }
        }
        return true;
    }

    private String epmem_print_retrieval_state(Map<WmeImpl, EpmemLiteral> literals, Map<EpmemTriple, EpmemPEdge>[] pedge_caches, Map<EpmemTriple, EpmemUEdge>[] uedge_caches) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("digraph {\n");
        sb.append("node [style=\"filled\"];\n");
        sb.append("subgraph cluster_literals {\n");
        sb.append("node [fillcolor=\"#0084D1\"];\n");
        for (Map.Entry<WmeImpl, EpmemLiteral> entry : literals.entrySet()) {
            EpmemLiteral literal = entry.getValue();
            if (literal.id_sym == null) continue;
            sb.append("\"" + literal.value_sym + "\" [");
            if (literal.child_n_id == -1L) {
                sb.append("label=\"" + literal.value_sym + "\"");
            } else {
                sb.append("label=\"" + literal.child_n_id + "\"");
            }
            if (literal.value_is_id == 0L) {
                sb.append(", shape=\"rect\"");
            }
            if (literal.matches.isEmpty()) {
                sb.append(", penwidth=\"2.0\"");
            }
            if (literal.is_neg_q != 0L) {
                sb.append(", fillcolor=\"#C5000B\"");
            }
            sb.append("];\n");
            sb.append("\"" + literal.id_sym + "\" -> \"" + literal.value_sym + "\" [label=\"");
            if (literal.attribute_s_id == -1L) {
                sb.append("?");
            } else {
                sb.append(literal.attribute_s_id);
            }
            sb.append("\\n" + literal + "\"];\n");
        }
        sb.append("};\n");
        sb.append("subgraph cluster_uedges{\n");
        sb.append("node [fillcolor=\"#FFD320\"];\n");
        for (int type = 0; type <= 1; ++type) {
            Map<EpmemTriple, EpmemUEdge> uedge_cache = uedge_caches[type];
            for (Map.Entry entry : uedge_cache.entrySet()) {
                EpmemTriple epmemTriple = (EpmemTriple)entry.getKey();
                if (epmemTriple.child_n_id == EPMEM_NODEID_ROOT) continue;
                if (type == 0) {
                    sb.append("\"n" + epmemTriple.child_n_id + "\" [shape=\"rect\"];\n");
                }
                sb.append("\"e" + epmemTriple.parent_n_id + "\" -> \"" + (type == 0 ? "n" : "e") + epmemTriple.child_n_id + "\" [label=\"" + epmemTriple.attribute_s_id + "\"];\n");
            }
        }
        sb.append("};\n");
        sb.append("subgraph cluster_pedges {\n");
        sb.append("node [fillcolor=\"#008000\"];\n");
        HashMultimap parent_pedge_map = HashMultimap.create();
        for (int type = 0; type <= 1; ++type) {
            Map<EpmemTriple, EpmemPEdge> pedge_cache = pedge_caches[type];
            for (Map.Entry<EpmemTriple, EpmemPEdge> entry : pedge_cache.entrySet()) {
                EpmemTriple triple = entry.getKey();
                EpmemPEdge pedge = entry.getValue();
                if (triple.attribute_s_id == -1L) continue;
                sb.append("\"" + pedge + "\" [label=\"" + pedge + "\\n(" + triple.parent_n_id + ", " + triple.attribute_s_id + ", ");
                if (triple.child_n_id == -1L) {
                    sb.append("?");
                } else {
                    sb.append(triple.child_n_id);
                }
                sb.append(")\"");
                if (pedge.value_is_id == 0) {
                    sb.append(", shape=\"rect\"");
                }
                sb.append("];\n");
                for (EpmemLiteral literal : pedge.literals) {
                    sb.append("\"" + literal.value_sym + "\" -> \"" + pedge + "\";\n");
                }
                parent_pedge_map.put((Object)triple.parent_n_id, (Object)pedge);
            }
        }
        sb.append("};\n");
        LinkedHashSet<EpmemPEdgeNodePair> drawn = new LinkedHashSet<EpmemPEdgeNodePair>();
        for (int type = 0; type <= 1; ++type) {
            Map<EpmemTriple, EpmemUEdge> map = uedge_caches[type];
            for (Map.Entry<EpmemTriple, EpmemUEdge> entry : map.entrySet()) {
                EpmemTriple triple = entry.getKey();
                EpmemUEdge uedge = entry.getValue();
                if (triple.attribute_s_id == -1L) continue;
                for (EpmemPEdge pedge : uedge.pedges) {
                    EpmemPEdgeNodePair pair = new EpmemPEdgeNodePair(pedge, triple.parent_n_id);
                    if (!drawn.contains(pair)) {
                        drawn.add(pair);
                        sb.append("\"" + pedge + "\" -> \"e" + triple.parent_n_id + "\";\n");
                    }
                    sb.append("\"" + pedge + "\" -> \"" + (pedge.value_is_id != 0 ? "e" : "n") + triple.child_n_id + "\" [style=\"dashed\"];\n");
                    for (EpmemPEdge pedge_iter : parent_pedge_map.get((Object)triple.child_n_id)) {
                        sb.append("\"" + pedge + "\" -> \"" + pedge_iter + "\";\n");
                    }
                }
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EpmemLiteral epmem_build_dnf(WmeImpl cue_wme, Map<WmeImpl, EpmemLiteral> literal_cache, Set<EpmemLiteral> leaf_literals, Map<SymbolImpl, Integer> symbol_num_incoming, Deque<EpmemLiteral> gm_ordering, Set<SymbolImpl> currents, long query_type, Set<SymbolImpl> visiting, Set<WmeImpl> cue_wmes) throws SQLException {
        EpmemLiteral literal;
        SymbolImpl value;
        block18: {
            if (visiting.contains(cue_wme.value)) {
                return null;
            }
            if (literal_cache.containsKey(cue_wme)) {
                return literal_cache.get(cue_wme);
            }
            cue_wmes.add(cue_wme);
            value = cue_wme.value;
            literal = new EpmemLiteral();
            literal.parents = new LinkedHashSet<EpmemLiteral>();
            literal.children = new LinkedHashSet<EpmemLiteral>();
            IdentifierImpl identifier = value.asIdentifier();
            if (identifier == null) {
                literal.value_is_id = 0L;
                literal.is_leaf = true;
                literal.child_n_id = this.epmem_temporal_hash(value);
                leaf_literals.add(literal);
            } else {
                if (identifier.smem_lti != 0L) {
                    this.db.find_lti.setLong(1, identifier.getNameLetter());
                    this.db.find_lti.setLong(2, identifier.getNameNumber());
                    try (ResultSet results = this.db.find_lti.executeQuery();){
                        if (results.next()) {
                            literal.value_is_id = 1L;
                            literal.is_leaf = true;
                            literal.child_n_id = results.getLong(1);
                            leaf_literals.add(literal);
                            break block18;
                        }
                        literal.parents = null;
                        literal.children = null;
                        literal = null;
                        EpmemLiteral epmemLiteral = null;
                        return epmemLiteral;
                    }
                }
                List<WmeImpl> children = this.epmem_get_augs_of_id(value, DefaultMarker.create());
                literal.value_is_id = 1L;
                literal.child_n_id = -1L;
                if (children.isEmpty()) {
                    literal.is_leaf = true;
                    leaf_literals.add(literal);
                } else {
                    boolean cycle = false;
                    visiting.add(cue_wme.value);
                    for (WmeImpl wme_iter : children) {
                        EpmemLiteral child = this.epmem_build_dnf(wme_iter, literal_cache, leaf_literals, symbol_num_incoming, gm_ordering, currents, query_type, visiting, cue_wmes);
                        if (child != null) {
                            child.parents.add(literal);
                            literal.children.add(child);
                            continue;
                        }
                        cycle = true;
                    }
                    visiting.remove(cue_wme.value);
                    if (cycle && literal.children.isEmpty()) {
                        literal.parents = null;
                        literal.children = null;
                        literal = null;
                        return null;
                    }
                    literal.is_leaf = false;
                    Integer incomingCount = symbol_num_incoming.get(value);
                    if (incomingCount == null) {
                        incomingCount = 1;
                    } else {
                        Integer n = incomingCount;
                        Integer n2 = incomingCount = Integer.valueOf(incomingCount + 1);
                    }
                    symbol_num_incoming.put(value, incomingCount);
                }
            }
        }
        if (query_type == 0L) {
            this.stats.qry_pos.set(this.stats.qry_pos.get() + 1L);
            gm_ordering.offerFirst(literal);
        } else {
            this.stats.qry_neg.set(this.stats.qry_neg.get() + 1L);
        }
        literal.id_sym = cue_wme.id;
        literal.value_sym = cue_wme.value;
        literal.is_current = currents.contains(value);
        literal.attribute_s_id = this.epmem_temporal_hash(cue_wme.attr);
        literal.is_neg_q = query_type;
        literal.weight = (double)(literal.is_neg_q != 0L ? -1 : 1) * (this.params.balance.get() >= 0.99999999 ? 1.0 : cue_wme.wma.wma_get_wme_activation(cue_wme, true));
        literal.matches = new TreeSet<EpmemNodePair>();
        literal.values = new LinkedHashMap<Long, Integer>();
        literal_cache.put(cue_wme, literal);
        return literal;
    }

    private void epmem_buffer_add_wme(List<WmeImpl.SymbolTriple> my_list, SymbolImpl id, SymbolImpl attr, SymbolImpl value) {
        my_list.add(new WmeImpl.SymbolTriple(id, attr, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long epmem_previous_episode(long memory_id) {
        long return_val = 0L;
        if (memory_id != 0L) {
            PreparedStatement myQuery = this.db.prev_episode;
            try {
                myQuery.setLong(1, memory_id);
                try (ResultSet resultSet = myQuery.executeQuery();){
                    if (resultSet.next()) {
                        return_val = resultSet.getLong(1);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return return_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long epmem_next_episode(long memory_id) {
        long return_val = 0L;
        if (memory_id != 0L) {
            PreparedStatement myQuery = this.db.next_episode;
            try {
                myQuery.setLong(1, memory_id);
                try (ResultSet resultSet = myQuery.executeQuery();){
                    if (resultSet.next()) {
                        return_val = resultSet.getLong(1);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return return_val;
    }

    private void epmem_install_memory(IdentifierImpl state, long memory_id, List<WmeImpl.SymbolTriple> meta_wmes, List<WmeImpl.SymbolTriple> retrieval_wmes) throws SQLException, SoarException {
        this.epmem_install_memory(state, memory_id, meta_wmes, retrieval_wmes, null);
    }

    private void epmem_install_memory(IdentifierImpl state, long memory_id, List<WmeImpl.SymbolTriple> meta_wmes, List<WmeImpl.SymbolTriple> retrieval_wmes, Map<Long, SymbolImpl> id_record) throws SQLException, SoarException {
        this.epmem_install_memory(state, memory_id, meta_wmes, retrieval_wmes, id_record, null);
    }

    private void epmem_install_memory(IdentifierImpl state, long memory_id, List<WmeImpl.SymbolTriple> meta_wmes, List<WmeImpl.SymbolTriple> retrieval_wmes, Map<Long, SymbolImpl> id_record, SymbolImpl filter) throws SQLException, SoarException {
        EpmemEdge orphan;
        WmeImpl childWme;
        Iterator<Wme> it;
        SymbolBooleanPair id_p;
        long parent_n_id;
        EpisodicMemoryStateInfo epmemInfo = this.epmem_info(state);
        IdentifierImpl result_header = epmemInfo.epmem_result_header;
        long num_wmes = 0L;
        this.stats.ncb_wmes.set(num_wmes);
        if (memory_id == 0L || !this.epmem_valid_episode(memory_id)) {
            this.epmem_buffer_add_wme(meta_wmes, result_header, this.predefinedSyms.epmem_sym_retrieved, this.predefinedSyms.epmem_sym_no_memory);
            epmemInfo.last_memory = 0L;
            return;
        }
        epmemInfo.last_memory = memory_id;
        IdentifierImpl retrieved_header = this.symbols.make_new_identifier('R', ((SymbolImpl)result_header).asIdentifier().level);
        if (id_record != null) {
            id_record.put(EPMEM_NODEID_ROOT, retrieved_header);
        }
        this.epmem_buffer_add_wme(meta_wmes, result_header, this.predefinedSyms.epmem_sym_retrieved, retrieved_header);
        IntegerSymbolImpl my_meta = this.symbols.createInteger(memory_id);
        this.epmem_buffer_add_wme(meta_wmes, result_header, this.predefinedSyms.epmem_sym_memory_id, my_meta);
        my_meta = this.symbols.createInteger(this.stats.time.get());
        this.epmem_buffer_add_wme(meta_wmes, result_header, this.predefinedSyms.epmem_sym_present_id, my_meta);
        LinkedHashMap<Long, SymbolBooleanPair> ids = new LinkedHashMap<Long, SymbolBooleanPair>();
        boolean dont_abide_by_ids_second = this.params.merge.get() == DefaultEpisodicMemoryParams.MergeChoices.add;
        HashSet<IdentifierImpl> passedFilter = null;
        HashMap filterParents = null;
        if (filter != null) {
            filterParents = new HashMap();
            passedFilter = new HashSet<IdentifierImpl>();
        }
        SymbolImpl attr = null;
        ids.put(EPMEM_NODEID_ROOT, new SymbolBooleanPair(retrieved_header, true));
        if (filter != null) {
            HashSet<SymbolImpl> initialFilter = new HashSet<SymbolImpl>();
            initialFilter.add(filter);
            filterParents.put(((SymbolImpl)retrieved_header).asIdentifier(), initialFilter);
        }
        PreparedStatement my_q = this.db.get_wmes_with_identifier_values;
        boolean val_is_short_term = false;
        char val_letter = '\u0000';
        long val_num = 0L;
        LinkedList<EpmemEdge> orphans = new LinkedList<EpmemEdge>();
        this.epmem_rit_prep_left_right(memory_id, memory_id, this.epmem_rit_state_graph[1]);
        my_q.setLong(1, memory_id);
        my_q.setLong(2, memory_id);
        my_q.setLong(3, memory_id);
        my_q.setLong(4, memory_id);
        my_q.setLong(5, memory_id);
        ResultSet resultSet = my_q.executeQuery();
        while (resultSet.next()) {
            parent_n_id = resultSet.getLong(1);
            long child_n_id = resultSet.getLong(3);
            attr = this.epmem_reverse_hash(resultSet.getLong(2));
            char tempValLetter = (char)resultSet.getLong(4);
            val_is_short_term = resultSet.wasNull();
            if (!val_is_short_term) {
                val_letter = tempValLetter;
                val_num = resultSet.getLong(5);
            }
            if ((id_p = (SymbolBooleanPair)ids.get(parent_n_id)) != null) {
                boolean should_install;
                if (!dont_abide_by_ids_second && !id_p.second) continue;
                HashSet<Slot> filterSlots = null;
                if (filter == null) {
                    should_install = true;
                } else {
                    should_install = false;
                    IdentifierImpl memoryId = id_p.first.asIdentifier();
                    if (passedFilter.contains(memoryId)) {
                        should_install = true;
                    } else {
                        Set filterIdSet = (Set)filterParents.get(memoryId);
                        if (filterIdSet != null) {
                            block1: for (Object filterSym : filterIdSet) {
                                IdentifierImpl filterId = ((SymbolImpl)filterSym).asIdentifier();
                                Slot slot = Slot.find_slot(filterId, attr);
                                if (slot == null) continue;
                                it = slot.getWmeIterator();
                                while (it.hasNext()) {
                                    childWme = (WmeImpl)it.next();
                                    if (childWme.value.asIdentifier() == null) continue;
                                    if (filterSlots == null) {
                                        filterSlots = new HashSet<Slot>();
                                    }
                                    filterSlots.add(slot);
                                    should_install = true;
                                    continue block1;
                                }
                            }
                        }
                    }
                }
                if (!should_install) continue;
                this._epmem_install_id_wme(id_p.first, attr, ids, child_n_id, val_is_short_term, val_letter, val_num, id_record, retrieval_wmes);
                ++num_wmes;
                if (filterSlots != null) {
                    Object filterSym;
                    SymbolImpl childMemorySym = ((SymbolBooleanPair)ids.get((Object)Long.valueOf((long)child_n_id))).first;
                    IdentifierImpl childMemoryId = childMemorySym.asIdentifier();
                    HashSet<SymbolImpl> currentFilterList = (HashSet<SymbolImpl>)filterParents.get(childMemorySym);
                    if (currentFilterList == null) {
                        currentFilterList = new HashSet<SymbolImpl>();
                        filterParents.put(childMemoryId, currentFilterList);
                    }
                    filterSym = filterSlots.iterator();
                    while (filterSym.hasNext()) {
                        Slot filterSlot = (Slot)filterSym.next();
                        Iterator<Wme> it2 = filterSlot.getWmeIterator();
                        while (it2.hasNext()) {
                            WmeImpl childWme2 = (WmeImpl)it2.next();
                            SymbolImpl childSym = childWme2.value;
                            IdentifierImpl childId = childSym.asIdentifier();
                            if (childId == null) continue;
                            if (childId.slots == null) {
                                passedFilter.add(childMemoryId);
                                continue;
                            }
                            currentFilterList.add(childSym);
                        }
                    }
                    continue;
                }
                if (filter == null) continue;
                passedFilter.add(((SymbolBooleanPair)ids.get((Object)Long.valueOf((long)child_n_id))).first.asIdentifier());
                continue;
            }
            orphan = new EpmemEdge();
            orphan.parent_n_id = parent_n_id;
            orphan.attribute = attr;
            orphan.child_n_id = child_n_id;
            orphan.val_letter = '\u0000';
            orphan.val_num = 0L;
            orphan.val_is_short_term = val_is_short_term;
            if (!val_is_short_term) {
                orphan.val_letter = val_letter;
                orphan.val_num = val_num;
            }
            orphans.add(orphan);
        }
        resultSet.close();
        this.epmem_rit_clear_left_right();
        if (!orphans.isEmpty()) {
            int orphans_left;
            LinkedList<EpmemEdge> still_orphans = new LinkedList<EpmemEdge>();
            do {
                orphans_left = orphans.size();
                while (!orphans.isEmpty()) {
                    orphan = (EpmemEdge)orphans.poll();
                    id_p = (SymbolBooleanPair)ids.get(orphan.parent_n_id);
                    if (id_p != null) {
                        boolean should_install;
                        if (!dont_abide_by_ids_second && !id_p.second) continue;
                        HashSet<Slot> filterSlots = null;
                        if (filter == null) {
                            should_install = true;
                        } else {
                            should_install = false;
                            IdentifierImpl memoryId = id_p.first.asIdentifier();
                            if (passedFilter.contains(memoryId)) {
                                should_install = true;
                            } else {
                                Set filterIdSet = (Set)filterParents.get(memoryId);
                                if (filterIdSet != null) {
                                    block7: for (SymbolImpl filterSym : filterIdSet) {
                                        IdentifierImpl filterId = filterSym.asIdentifier();
                                        Slot slot = Slot.find_slot(filterId, attr);
                                        if (slot == null) continue;
                                        Iterator<Wme> it3 = slot.getWmeIterator();
                                        while (it3.hasNext()) {
                                            WmeImpl childWme3 = (WmeImpl)it3.next();
                                            if (childWme3.value.asIdentifier() == null) continue;
                                            if (filterSlots == null) {
                                                filterSlots = new HashSet<Slot>();
                                            }
                                            filterSlots.add(slot);
                                            should_install = true;
                                            continue block7;
                                        }
                                    }
                                }
                            }
                        }
                        if (!should_install) continue;
                        this._epmem_install_id_wme(id_p.first, orphan.attribute, ids, orphan.child_n_id, orphan.val_is_short_term, orphan.val_letter, orphan.val_num, id_record, retrieval_wmes);
                        ++num_wmes;
                        if (filterSlots != null) {
                            SymbolImpl childMemorySym = ((SymbolBooleanPair)ids.get((Object)Long.valueOf((long)orphan.child_n_id))).first;
                            IdentifierImpl childMemoryId = childMemorySym.asIdentifier();
                            HashSet<SymbolImpl> currentFilterList = (HashSet<SymbolImpl>)filterParents.get(childMemorySym);
                            if (currentFilterList == null) {
                                currentFilterList = new HashSet<SymbolImpl>();
                                filterParents.put(childMemoryId, currentFilterList);
                            }
                            for (Slot filterSlot : filterSlots) {
                                it = filterSlot.getWmeIterator();
                                while (it.hasNext()) {
                                    childWme = (WmeImpl)it.next();
                                    SymbolImpl childSym = childWme.value;
                                    IdentifierImpl childId = childSym.asIdentifier();
                                    if (childId == null) continue;
                                    if (childId.slots == null) {
                                        passedFilter.add(childMemoryId);
                                        continue;
                                    }
                                    currentFilterList.add(childSym);
                                }
                            }
                            continue;
                        }
                        if (filter == null) continue;
                        passedFilter.add(((SymbolBooleanPair)ids.get((Object)Long.valueOf((long)orphan.child_n_id))).first.asIdentifier());
                        continue;
                    }
                    still_orphans.add(orphan);
                }
                orphans.addAll(still_orphans);
                still_orphans.clear();
            } while (!orphans.isEmpty() && orphans_left != orphans.size());
        }
        my_q = this.db.get_wmes_with_constant_values;
        SymbolImpl value = null;
        this.epmem_rit_prep_left_right(memory_id, memory_id, this.epmem_rit_state_graph[0]);
        my_q.setLong(1, memory_id);
        my_q.setLong(2, memory_id);
        my_q.setLong(3, memory_id);
        my_q.setLong(4, memory_id);
        ResultSet resultSet2 = my_q.executeQuery();
        while (resultSet2.next()) {
            boolean should_install;
            parent_n_id = resultSet2.getLong(2);
            SymbolBooleanPair parent = (SymbolBooleanPair)ids.get(parent_n_id);
            if (parent == null || !dont_abide_by_ids_second && !parent.second) continue;
            attr = this.epmem_reverse_hash(resultSet2.getLong(3));
            value = this.epmem_reverse_hash(resultSet2.getLong(4));
            if (filter == null) {
                should_install = true;
            } else {
                should_install = false;
                IdentifierImpl memoryId = parent.first.asIdentifier();
                if (passedFilter.contains(memoryId)) {
                    should_install = true;
                } else {
                    Set filterIdSet = (Set)filterParents.get(memoryId);
                    if (filterIdSet != null) {
                        for (SymbolImpl filterSym : filterIdSet) {
                            IdentifierImpl filterId = filterSym.asIdentifier();
                            Slot slot = Slot.find_slot(filterId, attr);
                            if (slot == null) continue;
                            Iterator<Wme> it4 = slot.getWmeIterator();
                            while (it4.hasNext()) {
                                WmeImpl childWme4 = (WmeImpl)it4.next();
                                IdentifierImpl valueId = childWme4.value.asIdentifier();
                                if (valueId != null && valueId.slots == null) {
                                    passedFilter.add(memoryId);
                                    should_install = true;
                                    break;
                                }
                                if (!DefaultEpisodicMemory.compare_symbol(childWme4.value, value)) continue;
                                should_install = true;
                                break;
                            }
                            if (!should_install) continue;
                            break;
                        }
                    }
                }
            }
            if (!should_install) continue;
            this.epmem_buffer_add_wme(retrieval_wmes, parent.first, attr, value);
            ++num_wmes;
        }
        resultSet2.close();
        this.epmem_rit_clear_left_right();
        if (filter != null) {
            int oldSize;
            int goodIndex = retrieval_wmes.size();
            int i = 0;
            while (i < goodIndex) {
                WmeImpl.SymbolTriple wme = retrieval_wmes.get(i);
                if (wme.value.asIdentifier() == null) {
                    passedFilter.add(wme.id.asIdentifier());
                }
                if (passedFilter.contains(wme.id)) {
                    Collections.swap(retrieval_wmes, i, --goodIndex);
                    continue;
                }
                ++i;
            }
            do {
                oldSize = goodIndex;
                i = 0;
                while (i < goodIndex) {
                    WmeImpl.SymbolTriple wme = retrieval_wmes.get(i);
                    if (passedFilter.contains(wme.value)) {
                        Collections.swap(retrieval_wmes, i, --goodIndex);
                        passedFilter.add(wme.id.asIdentifier());
                        continue;
                    }
                    ++i;
                }
            } while (oldSize != goodIndex);
            retrieval_wmes.subList(0, goodIndex).clear();
        }
        this.stats.ncb_wmes.set(num_wmes);
    }

    private void epmem_rit_clear_left_right() throws SQLException {
        this.db.rit_truncate_left.execute();
        this.db.rit_truncate_right.execute();
    }

    private void _epmem_install_id_wme(SymbolImpl parent, SymbolImpl attr, Map<Long, SymbolBooleanPair> ids, long child_n_id, boolean val_is_short_term, char val_letter, long val_num, Map<Long, SymbolImpl> id_record, List<WmeImpl.SymbolTriple> retrieval_wmes) throws SoarException {
        boolean existing_identifier;
        SymbolBooleanPair id_p = ids.get(child_n_id);
        boolean bl = existing_identifier = id_p != null;
        if (val_is_short_term) {
            if (!existing_identifier) {
                if (!ids.containsKey(child_n_id)) {
                    ids.put(child_n_id, new SymbolBooleanPair(this.symbols.make_new_identifier(Symbols.getSymbolType(attr) == 2 ? (char)attr.getFirstLetter() : (char)'E', parent.asIdentifier().level), true));
                }
                id_p = ids.get(child_n_id);
                if (id_record != null && id_record.containsKey(child_n_id)) {
                    id_record.put(child_n_id, id_p.first);
                }
            }
            this.epmem_buffer_add_wme(retrieval_wmes, parent, attr, id_p.first);
        } else if (existing_identifier) {
            this.epmem_buffer_add_wme(retrieval_wmes, parent, attr, id_p.first);
        } else {
            IdentifierImpl value = this.smem.smem_lti_soar_make(this.smem.smem_lti_get_id(val_letter, val_num), val_letter, val_num, parent.asIdentifier().level);
            if (id_record != null && id_record.containsKey(child_n_id)) {
                id_record.put(child_n_id, value);
            }
            this.epmem_buffer_add_wme(retrieval_wmes, parent, attr, value);
            ids.put(child_n_id, new SymbolBooleanPair(value, (((SymbolImpl)value).asIdentifier().goalInfo == null || ((SymbolImpl)value).asIdentifier().goalInfo.getImpasseWmes() == null) && ((SymbolImpl)value).asIdentifier().getInputWmes() == null && ((SymbolImpl)value).asIdentifier().slots == null));
        }
    }

    private void epmem_rit_prep_left_right(long lower, long upper, epmem_rit_state rit_state) throws SQLException {
        long offset = rit_state.offset.stat;
        this.epmem_rit_add_left(lower -= offset, upper -= offset);
        long node = 0L;
        long step = 0L;
        if (lower > node || upper < node) {
            if (lower > node) {
                node = rit_state.rightroot.stat;
                this.epmem_rit_add_left(0L, 0L);
            } else {
                node = rit_state.leftroot.stat;
                this.epmem_rit_add_right(0L);
            }
            for (step = (node >= 0L ? node : -1L * node) / 2L; step >= 1L; step /= 2L) {
                if (lower > node) {
                    this.epmem_rit_add_left(node, node);
                    node += step;
                    continue;
                }
                if (upper >= node) break;
                this.epmem_rit_add_right(node);
                node -= step;
            }
        }
        long left_node = node - step;
        for (long left_step = step / 2L; left_step >= 1L && lower != left_node; left_step /= 2L) {
            if (lower > left_node) {
                this.epmem_rit_add_left(left_node, left_node);
                left_node += left_step;
                continue;
            }
            left_node -= left_step;
        }
        long right_node = node + step;
        for (long right_step = step / 2L; right_step >= 1L && upper != right_node; right_step /= 2L) {
            if (upper < right_node) {
                this.epmem_rit_add_right(right_node);
                right_node -= right_step;
                continue;
            }
            right_node += right_step;
        }
    }

    private void epmem_rit_add_right(long id) throws SQLException {
        this.db.rit_add_right.setLong(1, id);
        this.db.rit_add_right.execute();
    }

    private void epmem_rit_add_left(long min, long max) throws SQLException {
        this.db.rit_add_left.setLong(1, min);
        this.db.rit_add_left.setLong(2, max);
        this.db.rit_add_left.execute();
    }

    private boolean epmem_valid_episode(long memory_id) throws SQLException {
        boolean return_val = false;
        PreparedStatement my_q = this.db.valid_episode;
        my_q.setLong(1, memory_id);
        ResultSet resultSet = my_q.executeQuery();
        resultSet.next();
        return_val = resultSet.getLong(1) > 0L;
        resultSet.close();
        return return_val;
    }

    private void _epmem_respond_to_cmd_parse(List<WmeImpl> cmds, ByRef<Boolean> good_cue, ByRef<Integer> path, ByRef<Long> retrieve, ByRef<SymbolImpl> next, ByRef<SymbolImpl> previous, ByRef<SymbolImpl> query, ByRef<SymbolImpl> neg_query, ByRef<SymbolImpl> filter, List<Long> prohibit, ByRef<Long> before, ByRef<Long> after, Set<SymbolImpl> currents, Set<WmeImpl> cue_wmes, ByRef<SymbolImpl> store) {
        cue_wmes.clear();
        retrieve.value = 0L;
        prohibit.clear();
        before.value = 0L;
        after.value = 0L;
        good_cue.value = true;
        path.value = 0;
        for (WmeImpl w_p : cmds) {
            cue_wmes.add(w_p);
            if (!((Boolean)good_cue.value).booleanValue()) continue;
            if (w_p.attr == this.predefinedSyms.epmem_sym_retrieve) {
                if (w_p.getValue().asInteger() != null && (Integer)path.value == 0 && w_p.value.asInteger().getValue() > 0L) {
                    retrieve.value = w_p.value.asInteger().getValue();
                    path.value = 1;
                    continue;
                }
                good_cue.value = false;
                continue;
            }
            if (w_p.attr == this.predefinedSyms.epmem_sym_next) {
                if (w_p.getValue().asIdentifier() != null && (Integer)path.value == 0) {
                    next.value = w_p.value;
                    path.value = 2;
                    continue;
                }
                good_cue.value = false;
                continue;
            }
            if (w_p.attr == this.predefinedSyms.epmem_sym_prev) {
                if (w_p.getValue().asIdentifier() != null && (Integer)path.value == 0) {
                    previous.value = w_p.value;
                    path.value = 2;
                    continue;
                }
                good_cue.value = false;
                continue;
            }
            if (w_p.attr == this.predefinedSyms.epmem_sym_query) {
                if (w_p.getValue().asIdentifier() != null && ((Integer)path.value == 0 || (Integer)path.value == 3) && query.value == null) {
                    query.value = w_p.value;
                    path.value = 3;
                    continue;
                }
                good_cue.value = false;
                continue;
            }
            if (w_p.attr == this.predefinedSyms.epmem_sym_negquery) {
                if (w_p.getValue().asIdentifier() != null && ((Integer)path.value == 0 || (Integer)path.value == 3) && neg_query.value == null) {
                    neg_query.value = w_p.value;
                    path.value = 3;
                    continue;
                }
                good_cue.value = false;
                continue;
            }
            if (w_p.attr == this.predefinedSyms.epmem_sym_filter) {
                if (w_p.getValue().asIdentifier() != null && ((Integer)path.value == 0 || (Integer)path.value == 3) && filter.value == null) {
                    filter.value = w_p.value;
                    path.value = 3;
                    continue;
                }
                good_cue.value = false;
                continue;
            }
            if (w_p.attr == this.predefinedSyms.epmem_sym_before) {
                if (w_p.getValue().asInteger() != null && ((Integer)path.value == 0 || (Integer)path.value == 3)) {
                    if ((Long)before.value == 0L || w_p.value.asInteger().getValue() < (Long)before.value) {
                        before.value = w_p.value.asInteger().getValue();
                    }
                    path.value = 3;
                    continue;
                }
                good_cue.value = false;
                continue;
            }
            if (w_p.attr == this.predefinedSyms.epmem_sym_after) {
                if (w_p.getValue().asInteger() != null && ((Integer)path.value == 0 || (Integer)path.value == 3)) {
                    if ((Long)after.value < w_p.value.asInteger().getValue()) {
                        after.value = w_p.value.asInteger().getValue();
                    }
                    path.value = 3;
                    continue;
                }
                good_cue.value = false;
                continue;
            }
            if (w_p.attr == this.predefinedSyms.epmem_sym_prohibit) {
                if (w_p.getValue().asInteger() != null && ((Integer)path.value == 0 || (Integer)path.value == 3)) {
                    prohibit.add(w_p.value.asInteger().getValue());
                    path.value = 3;
                    continue;
                }
                good_cue.value = false;
                continue;
            }
            if (w_p.attr == this.predefinedSyms.epmem_sym_current) {
                if (w_p.getValue().asIdentifier() != null && ((Integer)path.value == 0 || (Integer)path.value == 3)) {
                    currents.add(w_p.value);
                    path.value = 3;
                    continue;
                }
                good_cue.value = false;
                continue;
            }
            if (w_p.attr == this.predefinedSyms.epmem_sym_store) {
                if ((Integer)path.value == 0) {
                    store.value = w_p.value;
                    path.value = 4;
                    continue;
                }
                good_cue.value = false;
                continue;
            }
            good_cue.value = false;
        }
        if ((Integer)path.value == 3 && query == null) {
            good_cue.value = false;
        }
        if ((Integer)path.value == 0) {
            good_cue.value = false;
        }
    }

    private void epmem_clear_result(IdentifierImpl state) {
        Deque<Preference> wmes = this.epmem_info((IdentifierImpl)state).epmem_wmes;
        while (!wmes.isEmpty()) {
            Preference pref = wmes.removeLast();
            if (!pref.isInTempMemory()) continue;
            this.recognitionMemory.remove_preference_from_tm(pref);
        }
    }

    private EpisodicMemoryStateInfo epmem_info(IdentifierImpl state) {
        return this.stateInfos.get(state);
    }

    @Override
    public boolean epmem_enabled() {
        return this.params.learning.get() == DefaultEpisodicMemoryParams.Learning.on;
    }

    @Override
    public boolean encodeInOutputPhase() {
        return this.params.phase.get() == DefaultEpisodicMemoryParams.Phase.output;
    }

    @Override
    public boolean encodeInSelectionPhase() {
        return this.params.phase.get() == DefaultEpisodicMemoryParams.Phase.selection;
    }

    @Override
    public long epmem_validation() {
        return this.epmem_validation;
    }

    @Override
    public boolean addIdRefCount(long id, WmeImpl w) {
        Set<WmeImpl> wmes = this.epmem_id_ref_counts.get(id);
        if (wmes == null) {
            return false;
        }
        wmes.add(w);
        return true;
    }

    @Override
    public void addWme(IdentifierImpl id) {
        this.epmem_wme_adds.add(id);
    }

    @Override
    public void removeWme(WmeImpl w) {
        boolean was_encoded = false;
        if (w.value.asIdentifier() != null) {
            boolean lti;
            boolean bl = lti = w.value.asIdentifier().smem_lti != 0L;
            if (w.epmem_id != -1L && w.epmem_valid == this.epmem_validation) {
                was_encoded = true;
                this.epmem_edge_removals.put(w.epmem_id, true);
                if (!lti) {
                    LinkedList<EpisodicMemoryIdReservation.EpisodicMemoryIdPair> p = this.epmem_id_replacement.get(w.epmem_id);
                    p.addFirst(new EpisodicMemoryIdReservation.EpisodicMemoryIdPair(w.value.asIdentifier().epmem_id, w.epmem_id));
                    this.epmem_id_replacement.remove(w.epmem_id);
                }
            }
            if (!lti && w.value.asIdentifier().epmem_id != -1L && w.value.asIdentifier().epmem_valid == this.epmem_validation) {
                Set<WmeImpl> my_refs = this.epmem_id_ref_counts.get(w.value.asIdentifier().epmem_id);
                if (my_refs == null) {
                    my_refs = new LinkedHashSet<WmeImpl>();
                    this.epmem_id_ref_counts.put(w.value.asIdentifier().epmem_id, my_refs);
                }
                if (my_refs.contains(w)) {
                    my_refs.remove(w);
                    if (my_refs.isEmpty()) {
                        my_refs.clear();
                        this.epmem_id_removes.push(w.value);
                    }
                }
            }
        } else if (w.epmem_id != -1L && w.epmem_valid == this.epmem_validation) {
            was_encoded = true;
            this.epmem_node_removals.put(w.epmem_id, true);
        }
        if (was_encoded) {
            w.epmem_id = -1L;
            w.epmem_valid = 0L;
        }
    }

    @Override
    public void processIds() {
        while (!this.epmem_id_removes.isEmpty()) {
            WmeImpl w;
            IdentifierImpl id = this.epmem_id_removes.poll().asIdentifier();
            if (id == null) {
                this.logError("Expected identifier symbol type in epmem_id_removes queue");
                continue;
            }
            if (id.epmem_id == -1L || id.epmem_valid != this.epmem_validation) continue;
            id.epmem_id = -1L;
            id.epmem_valid = 0L;
            WmeImpl wmeImpl = w = id.goalInfo != null ? id.goalInfo.getImpasseWmes() : null;
            while (w != null) {
                this.removeWme(w);
                w = w.next;
            }
            w = id.getInputWmes();
            while (w != null) {
                this.removeWme(w);
                w = w.next;
            }
            Slot s = id.slots;
            while (s != null) {
                WmeImpl w2 = s.getWmes();
                while (w2 != null) {
                    this.removeWme(w2);
                    w2 = w2.next;
                }
                w2 = s.getAcceptablePreferenceWmes();
                while (w2 != null) {
                    this.removeWme(w2);
                    w2 = w2.next;
                }
                s = s.next;
            }
        }
    }

    private void logError(String text) {
        logger.error(text);
        this.agent.getPrinter().error(text);
    }

    String epmem_print_episode(long memory_id) {
        try {
            return this.epmem_print_episode_ex(memory_id);
        }
        catch (SoarException e) {
            logger.error("Soar Exception: ");
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.error("Database Error: ");
            e.printStackTrace();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String epmem_print_episode_ex(long memory_id) throws SoarException, SQLException {
        String buf = "";
        this.epmem_init_db();
        if (memory_id == 0L || !this.epmem_valid_episode(memory_id)) {
            return "";
        }
        TreeMap<Long, String> ltis = new TreeMap<Long, String>();
        TreeMap ep = new TreeMap();
        String temp_s = null;
        String temp_s2 = null;
        PreparedStatement my_q = this.db.get_wmes_with_identifier_values;
        this.epmem_rit_prep_left_right(memory_id, memory_id, this.epmem_rit_state_graph[1]);
        my_q.setLong(1, memory_id);
        my_q.setLong(2, memory_id);
        my_q.setLong(3, memory_id);
        my_q.setLong(4, memory_id);
        my_q.setLong(5, memory_id);
        try (ResultSet result = null;){
            result = my_q.executeQuery();
            while (result.next()) {
                List nestedList;
                boolean val_is_short_term;
                long parent_n_id = result.getLong(1);
                long child_n_id = result.getLong(3);
                temp_s = this.epmem_reverse_hash_print(result.getLong(2));
                boolean bl = val_is_short_term = this.db.column_type(result.getMetaData().getColumnType(4)) == EpisodicMemoryDatabase.value_type.null_t;
                if (val_is_short_term) {
                    temp_s2 = this._epmem_print_sti(child_n_id);
                } else {
                    temp_s2 = "@";
                    temp_s2 = temp_s2 + (char)result.getLong(4);
                    Long temp_i = result.getLong(5);
                    String temp_s3 = temp_i.toString();
                    temp_s2 = temp_s2 + temp_s3;
                    ltis.put(child_n_id, temp_s2);
                }
                Map nestedMap = (Map)ep.get(parent_n_id);
                if (nestedMap == null) {
                    ep.put(parent_n_id, new TreeMap());
                    nestedMap = (Map)ep.get(parent_n_id);
                }
                if ((nestedList = (List)nestedMap.get(temp_s)) == null) {
                    nestedMap.put(temp_s, new ArrayList());
                    nestedList = (List)nestedMap.get(temp_s);
                }
                nestedList.add(temp_s2);
            }
        }
        this.epmem_rit_clear_left_right();
        my_q = this.db.get_wmes_with_constant_values;
        this.epmem_rit_prep_left_right(memory_id, memory_id, this.epmem_rit_state_graph[0]);
        my_q.setLong(1, memory_id);
        my_q.setLong(2, memory_id);
        my_q.setLong(3, memory_id);
        my_q.setLong(4, memory_id);
        try (ResultSet result = my_q.executeQuery();){
            while (result.next()) {
                List nestedList;
                Long parent_n_id = result.getLong(2);
                temp_s = this.epmem_reverse_hash_print(result.getLong(3));
                temp_s2 = this.epmem_reverse_hash_print(result.getLong(4));
                Map nestedMap = (Map)ep.get(parent_n_id);
                if (nestedMap == null) {
                    ep.put(parent_n_id, new TreeMap());
                    nestedMap = (Map)ep.get(parent_n_id);
                }
                if ((nestedList = (List)nestedMap.get(temp_s)) == null) {
                    nestedMap.put(temp_s, new ArrayList());
                    nestedList = (List)nestedMap.get(temp_s);
                }
                nestedList.add(temp_s2);
            }
        }
        this.epmem_rit_clear_left_right();
        for (Map.Entry ep_it : ep.entrySet()) {
            buf = buf + "(";
            String lti_it = (String)ltis.get(ep_it.getKey());
            buf = lti_it == null ? buf + this._epmem_print_sti((Long)ep_it.getKey()) : buf + lti_it;
            for (Map.Entry slot_it : ((Map)ep_it.getValue()).entrySet()) {
                buf = buf + " ^";
                buf = buf + (String)slot_it.getKey();
                for (String val_it : (List)slot_it.getValue()) {
                    buf = buf + " ";
                    buf = buf + val_it;
                }
            }
            buf = buf + ")\n";
        }
        return buf;
    }

    String _epmem_print_sti(Long id) {
        String t1 = "<id";
        String t2 = id.toString();
        t1 = t1 + t2 + ">";
        return t1;
    }

    private String trimTrailingZerosFromDoubleString(String s) {
        if (s.contains(".")) {
            int firstTrailingZero = s.length() - 1;
            while (s.charAt(firstTrailingZero) == '0') {
                --firstTrailingZero;
            }
            if (s.charAt(firstTrailingZero - 1) == '.') {
                --firstTrailingZero;
            }
            s = s.substring(0, firstTrailingZero);
        }
        return s;
    }

    public void epmem_reinit() {
        try {
            this.epmem_close();
            this.epmem_init_db_ex(true);
            if (!":memory:".equalsIgnoreCase(this.params.path.get()) && this.params.append_database.get() == DefaultEpisodicMemoryParams.AppendDatabaseChoices.on) {
                logger.info("EpMem|   Note: There was no effective change to memory contents because append mode is on and path set to file.");
            }
        }
        catch (SQLException e) {
            logger.error("Failed to reinitialize database:" + e.getMessage());
        }
        catch (IOException e) {
            logger.error("Failed to reinitialize epmem:" + e.getMessage());
        }
        catch (SoarException e) {
            logger.error("Failed to reinitialize epmem:" + e.getMessage());
        }
    }

    boolean epmem_backup_db(String file_name, ByRef<String> err) throws SQLException {
        boolean return_val = false;
        if (this.db != null) {
            return this.db.backupDb(file_name);
        }
        err.value = "Episodic database is not currently connected.";
        return return_val;
    }

    static SymbolImpl epmem_parse_constant_attr(SymbolFactoryImpl syms, Lexeme lexeme) {
        SymbolImpl return_val = lexeme.type == LexemeType.SYM_CONSTANT ? syms.createString(lexeme.string) : (lexeme.type == LexemeType.INTEGER ? syms.createInteger(lexeme.int_val) : (lexeme.type == LexemeType.FLOAT ? syms.createDouble(lexeme.float_val) : null));
        return return_val;
    }

    static boolean epmem_parse_chunk(SymbolFactoryImpl symbols, Lexer lexer, Map<String, IdentifierImpl> ids, Set<WmeImpl> wmes, IdentifierHolder root, IdentifierHolder firstHolder) throws IOException {
        String s;
        boolean return_val = false;
        boolean good_at = false;
        lexer.getNextLexeme();
        boolean nextIdentifierIsState = false;
        if (lexer.getCurrentLexeme().type == LexemeType.SYM_CONSTANT && (s = lexer.getCurrentLexeme().string) != null && s.equalsIgnoreCase("state")) {
            nextIdentifierIsState = true;
            lexer.getNextLexeme();
        }
        if (lexer.getCurrentLexeme().type == LexemeType.AT || lexer.getCurrentLexeme().type == LexemeType.IDENTIFIER || lexer.getCurrentLexeme().type == LexemeType.VARIABLE) {
            good_at = true;
            if (lexer.getCurrentLexeme().type == LexemeType.AT) {
                lexer.getNextLexeme();
                boolean bl = good_at = lexer.getCurrentLexeme().type == LexemeType.IDENTIFIER;
            }
            if (good_at) {
                String idKey;
                IdentifierImpl id;
                Lexeme lexeme = lexer.getCurrentLexeme();
                if (lexer.getCurrentLexeme().type == LexemeType.IDENTIFIER) {
                    id = symbols.findOrCreateIdentifier(lexeme.id_letter, lexeme.id_number);
                    idKey = String.format("%c%d", Character.valueOf(lexeme.id_letter), lexeme.id_number);
                } else {
                    id = ids.get(lexeme.string);
                    if (id == null) {
                        id = symbols.createIdentifier('X');
                    }
                    idKey = lexeme.string;
                }
                if (nextIdentifierIsState) {
                    root.setIdentifier(id);
                }
                if (firstHolder.getIdentifier() == null) {
                    firstHolder.setIdentifier(id);
                }
                ids.put(idKey, id);
                lexer.getNextLexeme();
                IdentifierImpl parent = id;
                while (lexer.getCurrentLexeme().type == LexemeType.UP_ARROW) {
                    WmeImpl newWme;
                    IdentifierImpl intermediate_parent = parent;
                    lexer.getNextLexeme();
                    SymbolImpl chunk_attr = DefaultEpisodicMemory.epmem_parse_constant_attr(symbols, lexer.getCurrentLexeme());
                    if (chunk_attr == null) continue;
                    lexer.getNextLexeme();
                    while (lexer.getCurrentLexeme().type == LexemeType.PERIOD) {
                        IdentifierImpl temp_id = symbols.createIdentifier(chunk_attr.getFirstLetter());
                        newWme = new WmeImpl(intermediate_parent, chunk_attr, temp_id, false, 0);
                        wmes.add(newWme);
                        Slot.make_slot(intermediate_parent, chunk_attr, null).addWme(newWme);
                        intermediate_parent = temp_id;
                        lexer.getNextLexeme();
                        chunk_attr = DefaultEpisodicMemory.epmem_parse_constant_attr(symbols, lexer.getCurrentLexeme());
                        lexer.getNextLexeme();
                    }
                    if (chunk_attr == null) continue;
                    SymbolImpl chunk_value = null;
                    do {
                        chunk_value = null;
                        if (lexer.getCurrentLexeme().type == LexemeType.SYM_CONSTANT) {
                            chunk_value = symbols.createString(lexer.getCurrentLexeme().string);
                        } else if (lexer.getCurrentLexeme().type == LexemeType.INTEGER) {
                            chunk_value = symbols.createInteger(lexer.getCurrentLexeme().int_val);
                        } else if (lexer.getCurrentLexeme().type == LexemeType.FLOAT) {
                            chunk_value = symbols.createDouble(lexer.getCurrentLexeme().float_val);
                        } else if (lexer.getCurrentLexeme().type == LexemeType.AT || lexer.getCurrentLexeme().type == LexemeType.IDENTIFIER || lexer.getCurrentLexeme().type == LexemeType.VARIABLE) {
                            good_at = true;
                            if (lexer.getCurrentLexeme().type == LexemeType.AT) {
                                lexer.getNextLexeme();
                                boolean bl = good_at = lexer.getCurrentLexeme().type == LexemeType.IDENTIFIER;
                            }
                            if (good_at) {
                                lexeme = lexer.getCurrentLexeme();
                                if (lexer.getCurrentLexeme().type == LexemeType.IDENTIFIER) {
                                    id = symbols.findOrCreateIdentifier(lexeme.id_letter, lexeme.id_number);
                                    idKey = String.format("%c%d", Character.valueOf(lexeme.id_letter), lexeme.id_number);
                                } else {
                                    id = ids.get(lexeme.string);
                                    if (id == null) {
                                        id = symbols.createIdentifier('X');
                                    }
                                    idKey = lexeme.string;
                                }
                                ids.put(idKey, id);
                                chunk_value = id;
                            }
                        }
                        if (chunk_value == null) continue;
                        lexer.getNextLexeme();
                        newWme = null;
                        Iterator<Wme> it = intermediate_parent.getWmes(EnumSet.of(WmeType.NORMAL));
                        while (it.hasNext()) {
                            Wme wme = it.next();
                            if (!DefaultEpisodicMemory.compare_symbol(wme.getAttribute(), chunk_attr) || !DefaultEpisodicMemory.compare_symbol(wme.getValue(), chunk_value)) continue;
                            if (!(wme instanceof WmeImpl)) break;
                            newWme = (WmeImpl)wme;
                            break;
                        }
                        if (newWme == null) {
                            newWme = new WmeImpl(intermediate_parent, chunk_attr, chunk_value, false, 0);
                            wmes.add(newWme);
                            Slot.make_slot(intermediate_parent, chunk_attr, null).addWme(newWme);
                        }
                        if (lexer.getCurrentLexeme().type != LexemeType.R_PAREN) continue;
                        return_val = true;
                        lexer.getNextLexeme();
                        chunk_value = null;
                    } while (chunk_value != null);
                }
            }
        }
        return return_val;
    }

    public static boolean compare_symbol(Symbol a, Symbol b) {
        Identifier idB;
        Identifier idA = a.asIdentifier();
        if (idA == null != ((idB = b.asIdentifier()) == null)) {
            return false;
        }
        if (idA != null) {
            return a.equals(b);
        }
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        if (a instanceof DoubleSymbol) {
            return a.asDouble().getValue() == b.asDouble().getValue();
        }
        if (a instanceof IntegerSymbol) {
            return a.asInteger().getValue() == b.asInteger().getValue();
        }
        if (a instanceof StringSymbol) {
            return a.asString().getValue() == b.asString().getValue();
        }
        if (a instanceof JavaSymbol) {
            return a.asJava().getValue().equals(b.asJava().getValue());
        }
        return false;
    }

    boolean epmem_parse_and_add(String chunkString) throws SoarException {
        try {
            File filename = new File(chunkString);
            if (filename.isFile()) {
                return this.epmem_parse_and_add_file(filename);
            }
            return this.epmem_parse_and_add_string("{" + chunkString + "}");
        }
        catch (IOException e) {
            throw new SoarException(e);
        }
        catch (SQLException e) {
            throw new SoarException(e);
        }
    }

    private boolean epmem_parse_and_add_file(File filename) throws SoarException, SQLException {
        try {
            String fileContents = new String(Files.readAllBytes(filename.toPath()), Charset.defaultCharset());
            return this.epmem_parse_and_add_string(fileContents);
        }
        catch (IOException e) {
            throw new SoarException("Failed to read file contents: " + filename.getPath());
        }
    }

    private boolean epmem_parse_and_add_string(String chunkString) throws SoarException, IOException, SQLException {
        long episode_index = 0L;
        this.epmem_init_db();
        StringWriter errorWriter = new StringWriter();
        Lexer lexer = new Lexer(new Printer(errorWriter), new StringReader(chunkString));
        lexer.getNextLexeme();
        lexer.setAllowIds(true);
        boolean multi_episode = false;
        do {
            ++episode_index;
            HashMap<String, IdentifierImpl> ids = new HashMap<String, IdentifierImpl>();
            HashSet<WmeImpl> wmes = new HashSet<WmeImpl>();
            lexer.getNextLexeme();
            if (lexer.getCurrentLexeme().type == LexemeType.L_BRACE) {
                multi_episode = true;
                lexer.getNextLexeme();
            } else {
                if (multi_episode && lexer.getCurrentLexeme().type == LexemeType.R_BRACE) break;
                if (multi_episode) {
                    throw new SoarException("Unexpected charater at the beginning of episode #" + episode_index);
                }
            }
            IdentifierImpl rootId = null;
            IdentifierHolder firstHolder = new IdentifierHolder();
            long clause_count = 0L;
            while (lexer.getCurrentLexeme().type == LexemeType.L_PAREN) {
                ++clause_count;
                IdentifierHolder rootHolder = new IdentifierHolder();
                boolean good_clause = DefaultEpisodicMemory.epmem_parse_chunk(this.symbols, lexer, ids, wmes, rootHolder, firstHolder);
                if (!good_clause) {
                    throw new SoarException("Error parsing clause #" + clause_count + " in episode #" + episode_index);
                }
                if (rootHolder.getIdentifier() == null) continue;
                if (rootId != null) {
                    throw new SoarException("Error parsing clause #" + clause_count + " in episode #" + episode_index + ": too many root nodes.");
                }
                rootId = rootHolder.getIdentifier();
            }
            if (clause_count == 0L) {
                throw new SoarException("Unexpected character at the beginning of episode #" + episode_index);
            }
            if (rootId == null && (rootId = firstHolder.getIdentifier()) == null) {
                throw new SoarException("No top-state specified in episode #" + episode_index);
            }
            HashSet possibleRoots = new HashSet(ids.values());
            for (WmeImpl wme : wmes) {
                IdentifierImpl id = wme.value.asIdentifier();
                if (id == null) continue;
                possibleRoots.remove(id);
            }
            if (possibleRoots.size() == 1 && possibleRoots.iterator().next() != rootId || possibleRoots.size() > 1) {
                throw new SoarException("Too many possible top-states in episode #" + episode_index);
            }
            this.epmem_wme_adds.clear();
            rootId.epmem_id = EPMEM_NODEID_ROOT;
            rootId.epmem_valid = this.epmem_validation;
            this.addWme(rootId);
            DefaultMarker marker = DefaultMarker.create();
            LinkedList<SymbolImpl> symbolsToTraverse = new LinkedList<SymbolImpl>();
            symbolsToTraverse.add(this.decider.top_state);
            while (!symbolsToTraverse.isEmpty()) {
                SymbolImpl sym = (SymbolImpl)symbolsToTraverse.poll();
                List<WmeImpl> children = this.epmem_get_augs_of_id(sym, marker);
                for (WmeImpl wme : children) {
                    if (wme.value.asIdentifier() != null) {
                        symbolsToTraverse.add(wme.value);
                    }
                    this.removeWme(wme);
                }
            }
            this.epmem_new_episode();
            this.epmem_wme_adds.add(this.decider.top_state);
            this.decider.top_goal.epmem_id = EPMEM_NODEID_ROOT;
            this.decider.top_goal.epmem_valid = this.epmem_validation;
            for (WmeImpl wme : wmes) {
                this.removeWme(wme);
            }
        } while (multi_episode);
        return true;
    }

    class IdentifierHolder {
        private IdentifierImpl id;

        public IdentifierHolder() {
            this.id = null;
        }

        public IdentifierHolder(IdentifierImpl id) {
            this.id = id;
        }

        public IdentifierImpl getIdentifier() {
            return this.id;
        }

        public IdentifierImpl setIdentifier(IdentifierImpl id) {
            IdentifierImpl oldId = this.id;
            this.id = id;
            return oldId;
        }
    }

    private class EpmemEdge {
        long parent_n_id;
        SymbolImpl attribute;
        long child_n_id;
        boolean val_is_short_term;
        char val_letter;
        long val_num;

        private EpmemEdge() {
        }
    }

    private class SymbolBooleanPair {
        SymbolImpl first;
        boolean second;

        SymbolBooleanPair(SymbolImpl first, boolean second) {
            this.first = first;
            this.second = second;
        }
    }

    private static class EpmemPEdgeNodePair {
        EpmemPEdge pedge;
        long node_id;

        EpmemPEdgeNodePair(EpmemPEdge pedge, long node_id) {
            this.pedge = pedge;
            this.node_id = node_id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.node_id ^ this.node_id >>> 32);
            result = 31 * result + (this.pedge == null ? 0 : this.pedge.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EpmemPEdgeNodePair other = (EpmemPEdgeNodePair)obj;
            if (this.node_id != other.node_id) {
                return false;
            }
            return !(this.pedge == null ? other.pedge != null : !this.pedge.equals(other.pedge));
        }
    }

    private static class EpmemNodePair
    implements Comparable<EpmemNodePair> {
        final long first;
        final long second;

        public EpmemNodePair(long parent, long child) {
            this.first = parent;
            this.second = child;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.first ^ this.first >>> 32);
            result = 31 * result + (int)(this.second ^ this.second >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EpmemNodePair other = (EpmemNodePair)obj;
            if (this.first != other.first) {
                return false;
            }
            return this.second == other.second;
        }

        @Override
        public int compareTo(EpmemNodePair other) {
            if (this.first != other.first) {
                return this.first < other.first ? -1 : 1;
            }
            if (this.second != other.second) {
                return this.second < other.second ? -1 : 1;
            }
            return 0;
        }
    }

    private static class EpmemSymbolNodePair {
        final SymbolImpl first;
        final long second;

        public EpmemSymbolNodePair(SymbolImpl id_sym, long parent) {
            this.first = id_sym;
            this.second = parent;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
            result = 31 * result + (int)(this.second ^ this.second >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EpmemSymbolNodePair other = (EpmemSymbolNodePair)obj;
            if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
                return false;
            }
            return this.second == other.second;
        }
    }

    private static class EpmemInterval {
        EpmemUEdge uedge;
        int is_end_point;
        PreparedStatement sql = null;
        ResultSet sqlResult = null;
        long time;

        private EpmemInterval() {
        }
    }

    private static class EpmemUEdge {
        EpmemTriple triple;
        long value_is_id;
        boolean has_noncurrent;
        long activation_count;
        Set<EpmemPEdge> pedges;
        long intervals;
        boolean activated;

        private EpmemUEdge() {
        }
    }

    private static class EpmemPEdge {
        EpmemTriple triple;
        int value_is_id;
        boolean has_noncurrent;
        Set<EpmemLiteral> literals;
        PreparedStatement sql = null;
        ResultSet sqlResults = null;
        long time;

        private EpmemPEdge() {
        }
    }

    private static class EpmemTriple
    implements Comparable<EpmemTriple> {
        long parent_n_id;
        long attribute_s_id;
        long child_n_id;

        public EpmemTriple(long parent_n_id, long attribute_s_id, long child_n_id) {
            this.parent_n_id = parent_n_id;
            this.attribute_s_id = attribute_s_id;
            this.child_n_id = child_n_id;
        }

        public EpmemTriple copyEpmemTriple() {
            return new EpmemTriple(this.parent_n_id, this.attribute_s_id, this.child_n_id);
        }

        @Override
        public int compareTo(EpmemTriple other) {
            if (this.parent_n_id != other.parent_n_id) {
                return this.parent_n_id < other.parent_n_id ? -1 : 1;
            }
            if (this.attribute_s_id != other.attribute_s_id) {
                return this.attribute_s_id < other.attribute_s_id ? -1 : 1;
            }
            if (this.child_n_id != other.child_n_id) {
                return this.child_n_id < other.child_n_id ? -1 : 1;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.parent_n_id ^ this.parent_n_id >>> 32);
            result = 31 * result + (int)(this.child_n_id ^ this.child_n_id >>> 32);
            result = 31 * result + (int)(this.attribute_s_id ^ this.attribute_s_id >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EpmemTriple other = (EpmemTriple)obj;
            if (this.parent_n_id != other.parent_n_id) {
                return false;
            }
            if (this.child_n_id != other.child_n_id) {
                return false;
            }
            return this.attribute_s_id == other.attribute_s_id;
        }
    }

    private static class EpmemLiteral
    implements Comparable<EpmemLiteral> {
        private static AtomicLong nextId = new AtomicLong();
        private final long privateID = nextId.incrementAndGet();
        SymbolImpl id_sym;
        SymbolImpl value_sym;
        long is_neg_q;
        long value_is_id;
        boolean is_leaf;
        boolean is_current;
        long attribute_s_id;
        long child_n_id;
        double weight;
        Set<EpmemLiteral> parents;
        Set<EpmemLiteral> children;
        NavigableSet<EpmemNodePair> matches;
        Map<Long, Integer> values;

        private EpmemLiteral() {
        }

        @Override
        public int compareTo(EpmemLiteral o) {
            if (this.privateID == o.privateID) {
                return 0;
            }
            return this.privateID < o.privateID ? -1 : 1;
        }
    }

    private static final class EpmemRitForkNodeResult {
        public final long node;
        public final long step;

        public EpmemRitForkNodeResult(long node, long step) {
            this.node = node;
            this.step = step;
        }
    }

    private static class epmem_rit_state {
        epmem_rit_state_param offset = new epmem_rit_state_param();
        epmem_rit_state_param leftroot = new epmem_rit_state_param();
        epmem_rit_state_param rightroot = new epmem_rit_state_param();
        epmem_rit_state_param minstep = new epmem_rit_state_param();
        PreparedStatement add_query;

        private epmem_rit_state() {
        }
    }

    private static class epmem_rit_state_param {
        long stat;
        epmem_variable_key var_key = epmem_variable_key.var_rit_offset_1;

        private epmem_rit_state_param() {
        }
    }

    private static enum epmem_variable_key {
        var_rit_offset_1,
        var_rit_leftroot_1,
        var_rit_rightroot_1,
        var_rit_minstep_1,
        var_rit_offset_2,
        var_rit_leftroot_2,
        var_rit_rightroot_2,
        var_rit_minstep_2,
        var_next_id;

    }
}

