/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.epmem;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jsoar.kernel.SoarException;
import org.jsoar.util.db.AbstractSoarDatabase;
import org.jsoar.util.db.SoarPreparedStatement;

final class EpisodicMemoryDatabase
extends AbstractSoarDatabase {
    static final String EPMEM_SCHEMA = "epmem_";
    static final String EPMEM_SCHEMA_VERSION = "2.0";
    static final String IN_MEMORY_PATH = ":memory:";
    PreparedStatement begin;
    PreparedStatement commit;
    PreparedStatement rollback;
    SoarPreparedStatement backup;
    SoarPreparedStatement restore;
    PreparedStatement var_get;
    PreparedStatement var_set;
    PreparedStatement rit_add_left;
    PreparedStatement rit_truncate_left;
    PreparedStatement rit_add_right;
    PreparedStatement rit_truncate_right;
    PreparedStatement hash_rev_int;
    PreparedStatement hash_rev_float;
    PreparedStatement hash_rev_str;
    PreparedStatement hash_get_int;
    PreparedStatement hash_get_float;
    PreparedStatement hash_get_str;
    PreparedStatement hash_get_type;
    PreparedStatement hash_add_type;
    PreparedStatement hash_add_int;
    PreparedStatement hash_add_float;
    PreparedStatement hash_add_str;
    PreparedStatement add_node;
    PreparedStatement add_time;
    PreparedStatement add_epmem_wmes_constant_now;
    PreparedStatement delete_epmem_wmes_constant_now;
    PreparedStatement add_epmem_wmes_constant_point;
    PreparedStatement add_epmem_wmes_constant_range;
    PreparedStatement add_epmem_wmes_constant;
    PreparedStatement find_epmem_wmes_constant;
    PreparedStatement add_epmem_wmes_identifier_now;
    PreparedStatement delete_epmem_wmes_identifier_now;
    PreparedStatement add_epmem_wmes_identifier_point;
    PreparedStatement add_epmem_wmes_identifier_range;
    PreparedStatement add_epmem_wmes_identifier;
    PreparedStatement find_epmem_wmes_identifier;
    PreparedStatement find_epmem_wmes_identifier_shared;
    PreparedStatement valid_episode;
    PreparedStatement next_episode;
    PreparedStatement prev_episode;
    PreparedStatement get_wmes_with_identifier_values;
    PreparedStatement get_wmes_with_constant_values;
    PreparedStatement promote_id;
    PreparedStatement find_lti;
    PreparedStatement find_lti_promotion_time;
    PreparedStatement drop_epmem_nodes;
    PreparedStatement drop_epmem_episodes;
    PreparedStatement drop_epmem_wmes_constant_now;
    PreparedStatement drop_epmem_wmes_identifier_now;
    PreparedStatement drop_epmem_wmes_constant_point;
    PreparedStatement drop_epmem_wmes_identifier_point;
    PreparedStatement drop_epmem_wmes_constant_range;
    PreparedStatement drop_epmem_wmes_identifier_range;
    PreparedStatement drop_epmem_wmes_constant;
    PreparedStatement drop_epmem_wmes_identifier;
    PreparedStatement drop_epmem_lti;
    PreparedStatement drop_epmem_persistent_variables;
    PreparedStatement drop_epmem_rit_left_nodes;
    PreparedStatement drop_epmem_rit_right_nodes;
    PreparedStatement drop_epmem_symbols_type;
    PreparedStatement drop_epmem_symbols_integer;
    PreparedStatement drop_epmem_symbols_float;
    PreparedStatement drop_epmem_symbols_string;
    PreparedStatement update_epmem_wmes_identifier_last_episode_id;
    PreparedStatement get_max_time;
    PreparedStatement now_select_node;
    PreparedStatement now_select_edge;
    PreparedStatement now_delete_node;
    PreparedStatement now_delete_edge;
    PreparedStatement minmax_select_node;
    PreparedStatement minmax_select_edge;
    PreparedStatement edge_unique_select;
    PreparedStatement database_version;
    PreparedStatement set_schema_version;
    PreparedStatement get_schema_version;
    SoarPreparedStatement pool_dummy;
    SoarPreparedStatement pool_find_edge_queries_0_0;
    SoarPreparedStatement pool_find_edge_queries_0_1;
    SoarPreparedStatement pool_find_edge_queries_1_0;
    SoarPreparedStatement pool_find_edge_queries_1_1;
    public SoarPreparedStatement[][] pool_find_edge_queries;
    SoarPreparedStatement pool_find_interval_queries_0_0_0;
    SoarPreparedStatement pool_find_interval_queries_0_0_1;
    SoarPreparedStatement pool_find_interval_queries_0_0_2;
    SoarPreparedStatement pool_find_interval_queries_0_1_0;
    SoarPreparedStatement pool_find_interval_queries_0_1_1;
    SoarPreparedStatement pool_find_interval_queries_0_1_2;
    SoarPreparedStatement pool_find_interval_queries_1_0_0;
    SoarPreparedStatement pool_find_interval_queries_1_0_1;
    SoarPreparedStatement pool_find_interval_queries_1_0_2;
    SoarPreparedStatement pool_find_interval_queries_1_1_0;
    SoarPreparedStatement pool_find_interval_queries_1_1_1;
    SoarPreparedStatement pool_find_interval_queries_1_1_2;
    public SoarPreparedStatement[][][] pool_find_interval_queries;
    SoarPreparedStatement pool_find_lti_queries_0_0;
    SoarPreparedStatement pool_find_lti_queries_0_1;
    SoarPreparedStatement pool_find_lti_queries_0_2;
    SoarPreparedStatement pool_find_lti_queries_1_0;
    SoarPreparedStatement pool_find_lti_queries_1_1;
    SoarPreparedStatement pool_find_lti_queries_1_2;
    public SoarPreparedStatement[][] pool_find_lti_queries;

    @Override
    public void prepare() throws SoarException, IOException {
        super.prepare();
        this.pool_find_edge_queries = new SoarPreparedStatement[][]{{this.pool_find_edge_queries_0_0, this.pool_find_edge_queries_0_1}, {this.pool_find_edge_queries_1_0, this.pool_find_edge_queries_1_1}};
        this.pool_find_interval_queries = new SoarPreparedStatement[][][]{{{this.pool_find_interval_queries_0_0_0, this.pool_find_interval_queries_0_0_1, this.pool_find_interval_queries_0_0_2}, {this.pool_find_interval_queries_0_1_0, this.pool_find_interval_queries_0_1_1, this.pool_find_interval_queries_0_1_2}}, {{this.pool_find_interval_queries_1_0_0, this.pool_find_interval_queries_1_0_1, this.pool_find_interval_queries_1_0_2}, {this.pool_find_interval_queries_1_1_0, this.pool_find_interval_queries_1_1_1, this.pool_find_interval_queries_1_1_2}}};
        this.pool_find_lti_queries = new SoarPreparedStatement[][]{{this.pool_find_lti_queries_0_0, this.pool_find_lti_queries_0_1, this.pool_find_lti_queries_0_2}, {this.pool_find_lti_queries_1_0, this.pool_find_lti_queries_1_1, this.pool_find_lti_queries_1_2}};
    }

    public EpisodicMemoryDatabase(String driver, Connection db) {
        super(driver, db);
        this.getFilterMap().put("@PREFIX@", EPMEM_SCHEMA);
    }

    value_type column_type(int jdbcColumnType) {
        value_type return_val = value_type.null_t;
        switch (jdbcColumnType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return_val = value_type.int_t;
                break;
            }
            case 6: 
            case 8: {
                return_val = value_type.double_t;
                break;
            }
            case 12: {
                return_val = value_type.text_t;
            }
        }
        return return_val;
    }

    public void dropEpmemTables() throws SQLException {
        this.drop_epmem_nodes.execute();
        this.drop_epmem_episodes.execute();
        this.drop_epmem_wmes_constant_now.execute();
        this.drop_epmem_wmes_identifier_now.execute();
        this.drop_epmem_wmes_constant_point.execute();
        this.drop_epmem_wmes_identifier_point.execute();
        this.drop_epmem_wmes_constant_range.execute();
        this.drop_epmem_wmes_identifier_range.execute();
        this.drop_epmem_wmes_constant.execute();
        this.drop_epmem_wmes_identifier.execute();
        this.drop_epmem_lti.execute();
        this.drop_epmem_persistent_variables.execute();
        this.drop_epmem_rit_left_nodes.execute();
        this.drop_epmem_rit_right_nodes.execute();
        this.drop_epmem_symbols_type.execute();
        this.drop_epmem_symbols_integer.execute();
        this.drop_epmem_symbols_float.execute();
        this.drop_epmem_symbols_string.execute();
    }

    public boolean backupDb(String fileName) throws SQLException {
        boolean returnValue = false;
        if (this.getConnection().getAutoCommit()) {
            this.commit.execute();
            this.begin.execute();
        }
        String query = this.backup.getQuery() + " \"" + fileName + "\"";
        this.getConnection().createStatement().executeUpdate(query);
        returnValue = true;
        if (this.getConnection().getAutoCommit()) {
            this.commit.execute();
            this.begin.execute();
        }
        return returnValue;
    }

    static enum value_type {
        null_t,
        int_t,
        double_t,
        text_t;

    }
}

