/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jsoar.kernel.events.AbstractInputOutputEvent;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.OutputChange;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbol;

public class OutputEvent
extends AbstractInputOutputEvent {
    private final OutputMode mode;
    private final Set<Wme> wmes;
    private final Set<Wme> lastOutputSet;
    private List<OutputChange> changes;

    public OutputEvent(InputOutput io, OutputMode mode, Set<Wme> wmes, Set<Wme> lastOutputSet) {
        super(io);
        this.mode = mode;
        this.wmes = Collections.unmodifiableSet(wmes);
        this.lastOutputSet = lastOutputSet;
    }

    public OutputMode getMode() {
        return this.mode;
    }

    public Iterator<Wme> getWmes() {
        return this.wmes.iterator();
    }

    public Iterator<OutputChange> getChanges() {
        if (this.changes == null) {
            this.changes = new ArrayList<OutputChange>();
            if (this.wmes != this.lastOutputSet) {
                this.calculateAdditions();
                this.calculateRemovals();
            }
        }
        return this.changes.iterator();
    }

    public Symbol getOutputValue(Identifier id, Symbol attr) {
        for (Wme iw : this.wmes) {
            if (id != null && id != iw.getIdentifier() || attr != null && attr != iw.getAttribute()) continue;
            return iw.getValue();
        }
        return null;
    }

    private void calculateRemovals() {
        if (this.lastOutputSet != null) {
            for (Wme w : this.lastOutputSet) {
                if (this.wmes.contains(w)) continue;
                this.changes.add(new OutputChange(w, false));
            }
        }
    }

    private void calculateAdditions() {
        for (Wme w : this.wmes) {
            if (this.lastOutputSet != null && this.lastOutputSet.contains(w)) continue;
            this.changes.add(new OutputChange(w, true));
        }
    }

    public static enum OutputMode {
        UNCHANGED_OUTPUT_COMMAND,
        ADDED_OUTPUT_COMMAND,
        MODIFIED_OUTPUT_COMMAND,
        REMOVED_OUTPUT_COMMAND;

    }
}

