/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.exploration;

import java.util.EnumMap;
import java.util.Map;
import org.jsoar.kernel.exploration.ExplorationValueFunction;

public class ExplorationParameter {
    double value;
    String name;
    ReductionPolicy reduction_policy;
    ExplorationValueFunction val_func;
    Map<ReductionPolicy, Double> rates = new EnumMap<ReductionPolicy, Double>(ReductionPolicy.class);

    void update() {
        double current_value;
        double reduction_rate = this.rates.get((Object)this.reduction_policy);
        if (this.reduction_policy == ReductionPolicy.EXPLORATION_REDUCTION_EXPONENTIAL) {
            if (reduction_rate != 1.0) {
                this.value *= reduction_rate;
            }
        } else if (this.reduction_policy == ReductionPolicy.EXPLORATION_REDUCTION_LINEAR && (current_value = this.value) > 0.0 && reduction_rate != 0.0) {
            this.value = current_value - reduction_rate > 0.0 ? current_value - reduction_rate : 0.0;
        }
    }

    public double getReductionRate(ReductionPolicy policy) {
        return this.rates.get((Object)policy);
    }

    public boolean setReductionRate(ReductionPolicy policy, double rate) {
        boolean valid = policy.isRateValid(rate);
        if (valid) {
            this.rates.put(policy, rate);
        }
        return valid;
    }

    public static enum ReductionPolicy {
        EXPLORATION_REDUCTION_EXPONENTIAL("exponential"){

            @Override
            public boolean isRateValid(double rate) {
                return rate >= 0.0 && rate <= 1.0;
            }
        }
        ,
        EXPLORATION_REDUCTION_LINEAR("linear"){

            @Override
            public boolean isRateValid(double rate) {
                return rate >= 0.0;
            }
        };

        private final String policyName;

        private ReductionPolicy(String policyName) {
            this.policyName = policyName;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public static ReductionPolicy findPolicy(String policyName) {
            for (ReductionPolicy p : ReductionPolicy.values()) {
                if (!p.policyName.equals(policyName)) continue;
                return p;
            }
            return null;
        }

        public abstract boolean isRateValid(double var1);
    }
}

