/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io;

import org.jsoar.kernel.events.BeforeInitSoarEvent;
import org.jsoar.kernel.events.InputEvent;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.InputWme;
import org.jsoar.kernel.io.InputWmes;
import org.jsoar.util.Arguments;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;

public class CycleCountInput {
    private static final int START = 1;
    private final InputOutput io;
    private final InputListener listener;
    private final InitSoarListener initListener;
    private int count = 1;
    private InputWme wme;

    public CycleCountInput(InputOutput io) {
        Arguments.checkNotNull(io, "io");
        this.io = io;
        this.listener = new InputListener();
        this.initListener = new InitSoarListener();
        this.io.getEvents().addListener(InputEvent.class, this.listener);
        this.io.getEvents().addListener(BeforeInitSoarEvent.class, this.initListener);
    }

    public void dispose() {
        this.io.getEvents().removeListener(null, this.listener);
        this.io.getEvents().removeListener(null, this.initListener);
        if (this.wme != null) {
            this.wme.remove();
            this.wme = null;
        }
    }

    private void update() {
        if (this.wme == null) {
            this.wme = InputWmes.add(this.io, (Object)"cycle-count", (Object)this.count);
        } else {
            InputWmes.update(this.wme, this.count);
        }
        ++this.count;
    }

    private class InitSoarListener
    implements SoarEventListener {
        private InitSoarListener() {
        }

        @Override
        public void onEvent(SoarEvent event) {
            CycleCountInput.this.wme = null;
            CycleCountInput.this.count = 1;
        }
    }

    private class InputListener
    implements SoarEventListener {
        private InputListener() {
        }

        @Override
        public void onEvent(SoarEvent event) {
            CycleCountInput.this.update();
        }
    }
}

