/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io;

import java.util.HashMap;
import java.util.Map;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.InputWme;
import org.jsoar.kernel.io.InputWmes;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbols;

public class InputBuilder {
    public final InputOutput io;
    public final Identifier id;
    private final InputBuilder parent;
    private final Map<String, Identifier> idMap;
    private final Map<String, InputWme> wmeMap;

    public static InputBuilder create(InputOutput io, Identifier root) {
        return new InputBuilder(io, null, root, new HashMap<String, Identifier>(), new HashMap<String, InputWme>());
    }

    public static InputBuilder create(InputOutput io) {
        return InputBuilder.create(io, io.getInputLink());
    }

    private InputBuilder(InputOutput io, InputBuilder parent, Identifier id, Map<String, Identifier> idMap, Map<String, InputWme> wmeMap) {
        this.io = io;
        this.parent = parent;
        this.id = id;
        this.idMap = idMap;
        this.wmeMap = wmeMap;
    }

    public InputBuilder add(Object attr, Object value) {
        this.wmeMap.put(null, InputWmes.add(this.io, this.id, attr, value));
        return this;
    }

    public InputBuilder push(Object attr) {
        Identifier newId = this.io.getSymbols().createIdentifier(Symbols.getFirstLetter(attr));
        this.wmeMap.put(null, InputWmes.add(this.io, this.id, attr, newId));
        return new InputBuilder(this.io, this, newId, this.idMap, this.wmeMap);
    }

    public InputBuilder link(Object attr, String target) {
        Identifier targetId = this.idMap.get(target);
        if (targetId == null) {
            throw new IllegalArgumentException("Unknown target '" + target + "'");
        }
        this.wmeMap.put(null, InputWmes.add(this.io, this.id, attr, targetId));
        return this;
    }

    public InputBuilder markId(String name) {
        this.idMap.put(name, this.id);
        return this;
    }

    public Identifier getId(String name) {
        return this.idMap.get(name);
    }

    public InputBuilder markWme(String name) {
        this.wmeMap.put(name, this.wmeMap.get(null));
        return this;
    }

    public InputWme getWme(String name) {
        return this.wmeMap.get(name);
    }

    public InputBuilder pop() {
        if (this.parent == null) {
            throw new IllegalStateException("Can't pop");
        }
        return this.parent;
    }

    public InputBuilder top() {
        if (this.parent == null) {
            return this;
        }
        InputBuilder p = this.parent;
        while (p.parent != null) {
            p = p.parent;
        }
        return p;
    }

    public InputBuilder jump(String idName) {
        Identifier newId = this.idMap.get(idName);
        if (newId == null) {
            throw new IllegalArgumentException("No id with name '" + idName + "'");
        }
        return new InputBuilder(this.io, this, newId, this.idMap, this.wmeMap);
    }
}

