/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.events.AsynchronousInputReadyEvent;
import org.jsoar.kernel.events.InputEvent;
import org.jsoar.kernel.events.OutputEvent;
import org.jsoar.kernel.events.TopStateRemovedEvent;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.InputWme;
import org.jsoar.kernel.io.InputWmeImpl;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeFactory;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.memory.WorkingMemory;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.util.Arguments;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.events.SoarEventManager;
import org.jsoar.util.markers.DefaultMarker;
import org.jsoar.util.markers.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputOutputImpl
implements InputOutput,
WmeFactory<InputWme> {
    private static final Logger logger = LoggerFactory.getLogger(InputOutputImpl.class);
    private final Agent context;
    private Decider decider;
    private WorkingMemory workingMemory;
    private boolean prev_top_state = false;
    private IdentifierImpl io_header;
    private IdentifierImpl io_header_input;
    private IdentifierImpl io_header_output;
    private WmeImpl io_header_link;
    private WmeImpl outputLinkWme;
    private OutputLinkStatus outputLinkStatus = OutputLinkStatus.UNINITIALIZED_OL_STATUS;
    private Set<IdentifierImpl> ids_in_tc = new HashSet<IdentifierImpl>();
    private boolean output_link_changed = false;
    private Set<Wme> lastOutputSet = null;
    private final Set<Wme> pendingCommands = new HashSet<Wme>();
    private final Set<Wme> removingCommands = new HashSet<Wme>();
    private Marker output_link_tc_num;
    private final TopStateRemovedEvent topStateRemovedEvent = new TopStateRemovedEvent(this);
    private final InputEvent inputEvent = new InputEvent(this);
    private final AsynchronousInputReadyEvent asyncInputReadyEvent = new AsynchronousInputReadyEvent(this);
    private final ConcurrentLinkedQueue<InputWmeImpl> wmesToRemove = new ConcurrentLinkedQueue();

    public InputOutputImpl(Agent context) {
        this.context = context;
    }

    public void initialize() {
        this.decider = Adaptables.adapt(this.context, Decider.class);
        this.workingMemory = Adaptables.adapt(this.context, WorkingMemory.class);
    }

    @Override
    public WmeFactory<InputWme> asWmeFactory() {
        return this;
    }

    @Override
    public InputWme addWme(Identifier id, Symbol attr, Symbol value) {
        return this.addInputWme(id, attr, value);
    }

    @Override
    public SymbolFactory getSymbols() {
        return this.context.getSymbols();
    }

    @Override
    public SoarEventManager getEvents() {
        return this.context.getEvents();
    }

    public void init_agent_memory() {
        PredefinedSymbols predefinedSyms = Adaptables.adapt(this.context, PredefinedSymbols.class);
        SymbolFactoryImpl syms = predefinedSyms.getSyms();
        this.io_header = syms.createIdentifier('I');
        this.io_header_input = syms.createIdentifier('I');
        this.io_header_output = syms.createIdentifier('I');
        this.io_header_link = this.addInputWmeInternal(this.decider.top_state, predefinedSyms.io_symbol, this.io_header);
        this.addInputWmeInternal(this.io_header, predefinedSyms.input_link_symbol, this.io_header_input);
        this.outputLinkWme = this.addInputWmeInternal(this.io_header, predefinedSyms.output_link_symbol, this.io_header_output);
    }

    @Override
    public Identifier getInputLink() {
        return this.io_header_input;
    }

    @Override
    public Identifier getOutputLink() {
        return this.io_header_output;
    }

    @Override
    public InputWme addInputWme(Identifier id, Symbol attr, Symbol value) {
        InputWmeImpl iw = new InputWmeImpl(this, this.addInputWmeInternal(id, attr, value));
        return iw;
    }

    <T extends SymbolImpl> T checkSymbolOwnership(T s) {
        if (!s.belongsTo(this.getSymbols())) {
            throw new IllegalArgumentException("Symbol '" + s + "' is from another symbol factory");
        }
        return s;
    }

    public WmeImpl addInputWmeInternal(Identifier id, Symbol attr, Symbol value) {
        Arguments.checkNotNull(id, "id");
        Arguments.checkNotNull(attr, "attr");
        Arguments.checkNotNull(value, "value");
        WmeImpl w = this.workingMemory.make_wme(this.checkSymbolOwnership((IdentifierImpl)id), this.checkSymbolOwnership((SymbolImpl)attr), this.checkSymbolOwnership((SymbolImpl)value), false);
        ((IdentifierImpl)id).addInputWme(w);
        this.workingMemory.add_wme_to_wm(w);
        return w;
    }

    void removeInputWme(InputWme w) {
        Arguments.check(w instanceof InputWmeImpl, "Incompatible WME type: " + w + ", " + w.getClass());
        this.wmesToRemove.offer((InputWmeImpl)w);
    }

    private void processPendingWmeRemovals() {
        InputWmeImpl w = this.wmesToRemove.poll();
        while (w != null) {
            this.removeInputWmeInternal(w.getInner());
            w = this.wmesToRemove.poll();
        }
    }

    public void removeInputWmeInternal(WmeImpl w) {
        Arguments.checkNotNull(w, "w");
        if (!w.isMemberOfList(w.id.getInputWmes())) {
            logger.warn(String.format("removeInputWmeInternal: %s is not currently in working memory. Ignoring.", w));
            return;
        }
        w.id.removeInputWme(w);
        if (w.gds != null && w.gds.getGoal() != null) {
            this.decider.gds_invalid_so_remove_goal(w, "While removing an input WME");
        }
        this.workingMemory.remove_wme_from_wm(w);
    }

    InputWme updateInputWme(InputWme w, Symbol newValue) {
        Arguments.checkNotNull(w, "w");
        Arguments.check(w instanceof InputWmeImpl, "Incompatible WME type: " + w + ", " + w.getClass());
        if (newValue == w.getValue()) {
            return w;
        }
        InputWmeImpl iw = (InputWmeImpl)w;
        WmeImpl inner = iw.getInner();
        this.removeInputWmeInternal(inner);
        iw.setInner(this.addInputWmeInternal(w.getIdentifier(), w.getAttribute(), newValue));
        return w;
    }

    @Override
    public List<Wme> getPendingCommands() {
        return new ArrayList<Wme>(this.pendingCommands);
    }

    @Override
    public List<Wme> getRemovingCommands() {
        return new ArrayList<Wme>(this.removingCommands);
    }

    @Override
    public void asynchronousInputReady() {
        this.context.getEvents().fireEvent(this.asyncInputReadyEvent);
    }

    public void do_input_cycle() {
        this.pendingCommands.clear();
        this.removingCommands.clear();
        if (this.prev_top_state && this.decider.top_state == null) {
            this.context.getEvents().fireEvent(this.topStateRemovedEvent);
            this.io_header = null;
            this.io_header_input = null;
            this.io_header_output = null;
            this.io_header_link = null;
        }
        if (this.decider.top_state != null) {
            this.context.getEvents().fireEvent(this.inputEvent);
        }
        this.processPendingWmeRemovals();
        this.decider.do_buffered_wm_and_ownership_changes();
        if (this.decider.top_state != null) {
            this.prev_top_state = true;
        }
        this.setOutputLinkChanged(false);
    }

    private void update_for_top_state_wme_addition(WmeImpl w) {
        if (w == this.outputLinkWme) {
            this.outputLinkStatus = OutputLinkStatus.NEW_OL_STATUS;
        }
    }

    private void update_for_top_state_wme_removal(WmeImpl w) {
        if (w == this.outputLinkWme) {
            this.outputLinkStatus = OutputLinkStatus.REMOVED_OL_STATUS;
        }
    }

    private void update_for_io_wme_change(WmeImpl w, boolean added) {
        if (this.outputLinkStatus != OutputLinkStatus.UNINITIALIZED_OL_STATUS && this.ids_in_tc.contains(w.id)) {
            if (w.value.asIdentifier() != null) {
                if (this.outputLinkStatus == OutputLinkStatus.UNCHANGED_OL_STATUS || this.outputLinkStatus == OutputLinkStatus.MODIFIED_BUT_SAME_TC_OL_STATUS) {
                    this.outputLinkStatus = OutputLinkStatus.MODIFIED_OL_STATUS;
                }
                if (w.id == this.outputLinkWme.value) {
                    if (added) {
                        this.pendingCommands.add(w);
                        this.removingCommands.remove(w);
                    } else {
                        this.pendingCommands.remove(w);
                        this.removingCommands.add(w);
                    }
                }
            } else if (this.outputLinkStatus == OutputLinkStatus.UNCHANGED_OL_STATUS) {
                this.outputLinkStatus = OutputLinkStatus.MODIFIED_BUT_SAME_TC_OL_STATUS;
            }
            this.setOutputLinkChanged(true);
        }
    }

    public void inform_output_module_of_wm_changes(ListHead<WmeImpl> wmes_being_added, ListHead<WmeImpl> wmes_being_removed) {
        WmeImpl w;
        ListItem it = wmes_being_added.first;
        while (it != null) {
            w = (WmeImpl)it.item;
            if (w.id == this.io_header) {
                this.update_for_top_state_wme_addition(w);
                this.setOutputLinkChanged(true);
            }
            this.update_for_io_wme_change(w, true);
            it = it.next;
        }
        it = wmes_being_removed.first;
        while (it != null) {
            w = (WmeImpl)it.item;
            if (w.id == this.io_header) {
                this.update_for_top_state_wme_removal(w);
            }
            this.update_for_io_wme_change(w, false);
            it = it.next;
        }
    }

    private void remove_output_link_tc_info() {
        this.ids_in_tc.clear();
    }

    private void add_id_to_output_link_tc(IdentifierImpl id) {
        if (id.tc_number == this.output_link_tc_num) {
            return;
        }
        id.tc_number = this.output_link_tc_num;
        this.ids_in_tc.add(id);
        WmeImpl w = id.getInputWmes();
        while (w != null) {
            IdentifierImpl valueAsId = w.value.asIdentifier();
            if (valueAsId != null) {
                this.add_id_to_output_link_tc(valueAsId);
            }
            w = w.next;
        }
        Slot s = id.slots;
        while (s != null) {
            WmeImpl w2 = s.getWmes();
            while (w2 != null) {
                IdentifierImpl valueAsId = w2.value.asIdentifier();
                if (valueAsId != null) {
                    this.add_id_to_output_link_tc(valueAsId);
                }
                w2 = w2.next;
            }
            s = s.next;
        }
    }

    private void calculate_output_link_tc_info() {
        IdentifierImpl valueAsId = this.outputLinkWme.value.asIdentifier();
        if (valueAsId == null) {
            return;
        }
        this.output_link_tc_num = DefaultMarker.create();
        this.add_id_to_output_link_tc(valueAsId);
    }

    private Set<Wme> get_io_wmes_for_output_link() {
        LinkedHashSet<Wme> io_wmes = new LinkedHashSet<Wme>();
        io_wmes.add(this.outputLinkWme);
        for (IdentifierImpl id : this.ids_in_tc) {
            WmeImpl w = id.getInputWmes();
            while (w != null) {
                io_wmes.add(w);
                w = w.next;
            }
            Slot s = id.slots;
            while (s != null) {
                WmeImpl w2 = s.getWmes();
                while (w2 != null) {
                    io_wmes.add(w2);
                    w2 = w2.next;
                }
                s = s.next;
            }
        }
        return io_wmes;
    }

    public void do_output_cycle() {
        Set<Wme> iw_list = null;
        switch (this.outputLinkStatus) {
            case UNCHANGED_OL_STATUS: {
                break;
            }
            case NEW_OL_STATUS: {
                this.calculate_output_link_tc_info();
                iw_list = this.get_io_wmes_for_output_link();
                this.context.getEvents().fireEvent(new OutputEvent(this, OutputEvent.OutputMode.ADDED_OUTPUT_COMMAND, iw_list, this.lastOutputSet));
                this.outputLinkStatus = OutputLinkStatus.UNCHANGED_OL_STATUS;
                this.lastOutputSet = iw_list;
                break;
            }
            case MODIFIED_BUT_SAME_TC_OL_STATUS: {
                iw_list = this.get_io_wmes_for_output_link();
                this.context.getEvents().fireEvent(new OutputEvent(this, OutputEvent.OutputMode.MODIFIED_OUTPUT_COMMAND, iw_list, this.lastOutputSet));
                this.outputLinkStatus = OutputLinkStatus.UNCHANGED_OL_STATUS;
                this.lastOutputSet = iw_list;
                break;
            }
            case MODIFIED_OL_STATUS: {
                this.remove_output_link_tc_info();
                this.calculate_output_link_tc_info();
                iw_list = this.get_io_wmes_for_output_link();
                this.context.getEvents().fireEvent(new OutputEvent(this, OutputEvent.OutputMode.MODIFIED_OUTPUT_COMMAND, iw_list, this.lastOutputSet));
                this.outputLinkStatus = OutputLinkStatus.UNCHANGED_OL_STATUS;
                this.lastOutputSet = iw_list;
                break;
            }
            case REMOVED_OL_STATUS: {
                this.remove_output_link_tc_info();
                iw_list = this.get_io_wmes_for_output_link();
                this.context.getEvents().fireEvent(new OutputEvent(this, OutputEvent.OutputMode.REMOVED_OUTPUT_COMMAND, iw_list, this.lastOutputSet));
                this.outputLinkStatus = OutputLinkStatus.UNINITIALIZED_OL_STATUS;
                this.lastOutputSet = null;
                break;
            }
        }
    }

    private void setOutputLinkChanged(boolean output_link_changed) {
        this.output_link_changed = output_link_changed;
    }

    public boolean isOutputLinkChanged() {
        return this.output_link_changed;
    }

    private static enum OutputLinkStatus {
        UNINITIALIZED_OL_STATUS,
        NEW_OL_STATUS,
        UNCHANGED_OL_STATUS,
        MODIFIED_BUT_SAME_TC_OL_STATUS,
        MODIFIED_OL_STATUS,
        REMOVED_OL_STATUS;

    }
}

