/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jsoar.kernel.memory.Wme;

public class OutputChange {
    private final Wme wme;
    private final boolean added;

    public static List<OutputChange> sortByTimeTag(Iterator<OutputChange> changeIt) {
        ArrayList changes = Lists.newArrayList(changeIt);
        Collections.sort(changes, new Comparator<OutputChange>(){

            @Override
            public int compare(OutputChange o1, OutputChange o2) {
                return o1.getWme().getTimetag() - o2.getWme().getTimetag();
            }
        });
        return changes;
    }

    public OutputChange(Wme wme, boolean added) {
        this.wme = wme;
        this.added = added;
    }

    public Wme getWme() {
        return this.wme;
    }

    public boolean isAdded() {
        return this.added;
    }

    public String toString() {
        return String.format("(%d: %s ^%s %s) (%s)", this.wme.getTimetag(), this.wme.getIdentifier(), this.wme.getAttribute(), this.wme.getValue(), this.added ? "+" : "-");
    }
}

