/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io;

import java.util.Map;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.events.InputEvent;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.InputWme;
import org.jsoar.kernel.io.InputWmes;
import org.jsoar.kernel.symbols.Symbols;
import org.jsoar.util.Arguments;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;

public class ProductionCountInput {
    private final Agent agent;
    private final InputOutput io;
    private final InputListener listener;
    private InputWme rootIdWme;
    private InputWme totalCountWme;
    private InputWme userCountWme;
    private InputWme chunkCountWme;
    private InputWme defaultCountWme;
    private InputWme justificationCountWme;
    private InputWme templateCountWme;

    public ProductionCountInput(Agent agent) {
        Arguments.checkNotNull(agent, "agent");
        this.agent = agent;
        this.io = agent.getInputOutput();
        this.listener = new InputListener();
        this.io.getEvents().addListener(InputEvent.class, this.listener);
    }

    public void dispose() {
        this.io.getEvents().removeListener(null, this.listener);
        if (this.rootIdWme != null) {
            this.rootIdWme.remove();
            this.rootIdWme = null;
            this.chunkCountWme = null;
            this.defaultCountWme = null;
            this.justificationCountWme = null;
            this.templateCountWme = null;
            this.totalCountWme = null;
            this.userCountWme = null;
        }
    }

    private void update() {
        Map<ProductionType, Integer> counts = this.agent.getProductions().getProductionCounts();
        int totalCount = this.agent.getProductions().getProductionCount();
        int chunkCount = counts.get((Object)ProductionType.CHUNK);
        int defaultCount = counts.get((Object)ProductionType.DEFAULT);
        int justificationCount = counts.get((Object)ProductionType.JUSTIFICATION);
        int templateCount = counts.get((Object)ProductionType.TEMPLATE);
        int userCount = counts.get((Object)ProductionType.USER);
        if (this.rootIdWme == null) {
            this.rootIdWme = InputWmes.add(this.io, (Object)"production-counts", Symbols.NEW_ID);
            this.chunkCountWme = InputWmes.add(this.rootIdWme, (Object)"chunk", (Object)chunkCount);
            this.defaultCountWme = InputWmes.add(this.rootIdWme, (Object)"default", (Object)defaultCount);
            this.justificationCountWme = InputWmes.add(this.rootIdWme, (Object)"justification", (Object)justificationCount);
            this.templateCountWme = InputWmes.add(this.rootIdWme, (Object)"template", (Object)templateCount);
            this.totalCountWme = InputWmes.add(this.rootIdWme, (Object)"total", (Object)totalCount);
            this.userCountWme = InputWmes.add(this.rootIdWme, (Object)"user", (Object)userCount);
        } else {
            InputWmes.update(this.chunkCountWme, chunkCount);
            InputWmes.update(this.defaultCountWme, defaultCount);
            InputWmes.update(this.justificationCountWme, justificationCount);
            InputWmes.update(this.templateCountWme, templateCount);
            InputWmes.update(this.totalCountWme, totalCount);
            InputWmes.update(this.userCountWme, userCount);
        }
    }

    private class InputListener
    implements SoarEventListener {
        private InputListener() {
        }

        @Override
        public void onEvent(SoarEvent event) {
            ProductionCountInput.this.update();
        }
    }
}

