/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.jsoar.kernel.events.BeforeInitSoarEvent;
import org.jsoar.kernel.events.InputEvent;
import org.jsoar.kernel.io.InputBuilder;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.InputWme;
import org.jsoar.kernel.io.InputWmes;
import org.jsoar.util.Arguments;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;

public class TimeInput {
    private final InputOutput io;
    private final InputListener listener;
    private final InitSoarListener initListener;
    private Calendar startTime;
    private InputWme wme;
    private final Map<String, InputWme> childWmes = new HashMap<String, InputWme>();

    public TimeInput(InputOutput io) {
        Arguments.checkNotNull(io, "io");
        this.io = io;
        this.listener = new InputListener();
        this.initListener = new InitSoarListener();
        this.io.getEvents().addListener(InputEvent.class, this.listener);
        this.io.getEvents().addListener(BeforeInitSoarEvent.class, this.initListener);
    }

    public void dispose() {
        this.io.getEvents().removeListener(null, this.listener);
        this.io.getEvents().removeListener(null, this.initListener);
        if (this.wme != null) {
            this.wme.remove();
            this.wme = null;
            for (InputWme childWme : this.childWmes.values()) {
                childWme.remove();
            }
            this.childWmes.clear();
        }
    }

    private void setChildWme(String name, int value) {
        if (!this.childWmes.containsKey(name)) {
            InputWme childWme = InputWmes.add(this.wme, (Object)name, (Object)value);
            this.childWmes.put(name, childWme);
        } else {
            InputWmes.update(this.childWmes.get(name), value);
        }
    }

    private void update() {
        if (this.startTime == null) {
            this.startTime = Calendar.getInstance();
        }
        if (this.wme == null) {
            this.wme = InputBuilder.create(this.io).push("time").getWme(null);
        }
        Calendar currentTime = Calendar.getInstance();
        this.setChildWme("second", currentTime.get(13));
        this.setChildWme("minute", currentTime.get(12));
        this.setChildWme("hour", currentTime.get(10));
        this.setChildWme("day", currentTime.get(5));
        this.setChildWme("month", currentTime.get(2));
        this.setChildWme("year", currentTime.get(1));
        long msecFromStart = currentTime.getTimeInMillis() - this.startTime.getTimeInMillis();
        this.setChildWme("seconds-from-start", (int)((double)msecFromStart / 1000.0));
    }

    private class InitSoarListener
    implements SoarEventListener {
        private InitSoarListener() {
        }

        @Override
        public void onEvent(SoarEvent event) {
            TimeInput.this.wme = null;
            TimeInput.this.childWmes.clear();
            TimeInput.this.startTime = Calendar.getInstance();
        }
    }

    private class InputListener
    implements SoarEventListener {
        private InputListener() {
        }

        @Override
        public void onEvent(SoarEvent event) {
            TimeInput.this.update();
        }
    }
}

