/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.beans;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jsoar.kernel.events.OutputEvent;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.InputWmes;
import org.jsoar.kernel.io.beans.SoarBeanException;
import org.jsoar.kernel.io.beans.SoarBeanOutputContext;
import org.jsoar.kernel.io.beans.SoarBeanOutputHandler;
import org.jsoar.kernel.io.beans.SoarBeanReader;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;
import org.jsoar.util.events.SoarEventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoarBeanOutputManager {
    private static final Logger logger = LoggerFactory.getLogger(SoarBeanOutputManager.class);
    private final SoarEventManager eventManager;
    private final SoarEventListener listener;
    private final SoarBeanReader reader = new SoarBeanReader();
    private final Map<String, HandlerInfo> handlers = new ConcurrentHashMap<String, HandlerInfo>();

    public SoarBeanOutputManager(SoarEventManager eventManager) {
        this.eventManager = eventManager;
        this.listener = new SoarEventListener(){

            @Override
            public void onEvent(SoarEvent event) {
                SoarBeanOutputManager.this.handleCommands((OutputEvent)event);
            }
        };
        this.eventManager.addListener(OutputEvent.class, this.listener);
    }

    public void dispose() {
        this.eventManager.removeListener(null, this.listener);
    }

    public <T> void registerHandler(String name, SoarBeanOutputHandler<T> handler, Class<T> beanClass) {
        this.handlers.put(name, new HandlerInfo(handler, beanClass));
    }

    public void unregisterHandler(String name) {
        this.handlers.remove(name);
    }

    private void handleCommands(OutputEvent outputEvent) {
        for (Wme command : outputEvent.getInputOutput().getPendingCommands()) {
            this.handleCommand(outputEvent, command);
        }
    }

    private void handleCommand(final OutputEvent outputEvent, final Wme command) {
        String name = command.getAttribute().toString();
        HandlerInfo info = this.handlers.get(name);
        if (info == null) {
            return;
        }
        final Identifier id = command.getValue().asIdentifier();
        if (id == null) {
            return;
        }
        try {
            Object bean = this.reader.read(id, info.beanClass);
            SoarBeanOutputContext context = new SoarBeanOutputContext(){

                @Override
                public Wme getCommand() {
                    return command;
                }

                @Override
                public InputOutput getInputOutput() {
                    return outputEvent.getInputOutput();
                }

                @Override
                public void setStatus(Object status) {
                    InputWmes.add(this.getInputOutput(), id, "status", status);
                }

                @Override
                public void setStatusComplete() {
                    this.setStatus("complete");
                }
            };
            info.handler.handleOutputCommand(context, bean);
        }
        catch (SoarBeanException e) {
            if (info.handler.exceptionHandler != null) {
                info.handler.exceptionHandler.handleSoarBeanException(e);
            }
            logger.error("While handling output command '" + name + "'", (Throwable)e);
        }
    }

    private static class HandlerInfo {
        final Class<?> beanClass;
        final SoarBeanOutputHandler handler;

        public HandlerInfo(SoarBeanOutputHandler<?> handler, Class<?> beanClass) {
            this.beanClass = beanClass;
            this.handler = handler;
        }
    }
}

