/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.commands;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.jsoar.kernel.events.OutputEvent;
import org.jsoar.kernel.io.commands.OutputCommandHandler;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;
import org.jsoar.util.events.SoarEventManager;

public class OutputCommandManager {
    private final Map<String, OutputCommandHandler> commandHandlers = Maps.newConcurrentMap();
    private final SoarEventListener listener;
    private final SoarEventManager eventManager;

    public OutputCommandManager(SoarEventManager eventManager) {
        this.eventManager = eventManager;
        this.listener = new SoarEventListener(){

            @Override
            public void onEvent(SoarEvent soarEvent) {
                OutputEvent event = (OutputEvent)soarEvent;
                Collection pendingCommands = Collections2.filter(event.getInputOutput().getPendingCommands(), (Predicate)new ValidityPredicate());
                for (Wme wme : pendingCommands) {
                    String name = wme.getAttribute().asString().getValue();
                    Identifier identifier = wme.getValue().asIdentifier();
                    OutputCommandHandler handler = (OutputCommandHandler)OutputCommandManager.this.commandHandlers.get(name);
                    if (handler == null) continue;
                    handler.onCommandAdded(name, identifier);
                }
                Collection removingCommands = Collections2.filter(event.getInputOutput().getRemovingCommands(), (Predicate)new ValidityPredicate());
                for (Wme wme : removingCommands) {
                    String name = wme.getAttribute().asString().getValue();
                    Identifier identifier = wme.getValue().asIdentifier();
                    OutputCommandHandler handler = (OutputCommandHandler)OutputCommandManager.this.commandHandlers.get(name);
                    if (handler == null) continue;
                    handler.onCommandRemoved(name, identifier);
                }
            }
        };
        this.eventManager.addListener(OutputEvent.class, this.listener);
    }

    public void registerHandler(String commandName, OutputCommandHandler commandHandler) {
        this.commandHandlers.put(commandName, commandHandler);
    }

    public void dispose() {
        this.eventManager.removeListener(null, this.listener);
    }

    private static class ValidityPredicate
    implements Predicate<Wme> {
        private ValidityPredicate() {
        }

        public boolean apply(Wme wme) {
            if (wme.getAttribute().asString() == null) {
                return false;
            }
            return wme.getValue().asIdentifier() != null;
        }
    }
}

