/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.quick;

import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.InputWme;
import org.jsoar.kernel.io.quick.MemoryNode;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.Symbols;

class SoarMemoryNode {
    private InputWme wme;
    private Identifier idValue;
    private String name;
    private SoarMemoryNode parentNode;
    private MemoryNode memoryNode;

    private Identifier getIdValue() {
        return this.idValue;
    }

    public InputWme getWME() {
        return this.wme;
    }

    public Symbol getValue() {
        return this.wme != null ? this.wme.getValue() : this.getIdValue();
    }

    private void setWME(InputWme wme) {
        this.wme = wme;
        this.idValue = wme != null ? wme.getValue().asIdentifier() : null;
    }

    public SoarMemoryNode(Identifier idValue) {
        this.idValue = idValue;
        this.memoryNode = new MemoryNode();
    }

    public SoarMemoryNode(String name) {
        this.name = name;
        this.memoryNode = new MemoryNode();
    }

    public void setParentNode(SoarMemoryNode parentNode) {
        this.parentNode = parentNode;
    }

    private void createWME(InputOutput io, MemoryNode node) {
        assert (this.wme == null && this.parentNode != null);
        if (this.name == null) {
            return;
        }
        Identifier parentWME = this.parentNode.getIdValue();
        Symbol attr = Symbols.create(io.getSymbols(), this.name);
        Symbol value = node.getValue() != null ? Symbols.create(io.getSymbols(), node.getValue()) : io.getSymbols().createIdentifier(this.name.charAt(0));
        this.setWME(io.addInputWme(parentWME, attr, value));
        if (node.isString()) {
            String strVal = node.getStringValue();
            this.memoryNode.setStringValue(strVal);
        } else if (node.isInt()) {
            long intVal = node.getIntValue();
            this.memoryNode.setIntValue(intVal);
        } else if (node.isDouble()) {
            double doubleVal = node.getDoubleValue();
            this.memoryNode.setDoubleValue(doubleVal);
        } else {
            this.memoryNode.clearValue();
        }
    }

    private void updateWME(InputOutput io, MemoryNode node) {
        assert (this.wme != null && this.memoryNode.hasSameType(node));
        if (this.name == null) {
            return;
        }
        if (!this.memoryNode.valueIsEqual(node)) {
            this.wme.update(Symbols.create(io.getSymbols(), node.getValue() != null ? node.getValue() : Symbols.NEW_ID));
            this.setWME(this.wme);
            this.memoryNode.setValue(node);
        }
    }

    public void remove(InputOutput io) {
        if (this.wme != null) {
            this.wme.remove();
            this.setWME(null);
        }
    }

    public void synchronizeToMemoryNode(InputOutput io, MemoryNode node) {
        if (this.wme == null) {
            this.createWME(io, node);
        } else if (!this.memoryNode.hasSameType(node)) {
            this.wme.remove();
            this.wme = null;
            this.createWME(io, node);
        } else {
            this.updateWME(io, node);
        }
    }
}

