/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.quick;

import java.util.Set;
import org.jsoar.kernel.io.quick.DefaultQMemory;
import org.jsoar.kernel.io.quick.QMemory;
import org.jsoar.kernel.io.quick.QMemoryListener;

class SubQMemory
implements QMemory {
    private final DefaultQMemory source;
    private final String prefix;

    SubQMemory(DefaultQMemory source, String prefix) {
        this.source = source;
        this.prefix = prefix.endsWith(".") ? prefix : prefix + '.';
    }

    private String getPath(String path) {
        return this.prefix + path;
    }

    @Override
    public double getDouble(String path) {
        return this.source.getDouble(this.getPath(path));
    }

    @Override
    public long getInteger(String path) {
        return this.source.getInteger(this.getPath(path));
    }

    @Override
    public Set<String> getPaths() {
        return this.source.getPaths(this.prefix, true);
    }

    @Override
    public String getString(String path) {
        return this.source.getString(this.getPath(path));
    }

    @Override
    public boolean hasPath(String path) {
        return this.source.hasPath(this.getPath(path));
    }

    @Override
    public QMemory subMemory(String prefix) {
        return new SubQMemory(this.source, this.prefix + prefix);
    }

    @Override
    public void clear(String path) {
        this.source.clear(this.getPath(path));
    }

    @Override
    public void remove(String path) {
        this.source.remove(this.getPath(path));
    }

    @Override
    public void setDouble(String path, double doubleVal) {
        this.source.setDouble(this.getPath(path), doubleVal);
    }

    @Override
    public void setInteger(String path, int intVal) {
        this.source.setInteger(this.getPath(path), intVal);
    }

    @Override
    public void setInteger(String path, long longVal) {
        this.source.setInteger(this.getPath(path), longVal);
    }

    @Override
    public void setString(String path, String strVal) {
        this.source.setString(this.getPath(path), strVal);
    }

    @Override
    public void addListener(QMemoryListener listener) {
        this.source.addListener(listener);
    }

    @Override
    public void removeListener(QMemoryListener listener) {
        this.source.removeListener(listener);
    }
}

