/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.xml;

import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.xml.AbstractXmlFileToWme;
import org.jsoar.kernel.memory.WmeBuilder;
import org.jsoar.kernel.memory.WmeFactory;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AutoTypeXmlToWme
extends AbstractXmlFileToWme {
    public AutoTypeXmlToWme(InputOutput io) {
        super(io);
    }

    public AutoTypeXmlToWme(WmeFactory<?> io) {
        super(io);
    }

    public static AutoTypeXmlToWme forRhsFunction(RhsFunctionContext rhsContext) {
        return new AutoTypeXmlToWme(rhsContext);
    }

    @Override
    protected void getXmlTree(NodeList nodeList, WmeBuilder<?> builder) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node current = nodeList.item(i);
            if (current.getNodeType() != 1) continue;
            boolean pushed = false;
            if (current.hasAttributes()) {
                pushed = true;
                builder = builder.push(current.getNodeName());
                this.addAttributes(current.getAttributes(), builder);
            }
            if (current.getChildNodes().getLength() == 1 && current.getFirstChild().getNodeValue() != null) {
                if (pushed) {
                    builder = builder.pop();
                }
                this.addWme(builder, current.getNodeName(), current.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!current.hasChildNodes() && !current.hasAttributes()) {
                if (pushed) {
                    builder = builder.pop();
                }
                this.addWme(builder, current.getNodeName(), "");
                continue;
            }
            if (current.hasChildNodes() && current.getNodeName() != null) {
                if (!pushed) {
                    builder = builder.push(current.getNodeName());
                }
                this.getXmlTree(current.getChildNodes(), builder);
                builder = builder.pop();
                continue;
            }
            if (!pushed) continue;
            builder = builder.pop();
        }
    }

    @Override
    protected void addAttributes(NamedNodeMap nnm, WmeBuilder<?> builder) {
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            String val = n.getNodeValue().trim();
            if (val.length() <= 0) continue;
            this.addWme(builder, n.getNodeName(), n.getNodeValue());
        }
    }

    private void addWme(WmeBuilder<?> builder, String attribute, String value) {
        try {
            Long intVal = Long.parseLong(value);
            builder = builder.add(attribute, intVal);
            return;
        }
        catch (NumberFormatException intVal) {
            try {
                Double doubleVal = Double.parseDouble(value);
                builder = builder.add(attribute, doubleVal);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                builder = builder.add(attribute, value);
                return;
            }
        }
    }
}

