/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.xml;

import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.xml.XmlToWme;
import org.jsoar.kernel.memory.WmeFactory;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.Symbols;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DefaultXmlToWme
implements XmlToWme {
    private final WmeFactory<?> wmeFactory;

    public static DefaultXmlToWme forInput(InputOutput io) {
        return new DefaultXmlToWme(io.asWmeFactory());
    }

    public static DefaultXmlToWme forRhsFunction(RhsFunctionContext rhsContext) {
        return new DefaultXmlToWme(rhsContext);
    }

    public DefaultXmlToWme(WmeFactory<?> wmeFactory) {
        this.wmeFactory = wmeFactory;
    }

    @Override
    public Identifier fromXml(Element element) {
        return this.fromXmlInternal(element);
    }

    private void addAttributes(Element element, Identifier targetId) {
        assert (element != null);
        assert (targetId != null);
        SymbolFactory syms = this.wmeFactory.getSymbols();
        NamedNodeMap attrs = element.getAttributes();
        int attrsLength = attrs.getLength();
        if (attrsLength == 0) {
            return;
        }
        Identifier attrsId = syms.createIdentifier('a');
        this.wmeFactory.addWme(targetId, syms.createString("/attrs"), attrsId);
        for (int i = 0; i < attrsLength; ++i) {
            Attr attr = (Attr)attrs.item(i);
            this.wmeFactory.addWme(attrsId, syms.createString(attr.getName()), syms.createString(attr.getValue()));
        }
    }

    private void addTextWme(Identifier targetId, String text) {
        if (text != null && text.length() != 0) {
            SymbolFactory syms = this.wmeFactory.getSymbols();
            this.wmeFactory.addWme(targetId, syms.createString("/text"), syms.createString(text));
        }
    }

    private Identifier fromXmlInternal(Element element) {
        SymbolFactory syms = this.wmeFactory.getSymbols();
        Identifier targetId = syms.createIdentifier(Symbols.getFirstLetter(element.getTagName()));
        String text = "";
        Identifier lastChildId = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof Text) {
                text = text + ((Text)node).getData();
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element kid = (Element)node;
            String tagName = kid.getTagName();
            StringSymbol attribute = syms.createString(tagName);
            Identifier kidId = this.fromXmlInternal(kid);
            this.wmeFactory.addWme(targetId, attribute, kidId);
            if (lastChildId != null) {
                this.wmeFactory.addWme(lastChildId, syms.createString("/next"), kidId);
            }
            lastChildId = kidId;
        }
        this.addAttributes(element, targetId);
        this.addTextWme(targetId, text.trim());
        return targetId;
    }
}

