/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.io.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.io.xml.XmlToWme;
import org.jsoar.kernel.memory.WmeFactory;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.util.Arguments;
import org.jsoar.util.XmlTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoarTechXmlToWme
implements XmlToWme {
    private static final Logger logger = LoggerFactory.getLogger(SoarTechXmlToWme.class);
    private final WmeFactory<?> wmeFactory;
    private final Map<String, Symbol> linkMap = new HashMap<String, Symbol>();
    private final List<Link> links = new ArrayList<Link>();

    public static SoarTechXmlToWme forInput(InputOutput io) {
        return new SoarTechXmlToWme(io.asWmeFactory());
    }

    public static SoarTechXmlToWme forRhsFunction(RhsFunctionContext rhsContext) {
        return new SoarTechXmlToWme(rhsContext);
    }

    public SoarTechXmlToWme(WmeFactory<?> wmeFactory) {
        Arguments.checkNotNull(wmeFactory, "wmeFactory");
        this.wmeFactory = wmeFactory;
    }

    @Override
    public Identifier fromXml(Element element) {
        return this.fromXml(element, null);
    }

    public Identifier fromXml(Element element, Identifier targetId) {
        Identifier result = this.fromXmlInternal(element, targetId);
        for (Link link : this.links) {
            Symbol target = this.linkMap.get(link.linkTo);
            if (target != null) {
                this.wmeFactory.addWme(link.from, link.attribute, target);
                continue;
            }
            logger.error("Unknown link target '" + link.linkTo + "'");
        }
        this.links.clear();
        this.linkMap.clear();
        return result;
    }

    private Identifier fromXmlInternal(Element element, Identifier targetId) {
        SymbolFactory syms = this.wmeFactory.getSymbols();
        if (targetId == null) {
            targetId = syms.createIdentifier(element.getTagName().charAt(0));
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element kid = (Element)node;
            String linkTo = kid.getAttribute("link");
            String tagName = kid.getTagName();
            if (null == tagName) {
                logger.warn("null tagName on node " + node);
                continue;
            }
            StringSymbol attribute = syms.createString(tagName);
            if (linkTo.length() == 0) {
                Symbol value = this.getValue(kid);
                this.wmeFactory.addWme(targetId, attribute, value);
                String link = kid.getAttribute("link-id");
                if (link.length() == 0) continue;
                this.linkMap.put(link, value);
                continue;
            }
            this.links.add(new Link(targetId, attribute, linkTo));
        }
        return targetId;
    }

    private Symbol getValue(Element element) {
        SymbolFactory syms = this.wmeFactory.getSymbols();
        String type = element.getAttribute("type");
        if (type.length() == 0 && XmlTools.getFirstChild(element) != null) {
            return this.fromXmlInternal(element, null);
        }
        String value = element.hasAttribute("value") ? element.getAttribute("value") : element.getTextContent();
        if (null == value) {
            return syms.createString("");
        }
        if ("double".equals(type)) {
            return syms.createDouble(Double.valueOf(value));
        }
        if ("integer".equals(type)) {
            return syms.createInteger(Long.valueOf(value));
        }
        return syms.createString(value);
    }

    private static class Link {
        private final Identifier from;
        private final Symbol attribute;
        private final String linkTo;

        public Link(Identifier from, Symbol attribute, String linkTo) {
            this.from = from;
            this.attribute = attribute;
            this.linkTo = linkTo;
        }
    }
}

