/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.learning;

import java.util.Iterator;
import java.util.LinkedList;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.learning.Backtrace;
import org.jsoar.kernel.learning.ChunkCondition;
import org.jsoar.kernel.learning.Chunker;
import org.jsoar.kernel.lhs.BackTraceInfo;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.rete.NotStruct;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.util.ByRef;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.markers.DefaultMarker;

public class Backtracer {
    private final Agent context;
    private Chunker chunker;
    private PredefinedSymbols predefinedSyms;
    int backtrace_number;
    final LinkedList<Condition> grounds = new LinkedList();
    int grounds_tc;
    final LinkedList<PositiveCondition> locals = new LinkedList();
    int locals_tc = 0;
    final LinkedList<PositiveCondition> positive_potentials = new LinkedList();
    int potentials_tc = 0;

    public Backtracer(Agent context) {
        this.context = context;
    }

    public void initialize() {
        this.chunker = Adaptables.adapt(this.context, Chunker.class);
        this.predefinedSyms = Adaptables.adapt(this.context, PredefinedSymbols.class);
    }

    private void add_to_grounds(PositiveCondition cond) {
        BackTraceInfo bt = cond.bt();
        if (bt.wme_.grounds_tc != this.grounds_tc) {
            bt.wme_.grounds_tc = this.grounds_tc;
            this.grounds.push(cond);
        }
    }

    private void add_to_potentials(PositiveCondition cond) {
        BackTraceInfo bt = cond.bt();
        if (bt.wme_.potentials_tc != this.potentials_tc) {
            bt.wme_.potentials_tc = this.potentials_tc;
            bt.wme_.chunker_bt_pref = bt.trace;
            this.positive_potentials.push(cond);
        } else if (bt.wme_.chunker_bt_pref != bt.trace) {
            this.positive_potentials.push(cond);
        }
    }

    private void add_to_locals(PositiveCondition cond) {
        BackTraceInfo bt = cond.bt();
        if (bt.wme_.locals_tc != this.locals_tc) {
            bt.wme_.locals_tc = this.locals_tc;
            bt.wme_.chunker_bt_pref = bt.trace;
            this.locals.push(cond);
        } else if (bt.wme_.chunker_bt_pref != bt.trace) {
            this.locals.push(cond);
        }
    }

    private void print_consed_list_of_conditions(LinkedList<Condition> list, int indent) {
        Printer p = this.context.getPrinter();
        for (Condition c : list) {
            p.spaces(indent).print("%s", c);
        }
    }

    private void print_consed_list_of_condition_wmes(LinkedList<Condition> list, int indent) {
        Printer p = this.context.getPrinter();
        for (Condition c : list) {
            PositiveCondition pc = c.asPositiveCondition();
            p.spaces(indent).print("     %s", pc != null ? pc.bt().wme_ : null);
        }
    }

    void backtrace_through_instantiation(Instantiation inst, int grounds_level, Condition trace_cond, ByRef<Boolean> reliable, int indent) {
        PositiveCondition pc;
        Trace trace = this.context.getTrace();
        Printer p = trace.getPrinter();
        boolean traceBacktracing = trace.isEnabled(Trace.Category.BACKTRACING);
        if (traceBacktracing) {
            p.spaces(indent).print("... BT through instantiation of %s\n", inst.prod != null ? inst.prod.getName() : "[dummy production]");
        }
        if (inst.backtrace_number == this.backtrace_number) {
            if (traceBacktracing) {
                p.spaces(indent).print("(We already backtraced through this instantiation.)\n");
            }
            return;
        }
        inst.backtrace_number = this.backtrace_number;
        Backtrace temp_explain_backtrace = null;
        if (this.chunker.explain.isEnabled()) {
            temp_explain_backtrace = new Backtrace();
            temp_explain_backtrace.trace_cond = trace_cond;
            temp_explain_backtrace.result = trace_cond == null;
            temp_explain_backtrace.grounds = null;
            temp_explain_backtrace.potentials = null;
            temp_explain_backtrace.locals = null;
            temp_explain_backtrace.negated = null;
            temp_explain_backtrace.prod_name = inst.prod != null ? inst.prod.getName() : "Dummy production";
            temp_explain_backtrace.next_backtrace = null;
        }
        if (!inst.reliable) {
            reliable.value = false;
        }
        DefaultMarker tc = DefaultMarker.create();
        DefaultMarker tc2 = DefaultMarker.create();
        boolean need_another_pass = false;
        Condition c = inst.top_of_instantiated_conditions;
        while (c != null) {
            pc = c.asPositiveCondition();
            if (pc != null) {
                IdentifierImpl valueId;
                IdentifierImpl id = pc.id_test.asEqualityTest().getReferent().asIdentifier();
                if (id.tc_number == tc) {
                    valueId = pc.value_test.asEqualityTest().getReferent().asIdentifier();
                    if (valueId != null) {
                        if (valueId.tc_number == tc2) {
                            need_another_pass = true;
                        }
                        valueId.tc_number = tc;
                    }
                } else if (id.isGoal() && pc.bt().level <= grounds_level) {
                    id.tc_number = tc;
                    valueId = pc.value_test.asEqualityTest().getReferent().asIdentifier();
                    if (valueId != null) {
                        if (valueId.tc_number == tc2) {
                            need_another_pass = true;
                        }
                        valueId.tc_number = tc;
                    }
                } else {
                    id.tc_number = tc2;
                }
            }
            c = c.next;
        }
        while (need_another_pass) {
            need_another_pass = false;
            c = inst.top_of_instantiated_conditions;
            while (c != null) {
                IdentifierImpl valueId;
                pc = c.asPositiveCondition();
                if (pc != null && pc.id_test.asEqualityTest().getReferent().asIdentifier().tc_number == tc && (valueId = pc.value_test.asEqualityTest().getReferent().asIdentifier()) != null && valueId.tc_number != tc) {
                    valueId.tc_number = tc;
                    need_another_pass = true;
                }
                c = c.next;
            }
        }
        LinkedList<Condition> grounds_to_print = new LinkedList<Condition>();
        LinkedList<Condition> pots_to_print = new LinkedList<Condition>();
        LinkedList<Condition> locals_to_print = new LinkedList<Condition>();
        LinkedList<Condition> negateds_to_print = new LinkedList<Condition>();
        boolean traceBacktracingOrExplain = traceBacktracing || this.chunker.explain.isEnabled();
        Condition c2 = inst.top_of_instantiated_conditions;
        while (c2 != null) {
            PositiveCondition pc2 = c2.asPositiveCondition();
            if (pc2 != null) {
                if (pc2.id_test.asEqualityTest().getReferent().asIdentifier().tc_number == tc) {
                    this.add_to_grounds(pc2);
                    if (traceBacktracingOrExplain) {
                        grounds_to_print.push(c2);
                    }
                } else if (pc2.bt().level <= grounds_level) {
                    this.add_to_potentials(pc2);
                    if (traceBacktracingOrExplain) {
                        pots_to_print.push(c2);
                    }
                } else {
                    this.add_to_locals(pc2);
                    if (traceBacktracingOrExplain) {
                        locals_to_print.push(c2);
                    }
                }
            } else {
                this.chunker.negated_set.add_to_chunk_cond_set(ChunkCondition.make_chunk_cond_for_condition(c2));
                if (traceBacktracingOrExplain) {
                    negateds_to_print.push(c2);
                }
            }
            c2 = c2.next;
        }
        if (inst.nots != null) {
            this.chunker.instantiations_with_nots.push(inst);
        }
        if (this.chunker.explain.isEnabled()) {
            this.chunker.explain.explain_add_temp_to_backtrace_list(temp_explain_backtrace, grounds_to_print, pots_to_print, locals_to_print, negateds_to_print);
        }
        if (traceBacktracing) {
            p.spaces(indent).print("  -->Grounds:\n");
            this.print_consed_list_of_condition_wmes(grounds_to_print, indent);
            p.print("\n").spaces(indent).print("\n  -->Potentials:\n");
            this.print_consed_list_of_condition_wmes(pots_to_print, indent);
            p.print("\n").spaces(indent).print("  -->Locals:\n");
            this.print_consed_list_of_condition_wmes(locals_to_print, indent);
            p.print("\n").spaces(indent).print("  -->Negated:\n");
            this.print_consed_list_of_conditions(negateds_to_print, indent);
            p.print("\n").spaces(indent).print("  -->Nots:\n");
            NotStruct not1 = inst.nots;
            while (not1 != null) {
                p.print("    %s <> %s\n", not1.s1, not1.s2);
                not1 = not1.next;
            }
        }
    }

    void trace_locals(int grounds_level, ByRef<Boolean> reliable) {
        Trace trace = this.context.getTrace();
        Printer printer = trace.getPrinter();
        boolean traceBacktracing = trace.isEnabled(Trace.Category.BACKTRACING);
        if (traceBacktracing) {
            printer.print("\n\n*** Tracing Locals ***\n");
        }
        while (!this.locals.isEmpty()) {
            Preference bt_pref;
            PositiveCondition cond = this.locals.pop();
            BackTraceInfo bt = cond.bt();
            if (traceBacktracing) {
                printer.print("\nFor local %s ", bt.wme_);
            }
            if ((bt_pref = Preference.find_clone_for_level(bt.trace, grounds_level + 1)) != null) {
                this.backtrace_through_instantiation(bt_pref.inst, grounds_level, cond, reliable, 0);
                if (!bt.hasContextDependentPreferences()) continue;
                for (Preference p : bt) {
                    if (traceBacktracing) {
                        printer.print("     Backtracing through CDPS preference: %s", p);
                    }
                    this.backtrace_through_instantiation(p.inst, grounds_level, cond, reliable, 6);
                }
                continue;
            }
            if (traceBacktracing) {
                printer.print("...no trace, can't BT");
            }
            if (cond.id_test.asEqualityTest().getReferent().asIdentifier().isGoal()) {
                if (cond.attr_test.asEqualityTest().getReferent() != this.predefinedSyms.quiescence_symbol || cond.value_test.asEqualityTest().getReferent() != this.predefinedSyms.t_symbol || cond.test_for_acceptable_preference) continue;
                reliable.value = false;
                continue;
            }
            if (traceBacktracing) {
                printer.print(" --> make it a potential.");
            }
            this.add_to_potentials(cond);
        }
    }

    void trace_grounded_potentials() {
        Trace trace = this.context.getTrace();
        Printer printer = trace.getPrinter();
        boolean traceBacktracing = trace.isEnabled(Trace.Category.BACKTRACING);
        if (traceBacktracing) {
            printer.print("\n\n*** Tracing Grounded Potentials ***\n");
        }
        DefaultMarker tc = DefaultMarker.create();
        for (Condition c : this.grounds) {
            c.add_cond_to_tc(tc, null, null);
        }
        boolean need_another_pass = true;
        while (need_another_pass) {
            need_another_pass = false;
            Iterator it = this.positive_potentials.iterator();
            while (it.hasNext()) {
                PositiveCondition pot = (PositiveCondition)it.next();
                if (!pot.cond_is_in_tc(tc)) continue;
                BackTraceInfo bt = pot.bt();
                if (traceBacktracing) {
                    printer.print("\n-->Moving to grounds: %s", bt.wme_);
                }
                it.remove();
                if (bt.wme_.grounds_tc == this.grounds_tc) continue;
                bt.wme_.grounds_tc = this.grounds_tc;
                this.grounds.push(pot);
                pot.add_cond_to_tc(tc, null, null);
                need_another_pass = true;
            }
        }
    }

    boolean trace_ungrounded_potentials(int grounds_level, ByRef<Boolean> reliable) {
        PositiveCondition potential;
        Trace trace = this.context.getTrace();
        Printer printer = trace.getPrinter();
        boolean traceBacktracing = trace.isEnabled(Trace.Category.BACKTRACING);
        if (traceBacktracing) {
            printer.print("\n\n*** Tracing Ungrounded Potentials ***\n");
        }
        LinkedList<PositiveCondition> pots_to_bt = new LinkedList<PositiveCondition>();
        Iterator it = this.positive_potentials.iterator();
        while (it.hasNext()) {
            potential = (PositiveCondition)it.next();
            Preference bt_pref = Preference.find_clone_for_level(potential.bt().trace, grounds_level + 1);
            if (bt_pref == null) continue;
            it.remove();
            pots_to_bt.push(potential);
        }
        if (pots_to_bt.isEmpty()) {
            return false;
        }
        while (!pots_to_bt.isEmpty()) {
            potential = (PositiveCondition)pots_to_bt.pop();
            BackTraceInfo bt = potential.bt();
            if (traceBacktracing) {
                printer.print("\nFor ungrounded potential %s ", bt.wme_);
            }
            Preference bt_pref = Preference.find_clone_for_level(bt.trace, grounds_level + 1);
            this.backtrace_through_instantiation(bt_pref.inst, grounds_level, potential, reliable, 0);
            if (!bt.hasContextDependentPreferences()) continue;
            for (Preference p : bt) {
                if (traceBacktracing) {
                    printer.print("     Backtracing through CDPS preference: %s", p);
                }
                this.backtrace_through_instantiation(p.inst, grounds_level, potential, reliable, 6);
            }
        }
        return true;
    }

    void report_local_negation(Condition c) {
        Trace trace = this.context.getTrace();
        if (trace.isEnabled(Trace.Category.BACKTRACING)) {
            LinkedList<Condition> negated_to_print = new LinkedList<Condition>();
            negated_to_print.push(c);
            trace.getPrinter().print("\n*** Chunk won't be formed due to local negation in backtrace ***\n");
            this.print_consed_list_of_conditions(negated_to_print, 2);
        }
    }
}

