/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.learning;

import java.util.ArrayList;
import java.util.List;
import org.jsoar.kernel.learning.ChunkCondition;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;

public class ChunkConditionSet {
    static int CHUNK_COND_HASH_TABLE_SIZE = 1024;
    static int LOG_2_CHUNK_COND_HASH_TABLE_SIZE = 10;
    final ListHead<ChunkCondition> all = ListHead.newInstance();
    final List<ListHead<ChunkCondition>> table = new ArrayList<ListHead<ChunkCondition>>(CHUNK_COND_HASH_TABLE_SIZE);

    public ChunkConditionSet() {
        for (int i = 0; i < CHUNK_COND_HASH_TABLE_SIZE; ++i) {
            this.table.add(ListHead.newInstance());
        }
    }

    boolean add_to_chunk_cond_set(ChunkCondition new_cc) {
        ListHead<ChunkCondition> bucket = this.table.get(new_cc.compressed_hash_value);
        ListItem old = bucket.first;
        while (!(old == null || ((ChunkCondition)old.item).hash_value == new_cc.hash_value && Condition.conditions_are_equal(((ChunkCondition)old.item).cond, new_cc.cond))) {
            old = old.next;
        }
        if (old != null) {
            return false;
        }
        new_cc.next_prev.insertAtHead(this.all);
        new_cc.in_bucket.insertAtHead(bucket);
        return true;
    }

    void remove_from_chunk_cond_set(ChunkCondition cc) {
        cc.next_prev.remove(this.all);
        cc.in_bucket.remove(this.table.get(cc.compressed_hash_value));
    }
}

