/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.learning;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.learning.Backtrace;
import org.jsoar.kernel.learning.ExplainChunk;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.Conditions;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.properties.BooleanPropertyProvider;

public class Explain {
    private final Agent context;
    private ExplainChunk explain_chunk_list;
    private Backtrace explain_backtrace_list;
    private BooleanPropertyProvider enabled = new BooleanPropertyProvider(SoarProperties.EXPLAIN);

    public Explain(Agent agent) {
        this.context = agent;
        this.context.getProperties().setProvider(SoarProperties.EXPLAIN, this.enabled);
    }

    boolean isEnabled() {
        return this.enabled.value.get();
    }

    void reset_backtrace_list() {
        this.explain_backtrace_list = null;
    }

    public void explain_add_temp_to_backtrace_list(Backtrace temp, LinkedList<Condition> grounds, LinkedList<Condition> pots, LinkedList<Condition> locals, LinkedList<Condition> negateds) {
        Backtrace back = new Backtrace();
        back.result = temp.result;
        back.trace_cond = Condition.copy_condition(temp.trace_cond);
        if (back.trace_cond != null) {
            back.trace_cond.next = null;
        }
        back.prod_name = temp.prod_name;
        back.grounds = Condition.copy_conds_from_list(grounds);
        back.potentials = Condition.copy_conds_from_list(pots);
        back.locals = Condition.copy_conds_from_list(locals);
        back.negated = Condition.copy_conds_from_list(negateds);
        back.next_backtrace = this.explain_backtrace_list;
        this.explain_backtrace_list = back;
    }

    public void explain_add_temp_to_chunk_list(ExplainChunk temp) {
        ExplainChunk chunk = new ExplainChunk();
        chunk.conds = temp.conds;
        chunk.actions = temp.actions;
        chunk.name = temp.name;
        chunk.backtrace = this.explain_backtrace_list;
        this.explain_backtrace_list = null;
        chunk.all_grounds = Condition.copy_cond_list(temp.all_grounds);
        chunk.next_chunk = this.explain_chunk_list;
        this.explain_chunk_list = chunk;
    }

    public void reset_explain() {
        this.explain_chunk_list = null;
        this.reset_backtrace_list();
    }

    private ExplainChunk find_chunk(ExplainChunk chunk, String name) {
        while (chunk != null) {
            if (name.equals(chunk.name)) {
                return chunk;
            }
            chunk = chunk.next_chunk;
        }
        this.context.getPrinter().print("Could not find the chunk.  Maybe explain was not on when it was created.");
        this.context.getPrinter().print("\nTo turn on explain: save-backtraces --enable before the chunk is created.\n");
        return null;
    }

    public void explain_trace_named_chunk(String chunk_name) {
        ExplainChunk chunk = this.find_chunk(this.explain_chunk_list, chunk_name);
        if (chunk != null) {
            chunk.explain_trace_chunk(this.context.getPrinter());
        }
    }

    public void explain_trace(String chunk_name, Backtrace prod_list, Condition ground) {
        Backtrace prod = prod_list;
        Condition match = null;
        while (prod != null && match == null) {
            match = Condition.explain_find_cond(ground, prod.potentials);
            if (match == null) {
                match = Condition.explain_find_cond(ground, prod.grounds);
            }
            if (match == null) {
                match = Condition.explain_find_cond(ground, prod.negated);
            }
            if (match != null) continue;
            prod = prod.next_backtrace;
        }
        Printer printer = this.context.getPrinter();
        if (match == null) {
            printer.print("EXPLAIN: Error, couldn't find the ground condition\n");
            return;
        }
        printer.print("Explanation of why condition %s was included in %s\n\n", ground, chunk_name);
        printer.print("Production %s matched\n   %s which caused\n", prod.prod_name, match);
        Condition target = prod.trace_cond;
        int count = 0;
        while (!prod.result && count < 50 && match != null) {
            prod = prod_list;
            match = null;
            ++count;
            while (prod != null && match == null) {
                match = Condition.explain_find_cond(target, prod.locals);
                if (match == null) {
                    match = Condition.explain_find_cond(target, prod.negated);
                }
                if (match == null) {
                    match = Condition.explain_find_cond(target, prod.potentials);
                }
                if (match == null) {
                    match = Condition.explain_find_cond(target, prod.grounds);
                }
                if (match != null) continue;
                prod = prod.next_backtrace;
            }
            if (match == null) {
                printer.print("EXPLAIN : Unable to find which production matched condition %s\n", target);
                printer.print("To help understand what happened here and help debug this\nhere is all of the backtracing information stored for this chunk.\n\n");
                this.explain_trace_named_chunk(chunk_name);
                continue;
            }
            printer.print("production %s to match\n   %s which caused\n", prod.prod_name, match);
            target = prod.trace_cond;
        }
        if (prod.result) {
            printer.print("A result to be generated.\n");
        }
        if (count >= 50) {
            printer.print("EXPLAIN: Exceeded 50 productions traced through, so terminating now.\n");
        }
    }

    public void explain_chunk(String chunk_name, int cond_number) {
        ExplainChunk chunk = this.find_chunk(this.explain_chunk_list, chunk_name);
        if (chunk == null) {
            return;
        }
        Condition ground = chunk.find_ground(this.context.getPrinter(), cond_number);
        if (ground == null) {
            return;
        }
        this.explain_trace(chunk_name, chunk.backtrace, ground);
    }

    public void explain_cond_list(String chunk_name) {
        ExplainChunk chunk = this.find_chunk(this.explain_chunk_list, chunk_name);
        if (chunk == null) {
            return;
        }
        Printer printer = this.context.getPrinter();
        printer.print("(sp %s\n  ", chunk.name);
        Conditions.print_condition_list(printer, chunk.conds, 2, false);
        printer.print("\n-->\n   ");
        Action.print_action_list(printer, chunk.actions, 3, false);
        printer.print(")\n\n");
        int i = 0;
        Condition ground = chunk.all_grounds;
        Condition cond = chunk.conds;
        while (cond != null) {
            printer.print(" %2d : %s", ++i, cond);
            printer.print(" Ground :%s\n", ground);
            ground = ground.next;
            cond = cond.next;
        }
    }

    public List<ExplainChunk> getChunkExplanations() {
        ArrayList<ExplainChunk> result = new ArrayList<ExplainChunk>();
        ExplainChunk c = this.explain_chunk_list;
        while (c != null) {
            result.add(c);
            c = c.next_chunk;
        }
        return result;
    }

    public void explain_list_chunks() {
        ExplainChunk chunk = this.explain_chunk_list;
        if (chunk == null) {
            this.context.getPrinter().print("No chunks/justifications built yet!\n");
        } else {
            this.context.getPrinter().print("List of all explained chunks/justifications:\n");
            while (chunk != null) {
                this.context.getPrinter().print("Have explanation for %s\n", chunk.name);
                chunk = chunk.next_chunk;
            }
        }
    }

    public void explain_full_trace() {
        ExplainChunk chunk = this.explain_chunk_list;
        while (chunk != null) {
            chunk.explain_trace_chunk(this.context.getPrinter());
            chunk = chunk.next_chunk;
        }
    }
}

