/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.learning.rl;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.learning.rl.RLPrintHelper;
import org.jsoar.kernel.learning.rl.ReinforcementLearning;
import org.jsoar.kernel.learning.rl.ReinforcementLearningParams;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.commands.SoarCommandProvider;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyManager;
import picocli.CommandLine;

public class RLCommand
implements SoarCommand {
    private final Agent agent;

    public RLCommand(Adaptable context) {
        this.agent = (Agent)context;
    }

    @Override
    public Object getCommand() {
        return new RLC(this.agent);
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new RLC(this.agent), args);
        return "";
    }

    @CommandLine.Command(name="rl", description={"Controls how numeric indifferent preference values in RL rules are updated via reinforcement learning"}, subcommands={CommandLine.HelpCommand.class})
    public static class RLC
    implements Runnable {
        private final Agent agent;
        private final ReinforcementLearning rl;
        @CommandLine.Option(names={"-s", "--set"}, description={"Sets the given parameter value"})
        String setParam = null;
        @CommandLine.Parameters(arity="0..1", description={"The new value of the parameter"})
        String newVal = null;
        @CommandLine.Option(names={"-g", "--get"}, description={"Prints the current setting of the given parameter"})
        String getParam = null;

        public RLC(Agent agent) {
            this.agent = agent;
            this.rl = Adaptables.require(this.getClass(), agent, ReinforcementLearning.class);
        }

        @Override
        public void run() {
            if (this.setParam != null) {
                if (this.newVal == null) {
                    this.agent.getPrinter().startNewLine().print("Error: no parameter value provided");
                    return;
                }
                this.agent.getPrinter().startNewLine().print(this.doSet(this.setParam, this.newVal));
            } else if (this.getParam != null) {
                this.agent.getPrinter().startNewLine().print(this.doGet(this.getParam));
            } else {
                this.agent.getPrinter().startNewLine().print(this.doRl());
            }
        }

        private String doSet(String paramToSet, String value) {
            PropertyManager props = this.rl.getParams().getProperties();
            try {
                if (!paramToSet.equals("learning")) {
                    if (paramToSet.equals("discount-rate")) {
                        props.set(ReinforcementLearningParams.DISCOUNT_RATE, Double.parseDouble(value));
                        return "Set discount-rate to " + Double.parseDouble(value);
                    }
                    if (paramToSet.equals("learning-policy")) {
                        if (value.equals("off-policy-gq-lambda") || value.equals("on-policy-gq-lambda")) {
                            this.agent.getPrinter().startNewLine().print("RL learning-policy '" + value + "' has not yet been implemented in JSoar");
                            return "";
                        }
                        props.set(ReinforcementLearningParams.LEARNING_POLICY, ReinforcementLearningParams.LearningPolicy.valueOf(value));
                        return "Set learning-policy to " + (Object)((Object)ReinforcementLearningParams.LearningPolicy.valueOf(value));
                    }
                    if (paramToSet.equals("step-size-parameter")) {
                        this.agent.getPrinter().startNewLine().print("RL GQ parameter 'step-size-parameter' has not yet been implemented in JSoar");
                        return "";
                    }
                    if (paramToSet.equals("learning-rate")) {
                        props.set(ReinforcementLearningParams.LEARNING_RATE, Double.parseDouble(value));
                        return "Set learning-rate to " + Double.parseDouble(value);
                    }
                    if (paramToSet.equals("hrl-discount")) {
                        props.set(ReinforcementLearningParams.HRL_DISCOUNT, ReinforcementLearningParams.HrlDiscount.valueOf(value));
                        return "Set hrl-discount to " + (Object)((Object)ReinforcementLearningParams.HrlDiscount.valueOf(value));
                    }
                    if (paramToSet.equals("temporal-discount")) {
                        props.set(ReinforcementLearningParams.TEMPORAL_DISCOUNT, ReinforcementLearningParams.TemporalDiscount.valueOf(value));
                        return "Set temporal-discount to " + (Object)((Object)ReinforcementLearningParams.TemporalDiscount.valueOf(value));
                    }
                    if (paramToSet.equals("temporal-extension")) {
                        props.set(ReinforcementLearningParams.TEMPORAL_EXTENSION, ReinforcementLearningParams.TemporalExtension.valueOf(value));
                        return "Set temporal-extension to " + (Object)((Object)ReinforcementLearningParams.TemporalExtension.valueOf(value));
                    }
                    if (paramToSet.equals("eligibility-trace-decay-rate")) {
                        props.set(ReinforcementLearningParams.ET_DECAY_RATE, Double.parseDouble(value));
                        return "Set eligibility-trace-decay-rate to " + Double.parseDouble(value);
                    }
                    if (paramToSet.equals("eligibility-trace-tolerance")) {
                        props.set(ReinforcementLearningParams.ET_TOLERANCE, Double.parseDouble(value));
                        return "Set eligibility-trace-tolerance to " + Double.parseDouble(value);
                    }
                    if (paramToSet.equals("chunk-stop")) {
                        props.set(ReinforcementLearningParams.CHUNK_STOP, ReinforcementLearningParams.ChunkStop.valueOf(value));
                        return "Set chunk-stop to " + (Object)((Object)ReinforcementLearningParams.ChunkStop.valueOf(value));
                    }
                    if (paramToSet.equals("decay-mode")) {
                        props.set(ReinforcementLearningParams.DECAY_MODE, ReinforcementLearningParams.DecayMode.valueOf(value));
                        return "Set decay-mode to " + (Object)((Object)ReinforcementLearningParams.DecayMode.valueOf(value));
                    }
                    if (paramToSet.equals("meta")) {
                        props.set(ReinforcementLearningParams.META, ReinforcementLearningParams.Meta.valueOf(value));
                        return "Set meta to " + (Object)((Object)ReinforcementLearningParams.Meta.valueOf(value));
                    }
                    if (paramToSet.equals("meta-learning-rate")) {
                        props.set(ReinforcementLearningParams.META_LEARNING_RATE, Double.parseDouble(value));
                        return "Set meta-learning-rate to " + Double.parseDouble(value);
                    }
                    if (paramToSet.equals("update-log-path")) {
                        props.set(ReinforcementLearningParams.UPDATE_LOG_PATH, value);
                        return "Set update-log-path to " + value;
                    }
                    if (paramToSet.equals("apoptosis")) {
                        props.set(ReinforcementLearningParams.APOPTOSIS, ReinforcementLearningParams.ApoptosisChoices.getEnum(value));
                        return "Set apoptosis to " + (Object)((Object)ReinforcementLearningParams.ApoptosisChoices.getEnum(value));
                    }
                    if (paramToSet.equals("apoptosis-decay")) {
                        props.set(ReinforcementLearningParams.APOPTOSIS_DECAY, Double.parseDouble(value));
                        return "Set apoptosis-decay to " + Double.parseDouble(value);
                    }
                    if (paramToSet.equals("apoptosis-thresh")) {
                        props.set(ReinforcementLearningParams.APOPTOSIS_THRESH, Double.parseDouble(value));
                        return "Set apoptosis-thresh to " + Double.parseDouble(value);
                    }
                    if (paramToSet.equals("trace")) {
                        props.set(ReinforcementLearningParams.TRACE, ReinforcementLearningParams.Trace.valueOf(value));
                        return "Set trace to " + (Object)((Object)ReinforcementLearningParams.Trace.valueOf(value));
                    }
                    this.agent.getPrinter().startNewLine().print("Unknown rl parameter '" + paramToSet + "'");
                    return "";
                }
                props.set(ReinforcementLearningParams.LEARNING, ReinforcementLearningParams.Learning.valueOf(value));
            }
            catch (IllegalArgumentException e) {
                this.agent.getPrinter().startNewLine().print("Invalid value.");
            }
            return "";
        }

        private String doGet(String paramToGet) {
            PropertyKey<?> key = ReinforcementLearningParams.getProperty(this.rl.getParams().getProperties(), paramToGet);
            if (key == null) {
                this.agent.getPrinter().startNewLine().print("Unknown parameter '" + paramToGet + "'");
                return "";
            }
            return this.rl.getParams().getProperties().get(key).toString();
        }

        private String doRl() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ReinforcementLearningParams p = this.rl.getParams();
            pw.printf(RLPrintHelper.generateHeader("", 0), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("Soar-RL learning:", p.learning.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("temporal-extension:", p.temporal_extension.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateSection("Discount", 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("discount-rate:", p.discount_rate.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateSection("Learning", 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("learning-policy:", (Object)p.learning_policy.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("learning-rate:", p.learning_rate.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("hrl-discount:", p.hrl_discount.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateSection("Eligibility Traces", 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("eligibility-trace-decay-rate:", p.et_decay_rate.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("eligibility-trace-tolerance:", p.et_tolerance.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateSection("Experimental", 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("chunk-stop:", p.chunk_stop.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("decay-mode:", p.decay_mode.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("meta:", p.meta.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("meta-learning-rate:", p.meta_learning_rate.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("update-log-path:", p.update_log_path.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("", "0", 0), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("apoptosis:", p.apoptosis.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("apoptosis-decay:", p.apoptosis_decay.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("apoptosis-thresh:", p.apoptosis_thresh.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("", "0", 0), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("trace:", p.trace.get(), 40), new Object[0]);
            pw.printf(RLPrintHelper.generateItem("", "0", 0), new Object[0]);
            pw.flush();
            return sw.toString();
        }
    }

    public static class Provider
    implements SoarCommandProvider {
        @Override
        public void registerCommands(SoarCommandInterpreter interp, Adaptable context) {
            interp.addCommand("rl", new RLCommand(context));
        }
    }
}

