/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.lhs;

import java.io.StringWriter;
import java.util.Formattable;
import java.util.Formatter;
import java.util.List;
import org.jsoar.kernel.lhs.Conditions;
import org.jsoar.kernel.lhs.ConjunctiveNegationCondition;
import org.jsoar.kernel.lhs.NegativeCondition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.lhs.Tests;
import org.jsoar.kernel.lhs.ThreeFieldCondition;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.ByRef;
import org.jsoar.util.ListHead;
import org.jsoar.util.markers.Marker;

public abstract class Condition
implements Formattable {
    public boolean already_in_tc;
    public Condition next;
    public Condition prev;

    public static Condition insertAtHead(Condition header, Condition c) {
        c.next = header;
        c.prev = null;
        if (header != null) {
            header.prev = c;
        }
        return c;
    }

    public static Condition insertAtEnd(Condition tail, Condition c) {
        c.next = null;
        c.prev = tail;
        if (tail != null) {
            tail.next = c;
        }
        return c;
    }

    public static Condition removeFromList(Condition header, Condition c) {
        if (c.next != null) {
            c.next.prev = c.prev;
        }
        if (c.prev != null) {
            c.prev.next = c.next;
        } else {
            header = c.next;
        }
        return header;
    }

    public static void addAllVariables(Condition header, Marker tc_number, ListHead<Variable> var_list) {
        Condition c = header;
        while (c != null) {
            c.addAllVariables(tc_number, var_list);
            c = c.next;
        }
    }

    public static void addBoundVariables(Condition header, Marker tc_number, ListHead<Variable> var_list) {
        Condition c = header;
        while (c != null) {
            c.addBoundVariables(tc_number, var_list);
            c = c.next;
        }
    }

    public abstract void addBoundVariables(Marker var1, ListHead<Variable> var2);

    public abstract void addAllVariables(Marker var1, ListHead<Variable> var2);

    public ThreeFieldCondition asThreeFieldCondition() {
        return null;
    }

    public PositiveCondition asPositiveCondition() {
        return null;
    }

    public NegativeCondition asNegativeCondition() {
        return null;
    }

    public ConjunctiveNegationCondition asConjunctiveNegationCondition() {
        return null;
    }

    public abstract boolean cond_is_in_tc(Marker var1);

    public abstract void add_cond_to_tc(Marker var1, ListHead<IdentifierImpl> var2, ListHead<Variable> var3);

    public static int hash_condition(Condition cond) {
        PositiveCondition pc = cond.asPositiveCondition();
        if (pc != null) {
            int result = Tests.hash_test(pc.id_test);
            result = result << 24 | result >> 8;
            result ^= Tests.hash_test(pc.attr_test);
            result = result << 24 | result >> 8;
            result ^= Tests.hash_test(pc.value_test);
            if (pc.test_for_acceptable_preference) {
                ++result;
            }
            return result;
        }
        NegativeCondition nc = cond.asNegativeCondition();
        if (nc != null) {
            int result = 1267818;
            result ^= Tests.hash_test(nc.id_test);
            result = result << 24 | result >> 8;
            result ^= Tests.hash_test(nc.attr_test);
            result = result << 24 | result >> 8;
            result ^= Tests.hash_test(nc.value_test);
            if (nc.test_for_acceptable_preference) {
                ++result;
            }
            return result;
        }
        ConjunctiveNegationCondition ncc = cond.asConjunctiveNegationCondition();
        if (ncc != null) {
            int result = 82348149;
            Condition c = ncc.top;
            while (c != null) {
                result ^= Condition.hash_condition(c);
                result = result << 24 | result >> 8;
                c = c.next;
            }
            return result;
        }
        throw new IllegalStateException("Internal error: bad cond type in hash_condition");
    }

    public static boolean conditions_are_equal(Condition c1, Condition c2) {
        if (!c1.getClass().equals(c2.getClass())) {
            return false;
        }
        ThreeFieldCondition tfc1 = c1.asThreeFieldCondition();
        if (tfc1 != null) {
            boolean neg = c1.asNegativeCondition() != null;
            ThreeFieldCondition tfc2 = c2.asThreeFieldCondition();
            if (!Tests.tests_are_equal(tfc1.id_test, tfc2.id_test, neg)) {
                return false;
            }
            if (!Tests.tests_are_equal(tfc1.attr_test, tfc2.attr_test, neg)) {
                return false;
            }
            if (!Tests.tests_are_equal(tfc1.value_test, tfc2.value_test, neg)) {
                return false;
            }
            return tfc1.test_for_acceptable_preference == tfc2.test_for_acceptable_preference;
        }
        ConjunctiveNegationCondition ncc1 = c1.asConjunctiveNegationCondition();
        if (ncc1 != null) {
            ConjunctiveNegationCondition ncc2 = c2.asConjunctiveNegationCondition();
            c1 = ncc1.top;
            c2 = ncc2.top;
            while (c1 != null && c2 != null) {
                if (!Condition.conditions_are_equal(c1, c2)) {
                    return false;
                }
                c1 = c1.next;
                c2 = c2.next;
            }
            return c1 == c2;
        }
        throw new IllegalStateException("Unknown condition types: " + c1 + ", " + c2);
    }

    public static Condition copy_condition(Condition cond) {
        if (cond == null) {
            return null;
        }
        PositiveCondition pc = cond.asPositiveCondition();
        if (pc != null) {
            return pc.copy();
        }
        NegativeCondition nc = cond.asNegativeCondition();
        if (nc != null) {
            NegativeCondition New = new NegativeCondition();
            New.id_test = Tests.copy(nc.id_test);
            New.attr_test = Tests.copy(nc.attr_test);
            New.value_test = Tests.copy(nc.value_test);
            New.test_for_acceptable_preference = nc.test_for_acceptable_preference;
            return New;
        }
        ConjunctiveNegationCondition ncc = cond.asConjunctiveNegationCondition();
        if (ncc != null) {
            ConjunctiveNegationCondition New = new ConjunctiveNegationCondition();
            ByRef<Object> ncc_top = ByRef.create(null);
            ByRef<Object> ncc_bottom = ByRef.create(null);
            Condition.copy_condition_list(ncc.top, ncc_top, ncc_bottom);
            New.top = (Condition)ncc_top.value;
            New.bottom = (Condition)ncc_bottom.value;
            return New;
        }
        throw new IllegalStateException("Unknown condition type to copy_condition(): " + cond);
    }

    public static void copy_condition_list(Condition top_cond, ByRef<Condition> dest_top, ByRef<Condition> dest_bottom) {
        Condition prev = null;
        while (top_cond != null) {
            Condition New = Condition.copy_condition(top_cond);
            if (prev != null) {
                prev.next = New;
            } else {
                dest_top.value = New;
            }
            New.prev = prev;
            prev = New;
            top_cond = top_cond.next;
        }
        if (prev != null) {
            prev.next = null;
        } else {
            dest_top.value = null;
        }
        dest_bottom.value = prev;
    }

    public static Condition copy_cond_list(Condition top_list) {
        ByRef<Object> new_top = ByRef.create(null);
        ByRef<Object> new_bottom = ByRef.create(null);
        Condition.copy_condition_list(top_list, new_top, new_bottom);
        return (Condition)new_top.value;
    }

    public static Condition copy_conds_from_list(List<Condition> top_list) {
        Condition top = null;
        Condition prev = null;
        for (Condition cc : top_list) {
            Condition cond = Condition.copy_condition(cc);
            cond.prev = prev;
            cond.next = null;
            if (prev == null) {
                top = cond;
            } else {
                prev.next = cond;
            }
            prev = cond;
        }
        return top;
    }

    public static Condition explain_find_cond(Condition target, Condition cond_list) {
        Condition cond = cond_list;
        while (cond != null) {
            if (Condition.conditions_are_equal(target, cond)) {
                return cond;
            }
            cond = cond.next;
        }
        return null;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        Condition old_next = this.next;
        Condition old_prev = this.prev;
        this.next = null;
        this.prev = null;
        StringWriter writer = new StringWriter();
        Conditions.print_condition_list(new Printer(writer), this, 0, true);
        this.next = old_next;
        this.prev = old_prev;
        formatter.format(writer.toString(), new Object[0]);
    }
}

