/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.lhs;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jsoar.kernel.lhs.ConjunctiveTest;
import org.jsoar.kernel.lhs.DisjunctionTest;
import org.jsoar.kernel.lhs.EqualityTest;
import org.jsoar.kernel.lhs.RelationalTest;
import org.jsoar.kernel.lhs.Test;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.util.ByRef;
import org.jsoar.util.ListHead;
import org.jsoar.util.markers.Marker;

public class Tests {
    public static EqualityTest copy_of_equality_test_found_in_test(Test t) {
        if (Tests.isBlank(t)) {
            throw new IllegalStateException("Internal error: can't find equality test in blank test");
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            return (EqualityTest)eq.copy();
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test child : ct.conjunct_list) {
                if (Tests.isBlank(child) || child.asEqualityTest() == null) continue;
                return (EqualityTest)child.copy();
            }
        }
        throw new IllegalStateException("Internal error: can't find equality test in test\n");
    }

    public static Test add_new_test_to_test(Test t, Test add_me) {
        if (Tests.isBlank(add_me)) {
            return t;
        }
        if (Tests.isBlank(t)) {
            return add_me;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct == null) {
            ct = new ConjunctiveTest();
            ct.conjunct_list.add(0, t);
        }
        ct.conjunct_list.add(0, add_me);
        return ct;
    }

    public static boolean test_includes_equality_test_for_symbol(Test test, SymbolImpl sym) {
        if (Tests.isBlank(test)) {
            return false;
        }
        EqualityTest eq = test.asEqualityTest();
        if (eq != null) {
            if (sym != null) {
                return eq.getReferent() == sym;
            }
            return true;
        }
        ConjunctiveTest ct = test.asConjunctiveTest();
        if (ct != null) {
            for (Test child : ct.conjunct_list) {
                if (!Tests.test_includes_equality_test_for_symbol(child, sym)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean test_includes_goal_or_impasse_id_test(Test t, boolean look_for_goal, boolean look_for_impasse) {
        Iterator<Test> iterator;
        if (t.asEqualityTest() != null) {
            return false;
        }
        if (look_for_goal && t.asGoalIdTest() != null) {
            return true;
        }
        if (look_for_impasse && t.asImpasseIdTest() != null) {
            return true;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null && (iterator = ct.conjunct_list.iterator()).hasNext()) {
            Test c = iterator.next();
            return Tests.test_includes_goal_or_impasse_id_test(c, look_for_goal, look_for_impasse);
        }
        return false;
    }

    public static boolean test_tests_for_root(Test t, ListHead<Variable> roots) {
        if (Tests.isBlank(t)) {
            return false;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            Variable referent = eq.getReferent().asVariable();
            return referent != null && roots.contains(referent);
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test c : ct.conjunct_list) {
                if (!Tests.test_tests_for_root(c, roots)) continue;
                return true;
            }
            return false;
        }
        RelationalTest rt = t.asRelationalTest();
        if (rt != null) {
            Variable referent = rt.referent.asVariable();
            return referent != null && roots.contains(referent);
        }
        return false;
    }

    public static Test copy_test_removing_goal_impasse_tests(Test t, ByRef<Boolean> removed_goal, ByRef<Boolean> removed_impasse) {
        if (Tests.isBlank(t) || t.asEqualityTest() != null) {
            return t.copy();
        }
        if (t.asGoalIdTest() != null) {
            removed_goal.value = true;
            return null;
        }
        if (t.asImpasseIdTest() != null) {
            removed_impasse.value = true;
            return null;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            Test new_t = null;
            for (Test c : ct.conjunct_list) {
                Test temp = Tests.copy_test_removing_goal_impasse_tests(c, removed_goal, removed_impasse);
                if (Tests.isBlank(temp)) continue;
                new_t = Tests.add_new_test_to_test(new_t, temp);
            }
            ConjunctiveTest newct = new_t.asConjunctiveTest();
            if (newct != null) {
                Collections.reverse(newct.conjunct_list);
            }
            return new_t;
        }
        return t.copy();
    }

    public static char first_letter_from_test(Test t) {
        if (Tests.isBlank(t)) {
            return '*';
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            return eq.getReferent().getFirstLetter();
        }
        if (t.asGoalIdTest() != null) {
            return 's';
        }
        if (t.asImpasseIdTest() != null) {
            return 'i';
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test child : ct.conjunct_list) {
                char ch = Tests.first_letter_from_test(child);
                if (ch == '*') continue;
                return ch;
            }
        }
        return '*';
    }

    public static Test add_new_test_to_test_if_not_already_there(Test t, Test add_me, boolean neg) {
        if (Tests.tests_are_equal(t, add_me, neg)) {
            return t;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test child : ct.conjunct_list) {
                if (!Tests.tests_are_equal(child, add_me, neg)) continue;
                return t;
            }
        }
        return Tests.add_new_test_to_test(t, add_me);
    }

    public static void bind_variables_in_test(Test t, int depth, int field_num, boolean dense, ListHead<Variable> varlist) {
        if (Tests.isBlank(t)) {
            return;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            Variable referent = eq.getReferent().asVariable();
            if (referent == null) {
                return;
            }
            if (!dense && referent.var_is_bound()) {
                return;
            }
            referent.push_var_binding(depth, field_num);
            varlist.push(referent);
            return;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test c : ct.conjunct_list) {
                Tests.bind_variables_in_test(c, depth, field_num, dense, varlist);
            }
        }
    }

    static boolean tests_are_equal(Test t1, Test t2, boolean neg) {
        if (t1 == t2) {
            return true;
        }
        if (t1.getClass() != t2.getClass()) {
            return false;
        }
        EqualityTest eq1 = t1.asEqualityTest();
        if (eq1 != null) {
            EqualityTest eq2;
            if (neg && eq1.getReferent().asVariable() != null && (eq2 = t2.asEqualityTest()) != null && eq2.getReferent().asVariable() != null) {
                return true;
            }
            return eq1.getReferent() == t2.asEqualityTest().getReferent();
        }
        if (t1.asGoalIdTest() != null || t1.asImpasseIdTest() != null) {
            return true;
        }
        DisjunctionTest dt = t1.asDisjunctionTest();
        if (dt != null) {
            return dt.disjunction_list.equals(t2.asDisjunctionTest().disjunction_list);
        }
        ConjunctiveTest ct = t1.asConjunctiveTest();
        if (ct != null) {
            List<Test> c1 = ct.conjunct_list;
            List<Test> c2 = t2.asConjunctiveTest().conjunct_list;
            if (c1.size() != c2.size()) {
                return false;
            }
            LinkedList copy2 = Lists.newLinkedList(c2);
            block0: for (int i = 0; i < c1.size(); ++i) {
                for (int j = 0; j < copy2.size(); ++j) {
                    if (!Tests.tests_are_equal(c1.get(i), (Test)copy2.get(j), neg)) continue;
                    copy2.remove(j);
                    continue block0;
                }
            }
            return copy2.size() == 0;
        }
        return t1.asRelationalTest().referent == t2.asRelationalTest().referent;
    }

    static void add_test_to_tc(Test t, Marker tc, ListHead<IdentifierImpl> id_list, ListHead<Variable> var_list) {
        if (Tests.isBlank(t)) {
            return;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            eq.getReferent().add_symbol_to_tc(tc, id_list, var_list);
            return;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test c : ct.conjunct_list) {
                Tests.add_test_to_tc(c, tc, id_list, var_list);
            }
        }
    }

    static boolean test_is_in_tc(Test t, Marker tc) {
        if (Tests.isBlank(t)) {
            return false;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            return eq.getReferent().symbol_is_in_tc(tc);
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test c : ct.conjunct_list) {
                if (!Tests.test_is_in_tc(c, tc)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static int hash_test(Test t) {
        if (Tests.isBlank(t)) {
            return 0;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            return eq.getReferent().hash_id;
        }
        if (t.asGoalIdTest() != null) {
            return 34894895;
        }
        if (t.asImpasseIdTest() != null) {
            return 2089521;
        }
        DisjunctionTest dt = t.asDisjunctionTest();
        if (dt != null) {
            int result = 7245;
            for (SymbolImpl c : dt.disjunction_list) {
                result += c.hash_id;
            }
            return result;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            int result = 100276;
            return result;
        }
        RelationalTest rt = t.asRelationalTest();
        if (rt != null) {
            return (rt.type << 24) + rt.referent.hash_id;
        }
        throw new IllegalStateException("Error: bad test type in hash_test: " + t);
    }

    public static Test copy(Test t) {
        return t != null ? t.copy() : null;
    }

    public static boolean isBlank(Test t) {
        return t == null;
    }
}

